/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter;

import java.awt.Component;
import java.awt.Image;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.ewt.wizard.TitledWizardPage;
import oracle.bali.ewt.wizard.Wizard;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.bali.ewt.wizard.WizardValidateListener;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Project;
import oracle.ide.net.URLChooser;
import oracle.ide.util.GraphicsUtils;
import oracle.tip.tools.ide.common.utils.MultiLineOptionPane;
import oracle.tip.tools.ide.fabric.api.WsdlInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.ServiceNamePage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.JcaBinding;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.JcaOperation;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.PCInboundBinding;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.PartnerLinkType;

public class techAdapterWizardPage
extends JPanel
implements WizardValidateListener {
    public AdapterWizardContext m_wcontext;
    public Wizard m_wizard;
    public ImageWizardPage m_page;
    public boolean m_isSecondOperation = false;
    public boolean m_registeredDriver = false;
    public String helpTopicID = null;
    public static final String OUTPUT_NAMESPACE_PREFIX = "imp2";

    public void setContextAndPage(AdapterWizardContext wcontext, ImageWizardPage wpage) {
        this.m_wcontext = wcontext;
        this.m_wizard = this.m_wcontext._wizard;
        this.m_page = wpage;
        this.m_wizard.addPage((WizardPage)this.m_page);
        this.m_page.setInteractiveArea((Component)this);
        this.m_page.addWizardValidateListener((WizardValidateListener)this);
        if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone() && this.getHelpTopicID() != null) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)wpage.getContent(), this.getHelpTopicID());
        }
    }

    public void setHelpTopicID(String helpTopicID) {
        this.helpTopicID = helpTopicID;
    }

    public String getHelpTopicID() {
        return this.helpTopicID;
    }

    public void buildWSDL() throws WSDLException, Exception {
    }

    public Image _getImage() {
        techAdapterWizardPage techAdapterWizardPage2 = this;
        return techAdapterWizardPage2.m_wcontext._getImage();
    }

    public void removePages() {
        int rcnt = this.m_wizard.getCurrentPageIndex();
        if (rcnt == 0) {
            return;
        }
        for (int pcnt = this.m_wizard.getPageCount() - 1; rcnt < pcnt; --pcnt) {
            WizardPage temppage = this.m_wizard.getPageAt(pcnt);
            String tt = temppage.getLabel().toString();
            this.m_wizard.removePage(temppage);
        }
    }

    public void addFinishPage() {
        this.checkForAdapterBpmExtensions();
        this.m_wcontext._finish_page = new TitledWizardPage(null, this._getImage(), this.getTranslatedString("CM_WZ_FINISH_PAGE_TITLE"), null);
        if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)this.m_wcontext._finish_page.getContent(), "bpmjdev_adp_wiz_finish");
        }
        this.m_wizard.addPage((WizardPage)this.m_wcontext._finish_page);
    }

    public void checkForAdapterBpmExtensions() {
        try {
            Class<?> adapterExtensionUtil = Class.forName("oracle.bpm.fusion.soa.util.AdapterExtensionUtil");
            try {
                Class[] methodParams = new Class[]{Project.class};
                Method isBpmProjectMethod = adapterExtensionUtil.getMethod("isBpmProject", methodParams);
                Object[] methodArgs = new Object[]{this.m_wcontext._project};
                Object bpmProjectFlag = isBpmProjectMethod.invoke(null, methodArgs);
                boolean isBpm = (Boolean)bpmProjectFlag;
                this.m_wcontext.setIsBPM(isBpm);
            }
            catch (Exception exc) {
                exc.printStackTrace();
                this.m_page.setCanAdvance(false);
                MultiLineOptionPane.showMessageDialog((Component)this.m_wcontext._parentFrame, (Object)this.getTranslatedString("BPM_REFLECTION_LOAD_ERROR"), (String)this.getTranslatedString("BPM_ADAPTER_EXTENSION"), (int)0);
            }
        }
        catch (ClassNotFoundException e) {
            System.out.println("oracle.bpm.fusion.soa.util.AdapterExtensionUtil not found. This is an error if the project is a BPM Project");
        }
    }

    public void setFinishPageContents(String title, Object contents) {
        TitledWizardPage twp = this.m_wcontext._finish_page;
        twp.setTitle(title);
        if (this.m_wcontext.isBPM()) {
            try {
                Class<?> bcpPage = Class.forName("oracle.bpm.fusion.soa.ui.extension.BusinessCatalogPromotionPage");
                Class[] paramTypes = new Class[]{AdapterWizardContext.class, Object.class};
                Constructor<?> constr = bcpPage.getConstructor(paramTypes);
                Object bcpPageInstance = constr.newInstance(this.m_wcontext, contents);
                twp.setInteractiveArea((Component)bcpPageInstance);
            }
            catch (Exception exc) {
                exc.printStackTrace();
                this.m_page.setCanAdvance(false);
                MultiLineOptionPane.showMessageDialog((Component)this.m_wcontext._parentFrame, (Object)this.getTranslatedString("BPM_REFLECTION_LOAD_ERROR"), (String)this.getTranslatedString("BPM_ADAPTER_EXTENSION"), (int)0);
            }
        } else if (contents instanceof String) {
            MultiLineLabel jLabel1 = new MultiLineLabel(WordWrapper.getTextWrapper(), (String)contents);
            twp.setInteractiveArea((Component)jLabel1);
        } else {
            twp.setInteractiveArea((Component)contents);
        }
    }

    public void wizardValidatePage(WizardEvent event) {
    }

    public void createCommonOperationObjects(String operationName) throws WSDLException {
        this.createCommonOperationObjects(operationName, null);
    }

    public void createCommonOperationObjects(String operationName, String uiTransmissionPrimitive) throws WSDLException {
        this.m_wcontext._write_operation_name = operationName;
        Definition def1 = this.m_wcontext._write_definition;
        PortType portt = null;
        if (this.m_wcontext._importedWsdlInfo == null) {
            portt = def1.createPortType();
            QName portt_qname = new QName(this.m_wcontext._target_namespace, ServiceNamePage.getCleanName(operationName) + this.m_wcontext.PortType_suffix);
            portt.setQName(portt_qname);
            portt.setUndefined(false);
            def1.addPortType(portt);
            Operation oper1 = def1.createOperation();
            oper1.setName(operationName);
            oper1.setUndefined(false);
            portt.addOperation(oper1);
            this.m_wcontext._write_operation_abstract = oper1;
        } else {
            portt = WsdlInfo.getPorttypeByQname((Project)this.m_wcontext._project, (QName)this.m_wcontext._importedWsdlInfo.getRequestPorttype());
        }
        PartnerLinkType plt = (PartnerLinkType)this.m_wcontext._extReg.createExtension(PartnerLinkType.PARENT_CLASS, PartnerLinkType.FIELD_ELEMENT_TYPE);
        def1.addExtensibilityElement((ExtensibilityElement)plt);
        plt.setContext(this.m_wcontext);
        String pltname = portt.getQName().getLocalPart();
        if (pltname.endsWith(this.m_wcontext.PortType_suffix)) {
            pltname = pltname.substring(0, pltname.length() - this.m_wcontext.PortType_suffix.length());
        }
        this.m_wcontext._partnerLinkType_name = pltname + this.m_wcontext.PartnerLinkType_suffix;
        this.m_wcontext._role_name = operationName + this.m_wcontext.Role_suffix;
        plt.setPartnerLinkTypeName(this.m_wcontext._partnerLinkType_name);
        plt.setRoleName(this.m_wcontext._role_name);
        plt.setPortName(portt.getQName().getLocalPart());
        if (this.m_wcontext._importedWsdlInfo != null) {
            def1.addNamespace("imp1", portt.getQName().getNamespaceURI());
            plt.setPortNSPrefix("imp1");
        }
        Binding bind1 = def1.createBinding();
        bind1.setPortType(portt);
        bind1.setQName(new QName(this.m_wcontext._target_namespace, operationName + this.m_wcontext.Binding_suffix));
        bind1.setUndefined(false);
        def1.addBinding(bind1);
        if (this.m_wcontext._isInboundOperation) {
            PCInboundBinding pcib = (PCInboundBinding)this.m_wcontext._extReg.createExtension(PCInboundBinding.PARENT_CLASS, PCInboundBinding.FIELD_ELEMENT_TYPE);
            bind1.addExtensibilityElement((ExtensibilityElement)pcib);
            if (uiTransmissionPrimitive != null) {
                pcib.setAttributeValue("UITransmissionPrimitive", uiTransmissionPrimitive);
            }
        } else {
            JcaBinding jb1 = (JcaBinding)this.m_wcontext._extReg.createExtension(JcaBinding.PARENT_CLASS, JcaBinding.FIELD_ELEMENT_TYPE);
            bind1.addExtensibilityElement((ExtensibilityElement)jb1);
            if (uiTransmissionPrimitive != null) {
                jb1.setAttributeValue("UITransmissionPrimitive", uiTransmissionPrimitive);
            }
        }
        BindingOperation oper2 = def1.createBindingOperation();
        oper2.setName(operationName);
        bind1.addBindingOperation(oper2);
        this.m_wcontext._write_operation_physical = oper2;
        JcaOperation jop = (JcaOperation)this.m_wcontext._extReg.createExtension(JcaOperation.PARENT_CLASS, JcaOperation.FIELD_ELEMENT_TYPE);
        this.m_wcontext._write_operation_physical.addExtensibilityElement((ExtensibilityElement)jop);
        this.m_wcontext._write_jca_operation = jop;
        Port port1 = this.m_wcontext._write_port;
        port1.setName(operationName + this.m_wcontext.Port_suffix);
        port1.setBinding(bind1);
    }

    public PortType createPortType(String portTypeName) throws WSDLException {
        Definition def = this.m_wcontext._write_definition;
        PortType portType = def.createPortType();
        QName qName = new QName(this.m_wcontext._target_namespace, portTypeName);
        portType.setQName(qName);
        portType.setUndefined(false);
        def.addPortType(portType);
        return portType;
    }

    public PartnerLinkType createPartnerLinkType(String inboundOperationName, String outboundOperationName, PortType inboundPortType, PortType outboundPortType) throws WSDLException {
        QName inboundPortTypeName = null;
        QName outboundPortTypeName = null;
        if (inboundPortType != null) {
            inboundPortTypeName = inboundPortType.getQName();
        }
        if (outboundPortType != null) {
            outboundPortTypeName = outboundPortType.getQName();
        }
        PartnerLinkType plt = null;
        Definition def = this.m_wcontext._write_definition;
        plt = (PartnerLinkType)this.m_wcontext._extReg.createExtension(PartnerLinkType.PARENT_CLASS, PartnerLinkType.FIELD_ELEMENT_TYPE);
        def.addExtensibilityElement((ExtensibilityElement)plt);
        plt.setContext(this.m_wcontext);
        this.m_wcontext._partnerLinkType_name = this.m_wcontext._write_service_name + this.m_wcontext.PartnerLinkType_suffix;
        plt.setPartnerLinkTypeName(this.m_wcontext._partnerLinkType_name);
        if (this.m_wcontext._importedWsdlInfo != null) {
            def.addNamespace("imp1", inboundPortTypeName.getNamespaceURI());
            plt.setPortNSPrefix("imp1");
            plt.setPortNSPrefix2("imp1");
            if (inboundPortTypeName != null && outboundPortTypeName != null && !inboundPortTypeName.getNamespaceURI().equals(outboundPortTypeName.getNamespaceURI())) {
                def.addNamespace(OUTPUT_NAMESPACE_PREFIX, outboundPortTypeName.getNamespaceURI());
                plt.setPortNSPrefix2(OUTPUT_NAMESPACE_PREFIX);
            }
        }
        if (inboundOperationName != null) {
            plt.setRoleName(inboundOperationName + this.m_wcontext.Role_suffix);
        }
        if (outboundOperationName != null) {
            plt.setRoleName2(outboundOperationName + this.m_wcontext.Role_suffix);
        }
        if (inboundOperationName != null && inboundPortTypeName != null) {
            plt.setPortName(inboundPortTypeName.getLocalPart());
        }
        if (outboundOperationName != null && outboundPortTypeName != null) {
            plt.setPortName2(outboundPortTypeName.getLocalPart());
        }
        return plt;
    }

    public String selectDirectory() {
        String tempstr = null;
        if (AdapterWizardContext.IS_STANDALONE_TESTING || this.m_wcontext.isStandalone()) {
            JFileChooser m_filechooser = new JFileChooser();
            m_filechooser.setFileSelectionMode(1);
            int returnVal = m_filechooser.showDialog(this, this.getTranslatedString("CM_WZ_SELECT_DIRECTORY_TITLE"));
            if (returnVal == 0) {
                File file = m_filechooser.getSelectedFile();
                tempstr = file.getAbsolutePath();
            }
        } else {
            URLChooser m_urlchooser = DialogUtil.newURLChooser((URL)null);
            m_urlchooser.setSelectionScope(1);
            int ret = m_urlchooser.showOpenDialog((Component)this);
            if (ret == 0) {
                URL xslURL = m_urlchooser.getSelectedURL();
                File file1 = new File(xslURL.getFile());
                tempstr = file1.toString();
            }
        }
        return tempstr;
    }

    public String selectFile() {
        String tempstr = null;
        if (AdapterWizardContext.IS_STANDALONE_TESTING || this.m_wcontext.isStandalone()) {
            JFileChooser m_filechooser = new JFileChooser();
            m_filechooser.setFileSelectionMode(0);
            int returnVal = m_filechooser.showDialog(this, this.getTranslatedString("CM_WZ_SELECT_FILE"));
            if (returnVal == 0) {
                File file = m_filechooser.getSelectedFile();
                tempstr = file.getAbsolutePath();
            }
        } else {
            URLChooser m_urlchooser = DialogUtil.newURLChooser((URL)null);
            m_urlchooser.setSelectionScope(0);
            int ret = m_urlchooser.showOpenDialog((Component)this);
            if (ret == 0) {
                URL xslURL = m_urlchooser.getSelectedURL();
                File file1 = new File(xslURL.getFile());
                tempstr = file1.toString();
            }
        }
        return tempstr;
    }

    public int getInt(Object numobj) {
        int retint = 0;
        if (numobj instanceof Long) {
            retint = ((Long)numobj).intValue();
        } else if (numobj instanceof Integer) {
            retint = (Integer)numobj;
        } else if (numobj instanceof Double) {
            retint = ((Double)numobj).intValue();
        }
        return retint;
    }

    public long getLong(Object numobj) {
        long retint = 0L;
        if (numobj instanceof Long) {
            retint = (Long)numobj;
        } else if (numobj instanceof Integer) {
            retint = ((Integer)numobj).longValue();
        } else if (numobj instanceof Double) {
            retint = ((Double)numobj).longValue();
        }
        return retint;
    }

    public String getTranslatedString(String messageKey) {
        return this.m_wcontext._bundle.getString(messageKey);
    }

    public static Icon getIcon(String iconPath, Class objClass) {
        Image img = GraphicsUtils.loadFromResource((String)iconPath, (Class)objClass);
        return GraphicsUtils.createImageIcon((Image)img);
    }
}

