/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.socket;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.ui.TitledSeparator;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.resourcepicker.ResourcePickerDialog;
import oracle.tip.tools.ide.common.sca.CommonScaUtils;
import oracle.tip.tools.ide.common.ui.GlobalImageCache;
import oracle.tip.tools.ide.fabric.addin.SCAProject;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardFinishInterface;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.socket.SocketAdapterBasePage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.socket.SocketAdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.JcaOperation;
import oracle.tip.tools.ide.tx.addin.MapperCreator;
import oracle.tip.tools.ide.tx.addin.MapperNode;
import oracle.tip.tools.ide.tx.addin.MapperSource;
import oracle.tip.tools.ide.tx.addin.MapperTarget;

public class SocketAdapterProtocolPage
extends SocketAdapterBasePage
implements ActionListener,
DocumentListener,
FocusListener,
MouseListener,
ItemListener,
AdapterWizardFinishInterface {
    private MultiLineLabel introLabel;
    private final JRadioButton xsltRadioButton = new JRadioButton();
    private final JRadioButton customImplRadioButton = new JRadioButton();
    private final JRadioButton nxsdRadioButton = new JRadioButton();
    private final ButtonGroup protocolRadioButtonGroup = new ButtonGroup();
    private final JPanel spacer = new JPanel();
    private final JLabel xsltLabel = new JLabel();
    private final JLabel replyXsltLabel = new JLabel();
    private final JLabel classLabel = new JLabel();
    private final JTextField xsltTextField = new JTextField(15);
    private final JTextField replyXsltTextField = new JTextField(15);
    private final JTextField classTextField = new JTextField(15);
    private JButton xsltTextFieldBrowseButton;
    private JButton replyXsltTextFieldBrowseButton;
    private JButton createXsltButton;
    private JButton createReplyXsltButton;
    private static final TitledSeparator separator = new TitledSeparator("Encoding/ByteOrder");
    public static boolean xslt = false;
    public static boolean custImpl = false;
    public static boolean nxsd = false;
    private static EmptyBorder s_emptyBorder = new EmptyBorder(2, 2, 2, 2);
    private static EtchedBorder s_etchedBorder = new EtchedBorder();
    private String m_lasturl = "";
    private boolean m_xslHasError = false;
    private String m_projectDirectoryPath;
    private SCAProject m_scaProject;
    private Project m_project;
    private URL m_projURL;
    private URL m_xslDirUrl;
    private URL m_xsdDirUrl;
    protected boolean m_bCreatingMapper;
    private static final String MAPPER_FILE_SUFFIX = ".xsl";
    private static final String xsdStr = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<?oracle-xsl-mapper\n<!-- DUMMY FILE USED BY THE MAPPER TOOL, DO NOT MODIFY. -->\n?>\n<schema attributeFormDefault=\"unqualified\"\n \telementFormDefault=\"qualified\"\n \ttargetNamespace=\"http://xmlns.oracle.com/singleString\"\n \txmlns=\"http://www.w3.org/2001/XMLSchema\">\n<element name=\"input\" type=\"string\"/>\n</schema>";
    private String newFileName;
    private String xslFile1 = null;
    private String xslFile2 = null;
    final List<MapperSource> mapperSources = new ArrayList<MapperSource>(1);
    final List<MapperTarget> mapperTargets = new ArrayList<MapperTarget>(1);
    final List<MapperSource> mapperSources1 = new ArrayList<MapperSource>(1);
    final List<MapperTarget> mapperTargets1 = new ArrayList<MapperTarget>(1);
    private MultiLineLabel introLabel1;
    public static final JRadioButton encodingValFromSchemaRadioButton = new JRadioButton();
    public static final JRadioButton encodingRadioButton = new JRadioButton();
    public static final JRadioButton byteOrderValFromSchemaRadioButton = new JRadioButton();
    public static final JRadioButton byteOrderRadioButton = new JRadioButton();
    private final ButtonGroup encodingRadioButtonGroup = new ButtonGroup();
    private final ButtonGroup byteOrderRadioButtonGroup = new ButtonGroup();
    private static final String[] encodings = new String[]{"ASCII", "Big5", "Big5_HKSCS", "Big5_Solaris", "EBCDIC (cp037)", "Cp1006", "Cp1025", "Cp1026", "Cp1046", "Cp1047", "Cp1097", "Cp1098", "Cp1112", "Cp1122", "Cp1123", "Cp1124", "Cp1140", "Cp1141", "Cp1142", "Cp1143", "Cp1144", "Cp1145", "Cp1146", "Cp1147", "Cp1148", "Cp1149", "Cp1250", "Cp1251", "Cp1252", "Cp1253", "Cp1254", "Cp1255", "Cp1256", "Cp1257", "Cp1258", "Cp1381", "Cp1383", "Cp273", "Cp277", "Cp278", "Cp280", "Cp284", "Cp285", "Cp297", "Cp33722", "Cp420", "Cp424", "Cp437", "Cp500", "Cp737", "Cp775", "Cp838", "Cp850", "Cp852", "Cp855", "Cp856", "Cp857", "Cp858", "Cp860", "Cp861", "Cp862", "Cp863", "Cp864", "Cp865", "Cp866", "Cp868", "Cp869", "Cp870", "Cp871", "Cp874", "Cp875", "Cp918", "Cp921", "Cp922", "Cp930", "Cp933", "Cp935", "Cp937", "Cp939", "Cp942", "Cp942C", "Cp943", "Cp943C", "Cp948", "Cp949", "Cp949C", "Cp950", "Cp964", "Cp970", "EUC_CN", "EUC_JP", "EUC_JP_LINUX", "EUC_KR", "EUC_TW", "GB18030", "GBK", "ISCII91", "ISO2022_CN_CNS", "ISO2022_CN_GB", "ISO2022JP", "ISO2022KR", "ISO8859_1", "ISO8859_13", "ISO8859_15", "ISO8859_2", "ISO8859_3", "ISO8859_4", "ISO8859_5", "ISO8859_6", "ISO8859_7", "ISO8859_8", "ISO8859_9", "JISAutoDetect", "KOI8_R", "MacArabic", "MacCentralEurope", "MacCroatian", "MacCyrillic", "MacDingbat", "MacGreek", "MacHebrew", "MacIceland", "MacRoman", "MacRomania", "MacSymbol", "MacThai", "MacTurkish", "MacUkraine", "MS874", "MS932", "MS936", "MS949", "MS950", "MS950_HKSCS", "SJIS", "TIS620", "UnicodeBig", "UnicodeBigUnmarked", "UnicodeLittle", "UnicodeLittleUnmarked", "UTF-16", "UTF-16BE", "UTF-16LE", "UTF8"};
    private static final String[] byteOrders = new String[]{"BIG_ENDIAN", "LITTLE_ENDIAN"};
    private final JComboBox encodingComboBox = new JComboBox<String>(encodings);
    private final JComboBox byteOrderComboBox = new JComboBox<String>(byteOrders);
    private final JCheckBox encodingByteOrderCheckBox = new JCheckBox();
    private boolean encodingValFromSchema = false;
    private boolean byteOrderValFromSchema = false;
    private boolean encoding = false;
    private boolean byteOrder = false;
    private boolean browsedXSL = false;

    public SocketAdapterProtocolPage(AdapterWizardContext wcontext, ImageWizardPage iwp) {
        this.setHelpTopicID("jdev_adp_wiz_socket_proto");
        this.setContextAndPage(wcontext, iwp);
        try {
            this.m_project = this.m_wcontext._project;
            this.m_projectDirectoryPath = this.m_wcontext.getFilePath();
            this.m_scaProject = SCAProject.getSCAProject((Project)this.m_project);
            this.m_projURL = this.m_scaProject.getSCARoot();
            this.m_xslDirUrl = this.m_scaProject.getXSLRoot();
            if (!AdapterWizardContext.IS_STANDALONE_TESTING) {
                this.m_xslDirUrl = this.m_scaProject.getXSLRoot();
                this.m_xsdDirUrl = this.m_scaProject.getXSDRoot();
            }
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        String intro = this.getTranslatedString("SOCKET_PR_INTRO_PROMPT");
        String xsltText = this.getTranslatedString("SOCKET_PR_XSLT_OPTION");
        String custImplText = this.getTranslatedString("SOCKET_PR_CUSTIMPL_OPTION");
        String nxsdText = this.getTranslatedString("SOCKET_PR_NXSD_OPTION");
        String xsltLabelText = this.getTranslatedString("SOCKET_PR_XSLT_LABEL");
        String replyXsltLabelText = this.getTranslatedString("SOCKET_PR_REPLYXSLT_LABEL");
        String classNameText = this.getTranslatedString("SOCKET_PR_CLASS_LABEL");
        String xsltPrompt = this.getTranslatedString("SOCKET_PR_XSLT_PROMPT");
        String replyXsltPrompt = this.getTranslatedString("SOCKET_PR_REPLYXSLT_PROMPT");
        String xsltTextFieldBrowseButtonText = this.getTranslatedString("SOCKET_PR_XSLT_BROWSE_BUTTON_TEXT");
        String xsltTextFieldBrowseButtonTip = this.getTranslatedString("SOCKET_PR_XSLT_BROWSE_BUTTON_TIP");
        String createXsltButtonText = this.getTranslatedString("SOCKET_PR_XSLT_CREATE_BUTTON_TEXT");
        String createXsltButtonTip = this.getTranslatedString("SOCKET_PR_XSLT_CREATE_BUTTON_TIP");
        String classLabelText = this.getTranslatedString("SOCKET_PR_CLASS_LABEL_TEXT");
        String intro1 = this.getTranslatedString("SOCKET_ST_INTRO_PROMPT");
        String encodingValFromSchemaText = this.getTranslatedString("SOCKET_ST_USE_ENC_FROM_SCHEMA");
        String encodingValText = this.getTranslatedString("SOCKET_ST_ENC_TXT");
        String byteOrderValFromSchemaText = this.getTranslatedString("SOCKET_ST_USE_BO_FROM_SCHEMA");
        String byteOrderValText = this.getTranslatedString("SOCKET_ST_BO_TXT");
        String encodingByteOrderCheckBoxTxt = this.getTranslatedString("SOCKET_ST_CHKBOX_TXT");
        this.setLayout(new GridBagLayout());
        this.introLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), intro);
        this.xsltRadioButton.setText(StringUtils.stripMnemonic((String)xsltText));
        this.xsltRadioButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)xsltText));
        this.customImplRadioButton.setText(StringUtils.stripMnemonic((String)custImplText));
        this.customImplRadioButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)custImplText));
        this.nxsdRadioButton.setSelected(true);
        this.nxsdRadioButton.setText(StringUtils.stripMnemonic((String)nxsdText));
        this.nxsdRadioButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)nxsdText));
        this.protocolRadioButtonGroup.add(this.xsltRadioButton);
        this.protocolRadioButtonGroup.add(this.customImplRadioButton);
        this.protocolRadioButtonGroup.add(this.nxsdRadioButton);
        this.xsltRadioButton.addActionListener(this);
        this.customImplRadioButton.addActionListener(this);
        this.nxsdRadioButton.addActionListener(this);
        this.xsltLabel.setText(xsltLabelText);
        this.xsltTextField.setText("");
        this.xsltTextField.setEditable(false);
        this.xsltTextField.getAccessibleContext().setAccessibleName(xsltPrompt);
        this.xsltTextField.addFocusListener(this);
        this.xsltTextField.getDocument().addDocumentListener(this);
        this.xsltTextFieldBrowseButton = new JButton(GlobalImageCache.getIcon((String)"browse16"));
        this.xsltTextFieldBrowseButton.setBorder(s_emptyBorder);
        this.xsltTextFieldBrowseButton.setRequestFocusEnabled(false);
        this.xsltTextFieldBrowseButton.addActionListener(this);
        this.xsltTextFieldBrowseButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)xsltTextFieldBrowseButtonText));
        this.xsltTextFieldBrowseButton.setActionCommand("Browse");
        this.xsltTextFieldBrowseButton.setToolTipText(xsltTextFieldBrowseButtonTip);
        this.xsltTextFieldBrowseButton.getAccessibleContext().setAccessibleDescription(xsltTextFieldBrowseButtonTip);
        this.xsltTextFieldBrowseButton.getAccessibleContext().setAccessibleName(xsltTextFieldBrowseButtonText);
        this.xsltTextFieldBrowseButton.addMouseListener(this);
        this.xsltTextFieldBrowseButton.setEnabled(false);
        this.createXsltButton = new JButton(GlobalImageCache.getIcon((String)"create16"));
        this.createXsltButton.setBorder(s_emptyBorder);
        this.createXsltButton.setRequestFocusEnabled(false);
        this.createXsltButton.addActionListener(this);
        this.createXsltButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)createXsltButtonText));
        this.createXsltButton.setActionCommand("Create");
        this.createXsltButton.setToolTipText(createXsltButtonTip);
        this.createXsltButton.getAccessibleContext().setAccessibleDescription(createXsltButtonTip);
        this.createXsltButton.getAccessibleContext().setAccessibleName(createXsltButtonText);
        this.createXsltButton.addMouseListener(this);
        this.createXsltButton.setEnabled(false);
        this.createReplyXsltButton = new JButton(GlobalImageCache.getIcon((String)"create16"));
        this.createReplyXsltButton.setBorder(s_emptyBorder);
        this.createReplyXsltButton.setRequestFocusEnabled(false);
        this.createReplyXsltButton.addActionListener(this);
        this.createReplyXsltButton.setActionCommand("Create");
        this.createReplyXsltButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)createXsltButtonText));
        this.createReplyXsltButton.setToolTipText(createXsltButtonTip);
        this.createReplyXsltButton.getAccessibleContext().setAccessibleDescription(createXsltButtonTip);
        this.createReplyXsltButton.getAccessibleContext().setAccessibleName(createXsltButtonText);
        this.createReplyXsltButton.addMouseListener(this);
        this.createReplyXsltButton.setEnabled(false);
        this.replyXsltLabel.setText(replyXsltLabelText);
        this.replyXsltTextField.setText("");
        this.replyXsltTextField.setEditable(false);
        this.replyXsltTextField.getAccessibleContext().setAccessibleName(replyXsltPrompt);
        this.replyXsltTextField.getDocument().addDocumentListener(this);
        this.replyXsltTextFieldBrowseButton = new JButton(GlobalImageCache.getIcon((String)"browse16"));
        this.replyXsltTextFieldBrowseButton.addActionListener(this);
        this.replyXsltTextFieldBrowseButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)createXsltButtonText));
        this.replyXsltTextFieldBrowseButton.setBorder(s_emptyBorder);
        this.replyXsltTextFieldBrowseButton.setRequestFocusEnabled(false);
        this.replyXsltTextFieldBrowseButton.setActionCommand("Browse");
        this.replyXsltTextFieldBrowseButton.setToolTipText(xsltTextFieldBrowseButtonTip);
        this.replyXsltTextFieldBrowseButton.getAccessibleContext().setAccessibleDescription(xsltTextFieldBrowseButtonTip);
        this.replyXsltTextFieldBrowseButton.getAccessibleContext().setAccessibleName(xsltTextFieldBrowseButtonText);
        this.replyXsltTextFieldBrowseButton.addMouseListener(this);
        this.replyXsltTextFieldBrowseButton.setEnabled(false);
        this.classLabel.setText(classLabelText);
        this.classTextField.setText("");
        this.classTextField.setEditable(false);
        this.classTextField.getDocument().addDocumentListener(this);
        this.introLabel1 = new MultiLineLabel(WordWrapper.getTextWrapper(), intro1);
        this.encodingByteOrderCheckBox.setText(StringUtils.stripMnemonic((String)encodingByteOrderCheckBoxTxt));
        this.encodingByteOrderCheckBox.addItemListener(this);
        this.encodingByteOrderCheckBox.setSelected(false);
        this.encodingByteOrderCheckBox.setEnabled(true);
        encodingValFromSchemaRadioButton.setText(StringUtils.stripMnemonic((String)encodingValFromSchemaText));
        encodingValFromSchemaRadioButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)encodingValFromSchemaText));
        encodingValFromSchemaRadioButton.setEnabled(false);
        encodingRadioButton.setText(StringUtils.stripMnemonic((String)encodingValText));
        encodingRadioButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)encodingValText));
        encodingRadioButton.setEnabled(false);
        byteOrderValFromSchemaRadioButton.setText(StringUtils.stripMnemonic((String)byteOrderValFromSchemaText));
        byteOrderValFromSchemaRadioButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)byteOrderValFromSchemaText));
        byteOrderValFromSchemaRadioButton.setEnabled(false);
        byteOrderRadioButton.setText(StringUtils.stripMnemonic((String)byteOrderValText));
        byteOrderRadioButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)byteOrderValText));
        byteOrderRadioButton.setEnabled(false);
        this.encodingRadioButtonGroup.add(encodingValFromSchemaRadioButton);
        this.encodingRadioButtonGroup.add(encodingRadioButton);
        this.byteOrderRadioButtonGroup.add(byteOrderValFromSchemaRadioButton);
        this.byteOrderRadioButtonGroup.add(byteOrderRadioButton);
        encodingValFromSchemaRadioButton.addActionListener(this);
        encodingRadioButton.addActionListener(this);
        byteOrderValFromSchemaRadioButton.addActionListener(this);
        byteOrderRadioButton.addActionListener(this);
        this.encodingComboBox.addActionListener(this);
        this.byteOrderComboBox.addActionListener(this);
        this.encodingComboBox.setEnabled(false);
        this.byteOrderComboBox.setEnabled(false);
        this.encodingComboBox.setEditable(true);
        int y = 0;
        this.add((Component)this.introLabel, this.gbc(0, y++, 0, 1, 1.0, 0.0, 18, 2, in0000));
        this.add((Component)this.xsltRadioButton, this.gbc(0, y++, 0, 1, 0.0, 0.0, 17, 0, in10000));
        this.add((Component)this.xsltLabel, this.gbc(0, y, 1, 1, 0.0, 0.0, 17, 0, in51700));
        this.add((Component)this.xsltTextField, this.gbc(1, y, 1, 1, 1.0, 0.0, 17, 2, in5600));
        this.add((Component)this.xsltTextFieldBrowseButton, this.gbc(2, y, 1, 1, 0.0, 0.0, 17, 0, in5805));
        this.add((Component)this.createXsltButton, this.gbc(3, y++, 1, 1, 0.0, 0.0, 17, 0, in5205));
        if (((SocketAdapterWizardContext)this.m_wcontext._ascontext).operationType == "InboundRequestReply") {
            this.add((Component)this.replyXsltLabel, this.gbc(0, y, 1, 1, 0.0, 0.0, 17, 0, in51700));
            this.add((Component)this.replyXsltTextField, this.gbc(1, y, 1, 1, 1.0, 0.0, 17, 2, in5600));
            this.add((Component)this.replyXsltTextFieldBrowseButton, this.gbc(2, y, 1, 1, 0.0, 0.0, 17, 0, in5805));
            this.add((Component)this.createReplyXsltButton, this.gbc(3, y++, 1, 1, 0.0, 0.0, 17, 0, in5205));
        }
        this.add((Component)this.customImplRadioButton, this.gbc(0, y++, 0, 1, 0.0, 0.0, 17, 0, in10000));
        this.add((Component)this.classLabel, this.gbc(0, y, 1, 1, 0.0, 0.0, 17, 0, in51700));
        this.add((Component)this.classTextField, this.gbc(1, y++, 1, 1, 1.0, 0.0, 17, 2, in5600));
        this.add((Component)this.nxsdRadioButton, this.gbc(0, y++, 0, 1, 0.0, 0.0, 17, 0, in10000));
        this.add((Component)separator, this.gbc(0, y++, 0, 1, 0.0, 0.0, 17, 2, in10000));
        this.add((Component)this.introLabel1, this.gbc(0, y++, 0, 1, 1.0, 0.0, 18, 2, in10000));
        this.add((Component)this.encodingByteOrderCheckBox, this.gbc(0, y++, 0, 1, 1.0, 0.0, 18, 0, in13000));
        this.add((Component)encodingValFromSchemaRadioButton, this.gbc(0, y++, 1, 1, 0.0, 0.0, 17, 0, in10400));
        this.add((Component)encodingRadioButton, this.gbc(0, y, 1, 1, 0.0, 0.0, 17, 0, in5400));
        this.add((Component)this.encodingComboBox, this.gbc(1, y++, 1, 1, 1.0, 0.0, 17, 2, in5400));
        this.add((Component)byteOrderValFromSchemaRadioButton, this.gbc(0, y++, 1, 1, 0.0, 0.0, 17, 0, in10400));
        this.add((Component)byteOrderRadioButton, this.gbc(0, y, 1, 1, 0.0, 0.0, 17, 0, in5400));
        this.add((Component)this.byteOrderComboBox, this.gbc(1, y++, 1, 1, 1.0, 0.0, 17, 2, in5400));
        this.add((Component)this.spacer, this.gbc(0, y, 1, 1, 0.0, 1.0, 18, 0, in0000));
        if (this.m_wcontext._read_service != null) {
            this.initFromWSDL();
        }
        this.m_page.setCanAdvance(true);
    }

    public void wizardValidate() {
        if (this.xsltRadioButton.isSelected()) {
            String replyXslt;
            String xslt = this.xsltTextField.getText();
            if (xslt == null || xslt.length() == 0) {
                this.m_page.setCanAdvance(false);
                return;
            }
            if (((SocketAdapterWizardContext)this.m_wcontext._ascontext).operationType == "InboundRequestReply" && ((replyXslt = this.replyXsltTextField.getText()) == null || replyXslt.length() == 0)) {
                this.m_page.setCanAdvance(false);
                return;
            }
            this.m_page.setCanAdvance(true);
        }
        if (this.customImplRadioButton.isSelected()) {
            String className = this.classTextField.getText();
            if (className == null || className.length() == 0) {
                this.m_page.setCanAdvance(false);
                return;
            }
            this.m_page.setCanAdvance(true);
        }
        if (this.nxsdRadioButton.isSelected()) {
            this.m_page.setCanAdvance(true);
        }
    }

    @Override
    public boolean beforeWSDL(AdapterWizardContext _wcontext) {
        return true;
    }

    @Override
    public void afterWSDL(AdapterWizardContext _wcontext) {
        String t;
        Context jdevcontext;
        if (!xslt || this.browsedXSL || !this.xsltRadioButton.isSelected()) {
            return;
        }
        if (this.mapperSources.size() != 0) {
            jdevcontext = Context.newIdeContext();
            t = this.xsltTextField.getText();
            this.xslFile1 = t.substring(4, t.length());
            final URL mapperURL = URLFactory.newURL((URL)this.m_xslDirUrl, (String)this.xslFile1);
            Runnable createMapperRunnable = new Runnable(){

                @Override
                public void run() {
                    new MapperCreator(jdevcontext).createMapper(mapperURL, SocketAdapterProtocolPage.this.mapperSources, SocketAdapterProtocolPage.this.mapperTargets, true);
                }
            };
            SwingUtilities.invokeLater(createMapperRunnable);
        }
        if (((SocketAdapterWizardContext)this.m_wcontext._ascontext).operationType == "InboundRequestReply" && this.mapperSources1.size() != 0) {
            jdevcontext = Context.newIdeContext();
            t = this.replyXsltTextField.getText();
            this.xslFile2 = t.substring(4, t.length());
            final URL mapperURL1 = URLFactory.newURL((URL)this.m_xslDirUrl, (String)this.xslFile2);
            Runnable createMapperRunnable1 = new Runnable(){

                @Override
                public void run() {
                    new MapperCreator(jdevcontext).createMapper(mapperURL1, SocketAdapterProtocolPage.this.mapperSources1, SocketAdapterProtocolPage.this.mapperTargets1, true);
                }
            };
            SwingUtilities.invokeLater(createMapperRunnable1);
        }
    }

    private void checkDummyXsd() {
        String dummyXsd = URLFileSystem.getPath((URL)URLFactory.newURL((URL)this.m_xsdDirUrl, (String)"dummy.xsd"));
        File file = new File(dummyXsd);
        if (!file.exists()) {
            try {
                FileWriter writer = new FileWriter(file);
                writer.write(xsdStr);
                writer.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void wizardValidatePage(WizardEvent event) {
        this.checkDummyXsd();
    }

    public String createNewMapFile(Object src) {
        String initialSelectionValue = "";
        String newFileName = "";
        this.checkDummyXsd();
        if (src == this.createXsltButton) {
            if (((SocketAdapterWizardContext)this.m_wcontext._ascontext).operationType == "InboundRequestReply") {
                initialSelectionValue = "request.xsl";
                newFileName = JOptionPane.showInputDialog(this.getTranslatedString("SOCKET_PR_XSLT_DLG_CREATE_MESSAGE"), (Object)initialSelectionValue);
            }
            if (((SocketAdapterWizardContext)this.m_wcontext._ascontext).operationType == "Invoke" || ((SocketAdapterWizardContext)this.m_wcontext._ascontext).operationType == "OutboundRequestReply") {
                initialSelectionValue = "invoke.xsl";
                newFileName = JOptionPane.showInputDialog(this.getTranslatedString("SOCKET_PR_XSLT_DLG_CREATE_MESSAGE"), (Object)initialSelectionValue);
            }
            if (((SocketAdapterWizardContext)this.m_wcontext._ascontext).operationType == "Receive") {
                initialSelectionValue = "receive.xsl";
                newFileName = JOptionPane.showInputDialog(this.getTranslatedString("SOCKET_PR_XSLT_DLG_CREATE_MESSAGE"), (Object)initialSelectionValue);
            }
            if (newFileName == null || newFileName.length() == 0) {
                return "";
            }
            if (!newFileName.endsWith(MAPPER_FILE_SUFFIX)) {
                newFileName = newFileName + MAPPER_FILE_SUFFIX;
            }
            this.browsedXSL = false;
            this.checkDummyXsd();
            if (this.mapperSources.size() > 0) {
                this.mapperSources.clear();
            }
            if (this.mapperTargets.size() > 0) {
                this.mapperTargets.clear();
            }
            if (((SocketAdapterWizardContext)this.m_wcontext._ascontext).operationType == "InboundRequestReply") {
                this.mapperSources.add(new MapperSource(1, URLFactory.newURL((URL)this.m_xsdDirUrl, (String)"dummy.xsd"), new QName("http://xmlns.oracle.com/singleString", "input")));
                if (!((SocketAdapterWizardContext)this.m_wcontext._ascontext).requestSchemaOpaque) {
                    this.mapperTargets.add(new MapperTarget(1, URLFactory.newURL((URL)this.m_xsdDirUrl, (String)((SocketAdapterWizardContext)this.m_wcontext._ascontext).requestSchemaLocation), new QName(((SocketAdapterWizardContext)this.m_wcontext._ascontext).requestSchemaNamespace, ((SocketAdapterWizardContext)this.m_wcontext._ascontext).requestElementName)));
                } else {
                    this.mapperTargets.add(new MapperTarget(1, URLFactory.newURL((URL)this.m_xsdDirUrl, (String)"dummy.xsd"), new QName("http://xmlns.oracle.com/singleString", "input")));
                }
            }
            if (((SocketAdapterWizardContext)this.m_wcontext._ascontext).operationType == "OutboundRequestReply") {
                if (!((SocketAdapterWizardContext)this.m_wcontext._ascontext).requestSchemaOpaque) {
                    this.mapperSources.add(new MapperSource(1, URLFactory.newURL((URL)this.m_xsdDirUrl, (String)((SocketAdapterWizardContext)this.m_wcontext._ascontext).requestSchemaLocation), new QName(((SocketAdapterWizardContext)this.m_wcontext._ascontext).requestSchemaNamespace, ((SocketAdapterWizardContext)this.m_wcontext._ascontext).requestElementName)));
                } else {
                    this.mapperSources.add(new MapperSource(1, URLFactory.newURL((URL)this.m_xsdDirUrl, (String)"dummy.xsd"), new QName("http://xmlns.oracle.com/singleString", "input")));
                }
                if (((SocketAdapterWizardContext)this.m_wcontext._ascontext).replySchemaOpaque) {
                    this.mapperTargets.add(new MapperTarget(1, URLFactory.newURL((URL)this.m_xsdDirUrl, (String)"dummy.xsd"), new QName("http://xmlns.oracle.com/singleString", "input")));
                } else {
                    this.mapperTargets.add(new MapperTarget(1, URLFactory.newURL((URL)this.m_xsdDirUrl, (String)((SocketAdapterWizardContext)this.m_wcontext._ascontext).replySchemaLocation), new QName(((SocketAdapterWizardContext)this.m_wcontext._ascontext).replySchemaNamespace, ((SocketAdapterWizardContext)this.m_wcontext._ascontext).replyElementName)));
                }
            }
            if (((SocketAdapterWizardContext)this.m_wcontext._ascontext).operationType == "Receive") {
                this.mapperSources.add(new MapperSource(1, URLFactory.newURL((URL)this.m_xsdDirUrl, (String)"dummy.xsd"), new QName("http://xmlns.oracle.com/singleString", "input")));
                if (((SocketAdapterWizardContext)this.m_wcontext._ascontext).requestSchemaOpaque) {
                    this.mapperTargets.add(new MapperTarget(1, URLFactory.newURL((URL)this.m_xsdDirUrl, (String)"dummy.xsd"), new QName("http://xmlns.oracle.com/singleString", "input")));
                } else {
                    this.mapperTargets.add(new MapperTarget(1, URLFactory.newURL((URL)this.m_xsdDirUrl, (String)((SocketAdapterWizardContext)this.m_wcontext._ascontext).requestSchemaLocation), new QName(((SocketAdapterWizardContext)this.m_wcontext._ascontext).requestSchemaNamespace, ((SocketAdapterWizardContext)this.m_wcontext._ascontext).requestElementName)));
                }
            }
            if (((SocketAdapterWizardContext)this.m_wcontext._ascontext).operationType == "Invoke") {
                if (((SocketAdapterWizardContext)this.m_wcontext._ascontext).requestSchemaOpaque) {
                    this.mapperSources.add(new MapperSource(1, URLFactory.newURL((URL)this.m_xsdDirUrl, (String)"dummy.xsd"), new QName("http://xmlns.oracle.com/singleString", "input")));
                } else {
                    this.mapperSources.add(new MapperSource(1, URLFactory.newURL((URL)this.m_xsdDirUrl, (String)((SocketAdapterWizardContext)this.m_wcontext._ascontext).requestSchemaLocation), new QName(((SocketAdapterWizardContext)this.m_wcontext._ascontext).requestSchemaNamespace, ((SocketAdapterWizardContext)this.m_wcontext._ascontext).requestElementName)));
                }
                this.mapperTargets.add(new MapperTarget(1, URLFactory.newURL((URL)this.m_xsdDirUrl, (String)"dummy.xsd"), new QName("http://xmlns.oracle.com/singleString", "input")));
            }
        } else {
            initialSelectionValue = "reply.xsl";
            newFileName = JOptionPane.showInputDialog(this.getTranslatedString("SOCKET_PR_XSLT_DLG_CREATE_MESSAGE"), (Object)initialSelectionValue);
            if (newFileName == null || newFileName.length() == 0) {
                return "";
            }
            if (!newFileName.endsWith(MAPPER_FILE_SUFFIX)) {
                newFileName = newFileName + MAPPER_FILE_SUFFIX;
            }
            if (this.mapperSources1.size() > 0) {
                this.mapperSources1.clear();
            }
            if (this.mapperTargets1.size() > 0) {
                this.mapperTargets1.clear();
            }
            this.checkDummyXsd();
            if (!((SocketAdapterWizardContext)this.m_wcontext._ascontext).replySchemaOpaque) {
                this.mapperSources1.add(new MapperSource(1, URLFactory.newURL((URL)this.m_xsdDirUrl, (String)((SocketAdapterWizardContext)this.m_wcontext._ascontext).replySchemaLocation), new QName(((SocketAdapterWizardContext)this.m_wcontext._ascontext).replySchemaNamespace, ((SocketAdapterWizardContext)this.m_wcontext._ascontext).replyElementName)));
            } else {
                this.mapperSources1.add(new MapperSource(1, URLFactory.newURL((URL)this.m_xsdDirUrl, (String)"dummy.xsd"), new QName("http://xmlns.oracle.com/singleString", "input")));
            }
            this.mapperTargets1.add(new MapperTarget(1, URLFactory.newURL((URL)this.m_xsdDirUrl, (String)"dummy.xsd"), new QName("http://xmlns.oracle.com/singleString", "input")));
            this.browsedXSL = false;
        }
        URL mapperURL = URLFactory.newURL((URL)this.m_xslDirUrl, (String)newFileName);
        return URLFileSystem.toRelativeSpec((URL)mapperURL, (URL)this.m_projURL);
    }

    private void updateControls(boolean isInitialization, ActionEvent e) {
        Object src = e.getSource();
        if (src == this.xsltRadioButton) {
            xslt = true;
            custImpl = false;
            nxsd = false;
            this.encodingByteOrderCheckBox.setEnabled(true);
            if (this.encodingByteOrderCheckBox.isSelected()) {
                encodingRadioButton.setEnabled(true);
                encodingValFromSchemaRadioButton.setEnabled(true);
                byteOrderRadioButton.setEnabled(true);
                byteOrderValFromSchemaRadioButton.setEnabled(true);
                this.encodingComboBox.setEnabled(true);
                this.byteOrderComboBox.setEnabled(true);
            }
            this.classTextField.setEditable(false);
            this.xsltTextFieldBrowseButton.setEnabled(true);
            this.replyXsltTextFieldBrowseButton.setEnabled(true);
            this.createXsltButton.setEnabled(true);
            this.createReplyXsltButton.setEnabled(true);
        } else if (src == this.customImplRadioButton) {
            xslt = false;
            custImpl = true;
            nxsd = false;
            this.encodingByteOrderCheckBox.setEnabled(false);
            encodingRadioButton.setEnabled(false);
            encodingValFromSchemaRadioButton.setEnabled(false);
            byteOrderRadioButton.setEnabled(false);
            byteOrderValFromSchemaRadioButton.setEnabled(false);
            this.encodingComboBox.setEnabled(false);
            this.byteOrderComboBox.setEnabled(false);
            this.classTextField.setEditable(true);
            this.xsltTextField.setEditable(false);
            this.replyXsltTextField.setEditable(false);
            this.xsltTextFieldBrowseButton.setEnabled(false);
            this.replyXsltTextFieldBrowseButton.setEnabled(false);
            this.createXsltButton.setEnabled(false);
            this.createReplyXsltButton.setEnabled(false);
        } else if (src == this.nxsdRadioButton) {
            xslt = false;
            custImpl = false;
            nxsd = true;
            this.encodingByteOrderCheckBox.setEnabled(true);
            if (this.encodingByteOrderCheckBox.isSelected()) {
                encodingRadioButton.setEnabled(true);
                encodingValFromSchemaRadioButton.setEnabled(true);
                byteOrderRadioButton.setEnabled(true);
                byteOrderValFromSchemaRadioButton.setEnabled(true);
                this.encodingComboBox.setEnabled(true);
                this.byteOrderComboBox.setEnabled(true);
            }
            this.classTextField.setEditable(false);
            this.xsltTextField.setEditable(false);
            this.replyXsltTextField.setEditable(false);
            this.xsltTextFieldBrowseButton.setEnabled(false);
            this.replyXsltTextFieldBrowseButton.setEnabled(false);
            this.createXsltButton.setEnabled(false);
            this.createReplyXsltButton.setEnabled(false);
        }
        if (src == this.xsltTextFieldBrowseButton) {
            this.handleBrowseXSL(true);
        } else if (src == this.replyXsltTextFieldBrowseButton) {
            this.handleBrowseXSL(false);
        } else if (src == this.createXsltButton) {
            this.xsltTextField.setText(this.createNewMapFile(src));
            String t = this.xsltTextField.getText();
            if (t.length() > 4) {
                this.xslFile1 = t.substring(4, t.length());
            }
        } else if (src == this.createReplyXsltButton) {
            this.replyXsltTextField.setText(this.createNewMapFile(src));
            String t = this.replyXsltTextField.getText();
            if (t.length() > 4) {
                this.xslFile2 = t.substring(4, t.length());
            }
        }
        if (this.encodingByteOrderCheckBox.isSelected() && (this.xsltRadioButton.isSelected() || this.nxsdRadioButton.isSelected())) {
            if (encodingValFromSchemaRadioButton.isSelected()) {
                this.encodingValFromSchema = true;
                this.encoding = false;
                this.encodingComboBox.setEnabled(false);
            }
            if (byteOrderValFromSchemaRadioButton.isSelected()) {
                this.byteOrderValFromSchema = true;
                this.byteOrder = false;
                this.byteOrderComboBox.setEnabled(false);
            }
            if (encodingRadioButton.isSelected()) {
                this.encodingValFromSchema = false;
                this.encoding = true;
                this.encodingComboBox.setEnabled(true);
            }
            if (byteOrderRadioButton.isSelected()) {
                this.byteOrderValFromSchema = false;
                this.byteOrder = true;
                this.byteOrderComboBox.setEnabled(true);
            }
        }
        this.wizardValidate();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            encodingValFromSchemaRadioButton.setEnabled(true);
            encodingRadioButton.setEnabled(true);
            if (this.encodingValFromSchema) {
                encodingValFromSchemaRadioButton.setSelected(true);
                this.encoding = false;
            } else {
                encodingRadioButton.setSelected(true);
                this.encodingComboBox.setEnabled(true);
                this.encoding = true;
            }
            byteOrderValFromSchemaRadioButton.setEnabled(true);
            byteOrderRadioButton.setEnabled(true);
            if (this.byteOrderValFromSchema) {
                byteOrderValFromSchemaRadioButton.setSelected(true);
                this.byteOrder = false;
            } else {
                byteOrderRadioButton.setSelected(true);
                this.byteOrderComboBox.setEnabled(true);
                this.byteOrder = true;
            }
        } else {
            encodingValFromSchemaRadioButton.setEnabled(false);
            encodingRadioButton.setEnabled(false);
            this.encodingComboBox.setEnabled(false);
            byteOrderValFromSchemaRadioButton.setEnabled(false);
            byteOrderRadioButton.setEnabled(false);
            this.byteOrderComboBox.setEnabled(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.updateControls(false, event);
    }

    private void checkDoc(DocumentEvent e) {
        this.wizardValidate();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.checkDoc(e);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.checkDoc(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.checkDoc(e);
    }

    @Override
    public void buildWSDL() throws WSDLException {
        String implClass;
        String xsltValue;
        JcaOperation jop = this.m_wcontext._write_jca_operation;
        if (this.m_wcontext._isInboundOperation) {
            jop.setAttributeValue("ActivationSpec", "oracle.tip.adapter.socket.SocketActivationSpec");
            if (xslt) {
                String replyXsltValue;
                jop.setAttributeValue("TransMode", "XSLT");
                xsltValue = this.xsltTextField.getText().trim();
                if (xsltValue != null && xsltValue.length() > 0) {
                    jop.setAttributeValue("Xslt", xsltValue);
                }
                if (((SocketAdapterWizardContext)this.m_wcontext._ascontext).operationType == "InboundRequestReply" && (replyXsltValue = this.replyXsltTextField.getText().trim()) != null && replyXsltValue.length() > 0) {
                    jop.setAttributeValue("ReplyXslt", replyXsltValue);
                }
            } else if (custImpl) {
                jop.setAttributeValue("TransMode", "CustomImpl");
                implClass = this.classTextField.getText().trim();
                if (implClass != null && implClass.length() > 0) {
                    jop.setAttributeValue("CustomImpl", implClass);
                }
            } else {
                jop.setAttributeValue("TransMode", "NXSD");
            }
        } else {
            jop.setAttributeValue("InteractionSpec", "oracle.tip.adapter.socket.SocketInteractionSpec");
            if (xslt) {
                jop.setAttributeValue("TransMode", "XSLT");
                xsltValue = this.xsltTextField.getText().trim();
                if (xsltValue != null && xsltValue.length() > 0) {
                    jop.setAttributeValue("Xslt", xsltValue);
                }
            } else if (custImpl) {
                jop.setAttributeValue("TransMode", "CustomImpl");
                implClass = this.classTextField.getText().trim();
                if (implClass != null && implClass.length() > 0) {
                    jop.setAttributeValue("CustomImpl", implClass);
                }
            } else {
                jop.setAttributeValue("TransMode", "NXSD");
            }
        }
        if (this.encodingByteOrderCheckBox.isSelected()) {
            jop.setAttributeValue("EncByteOrderCheckBox", "true");
            if (this.encoding) {
                String encodingVal = (String)this.encodingComboBox.getSelectedItem();
                jop.setAttributeValue("Encoding", encodingVal);
            }
            if (this.byteOrder) {
                String byteOrderVal = (String)this.byteOrderComboBox.getSelectedItem();
                jop.setAttributeValue("ByteOrder", byteOrderVal);
            }
        } else {
            jop.setAttributeValue("EncByteOrderCheckBox", "false");
        }
    }

    private void initFromWSDL() throws Exception {
        JcaOperation jop = this.m_wcontext._read_jca_operation;
        String transMode = jop.getAttributeValue("TransMode");
        if (transMode != null && transMode.equals("XSLT")) {
            String replyXslt;
            this.xsltRadioButton.setSelected(true);
            this.xsltRadioButton.doClick();
            String xslt = jop.getAttributeValue("Xslt");
            if (xslt != null && xslt.length() > 0) {
                this.xsltTextField.setText(xslt);
            }
            if ((replyXslt = jop.getAttributeValue("ReplyXslt")) != null && replyXslt.length() > 0) {
                this.replyXsltTextField.setText(replyXslt);
            }
        } else if (transMode != null && transMode.equals("CustomImpl")) {
            this.customImplRadioButton.setSelected(true);
            this.customImplRadioButton.doClick();
            String customImpl = jop.getAttributeValue("CustomImpl");
            if (customImpl != null && customImpl.length() > 0) {
                this.classTextField.setText(customImpl);
            }
        } else {
            this.nxsdRadioButton.setSelected(true);
            this.nxsdRadioButton.doClick();
        }
        if (jop.getAttributeValue("EncByteOrderCheckBox").equals("true")) {
            this.encodingByteOrderCheckBox.setSelected(true);
        } else {
            this.encodingByteOrderCheckBox.setSelected(false);
        }
        String encodingVal = jop.getAttributeValue("Encoding");
        String byteOrderVal = jop.getAttributeValue("ByteOrder");
        if (encodingVal != null && encodingVal.length() > 0 || byteOrderVal != null && byteOrderVal.length() > 0) {
            if (encodingVal != null && encodingVal.length() > 0) {
                this.encodingComboBox.setSelectedItem(encodingVal);
            } else {
                encodingValFromSchemaRadioButton.setSelected(true);
            }
            if (byteOrderVal != null && byteOrderVal.length() > 0) {
                this.byteOrderComboBox.setSelectedItem(byteOrderVal);
            } else {
                byteOrderValFromSchemaRadioButton.setSelected(true);
            }
        } else if (jop.getAttributeValue("EncByteOrderCheckBox").equals("true")) {
            encodingValFromSchemaRadioButton.setSelected(true);
            byteOrderValFromSchemaRadioButton.setSelected(true);
        }
    }

    private void handleBrowseXSL(boolean flag) {
        ResourcePickerDialog dlg = new ResourcePickerDialog(GraphUtils.getFrame((Component)this), 2, new File(SCAProject.getFilePath((URL)this.m_xslDirUrl)));
        if (dlg.display() != 1) {
            return;
        }
        URL fileUrl = dlg.getSelectedURL();
        if (fileUrl == null) {
            return;
        }
        if ((fileUrl = CommonScaUtils.putFileinProjectDir((Component)this.m_wcontext._parentFrame, (Project)this.m_project, (URL)this.m_projURL, (URL)this.m_xslDirUrl, (URL)fileUrl, MapperNode.class)) == null) {
            return;
        }
        String temp = "";
        if (URLFileSystem.isBaseURLFor((URL)this.m_projURL, (URL)fileUrl)) {
            temp = URLFileSystem.toRelativeSpec((URL)fileUrl, (URL)this.m_projURL);
        }
        if (flag) {
            this.xsltTextField.setText(temp);
        } else {
            this.replyXsltTextField.setText(temp);
        }
        this.m_lasturl = this.xsltTextField.getText().trim();
        this.xsltTextField.requestFocus();
        this.browsedXSL = true;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        JButton button;
        Object object = e.getSource();
        if (object instanceof JButton && (button = (JButton)object).isEnabled()) {
            button.setBorder(s_etchedBorder);
            button.setCursor(Cursor.getPredefinedCursor(12));
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        Object object = e.getSource();
        if (object instanceof JButton) {
            JButton button = (JButton)object;
            button.setBorder(s_emptyBorder);
            button.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
    }
}

