/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.socket;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.share.nls.StringUtils;
import oracle.tip.tools.ide.common.ui.NCNameField;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.socket.SocketAdapterBasePage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.socket.SocketAdapterConnectionPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.socket.SocketAdapterInOutSchemaPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.socket.SocketAdapterProtocolPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.socket.SocketAdapterSchemaPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.socket.SocketAdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.JcaBinding;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.PCInboundBinding;

public class SocketAdapterOperationTypePage
extends SocketAdapterBasePage
implements ActionListener,
DocumentListener {
    private MultiLineLabel introLabel;
    private final JLabel operationTypePrompt = new JLabel();
    private final JRadioButton inboundSyncReqRepRadioButton = new JRadioButton();
    private final JRadioButton oneWayRecRadioButton = new JRadioButton();
    private final JRadioButton outboundSyncReqRepRadioButton = new JRadioButton();
    private final JRadioButton oneWayInvokeRadioButton = new JRadioButton();
    private final ButtonGroup opRadioButtonGroup = new ButtonGroup();
    private final JPanel opNamePanel = new JPanel();
    private final JLabel opNameLabel = new JLabel();
    private final NCNameField opNameTextField = new NCNameField();
    private final JPanel spacerPanel = new JPanel();

    public SocketAdapterOperationTypePage(AdapterWizardContext wcontext, ImageWizardPage iwp) {
        try {
            this.setHelpTopicID("jdev_adp_wiz_socket_oper");
            this.setContextAndPage(wcontext, iwp);
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        String intro = this.getTranslatedString("SOCKET_OP_INTRO_PROMPT");
        String opprompt = this.getTranslatedString("SOCKET_OP_TYPE_PROMPT");
        String inboundSyncReqRepTxt = this.getTranslatedString("SOCKET_OP_INSYNCREQREP_OPTION");
        String oneWayRecText = this.getTranslatedString("SOCKET_OP_ONEWAYREC_OPTION");
        String oneWayInvokeText = this.getTranslatedString("SOCKET_OP_ONEWAYINVOKE_NAME");
        String outboundSyncReqRepText = this.getTranslatedString("SOCKET_OP_OUTSYNCREQREP_NAME");
        String opNameText = this.getTranslatedString("SOCKET_OP_OPERATION_NAME");
        String opNameStrippedText = StringUtils.stripMnemonic((String)opNameText);
        this.setLayout(new GridBagLayout());
        this.opNamePanel.setLayout(new GridBagLayout());
        this.introLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), intro);
        this.operationTypePrompt.setText(opprompt);
        this.operationTypePrompt.setLabelFor(this.inboundSyncReqRepRadioButton);
        this.inboundSyncReqRepRadioButton.setText(StringUtils.stripMnemonic((String)inboundSyncReqRepTxt));
        this.inboundSyncReqRepRadioButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)inboundSyncReqRepTxt));
        this.oneWayRecRadioButton.setText(StringUtils.stripMnemonic((String)oneWayRecText));
        this.oneWayRecRadioButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)oneWayRecText));
        this.outboundSyncReqRepRadioButton.setText(StringUtils.stripMnemonic((String)outboundSyncReqRepText));
        this.outboundSyncReqRepRadioButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)outboundSyncReqRepText));
        this.oneWayInvokeRadioButton.setText(StringUtils.stripMnemonic((String)oneWayInvokeText));
        this.oneWayInvokeRadioButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)oneWayInvokeText));
        this.opRadioButtonGroup.add(this.inboundSyncReqRepRadioButton);
        this.opRadioButtonGroup.add(this.oneWayRecRadioButton);
        this.opRadioButtonGroup.add(this.outboundSyncReqRepRadioButton);
        this.opRadioButtonGroup.add(this.oneWayInvokeRadioButton);
        this.inboundSyncReqRepRadioButton.addActionListener(this);
        this.oneWayRecRadioButton.addActionListener(this);
        this.outboundSyncReqRepRadioButton.addActionListener(this);
        this.oneWayInvokeRadioButton.addActionListener(this);
        this.opNameLabel.setText(opNameStrippedText);
        this.opNameLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)opNameText));
        this.opNameLabel.setLabelFor((Component)this.opNameTextField);
        this.opNameTextField.getDocument().addDocumentListener(this);
        this.opNamePanel.setVisible(false);
        this.opNamePanel.add((Component)this.opNameLabel, this.gbc(0, 0, 1, 1, 0.0, 0.0, 17, 0, in0000));
        this.opNamePanel.add((Component)this.opNameTextField, this.gbc(1, 0, 1, 1, 1.0, 0.0, 17, 2, in0600));
        int y = 0;
        this.add((Component)this.introLabel, this.gbc(0, y++, 0, 1, 1.0, 0.0, 18, 2, in0000));
        this.add((Component)this.operationTypePrompt, this.gbc(0, y, 1, 1, 0.0, 0.0, 17, 0, in10000));
        this.add((Component)this.inboundSyncReqRepRadioButton, this.gbc(1, y++, 1, 1, 0.0, 0.0, 17, 0, in10400));
        this.add((Component)this.oneWayRecRadioButton, this.gbc(1, y++, 1, 1, 0.0, 0.0, 17, 0, in5400));
        this.add((Component)this.outboundSyncReqRepRadioButton, this.gbc(1, y++, 1, 1, 0.0, 0.0, 17, 0, in5400));
        this.add((Component)this.oneWayInvokeRadioButton, this.gbc(1, y++, 1, 1, 0.0, 0.0, 17, 0, in5400));
        this.add((Component)this.spacerPanel, this.gbc(0, y, 0, 1, 0.0, 4.0, 18, 2, in0000));
        this.add((Component)this.opNamePanel, this.gbc(0, y, 0, 1, 0.0, 4.0, 18, 2, in13000));
        if (this.m_wcontext._read_service != null) {
            this.initFromWSDL();
            return;
        }
        if (this.m_wcontext._importedWsdlInfo != null) {
            this.displaySingleOperation();
            this.opNameTextField.setText(this.m_wcontext._write_operation_name);
            this.opNameTextField.setEditable(false);
            if (this.m_wcontext._isOutboundRead) {
                this.inboundSyncReqRepRadioButton.setEnabled(true);
                this.outboundSyncReqRepRadioButton.setEnabled(true);
                this.oneWayInvokeRadioButton.setEnabled(false);
                this.oneWayRecRadioButton.setEnabled(false);
            } else {
                this.inboundSyncReqRepRadioButton.setEnabled(false);
                this.outboundSyncReqRepRadioButton.setEnabled(false);
                this.oneWayInvokeRadioButton.setEnabled(true);
                this.oneWayRecRadioButton.setEnabled(true);
            }
        }
        this.m_page.setCanAdvance(false);
    }

    private void displaySingleOperation() {
        this.spacerPanel.setVisible(false);
        this.opNamePanel.setVisible(true);
    }

    private void displayMultiOperations() {
        this.spacerPanel.setVisible(false);
        this.opNamePanel.setVisible(false);
    }

    private void updateControls(boolean isInitialization) {
        if (this.inboundSyncReqRepRadioButton.isSelected()) {
            ((SocketAdapterWizardContext)this.m_wcontext._ascontext).operationType = "InboundRequestReply";
            this.m_wcontext._isInboundOperation = true;
            this.displaySingleOperation();
            if (this.m_wcontext._importedWsdlInfo == null) {
                this.opNameTextField.setText("InboundRequestReply");
            }
        } else if (this.oneWayRecRadioButton.isSelected()) {
            ((SocketAdapterWizardContext)this.m_wcontext._ascontext).operationType = "Receive";
            this.m_wcontext._isInboundOperation = true;
            this.displaySingleOperation();
            if (this.m_wcontext._importedWsdlInfo == null) {
                this.opNameTextField.setText("Receive");
            }
        } else if (this.outboundSyncReqRepRadioButton.isSelected()) {
            ((SocketAdapterWizardContext)this.m_wcontext._ascontext).operationType = "OutboundRequestReply";
            this.m_wcontext._isInboundOperation = false;
            this.displaySingleOperation();
            if (this.m_wcontext._importedWsdlInfo == null) {
                this.opNameTextField.setText("OutboundRequestReply");
            }
        } else if (this.oneWayInvokeRadioButton.isSelected()) {
            ((SocketAdapterWizardContext)this.m_wcontext._ascontext).operationType = "Invoke";
            this.m_wcontext._isInboundOperation = false;
            this.displaySingleOperation();
            if (this.m_wcontext._importedWsdlInfo == null) {
                this.opNameTextField.setText("Invoke");
            }
        }
        if (isInitialization) {
            this.removePages();
            ImageWizardPage tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("SOCKET_CN_PAGE_TITLE"));
            SocketAdapterConnectionPage connPage = new SocketAdapterConnectionPage(this.m_wcontext, tempwp);
            ImageWizardPage tempwp1 = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("FA_SC_TITLE"));
            if (((SocketAdapterWizardContext)this.m_wcontext._ascontext).operationType == "OutboundRequestReply" || ((SocketAdapterWizardContext)this.m_wcontext._ascontext).operationType == "InboundRequestReply") {
                SocketAdapterInOutSchemaPage socketAdapterInOutSchemaPage = new SocketAdapterInOutSchemaPage(this.m_wcontext, tempwp1);
            }
            if (((SocketAdapterWizardContext)this.m_wcontext._ascontext).operationType == "Invoke" || ((SocketAdapterWizardContext)this.m_wcontext._ascontext).operationType == "Receive") {
                SocketAdapterSchemaPage socketAdapterSchemaPage = new SocketAdapterSchemaPage(this.m_wcontext, tempwp1);
            }
            tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("SOCKET_PR_PAGE_TITLE"));
            SocketAdapterProtocolPage page = new SocketAdapterProtocolPage(this.m_wcontext, tempwp);
            this.m_wcontext._adapterWizardFinish = page;
        }
        this.m_page.setCanAdvance(true);
    }

    private void checkDoc(DocumentEvent e) {
        String operationName = this.opNameTextField.getText();
        if (operationName == null) {
            return;
        }
        if (operationName.trim().equals("")) {
            this.m_page.setCanAdvance(false);
            return;
        }
        this.m_page.setCanAdvance(true);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.updateControls(true);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.checkDoc(e);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.checkDoc(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.checkDoc(e);
    }

    private String getUITransmissionPrimitiveFromWSDL() {
        String uiTransmissionPrimitive = null;
        Definition def = this.m_wcontext._read_definition;
        Map bindings = def.getBindings();
        for (Binding bind : bindings.values()) {
            List bext = bind.getExtensibilityElements();
            for (Object ext : bext) {
                if (ext instanceof JcaBinding) {
                    JcaBinding jbind = (JcaBinding)ext;
                    uiTransmissionPrimitive = jbind.getAttributeValue("UITransmissionPrimitive");
                } else if (ext instanceof PCInboundBinding) {
                    PCInboundBinding pcbind = (PCInboundBinding)ext;
                    uiTransmissionPrimitive = pcbind.getAttributeValue("UITransmissionPrimitive");
                }
                if (uiTransmissionPrimitive == null || uiTransmissionPrimitive.trim().equals("")) continue;
                return uiTransmissionPrimitive;
            }
        }
        return uiTransmissionPrimitive;
    }

    @Override
    public void buildWSDL() throws WSDLException {
        if (this.inboundSyncReqRepRadioButton.isSelected()) {
            this.m_wcontext._isInboundOperation = true;
            this.createCommonOperationObjects(this.opNameTextField.getText().trim(), "InboundRequestReply");
        } else if (this.oneWayRecRadioButton.isSelected()) {
            this.m_wcontext._isInboundOperation = true;
            this.createCommonOperationObjects(this.opNameTextField.getText().trim(), "Receive");
        } else if (this.outboundSyncReqRepRadioButton.isSelected()) {
            this.m_wcontext._isInboundOperation = false;
            this.createCommonOperationObjects(this.opNameTextField.getText().trim(), "OutboundRequestReply");
        } else if (this.oneWayInvokeRadioButton.isSelected()) {
            this.m_wcontext._isInboundOperation = false;
            this.createCommonOperationObjects(this.opNameTextField.getText().trim(), "Invoke");
        }
    }

    private void initFromWSDL() throws Exception {
        SocketAdapterWizardContext socketContext = null;
        socketContext = (SocketAdapterWizardContext)this.m_wcontext._ascontext;
        socketContext.operationType = this.getUITransmissionPrimitiveFromWSDL().trim();
        if (socketContext.operationType.equals("InboundRequestReply")) {
            this.inboundSyncReqRepRadioButton.setSelected(true);
        }
        if (socketContext.operationType.equals("Receive")) {
            this.oneWayRecRadioButton.setSelected(true);
        }
        if (socketContext.operationType.equals("OutboundRequestReply")) {
            this.outboundSyncReqRepRadioButton.setSelected(true);
        }
        if (socketContext.operationType.equals("Invoke")) {
            this.oneWayInvokeRadioButton.setSelected(true);
        }
        this.updateControls(true);
        this.disableAllControls();
    }

    private void disableAllControls() {
        this.inboundSyncReqRepRadioButton.setEnabled(false);
        this.oneWayRecRadioButton.setEnabled(false);
        this.outboundSyncReqRepRadioButton.setEnabled(false);
        this.oneWayInvokeRadioButton.setEnabled(false);
        this.opNameTextField.setEnabled(false);
    }
}

