/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.socket;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import oracle.bali.ewt.event.Cancelable;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.bali.share.nls.StringUtils;
import oracle.tip.tools.ide.common.utils.MultiLineOptionPane;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.socket.SocketAdapterBasePage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.socket.SocketAdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.JcaAddress;

public class SocketAdapterConnectionPage
extends SocketAdapterBasePage
implements ItemListener,
DocumentListener {
    private MultiLineLabel introLabel;
    private final JLabel socketConnectionLabel = new JLabel();
    private final JTextField socketConnectionTextField = new JTextField();
    private final JLabel portLabel = new JLabel();
    private final JLabel hostLabel = new JLabel();
    private final JTextField portTextField = new JTextField(15);
    private final JTextField hostTextField = new JTextField(15);
    private final JPanel spacer = new JPanel();
    private final JCheckBox hostPortCheckBox = new JCheckBox();
    private static String jndiName = "eis/socket/SocketAdapter";

    public SocketAdapterConnectionPage(AdapterWizardContext wcontext, ImageWizardPage iwp) {
        try {
            this.setHelpTopicID("jdev_adp_wiz_socket_conn");
            this.setContextAndPage(wcontext, iwp);
            this.jbInit();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, " Exception in jbInit() of ConnectionPage " + e);
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        String intro = this.getTranslatedString("SOCKET_CN_INTRO_PROMPT");
        String connectionText = this.getTranslatedString("SOCKET_CN_NAME_PROMPT");
        String connectionTip = this.getTranslatedString("SOCKET_CN_NAME_TIP");
        String hostPortCheckBoxTxt = this.getTranslatedString("SOCKET_CN_CHKBOX_TXT");
        String hostLabelTxt = this.getTranslatedString("SOCKET_CN_HOST_LABEL_TXT");
        String portLabelTxt = this.getTranslatedString("SOCKET_CN_PORT_LABEL_TXT");
        this.setLayout(new GridBagLayout());
        this.introLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), intro);
        this.socketConnectionLabel.setText(StringUtils.stripMnemonic((String)connectionText));
        this.socketConnectionLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)connectionText));
        this.socketConnectionLabel.setLabelFor(this.socketConnectionTextField);
        this.hostPortCheckBox.setText(StringUtils.stripMnemonic((String)hostPortCheckBoxTxt));
        this.hostLabel.setText(StringUtils.stripMnemonic((String)hostLabelTxt));
        this.portLabel.setText(StringUtils.stripMnemonic((String)portLabelTxt));
        this.socketConnectionTextField.setToolTipText(connectionTip);
        this.socketConnectionTextField.getAccessibleContext().setAccessibleDescription(connectionTip);
        this.socketConnectionTextField.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)connectionText));
        this.socketConnectionTextField.setText(jndiName);
        this.hostPortCheckBox.setSelected(false);
        this.portTextField.setEditable(false);
        this.hostTextField.setEditable(false);
        this.hostLabel.setEnabled(false);
        this.hostTextField.setEnabled(false);
        this.portLabel.setEnabled(false);
        this.portTextField.setEnabled(false);
        this.socketConnectionTextField.getDocument().addDocumentListener(this);
        this.hostPortCheckBox.addItemListener(this);
        this.hostTextField.getDocument().addDocumentListener(this);
        this.portTextField.getDocument().addDocumentListener(this);
        int y = 0;
        this.add((Component)this.introLabel, this.gbc(0, y++, 0, 1, 1.0, 0.0, 18, 2, in0000));
        this.add((Component)this.socketConnectionLabel, this.gbc(0, y, 1, 1, 0.0, 0.0, 17, 0, in13000));
        this.add((Component)this.socketConnectionTextField, this.gbc(1, y++, 1, 1, 1.0, 0.0, 17, 2, in13600));
        this.add((Component)this.hostPortCheckBox, this.gbc(0, y++, 0, 1, 1.0, 0.0, 18, 0, in13000));
        this.add((Component)this.hostLabel, this.gbc(0, y, 1, 1, 0.0, 0.0, 17, 0, in131700));
        this.add((Component)this.hostTextField, this.gbc(1, y++, 1, 1, 1.0, 0.0, 17, 2, in13600));
        this.add((Component)this.portLabel, this.gbc(0, y, 1, 1, 0.0, 0.0, 17, 0, in51700));
        this.add((Component)this.portTextField, this.gbc(1, y++, 1, 1, 1.0, 0.0, 17, 2, in5600));
        this.add((Component)this.spacer, this.gbc(0, y++, 5, 1, 1.0, 1.0, 18, 0, in0000));
        this.m_page.setInitialFocus((Component)this.socketConnectionTextField);
        this.m_page.setCanAdvance(true);
        if (this.m_wcontext._read_service != null) {
            this.m_page.setCanAdvance(true);
            if (this.m_wcontext._read_jca_address != null) {
                String wsdlSocketServiceName = this.m_wcontext._read_jca_address.getAdapterInstanceJndi();
                this.socketConnectionTextField.setText(wsdlSocketServiceName);
            }
            this.initFromWSDL();
        }
    }

    private void initFromWSDL() throws Exception {
        String flag = this.m_wcontext._read_jca_operation.getAttributeValue("hostPortCheckFlag");
        if (this.m_wcontext._read_jca_operation.getAttributeValue("Host") != null || this.m_wcontext._read_jca_operation.getAttributeValue("Port") != null) {
            this.hostPortCheckBox.setSelected(true);
            String port = this.m_wcontext._read_jca_operation.getAttributeValue("Port");
            String host = this.m_wcontext._read_jca_operation.getAttributeValue("Host");
            if (port != null) {
                this.portLabel.setEnabled(true);
                this.portTextField.setEnabled(true);
                this.portTextField.setText(port);
            }
            if (host != null) {
                this.hostLabel.setEnabled(true);
                this.hostTextField.setEnabled(true);
                this.hostTextField.setText(host);
            }
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.checkDoc(e);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.checkDoc(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.checkDoc(e);
    }

    private void checkDoc(DocumentEvent e) {
        boolean flag = false;
        String socketServiceName = this.socketConnectionTextField.getText().trim();
        if (socketServiceName != null && socketServiceName.length() > 0) {
            this.m_page.setCanAdvance(true);
        } else {
            this.m_page.setCanAdvance(false);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        ((SocketAdapterWizardContext)this.m_wcontext._ascontext).hostPortCheckBoxSelected = e.getStateChange() == 1;
        if (e.getStateChange() == 1) {
            this.portLabel.setEnabled(true);
            this.hostLabel.setEnabled(true);
            this.portTextField.setEnabled(true);
            this.portTextField.setEditable(true);
            this.hostTextField.setEnabled(true);
            this.hostTextField.setEditable(true);
        } else {
            this.portLabel.setEnabled(false);
            this.hostLabel.setEnabled(false);
            this.portTextField.setEnabled(false);
            this.portTextField.setEditable(false);
            this.hostTextField.setEnabled(false);
            this.hostTextField.setEditable(false);
        }
    }

    @Override
    public void wizardValidatePage(WizardEvent event) {
        if (this.hostPortCheckBox.isSelected()) {
            if (this.m_wcontext._isInboundOperation) {
                try {
                    String host = this.hostTextField.getText();
                    if (host == null || host.length() == 0) {
                        MultiLineOptionPane.showMessageDialog((Component)this, (Object)this.getTranslatedString("SOCKET_CN_HOST_ERROR"), (String)this.getTranslatedString("SOCKET_CN_HOST_PORT_ERROR_TITLE"), (int)0);
                        ((Cancelable)event).cancel();
                        return;
                    }
                    String port = this.portTextField.getText();
                    if (port == null || port.length() == 0 || Integer.valueOf(port) < 1024 || Integer.valueOf(port) > 65535) {
                        MultiLineOptionPane.showMessageDialog((Component)this, (Object)this.getTranslatedString("SOCKET_CN_PORT_ERROR"), (String)this.getTranslatedString("SOCKET_CN_HOST_PORT_ERROR_TITLE"), (int)0);
                        ((Cancelable)event).cancel();
                        return;
                    }
                }
                catch (NumberFormatException ex) {
                    MultiLineOptionPane.showMessageDialog((Component)this, (Object)this.getTranslatedString("SOCKET_CN_PORT_ERROR"), (String)this.getTranslatedString("SOCKET_CN_HOST_PORT_ERROR_TITLE"), (int)0);
                    ((Cancelable)event).cancel();
                }
            } else {
                String port = this.portTextField.getText();
                String host = this.hostTextField.getText();
                if (host == null || host.length() == 0) {
                    MultiLineOptionPane.showMessageDialog((Component)this, (Object)this.getTranslatedString("SOCKET_CN_HOST_ERROR"), (String)this.getTranslatedString("SOCKET_CN_HOST_PORT_ERROR_TITLE"), (int)0);
                    ((Cancelable)event).cancel();
                    return;
                }
                try {
                    if (port == null || port.length() == 0 || Integer.valueOf(port) < 1024 || Integer.valueOf(port) > 65535) {
                        MultiLineOptionPane.showMessageDialog((Component)this, (Object)this.getTranslatedString("SOCKET_CN_PORT_ERROR"), (String)this.getTranslatedString("SOCKET_CN_HOST_PORT_ERROR_TITLE"), (int)0);
                        ((Cancelable)event).cancel();
                    }
                }
                catch (NumberFormatException ex) {
                    MultiLineOptionPane.showMessageDialog((Component)this, (Object)this.getTranslatedString("SOCKET_CN_PORT_ERROR"), (String)this.getTranslatedString("SOCKET_CN_HOST_PORT_ERROR_TITLE"), (int)0);
                    ((Cancelable)event).cancel();
                }
            }
        }
    }

    @Override
    public void buildWSDL() throws WSDLException {
        JcaAddress jcaa = (JcaAddress)this.m_wcontext._extReg.createExtension(JcaAddress.PARENT_CLASS, JcaAddress.FIELD_ELEMENT_TYPE);
        this.m_wcontext._write_port.addExtensibilityElement((ExtensibilityElement)jcaa);
        String socketServiceName = this.socketConnectionTextField.getText().trim();
        jcaa.setAdapterInstanceJndi(socketServiceName);
        this.m_wcontext._write_jca_address = jcaa;
        if (((SocketAdapterWizardContext)this.m_wcontext._ascontext).hostPortCheckBoxSelected) {
            String portNumber;
            String hostName;
            if (((SocketAdapterWizardContext)this.m_wcontext._ascontext).operationType == "OutboundRequestReply" || ((SocketAdapterWizardContext)this.m_wcontext._ascontext).operationType == "Invoke") {
                hostName = this.hostTextField.getText().trim();
                portNumber = this.portTextField.getText().trim();
                if (hostName != null && hostName.length() > 0) {
                    ((SocketAdapterWizardContext)this.m_wcontext._ascontext).hostName = hostName;
                    this.m_wcontext._write_jca_operation.setAttributeValue("Host", hostName);
                }
                if (portNumber != null && portNumber.length() > 0) {
                    ((SocketAdapterWizardContext)this.m_wcontext._ascontext).portNumber = portNumber;
                    this.m_wcontext._write_jca_operation.setAttributeValue("Port", portNumber);
                }
            }
            if (((SocketAdapterWizardContext)this.m_wcontext._ascontext).operationType == "InboundRequestReply" || ((SocketAdapterWizardContext)this.m_wcontext._ascontext).operationType == "Receive") {
                hostName = this.hostTextField.getText().trim();
                portNumber = this.portTextField.getText().trim();
                if (hostName != null && hostName.length() > 0) {
                    ((SocketAdapterWizardContext)this.m_wcontext._ascontext).hostName = hostName;
                    this.m_wcontext._write_jca_operation.setAttributeValue("Host", hostName);
                }
                if (portNumber != null && portNumber.length() > 0) {
                    ((SocketAdapterWizardContext)this.m_wcontext._ascontext).portNumber = portNumber;
                    this.m_wcontext._write_jca_operation.setAttributeValue("Port", portNumber);
                }
            }
        }
    }
}

