/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.mq;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import oracle.bali.share.nls.StringUtils;
import oracle.javatools.util.BundleLoader;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.mq.MQAdapterWizardContext;

public class MQPredefinedSchemaPanel
extends JPanel
implements ActionListener {
    private static final String RESOURCE_BUNDLE = "oracle.tip.tools.ide.pm.modules.bizintegration.adapter.techAdapterResource";
    private ResourceBundle resourceBundle;
    private JRadioButton preDefSchemaRB = new JRadioButton();
    private JRadioButton otherSchemaRB = new JRadioButton();
    private ButtonGroup schemaChoiceGroup = new ButtonGroup();
    private JComboBox preDefSchemaCB = new JComboBox();
    private Border border = BorderFactory.createLineBorder(Color.GRAY);
    private MQAdapterWizardContext mqContext;

    public MQPredefinedSchemaPanel(MQAdapterWizardContext mqContext) throws Exception {
        if (mqContext == null) {
            throw new Exception("ERROR: mqContext is null when constructing MQPredefinedSchemaPanel.");
        }
        this.mqContext = mqContext;
        this.layoutComponents();
    }

    private void layoutComponents() {
        this.resourceBundle = BundleLoader.getBundle((String)RESOURCE_BUNDLE);
        String preDefSchemaText = this.getTranslatedString("MQ_SC_CHOOSE_PREDEF_SCHEMA");
        String otherSchemaText = this.getTranslatedString("MQ_SC_CHOOSE_OTHER_SCHEMA");
        String borderTitle = this.getTranslatedString("MQ_SC_SCHEMA_OPTIONS");
        this.setBorder(BorderFactory.createTitledBorder(this.border, borderTitle));
        this.preDefSchemaRB.setText(StringUtils.stripMnemonic((String)preDefSchemaText));
        this.preDefSchemaRB.setMnemonic(StringUtils.getMnemonicKeyCode((String)preDefSchemaText));
        this.preDefSchemaRB.addActionListener(this);
        this.otherSchemaRB.setText(StringUtils.stripMnemonic((String)otherSchemaText));
        this.otherSchemaRB.setMnemonic(StringUtils.getMnemonicKeyCode((String)otherSchemaText));
        this.otherSchemaRB.addActionListener(this);
        this.otherSchemaRB.setSelected(true);
        this.schemaChoiceGroup.add(this.preDefSchemaRB);
        this.schemaChoiceGroup.add(this.otherSchemaRB);
        this.preDefSchemaCB.addItem("CICS Schema");
        this.preDefSchemaCB.addItem("IMS Schema");
        this.setLayout(new GridBagLayout());
        this.add((Component)this.otherSchemaRB, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.preDefSchemaRB, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.add((Component)this.preDefSchemaCB, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.updateControls(this.mqContext);
    }

    public void updateControls(MQAdapterWizardContext mqContext) {
        if (mqContext != null) {
            if (mqContext.predefinedSchema != null) {
                this.preDefSchemaRB.setSelected(true);
                this.preDefSchemaCB.setSelectedItem(mqContext.predefinedSchema);
            } else {
                this.otherSchemaRB.setSelected(true);
            }
        }
        if (this.otherSchemaRB.isSelected()) {
            this.preDefSchemaCB.setEnabled(false);
        } else {
            this.preDefSchemaCB.setEnabled(true);
        }
    }

    private String getTranslatedString(String messageKey) {
        return this.resourceBundle.getString(messageKey);
    }

    public MQAdapterWizardContext getContext() {
        this.mqContext.predefinedSchema = this.preDefSchemaRB.isSelected() ? (String)this.preDefSchemaCB.getSelectedItem() : null;
        return this.mqContext;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.updateControls(null);
    }
}

