/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.mq;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;

public class MQPollingDurationPanel
extends JPanel {
    private AdapterWizardContext wcontext;
    private NumericSpinBox durationSpinBox;
    private JComboBox durationUnitsComboBox;

    public MQPollingDurationPanel(AdapterWizardContext wcontext) {
        this.wcontext = wcontext;
        this.init();
    }

    private void init() {
        String[] timeIntervalArray = new String[]{this.wcontext.TIME_SECONDS, this.wcontext.TIME_MINUTES, this.wcontext.TIME_HOURS, this.wcontext.TIME_DAYS};
        this.setLayout(new GridBagLayout());
        this.durationSpinBox = new NumericSpinBox(1, Integer.MAX_VALUE);
        this.durationUnitsComboBox = new JComboBox<String>(timeIntervalArray);
        this.durationUnitsComboBox.setSelectedIndex(1);
        this.add((Component)this.durationSpinBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.durationUnitsComboBox, new GridBagConstraints(1, 0, 1, 1, 2.0, 0.0, 18, 0, new Insets(2, 5, 0, 0), 0, 0));
    }

    private String getTranslatedString(String messageKey) {
        return this.wcontext._bundle.getString(messageKey);
    }

    public String getPollingIntervalDurationInSeconds() {
        long durationVal = this.getLong(this.durationSpinBox.getValue());
        return this.convertToSeconds(durationVal, (String)this.durationUnitsComboBox.getSelectedItem());
    }

    public String getSelectedUnitOfMeasure() {
        return (String)this.durationUnitsComboBox.getSelectedItem();
    }

    private String convertToSeconds(long duration, String unitOfMeasure) {
        String durationStr = null;
        long convDuration = -1L;
        if (unitOfMeasure != null) {
            if (unitOfMeasure.equals(this.wcontext.TIME_SECONDS)) {
                convDuration = duration;
            } else if (unitOfMeasure.equals(this.wcontext.TIME_MINUTES)) {
                convDuration = duration * 60L;
            } else if (unitOfMeasure.equals(this.wcontext.TIME_HOURS)) {
                convDuration = duration * 60L * 60L;
            } else if (unitOfMeasure.equals(this.wcontext.TIME_DAYS)) {
                convDuration = duration * 60L * 60L * 24L;
            }
        }
        durationStr = String.valueOf(convDuration);
        return durationStr;
    }

    private String convertToUnitOfMeasure(long duration, String unitOfMeasure) {
        String durationStr = null;
        long convDuration = -1L;
        if (unitOfMeasure != null) {
            if (unitOfMeasure.equals(this.wcontext.TIME_SECONDS)) {
                convDuration = duration;
            } else if (unitOfMeasure.equals(this.wcontext.TIME_MINUTES)) {
                convDuration = duration / 60L;
            } else if (unitOfMeasure.equals(this.wcontext.TIME_HOURS)) {
                convDuration = duration / 3600L;
            } else if (unitOfMeasure.equals(this.wcontext.TIME_DAYS)) {
                convDuration = duration / 3600L / 24L;
            }
        }
        return durationStr;
    }

    private long getLong(Object numobj) {
        long retint = 0L;
        if (numobj instanceof Long) {
            retint = (Long)numobj;
        } else if (numobj instanceof Integer) {
            retint = ((Integer)numobj).longValue();
        } else if (numobj instanceof Double) {
            retint = ((Double)numobj).longValue();
        }
        return retint;
    }
}

