/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.mq;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import oracle.bali.share.nls.StringUtils;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.mq.MQPriorityComboBox;

public class MQFilterByPriorityPanel
extends JPanel
implements ActionListener {
    private AdapterWizardContext wcontext;
    private JCheckBox filterCheckBox;
    private MQPriorityComboBox priorityComboBox;

    public MQFilterByPriorityPanel(AdapterWizardContext wcontext) {
        this.wcontext = wcontext;
        this.init();
    }

    private void init() {
        String filterText = this.getTranslatedString("MQ_GM_FILTER_BY_PRIORITY");
        String filterTip = this.getTranslatedString("MQ_GM_FILTER_BY_PRIORITY_TIP");
        this.filterCheckBox = new JCheckBox();
        this.filterCheckBox.setText(StringUtils.stripMnemonic((String)filterText));
        this.filterCheckBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)filterText));
        this.filterCheckBox.setToolTipText(filterTip);
        this.filterCheckBox.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)filterText));
        this.priorityComboBox = new MQPriorityComboBox(true);
        this.setLayout(new GridBagLayout());
        this.filterCheckBox.addActionListener(this);
        this.add((Component)this.filterCheckBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.priorityComboBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.filterCheckBox.setSelected(false);
        this.refreshControls();
    }

    public void refreshControls() {
        if (this.filterCheckBox.isSelected()) {
            this.priorityComboBox.setEnabled(true);
        } else {
            this.priorityComboBox.setEnabled(false);
        }
    }

    private String getTranslatedString(String messageKey) {
        return this.wcontext._bundle.getString(messageKey);
    }

    public boolean isFilterCheckBoxSelected() {
        return this.filterCheckBox.isSelected();
    }

    public void setFilterCheckBoxSelected(boolean selected) {
        this.filterCheckBox.setSelected(selected);
    }

    public void setSelectedPriority(String priority) {
        this.priorityComboBox.setSelectedItemByValue(priority);
    }

    public String getSelectedPriority() {
        return this.priorityComboBox.getSelectedValue();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.refreshControls();
    }
}

