/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.mq;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.bali.share.nls.StringUtils;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;

public class MQExpiryPanel
extends JPanel
implements ActionListener {
    public static final String NEVER = "NEVER";
    private AdapterWizardContext wcontext;
    private JRadioButton neverRadioButton;
    private JRadioButton expiresRadioButton;
    private ButtonGroup buttonGroup;
    private NumericSpinBox expiryNumSpinBox;
    private JComboBox expiryUnitsComboBox;

    public MQExpiryPanel(AdapterWizardContext wcontext) {
        this.wcontext = wcontext;
        this.init();
    }

    private void init() {
        String expiryText = this.getTranslatedString("MQ_CM_EXPIRY");
        String neverText = this.getTranslatedString("MQ_CM_NEVER");
        String expiresInText = this.getTranslatedString("MQ_CM_EXPIRES_IN");
        String[] timeIntervalArray = new String[]{this.wcontext.TIME_SECONDS, this.wcontext.TIME_MINUTES, this.wcontext.TIME_HOURS, this.wcontext.TIME_DAYS};
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(expiryText));
        this.neverRadioButton = new JRadioButton(StringUtils.stripMnemonic((String)neverText), true);
        this.neverRadioButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)neverText));
        this.expiresRadioButton = new JRadioButton(StringUtils.stripMnemonic((String)expiresInText), false);
        this.expiresRadioButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)expiresInText));
        this.expiryNumSpinBox = new NumericSpinBox(1, Integer.MAX_VALUE);
        this.expiryUnitsComboBox = new JComboBox<String>(timeIntervalArray);
        this.buttonGroup = new ButtonGroup();
        this.getAccessibleContext().setAccessibleName(expiryText);
        this.neverRadioButton.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)neverText));
        this.expiresRadioButton.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)expiresInText));
        this.expiryUnitsComboBox.setSelectedIndex(1);
        this.buttonGroup.add(this.neverRadioButton);
        this.buttonGroup.add(this.expiresRadioButton);
        this.neverRadioButton.addActionListener(this);
        this.expiresRadioButton.addActionListener(this);
        this.refreshControls();
        this.add((Component)this.neverRadioButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.expiresRadioButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.expiryNumSpinBox, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.expiryUnitsComboBox, new GridBagConstraints(2, 1, 1, 1, 2.0, 0.0, 18, 0, new Insets(0, 5, 0, 0), 0, 0));
    }

    private void refreshControls() {
        if (this.neverRadioButton.isSelected()) {
            this.expiryNumSpinBox.setEnabled(false);
            this.expiryUnitsComboBox.setEnabled(false);
        } else if (this.expiresRadioButton.isSelected()) {
            this.expiryNumSpinBox.setEnabled(true);
            this.expiryUnitsComboBox.setEnabled(true);
        }
    }

    private String getTranslatedString(String messageKey) {
        return this.wcontext._bundle.getString(messageKey);
    }

    public String getExpiry() {
        String expiryVal = null;
        if (this.neverRadioButton.isSelected()) {
            expiryVal = NEVER;
        } else if (this.expiresRadioButton.isSelected()) {
            long expiryLongVal = this.getLong(this.expiryNumSpinBox.getValue());
            expiryVal = this.convertToSeconds(expiryLongVal, (String)this.expiryUnitsComboBox.getSelectedItem());
        }
        return expiryVal;
    }

    public void setExpiry(String expiryInTenthsOfSec, String unitOfMeasure) {
        if (expiryInTenthsOfSec.trim().equals(NEVER)) {
            this.neverRadioButton.setSelected(true);
        } else {
            long expiryLongVal = this.getLong(Integer.valueOf(expiryInTenthsOfSec));
            String expiryValue = this.convertToUnitOfMeasure(expiryLongVal, unitOfMeasure);
            int expiryValInt = Integer.valueOf(expiryValue);
            this.expiryNumSpinBox.setIntValue(expiryValInt);
            this.expiryUnitsComboBox.setSelectedItem(unitOfMeasure);
            this.expiresRadioButton.setSelected(true);
        }
        this.refreshControls();
    }

    public String getSelectedUnitOfMeasure() {
        return (String)this.expiryUnitsComboBox.getSelectedItem();
    }

    private String convertToSeconds(long expiry, String unitOfMeasure) {
        String secondsStr = null;
        long seconds = -1L;
        if (unitOfMeasure != null) {
            if (unitOfMeasure.equals(this.wcontext.TIME_SECONDS)) {
                seconds = expiry;
            } else if (unitOfMeasure.equals(this.wcontext.TIME_MINUTES)) {
                seconds = expiry * 60L;
            } else if (unitOfMeasure.equals(this.wcontext.TIME_HOURS)) {
                seconds = expiry * 60L * 60L;
            } else if (unitOfMeasure.equals(this.wcontext.TIME_DAYS)) {
                seconds = expiry * 60L * 60L * 24L;
            }
        }
        secondsStr = String.valueOf(seconds);
        return secondsStr;
    }

    private String convertToUnitOfMeasure(long expiry, String unitOfMeasure) {
        long convertedExpiry = -1L;
        if (unitOfMeasure != null) {
            if (unitOfMeasure.equals(this.wcontext.TIME_SECONDS)) {
                convertedExpiry = expiry;
            } else if (unitOfMeasure.equals(this.wcontext.TIME_MINUTES)) {
                convertedExpiry = expiry / 60L;
            } else if (unitOfMeasure.equals(this.wcontext.TIME_HOURS)) {
                convertedExpiry = expiry / 3600L;
            } else if (unitOfMeasure.equals(this.wcontext.TIME_DAYS)) {
                convertedExpiry = expiry / 3600L / 24L;
            }
        }
        return String.valueOf(convertedExpiry);
    }

    private long getLong(Object numobj) {
        long retint = 0L;
        if (numobj instanceof Long) {
            retint = (Long)numobj;
        } else if (numobj instanceof Integer) {
            retint = ((Integer)numobj).longValue();
        } else if (numobj instanceof Double) {
            retint = ((Double)numobj).longValue();
        }
        return retint;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.refreshControls();
    }
}

