/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.mq;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.mq.MQAdapterInOutSchemaPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.mq.PredefinedSchemaInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.JcaBinding;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.JcaOperation;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.PCInboundBinding;

public class MQAdapterWizardContext {
    public static final String MQ_ADAPTER_CICS_SCHEMA_FILE = "MQCIH.CICS_Message.xsd";
    public static final String MQ_ADAPTER_IMS_SCHEMA_FILE = "MQIIH.IMS_Message.xsd";
    public String inboundOperationName;
    public String outboundOperationName;
    public JcaOperation inboundJcaOperation;
    public JcaOperation outboundJcaOperation;
    public String serviceType;
    public Operation inboundOperation;
    public Operation outboundOperation;
    public String messageFormat;
    public String predefinedSchema;
    public HashMap predefSchemaHash;
    private char[] invalidQNameCharsArray = new char[]{'~', '`', '!', '@', '#', '$', '^', '&', '*', '(', ')', '-', '+', '=', '?', ':', ';', ',', '<', '>', '\\'};
    public String messageType = null;
    public String messageId = null;
    public String correlationId = null;
    public String operationType;
    public String replyToQueueName = null;
    public int retryInterval = 0;
    public int retryCount = 0;
    public int retryBackoff = 0;
    private AdapterWizardContext wcontext;

    public MQAdapterWizardContext(AdapterWizardContext wcontext) {
        this.wcontext = wcontext;
        this.initPredefinedSchemaHash();
    }

    private void initPredefinedSchemaHash() {
        this.predefSchemaHash = new HashMap();
        this.predefSchemaHash.put("CICS Schema", new PredefinedSchemaInfo(MQ_ADAPTER_CICS_SCHEMA_FILE, "http://xmlns.oracle.com/pcbpel/nxsd/cics_mqcih", "CICS_Message"));
        this.predefSchemaHash.put("IMS Schema", new PredefinedSchemaInfo(MQ_ADAPTER_IMS_SCHEMA_FILE, "http://xmlns.oracle.com/pcbpel/nxsd/ims_mqiih", "IMS_Message"));
    }

    public void addPredefinedSchemas(boolean isAsync) throws WSDLException {
        JcaOperation jcaOp;
        Operation operation;
        Definition def = this.wcontext._write_definition;
        String inboundNamespacePrefix = "msg_in";
        String outboundNamespacePrefix = "msg_out";
        String inboundSchemaFilename = null;
        String outboundSchemaFilename = null;
        String outboundPredefSchema = null;
        boolean isOutboundSchemaPredefined = false;
        PredefinedSchemaInfo inboundInfo = (PredefinedSchemaInfo)this.predefSchemaHash.get(this.predefinedSchema);
        if (inboundInfo != null) {
            inboundSchemaFilename = inboundInfo.getSchemaFilename();
        }
        if ("CICS".equals(this.messageFormat)) {
            outboundPredefSchema = "CICS Schema";
            isOutboundSchemaPredefined = true;
        } else if ("IMS".equals(this.messageFormat)) {
            outboundPredefSchema = "IMS Schema";
            isOutboundSchemaPredefined = true;
        }
        PredefinedSchemaInfo outboundInfo = (PredefinedSchemaInfo)this.predefSchemaHash.get(outboundPredefSchema);
        if (outboundInfo != null) {
            outboundSchemaFilename = outboundInfo.getSchemaFilename();
        }
        if (inboundSchemaFilename != null && outboundSchemaFilename != null && inboundSchemaFilename.equals(outboundSchemaFilename)) {
            inboundNamespacePrefix = "msg_in_out";
            outboundNamespacePrefix = "msg_in_out";
        }
        if (this.predefinedSchema != null) {
            operation = null;
            jcaOp = null;
            if (isAsync) {
                operation = this.inboundOperation;
                jcaOp = this.inboundJcaOperation;
            } else {
                operation = this.wcontext._write_operation_abstract;
                jcaOp = this.wcontext._write_jca_operation;
            }
            this.createPredefinedMsg(inboundNamespacePrefix, this.predefinedSchema, operation, true, true, true);
        }
        if (isOutboundSchemaPredefined) {
            operation = null;
            jcaOp = null;
            boolean isInput = true;
            if (isAsync) {
                operation = this.outboundOperation;
                jcaOp = this.outboundJcaOperation;
                isInput = true;
            } else {
                operation = this.wcontext._write_operation_abstract;
                jcaOp = this.wcontext._write_jca_operation;
                isInput = false;
            }
            boolean addSchema = !inboundSchemaFilename.equals(outboundSchemaFilename);
            this.createPredefinedMsg(outboundNamespacePrefix, outboundPredefSchema, operation, false, addSchema, isInput);
        }
    }

    public void addSinglePredefinedSchema(String predefSchema, boolean isInbound, boolean isInput) throws WSDLException {
        Definition def = this.wcontext._write_definition;
        String namespacePrefix = "msg";
        if (predefSchema != null) {
            this.createPredefinedMsg(namespacePrefix, predefSchema, this.wcontext._write_operation_abstract, isInbound, true, isInput);
            JcaOperation jcaOp = this.wcontext._write_jca_operation;
        }
    }

    public void createPredefinedMsg(String namespacePrefix, String predefinedSchemaKey, Operation operation, boolean isInbound, boolean addSchema, boolean isInput) throws WSDLException {
        Definition def = this.wcontext._write_definition;
        PredefinedSchemaInfo info = (PredefinedSchemaInfo)this.predefSchemaHash.get(predefinedSchemaKey);
        String elnamespace = info.getNamespace();
        String schemaLoc = "xsd/" + info.getSchemaFilename();
        String rootElement = info.getRootElement();
        if (addSchema) {
            MQAdapterInOutSchemaPage.addSchema(this.wcontext, def, namespacePrefix, elnamespace, schemaLoc);
        }
        Message msg = MQAdapterInOutSchemaPage.addSchemaMessageAttributes(this.wcontext, def, isInbound, operation, elnamespace, rootElement);
        if (isInput) {
            Input input = def.createInput();
            input.setMessage(msg);
            operation.setInput(input);
        } else {
            Output output = def.createOutput();
            output.setMessage(msg);
            operation.setOutput(output);
        }
    }

    public void createWSDLBindingsForAsyncReqRes(PortType inboundPortType, PortType outboundPortType, String inboundOperationName, String outboundOperationName, String uiTransmissionPrimitive) throws WSDLException {
        Definition def = this.wcontext._write_definition;
        Service service = this.wcontext._write_service;
        Operation inboundOp = null;
        if (this.wcontext._importedWsdlInfo == null) {
            inboundOp = def.createOperation();
            inboundOp.setName(inboundOperationName);
            inboundOp.setUndefined(false);
            inboundPortType.addOperation(inboundOp);
        } else {
            inboundOp = inboundPortType.getOperation(inboundOperationName, null, null);
        }
        this.inboundOperation = inboundOp;
        Binding inboundBinding = def.createBinding();
        inboundBinding.setPortType(inboundPortType);
        inboundBinding.setQName(new QName(this.wcontext._target_namespace, inboundOperationName + this.wcontext.Binding_suffix));
        inboundBinding.setUndefined(false);
        def.addBinding(inboundBinding);
        PCInboundBinding pcib = (PCInboundBinding)this.wcontext._extReg.createExtension(PCInboundBinding.PARENT_CLASS, PCInboundBinding.FIELD_ELEMENT_TYPE);
        pcib.setAttributeValue("UITransmissionPrimitive", uiTransmissionPrimitive);
        inboundBinding.addExtensibilityElement((ExtensibilityElement)pcib);
        BindingOperation inboundBindingOp = def.createBindingOperation();
        inboundBindingOp.setName(inboundOperationName);
        inboundBinding.addBindingOperation(inboundBindingOp);
        this.wcontext._write_operation_physical = inboundBindingOp;
        JcaOperation injop = (JcaOperation)this.wcontext._extReg.createExtension(JcaOperation.PARENT_CLASS, JcaOperation.FIELD_ELEMENT_TYPE);
        this.wcontext._write_operation_physical.addExtensibilityElement((ExtensibilityElement)injop);
        this.inboundJcaOperation = injop;
        Port inPort = this.wcontext._write_port;
        inPort.setName(inboundOperationName + this.wcontext.Port_suffix);
        inPort.setBinding(inboundBinding);
        Operation outboundOp = null;
        if (this.wcontext._importedWsdlInfo == null) {
            outboundOp = def.createOperation();
            outboundOp.setName(outboundOperationName);
            outboundOp.setUndefined(false);
            outboundPortType.addOperation(outboundOp);
        } else {
            outboundOp = outboundPortType.getOperation(outboundOperationName, null, null);
        }
        this.outboundOperation = outboundOp;
        Binding outboundBinding = def.createBinding();
        outboundBinding.setPortType(outboundPortType);
        outboundBinding.setQName(new QName(this.wcontext._target_namespace, outboundOperationName + this.wcontext.Binding_suffix));
        outboundBinding.setUndefined(false);
        def.addBinding(outboundBinding);
        JcaBinding jcaBinding = (JcaBinding)this.wcontext._extReg.createExtension(JcaBinding.PARENT_CLASS, JcaBinding.FIELD_ELEMENT_TYPE);
        jcaBinding.setAttributeValue("UITransmissionPrimitive", uiTransmissionPrimitive);
        outboundBinding.addExtensibilityElement((ExtensibilityElement)jcaBinding);
        BindingOperation outboundBindingOp = def.createBindingOperation();
        outboundBindingOp.setName(outboundOperationName);
        outboundBinding.addBindingOperation(outboundBindingOp);
        this.wcontext._write_operation_physical = outboundBindingOp;
        JcaOperation outjop = (JcaOperation)this.wcontext._extReg.createExtension(JcaOperation.PARENT_CLASS, JcaOperation.FIELD_ELEMENT_TYPE);
        this.wcontext._write_operation_physical.addExtensibilityElement((ExtensibilityElement)outjop);
        this.outboundJcaOperation = outjop;
        Port outPort = def.createPort();
        outPort.setName(outboundOperationName + this.wcontext.Port_suffix);
        outPort.setBinding(outboundBinding);
        service.addPort(outPort);
        this.wcontext._write_port2 = outPort;
        this.wcontext._write_port2.addExtensibilityElement((ExtensibilityElement)this.wcontext._write_jca_address);
    }

    public void initFromWSDLMultiOp() throws WSDLException {
        if (this.wcontext._update_wsdl_path != null) {
            Definition def = this.wcontext._read_definition;
            Map services = def.getServices();
            if (services == null || services.size() == 0) {
                throw new WSDLException("INVALID_WSDL", this.wcontext._bundle.getString("CM_WZ_WSDL_NO_SERVICE_ERROR"));
            }
            Map bindings = this.wcontext._read_definition.getBindings();
            Iterator bindingI = bindings.values().iterator();
            Operation currentOp = null;
            while (bindingI.hasNext()) {
                boolean isInbound;
                Binding bind = (Binding)bindingI.next();
                List boperations = bind.getBindingOperations();
                Iterator boperI = boperations.iterator();
                if (!boperI.hasNext()) continue;
                BindingOperation bop = (BindingOperation)boperI.next();
                currentOp = bop.getOperation();
                List extElements = bind.getExtensibilityElements();
                if (extElements.size() > 0 && extElements.get(0) instanceof PCInboundBinding) {
                    this.inboundOperation = currentOp;
                    this.inboundOperationName = this.inboundOperation.getName();
                    isInbound = true;
                } else {
                    this.outboundOperation = currentOp;
                    this.outboundOperationName = this.outboundOperation.getName();
                    isInbound = false;
                }
                List bextElements = bop.getExtensibilityElements();
                for (Object obj : bextElements) {
                    if (!(obj instanceof JcaOperation)) continue;
                    if (isInbound) {
                        this.inboundJcaOperation = (JcaOperation)obj;
                        continue;
                    }
                    this.outboundJcaOperation = (JcaOperation)obj;
                }
            }
        }
    }

    public boolean queueNameHasInvalidChars(String name) {
        if (name == null || name.trim().equals("")) {
            return false;
        }
        for (int i = 0; i < this.invalidQNameCharsArray.length; ++i) {
            if (name.indexOf(this.invalidQNameCharsArray[i]) <= -1) continue;
            return true;
        }
        return false;
    }

    public boolean isQueueNameTooLong(String name) {
        int LIMIT = 48;
        if (name == null) {
            return false;
        }
        return name.length() > 48;
    }
}

