/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.mq;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.wsdl.WSDLException;
import oracle.bali.ewt.event.Cancelable;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.bali.share.nls.StringUtils;
import oracle.tip.tools.ide.common.utils.MultiLineOptionPane;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.LimitDocument;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.mq.MQAdapterAdvancedOptionsPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.mq.MQAdapterFinishPanel;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.mq.MQAdapterInOutSchemaPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.mq.MQAdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.mq.MQCorrelationIdComboBox;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.mq.MQMessageIdComboBox;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.mq.MQPredefinedSchemaPanel;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.techAdapterWizardPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.JcaOperation;

public class MQAdapterSendMsgResponsePage
extends techAdapterWizardPage
implements DocumentListener,
FocusListener {
    private MultiLineLabel introLabel;
    private JLabel qNameLabel;
    private JTextField qNameTextField;
    private JPanel correlationPanel;
    private JLabel msgIDLabel;
    private MQMessageIdComboBox msgIDComboBox;
    private JLabel corrIDLabel;
    private MQCorrelationIdComboBox corrIDComboBox;
    private JLabel msgTypeLabel;
    private JTextField msgTypeTextField;
    private MQPredefinedSchemaPanel schemaOptionPanel;
    private MQAdapterWizardContext mqContext;
    private boolean noSchemaPage;
    private JCheckBox respWaitCB;
    private NumericSpinBox respWaitNumSpinBox;
    private JComboBox respWaitUnitsComboBox;
    private JCheckBox respNoMsgCB;

    public MQAdapterSendMsgResponsePage(AdapterWizardContext wcontext, ImageWizardPage iwp) {
        try {
            this.setHelpTopicID("bpmjdev_adp_wiz_mq_response");
            this.setContextAndPage(wcontext, iwp);
            this.mqContext = (MQAdapterWizardContext)this.m_wcontext._ascontext;
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        String introText = this.getTranslatedString("MQ_SRES_INTRO_PROMPT");
        String qNameText = this.getTranslatedString("MQ_CM_REPLY_QUEUE_NAME");
        String corrSchemeText = this.getTranslatedString("MQ_SRES_CORRELATION_SCHEME");
        String msgIDText = this.getTranslatedString("MQ_SRES_MESSAGE_ID");
        String corrIDText = this.getTranslatedString("MQ_SRES_CORRELATION_ID");
        String msgTypeText = this.getTranslatedString("MQ_CM_MESSAGE_TYPE");
        String waitIntervalText = this.getTranslatedString("MQ_CM_RESP_WAIT");
        String respNoMsgText = this.getTranslatedString("MQ_CM_RESP_NOMSG");
        String[] waitIntervalArray = new String[]{this.m_wcontext.TIME_SECONDS, this.m_wcontext.TIME_MINUTES, this.m_wcontext.TIME_HOURS, this.m_wcontext.TIME_DAYS};
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(431, 326));
        this.introLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), introText);
        this.qNameLabel = new JLabel();
        this.qNameTextField = new JTextField();
        this.correlationPanel = new JPanel();
        this.msgIDLabel = new JLabel(StringUtils.stripMnemonic((String)msgIDText));
        this.msgIDComboBox = new MQMessageIdComboBox(this.m_wcontext);
        this.corrIDLabel = new JLabel(StringUtils.stripMnemonic((String)corrIDText));
        this.corrIDComboBox = new MQCorrelationIdComboBox(this.m_wcontext);
        this.msgTypeLabel = new JLabel();
        this.msgTypeTextField = new JTextField();
        this.qNameLabel.setText(StringUtils.stripMnemonic((String)qNameText));
        this.qNameLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)qNameText));
        this.qNameLabel.setLabelFor(this.qNameTextField);
        LimitDocument limitDoc = new LimitDocument(48);
        this.qNameTextField.setDocument(limitDoc);
        this.qNameTextField.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)qNameText));
        this.qNameTextField.getDocument().addDocumentListener(this);
        this.correlationPanel.setLayout(new GridBagLayout());
        this.correlationPanel.setBorder(BorderFactory.createTitledBorder(corrSchemeText));
        this.msgIDLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)msgIDText));
        this.msgIDLabel.setLabelFor(this.msgIDComboBox);
        this.msgIDComboBox.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)msgIDText));
        this.corrIDLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)corrIDText));
        this.corrIDLabel.setLabelFor(this.corrIDComboBox);
        this.corrIDComboBox.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)corrIDText));
        this.msgTypeLabel.setText(StringUtils.stripMnemonic((String)msgTypeText));
        this.msgTypeTextField.setEditable(false);
        this.qNameTextField.addFocusListener(this);
        this.schemaOptionPanel = new MQPredefinedSchemaPanel(this.mqContext);
        this.respWaitCB = new JCheckBox();
        this.respWaitCB.setText(StringUtils.stripMnemonic((String)waitIntervalText));
        this.respWaitCB.setMnemonic(StringUtils.getMnemonicKeyCode((String)waitIntervalText));
        this.respWaitCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MQAdapterSendMsgResponsePage.this.respWaitCB.isSelected()) {
                    MQAdapterSendMsgResponsePage.this.respWaitNumSpinBox.setEnabled(true);
                    MQAdapterSendMsgResponsePage.this.respWaitUnitsComboBox.setEnabled(true);
                } else {
                    MQAdapterSendMsgResponsePage.this.respWaitNumSpinBox.setEnabled(false);
                    MQAdapterSendMsgResponsePage.this.respWaitUnitsComboBox.setEnabled(false);
                }
            }
        });
        this.respWaitNumSpinBox = new NumericSpinBox(1, Integer.MAX_VALUE);
        this.respWaitNumSpinBox.setEnabled(false);
        this.respWaitUnitsComboBox = new JComboBox<String>(waitIntervalArray);
        this.respWaitUnitsComboBox.setSelectedIndex(0);
        this.respWaitUnitsComboBox.setEnabled(false);
        this.respNoMsgCB = new JCheckBox();
        this.respNoMsgCB.setText(StringUtils.stripMnemonic((String)respNoMsgText));
        this.respNoMsgCB.setMnemonic(StringUtils.getMnemonicKeyCode((String)respNoMsgText));
        this.correlationPanel.add((Component)this.msgIDLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.correlationPanel.add((Component)this.msgIDComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 10, 0, 10), 0, 0));
        this.correlationPanel.add((Component)this.corrIDLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.correlationPanel.add((Component)this.corrIDComboBox, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.introLabel, new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 10, 0), 0, 0));
        this.add((Component)this.msgTypeLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.msgTypeTextField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this.qNameLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.qNameTextField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 18, 2, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this.correlationPanel, new GridBagConstraints(0, 3, 0, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.schemaOptionPanel, new GridBagConstraints(0, 4, 0, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.respWaitCB, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.respWaitNumSpinBox, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this.respWaitUnitsComboBox, new GridBagConstraints(2, 5, 1, 1, 2.0, 0.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.respNoMsgCB, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)new JLabel(), new GridBagConstraints(0, 7, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.m_page.setInitialFocus((Component)this.qNameTextField);
        this.m_page.setCanAdvance(false);
        if (this.m_wcontext._read_service != null) {
            this.initFromWSDL();
        }
        if (this.m_wcontext._importedWsdlInfo != null) {
            this.schemaOptionPanel.setVisible(false);
        }
        if (this.mqContext.serviceType.equals("Asynchronous")) {
            this.respNoMsgCB.setVisible(false);
            this.respWaitCB.setVisible(false);
            this.respWaitNumSpinBox.setVisible(false);
            this.respWaitUnitsComboBox.setVisible(false);
        } else {
            this.respNoMsgCB.setVisible(true);
            this.respWaitCB.setVisible(true);
            this.respWaitNumSpinBox.setVisible(true);
            this.respWaitUnitsComboBox.setVisible(true);
        }
    }

    private void initFromWSDL() throws Exception {
        JcaOperation jop = null;
        String qName = null;
        String respWaitInterval = null;
        String respNoMsg = null;
        if (this.mqContext.serviceType.equals("Synchronous")) {
            jop = this.m_wcontext._read_jca_operation;
            respWaitInterval = jop.getAttributeValue("ResponseWaitInterval");
            respNoMsg = jop.getAttributeValue("ResponseNoMessageAllowed");
            qName = jop.getAttributeValue("ReplyToQueueName");
        } else {
            jop = this.mqContext.inboundJcaOperation;
            qName = jop.getAttributeValue("QueueName");
        }
        String msgType = jop.getAttributeValue("MessageType");
        String msgIDStr = jop.getAttributeValue("MessageId");
        String corrIDStr = jop.getAttributeValue("CorrelationId");
        this.mqContext.predefinedSchema = this.m_wcontext._read_jca_address.getAttributeValue("UIInPredefinedSchema");
        if (msgType != null) {
            this.msgTypeTextField.setText(msgType);
        }
        if (qName != null) {
            this.qNameTextField.setText(qName);
        }
        if (msgIDStr != null) {
            this.msgIDComboBox.setSelectedItemByValue(msgIDStr);
            this.mqContext.messageId = msgIDStr;
        }
        if (corrIDStr != null) {
            this.corrIDComboBox.setSelectedItemByValue(corrIDStr);
            this.mqContext.correlationId = corrIDStr;
        }
        this.schemaOptionPanel.updateControls(this.mqContext);
        if (respWaitInterval != null) {
            this.respWaitCB.setSelected(true);
            this.respWaitNumSpinBox.setEnabled(true);
            this.respWaitUnitsComboBox.setEnabled(true);
            this.setWaitInterval(respWaitInterval, this.m_wcontext.TIME_SECONDS);
        }
        if (respNoMsg != null) {
            if (respNoMsg.equals("true")) {
                this.respNoMsgCB.setSelected(true);
            } else {
                this.respNoMsgCB.setSelected(false);
            }
        }
        this.updateControls();
    }

    private void updateControls() {
        if (this.qNameTextField.getText() != null && !this.qNameTextField.getText().trim().equals("")) {
            this.m_page.setCanAdvance(true);
        } else {
            this.m_page.setCanAdvance(false);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateControls();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateControls();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateControls();
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.mqContext.messageType != null) {
            if (this.mqContext.messageType.equals("NORMAL")) {
                this.msgTypeTextField.setText("REPORT");
            } else if (this.mqContext.messageType.equals("REQUEST")) {
                this.msgTypeTextField.setText("REPLY");
            }
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    @Override
    public void wizardValidatePage(WizardEvent event) {
        this.mqContext = this.schemaOptionPanel.getContext();
        this.removePages();
        ImageWizardPage tempwp = new ImageWizardPage(null, this._getImage(), StringUtils.stripMnemonic((String)this.getTranslatedString("DB_AO_TITLE")));
        MQAdapterAdvancedOptionsPage dsp = new MQAdapterAdvancedOptionsPage(this.m_wcontext, tempwp);
        this.mqContext.replyToQueueName = this.qNameTextField.getText();
        if (this.mqContext.queueNameHasInvalidChars(this.mqContext.replyToQueueName)) {
            MultiLineOptionPane.showMessageDialog((Component)this, (Object)this.getTranslatedString("MQ_CM_INVALID_QNAME"), (String)this.getTranslatedString("MQ_CM_ERROR_TITLE"), (int)0);
            ((Cancelable)event).cancel();
        }
        this.mqContext.messageId = this.msgIDComboBox.getSelectedValue();
        this.mqContext.correlationId = this.corrIDComboBox.getSelectedValue();
        if (("CICS Schema".equals(this.mqContext.predefinedSchema) || "IMS Schema".equals(this.mqContext.predefinedSchema)) && ("CICS".equals(this.mqContext.messageFormat) || "IMS".equals(this.mqContext.messageFormat))) {
            this.addFinishPage();
            this.setFinishPage();
            this.noSchemaPage = true;
        } else {
            ImageWizardPage wp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("FA_SC_TITLE"));
            MQAdapterInOutSchemaPage inOutSchemaPage = new MQAdapterInOutSchemaPage(this.m_wcontext, wp);
            this.addFinishPage();
            this.noSchemaPage = false;
        }
    }

    public void setFinishPage() {
        new MQAdapterFinishPanel(this.m_wcontext, this);
    }

    @Override
    public void buildWSDL() throws WSDLException {
        JcaOperation jop = null;
        if (this.mqContext.serviceType.equals("Asynchronous")) {
            jop = this.mqContext.inboundJcaOperation;
            jop.setAttributeValue("ActivationSpec", "oracle.tip.adapter.mq.inbound.ActivationSpecImpl");
        } else {
            jop = this.m_wcontext._write_jca_operation;
            if (this.respWaitCB.isSelected()) {
                long respWaitInterval = ((Integer)this.respWaitNumSpinBox.getValue()).longValue();
                String respWaitUOM = (String)this.respWaitUnitsComboBox.getSelectedItem();
                if (respWaitInterval > 0L) {
                    jop.setAttributeValue("ResponseWaitInterval", this.convertToMilliSeconds(respWaitInterval, respWaitUOM));
                }
            }
            if (this.respNoMsgCB.isSelected()) {
                jop.setAttributeValue("ResponseNoMessageAllowed", "true");
            } else {
                jop.setAttributeValue("ResponseNoMessageAllowed", "false");
            }
        }
        if (this.mqContext.serviceType.equals("Asynchronous")) {
            jop.setAttributeValue("MessageType", this.msgTypeTextField.getText());
            jop.setAttributeValue("QueueName", this.qNameTextField.getText());
        } else {
            jop.setAttributeValue("ReplyToQueueName", this.qNameTextField.getText());
        }
        jop.setAttributeValue("MessageId", this.mqContext.messageId);
        jop.setAttributeValue("CorrelationId", this.mqContext.correlationId);
        if (this.noSchemaPage) {
            this.mqContext.addPredefinedSchemas(this.mqContext.serviceType.equals("Asynchronous"));
        }
        if (this.mqContext.predefinedSchema != null) {
            this.m_wcontext._write_jca_address.setAttributeValue("UIInPredefinedSchema", this.mqContext.predefinedSchema);
        }
    }

    public void setWaitInterval(String waitInMilliSec, String unitOfMeasure) {
        if (!waitInMilliSec.trim().equals("")) {
            long waitLongVal = this.getLong(Integer.valueOf(waitInMilliSec));
            String waitIntervalValue = this.convertToUnitOfMeasure(waitLongVal, unitOfMeasure);
            int waitValInt = Integer.valueOf(waitIntervalValue);
            this.respWaitNumSpinBox.setIntValue(waitValInt);
            this.respWaitUnitsComboBox.setSelectedItem(unitOfMeasure);
        }
    }

    private String convertToUnitOfMeasure(long expiry, String unitOfMeasure) {
        long convertedExpiry = -1L;
        if (unitOfMeasure != null) {
            if (unitOfMeasure.equals(this.m_wcontext.TIME_SECONDS)) {
                convertedExpiry = expiry / 1000L;
            } else if (unitOfMeasure.equals(this.m_wcontext.TIME_MINUTES)) {
                convertedExpiry = expiry / 1000L / 60L;
            } else if (unitOfMeasure.equals(this.m_wcontext.TIME_HOURS)) {
                convertedExpiry = expiry / 1000L / 3600L;
            } else if (unitOfMeasure.equals(this.m_wcontext.TIME_DAYS)) {
                convertedExpiry = expiry / 1000L / 3600L / 24L;
            }
        }
        return String.valueOf(convertedExpiry);
    }

    private String convertToMilliSeconds(long waitInterval, String unitOfMeasure) {
        String msecondsStr = null;
        long mseconds = -1L;
        if (unitOfMeasure != null) {
            if (unitOfMeasure.equals(this.m_wcontext.TIME_SECONDS)) {
                mseconds = waitInterval * 1000L;
            } else if (unitOfMeasure.equals(this.m_wcontext.TIME_MINUTES)) {
                mseconds = waitInterval * 60L * 1000L;
            } else if (unitOfMeasure.equals(this.m_wcontext.TIME_HOURS)) {
                mseconds = waitInterval * 60L * 60L * 1000L;
            } else if (unitOfMeasure.equals(this.m_wcontext.TIME_DAYS)) {
                mseconds = waitInterval * 60L * 60L * 24L * 1000L;
            }
        }
        msecondsStr = String.valueOf(mseconds);
        return msecondsStr;
    }
}

