/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.mq;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.wsdl.WSDLException;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.share.nls.StringUtils;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.mq.MQAdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.mq.MQReportOptionComboBox;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.techAdapterWizardPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.JcaOperation;

public class MQAdapterSendMsgReportPage
extends techAdapterWizardPage
implements ActionListener {
    private MultiLineLabel introLabel;
    private JCheckBox coaCheckBox;
    private MQReportOptionComboBox coaRepOptComboBox;
    private JCheckBox codCheckBox;
    private MQReportOptionComboBox codRepOptComboBox;
    private JCheckBox exceptionRepCheckBox;
    private MQReportOptionComboBox exceptionRepOptComboBox;
    private JCheckBox expiryRepCheckBox;
    private MQReportOptionComboBox expiryRepOptComboBox;

    public MQAdapterSendMsgReportPage(AdapterWizardContext wcontext, ImageWizardPage iwp) {
        try {
            this.setHelpTopicID("bpmjdev_adp_wiz_mq_send_reports");
            this.setContextAndPage(wcontext, iwp);
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        String introText = this.getTranslatedString("MQ_SR_INTRO_PROMPT");
        String coaText = this.getTranslatedString("MQ_SR_CONFIRMATION_ON_ARRIVAL");
        String codText = this.getTranslatedString("MQ_SR_CONFIRMATION_ON_DELIVERY");
        String exRepText = this.getTranslatedString("MQ_SR_EXCEPTION_REPORT");
        String expiryRepText = this.getTranslatedString("MQ_SR_EXPIRY_REPORT");
        String repOptText = this.getTranslatedString("MQ_SR_REPORT_OPTION");
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(431, 326));
        this.introLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), introText);
        this.coaCheckBox = new JCheckBox(StringUtils.stripMnemonic((String)coaText), false);
        this.coaCheckBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)coaText));
        this.coaCheckBox.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)coaText));
        this.coaCheckBox.addActionListener(this);
        this.coaRepOptComboBox = new MQReportOptionComboBox();
        this.coaRepOptComboBox.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)coaText) + " " + repOptText);
        this.codCheckBox = new JCheckBox(StringUtils.stripMnemonic((String)codText), false);
        this.codCheckBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)codText));
        this.codCheckBox.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)codText));
        this.codCheckBox.addActionListener(this);
        this.codRepOptComboBox = new MQReportOptionComboBox();
        this.codRepOptComboBox.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)codText) + " " + repOptText);
        this.exceptionRepCheckBox = new JCheckBox(StringUtils.stripMnemonic((String)exRepText), false);
        this.exceptionRepCheckBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)exRepText));
        this.exceptionRepCheckBox.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)exRepText));
        this.exceptionRepCheckBox.addActionListener(this);
        this.exceptionRepOptComboBox = new MQReportOptionComboBox();
        this.exceptionRepOptComboBox.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)exRepText) + " " + repOptText);
        this.expiryRepCheckBox = new JCheckBox(StringUtils.stripMnemonic((String)expiryRepText), false);
        this.expiryRepCheckBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)expiryRepText));
        this.expiryRepCheckBox.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)expiryRepText));
        this.expiryRepCheckBox.addActionListener(this);
        this.expiryRepOptComboBox = new MQReportOptionComboBox();
        this.expiryRepOptComboBox.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)expiryRepText) + " " + repOptText);
        this.add((Component)this.introLabel, new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.coaCheckBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(15, 0, 0, 0), 0, 0));
        this.add((Component)this.coaRepOptComboBox, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 20, 0, 0), 0, 0));
        this.add((Component)this.codCheckBox, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(15, 0, 0, 0), 0, 0));
        this.add((Component)this.codRepOptComboBox, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 20, 0, 0), 0, 0));
        this.add((Component)this.exceptionRepCheckBox, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 18, 0, new Insets(15, 0, 0, 0), 0, 0));
        this.add((Component)this.exceptionRepOptComboBox, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 20, 0, 0), 0, 0));
        this.add((Component)this.expiryRepCheckBox, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 18, 0, new Insets(15, 0, 0, 0), 0, 0));
        this.add((Component)this.expiryRepOptComboBox, new GridBagConstraints(0, 8, 1, 1, 0.0, 3.0, 18, 0, new Insets(0, 20, 0, 0), 0, 0));
        this.m_page.setCanAdvance(true);
        this.updateControls();
        if (this.m_wcontext._read_service != null) {
            this.initFromWSDL();
        }
    }

    private void initFromWSDL() throws Exception {
        MQAdapterWizardContext mqContext = (MQAdapterWizardContext)this.m_wcontext._ascontext;
        JcaOperation jop = mqContext.outboundJcaOperation;
        String coaRepStr = jop.getAttributeValue("ReportCOA");
        String codRepStr = jop.getAttributeValue("ReportCOD");
        String excRepStr = jop.getAttributeValue("ReportException");
        String expiryRepStr = jop.getAttributeValue("ReportExpiry");
        if (coaRepStr != null) {
            this.coaCheckBox.setSelected(true);
            this.coaRepOptComboBox.setSelectedItemByValue(coaRepStr);
        }
        if (codRepStr != null) {
            this.codCheckBox.setSelected(true);
            this.codRepOptComboBox.setSelectedItemByValue(codRepStr);
        }
        if (excRepStr != null) {
            this.exceptionRepCheckBox.setSelected(true);
            this.exceptionRepOptComboBox.setSelectedItemByValue(excRepStr);
        }
        if (expiryRepStr != null) {
            this.expiryRepCheckBox.setSelected(true);
            this.expiryRepOptComboBox.setSelectedItemByValue(expiryRepStr);
        }
        this.updateControls();
    }

    private void updateControls() {
        if (this.coaCheckBox.isSelected()) {
            this.coaRepOptComboBox.setEnabled(true);
        } else {
            this.coaRepOptComboBox.setEnabled(false);
        }
        if (this.codCheckBox.isSelected()) {
            this.codRepOptComboBox.setEnabled(true);
        } else {
            this.codRepOptComboBox.setEnabled(false);
        }
        if (this.exceptionRepCheckBox.isSelected()) {
            this.exceptionRepOptComboBox.setEnabled(true);
        } else {
            this.exceptionRepOptComboBox.setEnabled(false);
        }
        if (this.expiryRepCheckBox.isSelected()) {
            this.expiryRepOptComboBox.setEnabled(true);
        } else {
            this.expiryRepOptComboBox.setEnabled(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.updateControls();
    }

    @Override
    public void buildWSDL() throws WSDLException {
        MQAdapterWizardContext mqContext = (MQAdapterWizardContext)this.m_wcontext._ascontext;
        JcaOperation jop = mqContext.outboundJcaOperation;
        if (mqContext.operationType.equals("Request-response") && mqContext.serviceType.equals("Synchronous")) {
            jop = this.m_wcontext._write_jca_operation;
        }
        if (this.coaCheckBox.isSelected()) {
            jop.setAttributeValue("ReportCOA", this.coaRepOptComboBox.getSelectedValue());
        }
        if (this.codCheckBox.isSelected()) {
            jop.setAttributeValue("ReportCOD", this.codRepOptComboBox.getSelectedValue());
        }
        if (this.exceptionRepCheckBox.isSelected()) {
            jop.setAttributeValue("ReportException", this.exceptionRepOptComboBox.getSelectedValue());
        }
        if (this.expiryRepCheckBox.isSelected()) {
            jop.setAttributeValue("ReportExpiry", this.expiryRepOptComboBox.getSelectedValue());
        }
    }
}

