/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.mq;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.wsdl.WSDLException;
import oracle.bali.ewt.event.Cancelable;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.bali.share.nls.StringUtils;
import oracle.tip.tools.ide.common.utils.MultiLineOptionPane;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.LimitDocument;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.mq.MQAdapterAdvancedOptionsPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.mq.MQAdapterFinishPanel;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.mq.MQAdapterSchemaPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.mq.MQAdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.mq.MQDeliveryFailureComboBox;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.mq.MQExpiryPanel;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.mq.MQMessageFormatComboBox;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.mq.MQPersistenceComboBox;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.mq.MQPriorityComboBox;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.techAdapterWizardPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.JcaOperation;

public class MQAdapterPutMsgIntoMQPage
extends techAdapterWizardPage
implements ActionListener,
FocusListener {
    private final String QUEUE_SEPARATOR = ";";
    private final String COMMA_SEPARATOR = ",";
    private MultiLineLabel introLabel;
    private JLabel messageFormatLabel;
    private MQMessageFormatComboBox messageFormatComboBox;
    private JLabel priorityLabel;
    private MQPriorityComboBox priorityComboBox;
    private JLabel persistenceLabel;
    private MQPersistenceComboBox persistenceComboBox;
    private MQExpiryPanel expiryPanel;
    private JCheckBox segmentationCheckBox;
    private JLabel deliveryFailureLabel;
    private MQDeliveryFailureComboBox deliveryFailureComboBox;
    private JCheckBox partialDeliveryCheckBox;
    private JPanel buttonPanel;
    private JButton addButton;
    private JButton removeButton;
    private JTable qTable;
    private JScrollPane qTablePane;
    private DefaultTableModel qTableModel;
    private Vector qTableData;
    private Vector qColumnNames;
    private MQAdapterWizardContext mqContext;
    private boolean noSchemaPage;
    private boolean pageInit = false;

    public MQAdapterPutMsgIntoMQPage(AdapterWizardContext wcontext, ImageWizardPage iwp) {
        try {
            this.setHelpTopicID("bpmjdev_adp_wiz_mq_put");
            this.setContextAndPage(wcontext, iwp);
            this.mqContext = (MQAdapterWizardContext)this.m_wcontext._ascontext;
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        String introText = this.getTranslatedString("MQ_PM_INTRO_PROMPT");
        String qNameText = this.getTranslatedString("MQ_CM_QUEUE_NAME");
        String qMgrText = this.getTranslatedString("MQ_CM_QUEUE_MANAGER");
        String qMgrTip = this.getTranslatedString("MQ_CM_QUEUE_MANAGER_TIP");
        String msgFormatText = this.getTranslatedString("MQ_CM_MESSAGE_FORMAT");
        String priorityText = this.getTranslatedString("MQ_CM_PRIORITY");
        String persText = this.getTranslatedString("MQ_CM_PERSISTENCE");
        String segmentationText = this.getTranslatedString("MQ_PM_ALLOW_SEGMENTATION");
        String segmentationTip = this.getTranslatedString("MQ_PM_ALLOW_SEGMENTATION_TIP");
        String deliveryFailureText = this.getTranslatedString("MQ_PM_DELIVERY_FAILURE");
        String deliveryFailureTip = this.getTranslatedString("MQ_PM_DELIVERY_FAILURE_TIP");
        String addText = this.getTranslatedString("MQ_PM_Q_ADD");
        String addTip = this.getTranslatedString("MQ_PM_Q_ADD_TIP");
        String removeText = this.getTranslatedString("MQ_PM_Q_REMOVE");
        String removeTip = this.getTranslatedString("MQ_PM_Q_REMOVE_TIP");
        String qTableText = this.getTranslatedString("MQ_PM_Q_TABLE");
        String partialDeliveryText = this.getTranslatedString("MQ_PM_PARTIAL_DELIVERY");
        String partialDeliveryTip = this.getTranslatedString("MQ_PM_PARTIAL_DELIVERY_TIP");
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(431, 326));
        this.introLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), introText);
        this.buttonPanel = new JPanel();
        this.addButton = new JButton(StringUtils.stripMnemonic((String)addText));
        this.addButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)addText));
        this.addButton.setToolTipText(addTip);
        this.addButton.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)addText));
        this.addButton.getAccessibleContext().setAccessibleDescription(addTip);
        this.addButton.addActionListener(this);
        this.removeButton = new JButton(StringUtils.stripMnemonic((String)removeText));
        this.removeButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)removeText));
        this.removeButton.setToolTipText(removeTip);
        this.removeButton.setEnabled(false);
        this.removeButton.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)removeText));
        this.removeButton.getAccessibleContext().setAccessibleDescription(removeTip);
        this.removeButton.addActionListener(this);
        this.partialDeliveryCheckBox = new JCheckBox();
        this.messageFormatLabel = new JLabel();
        this.messageFormatComboBox = new MQMessageFormatComboBox(this.m_wcontext);
        this.priorityLabel = new JLabel();
        this.priorityComboBox = new MQPriorityComboBox(this.m_wcontext);
        this.persistenceLabel = new JLabel();
        this.persistenceComboBox = new MQPersistenceComboBox(this.m_wcontext);
        this.expiryPanel = new MQExpiryPanel(this.m_wcontext);
        this.segmentationCheckBox = new JCheckBox();
        this.deliveryFailureLabel = new JLabel();
        this.deliveryFailureComboBox = new MQDeliveryFailureComboBox(this.m_wcontext);
        this.qTable = new JTable();
        this.qTable.addFocusListener(this);
        this.qTablePane = new JScrollPane(this.qTable);
        this.qTablePane.getAccessibleContext().setAccessibleName(qTableText);
        this.qTablePane.setToolTipText(qMgrTip);
        this.qColumnNames = new Vector(2);
        this.qColumnNames.add(StringUtils.stripMnemonic((String)qNameText));
        this.qColumnNames.add(StringUtils.stripMnemonic((String)qMgrText));
        this.qTableModel = new DefaultTableModel();
        this.qTableData = new Vector();
        ListSelectionModel lsm = this.qTable.getSelectionModel();
        lsm.addListSelectionListener(new QTableSelectionListener());
        this.qTable.addFocusListener(this);
        this.setQTableDataModel();
        if (this.m_wcontext._read_service == null) {
            this.addRow("", "");
            this.pageInit = true;
            this.m_page.setInitialFocus((Component)this.qTable);
        }
        this.partialDeliveryCheckBox.setText(StringUtils.stripMnemonic((String)partialDeliveryText));
        this.partialDeliveryCheckBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)partialDeliveryText));
        this.partialDeliveryCheckBox.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)partialDeliveryText));
        this.partialDeliveryCheckBox.setToolTipText(partialDeliveryTip);
        this.messageFormatLabel.setText(StringUtils.stripMnemonic((String)msgFormatText));
        this.messageFormatLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)msgFormatText));
        this.messageFormatLabel.setLabelFor(this.messageFormatComboBox);
        this.messageFormatComboBox.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)msgFormatText));
        this.priorityLabel.setText(StringUtils.stripMnemonic((String)priorityText));
        this.priorityLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)priorityText));
        this.priorityLabel.setLabelFor(this.priorityComboBox);
        this.priorityComboBox.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)priorityText));
        this.persistenceLabel.setText(StringUtils.stripMnemonic((String)persText));
        this.persistenceLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)persText));
        this.persistenceLabel.setLabelFor(this.persistenceComboBox);
        this.persistenceComboBox.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)persText));
        this.segmentationCheckBox.setText(StringUtils.stripMnemonic((String)segmentationText));
        this.segmentationCheckBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)segmentationText));
        this.segmentationCheckBox.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)segmentationText));
        this.segmentationCheckBox.setToolTipText(segmentationTip);
        this.deliveryFailureLabel.setText(StringUtils.stripMnemonic((String)deliveryFailureText));
        this.deliveryFailureLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)deliveryFailureText));
        this.deliveryFailureLabel.setLabelFor(this.deliveryFailureComboBox);
        this.deliveryFailureComboBox.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)deliveryFailureText));
        this.deliveryFailureComboBox.setToolTipText(deliveryFailureTip);
        this.buttonPanel.add(this.addButton);
        this.buttonPanel.add(this.removeButton);
        this.buttonPanel.add((Component)this.addButton, new GridBagConstraints(0, 0, 0, 0, 0.0, 0.0, 12, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.buttonPanel.add((Component)this.removeButton, new GridBagConstraints(1, 0, 0, 0, 0.0, 0.0, 12, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.introLabel, new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.buttonPanel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.qTablePane, new GridBagConstraints(0, 2, 0, 5, 0.0, 2.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.partialDeliveryCheckBox, new GridBagConstraints(0, -1, 2, 1, 0.0, 0.0, 18, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.messageFormatLabel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.messageFormatComboBox, new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 18, 2, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this.priorityLabel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.priorityComboBox, new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 18, 2, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this.persistenceLabel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.persistenceComboBox, new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 18, 2, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this.deliveryFailureLabel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 18, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.deliveryFailureComboBox, new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 18, 2, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this.segmentationCheckBox, new GridBagConstraints(0, -1, 2, 1, 0.0, 0.0, 18, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.expiryPanel, new GridBagConstraints(0, -1, 2, 1, 0.0, 0.0, 18, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.m_page.setInitialFocus((Component)this.qTable);
        this.m_page.setCanAdvance(true);
        if (this.m_wcontext._read_service != null) {
            this.initFromWSDL();
        }
    }

    private void initFromWSDL() throws Exception {
        JcaOperation jop = this.m_wcontext._read_jca_operation;
        String qName = jop.getAttributeValue("QueueName");
        String qNameMgr = jop.getAttributeValue("SecondaryQueueManagerName");
        String msgFormat = jop.getAttributeValue("MessageFormat");
        String priority = jop.getAttributeValue("Priority");
        String persistence = jop.getAttributeValue("Persistence");
        String expiry = jop.getAttributeValue("Expiry");
        String segment = jop.getAttributeValue("SegmentIfRequired");
        String deliveryFailure = jop.getAttributeValue("OnDeliveryFailure");
        String distributionListStr = jop.getAttributeValue("DistributionList");
        String partialDelivery = jop.getAttributeValue("PartialDeliveryForDL");
        String msgType = jop.getAttributeValue("MessageType");
        if (qName != null) {
            this.addRow(qName, qNameMgr);
        } else if (distributionListStr != null) {
            this.qTableData = this.convertStringToQTableData(distributionListStr);
            this.setQTableDataModel();
        }
        if (partialDelivery != null && partialDelivery.equals("true")) {
            this.partialDeliveryCheckBox.setSelected(true);
        } else {
            this.partialDeliveryCheckBox.setSelected(false);
        }
        if (msgFormat != null) {
            this.messageFormatComboBox.setSelectedItemByValue(msgFormat);
        }
        if (priority != null) {
            this.priorityComboBox.setSelectedItemByValue(priority);
        }
        if (persistence != null) {
            this.persistenceComboBox.setSelectedItemByValue(persistence);
        }
        if (deliveryFailure != null) {
            this.deliveryFailureComboBox.setSelectedItemByValue(deliveryFailure);
        }
        if (segment != null && segment.equalsIgnoreCase("true")) {
            this.segmentationCheckBox.setSelected(true);
        } else {
            this.segmentationCheckBox.setSelected(false);
        }
        if (expiry != null) {
            this.expiryPanel.setExpiry(expiry, this.m_wcontext.TIME_SECONDS);
        }
    }

    private void setQTableDataModel() {
        int[] selRows = this.qTable.getSelectedRows();
        this.qTableModel.setDataVector(this.qTableData, this.qColumnNames);
        this.qTable.setModel(this.qTableModel);
        this.selectRows(selRows);
    }

    private void addRow(String qName, String qMgr) {
        if (this.qTableData != null) {
            Vector<String> row = new Vector<String>(2);
            row.add(qName);
            row.add(qMgr);
            this.qTableData.add(row);
            this.qTableModel.fireTableRowsInserted(this.qTableData.size(), this.qTableData.size());
        }
    }

    private void removeRows(int[] selectedRows) {
        if (selectedRows.length > 0) {
            for (int i = selectedRows.length - 1; i >= 0; --i) {
                this.qTableData.remove(selectedRows[i]);
            }
            this.setQTableDataModel();
        }
    }

    private void selectRows(int[] selectedRows) {
        if (selectedRows.length > 0) {
            for (int i = 0; i < selectedRows.length; ++i) {
                int curRow = selectedRows[i];
                this.qTable.addRowSelectionInterval(curRow, curRow);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.addButton) {
            this.addRow("", "");
            int row = this.qTable.getRowCount() - 1;
            int col = 0;
            this.editCell(this.qTable, row, col);
        } else if (e.getSource() == this.removeButton) {
            this.removeRows(this.qTable.getSelectedRows());
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (e.getSource() == this.qTable && this.pageInit) {
            this.editCell(this.qTable, 0, 0);
            this.pageInit = false;
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    private void editCell(JTable table, int row, int col) {
        if (table.editCellAt(row, col)) {
            table.changeSelection(row, col, false, false);
            Component editor = table.getEditorComponent();
            if (editor != null) {
                ((JTextField)editor).setDocument(new LimitDocument(48));
                editor.requestFocusInWindow();
            }
        }
    }

    @Override
    public void wizardValidatePage(WizardEvent event) {
        this.removePages();
        String pageTitle = StringUtils.stripMnemonic((String)this.getTranslatedString("DB_AO_TITLE"));
        ImageWizardPage tempwp = new ImageWizardPage(null, this._getImage(), pageTitle);
        MQAdapterAdvancedOptionsPage dsp1 = new MQAdapterAdvancedOptionsPage(this.m_wcontext, tempwp);
        TableCellEditor cellEditor = this.qTable.getCellEditor();
        if (cellEditor != null) {
            cellEditor.stopCellEditing();
        }
        if (this.qTableData == null || this.qTableData.size() <= 0) {
            MultiLineOptionPane.showMessageDialog((Component)this, (Object)this.getTranslatedString("MQ_PM_NO_Q_NAME_ERROR"), (String)this.getTranslatedString("MQ_CM_ERROR_TITLE"), (int)0);
            ((Cancelable)event).cancel();
        } else if (!this.qTableDataIsValid()) {
            MultiLineOptionPane.showMessageDialog((Component)this, (Object)this.getTranslatedString("MQ_PM_Q_NAME_MISSING_ERROR"), (String)this.getTranslatedString("MQ_CM_ERROR_TITLE"), (int)0);
            ((Cancelable)event).cancel();
        }
        if (this.queueNamesTooLong()) {
            MultiLineOptionPane.showMessageDialog((Component)this, (Object)this.getTranslatedString("MQ_CM_QNAME_TOO_LONG"), (String)this.getTranslatedString("MQ_CM_ERROR_TITLE"), (int)0);
            ((Cancelable)event).cancel();
        }
        if (!this.validQueueNames()) {
            MultiLineOptionPane.showMessageDialog((Component)this, (Object)this.getTranslatedString("MQ_CM_INVALID_QNAME"), (String)this.getTranslatedString("MQ_CM_ERROR_TITLE"), (int)0);
            ((Cancelable)event).cancel();
        }
        this.mqContext.messageFormat = this.messageFormatComboBox.getSelectedValue();
        if (this.mqContext.messageFormat.equals("CICS") || this.mqContext.messageFormat.equals("IMS")) {
            this.addFinishPage();
            this.setFinishPage();
            this.noSchemaPage = true;
        } else {
            ImageWizardPage wp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("FA_SC_TITLE"));
            MQAdapterSchemaPage schemaPage = new MQAdapterSchemaPage(this.m_wcontext, wp);
            this.addFinishPage();
            this.noSchemaPage = false;
        }
    }

    private boolean qTableDataIsValid() {
        boolean isValid = true;
        int emptyCount = 0;
        if (this.qTableData != null && this.qTableData.size() > 0) {
            for (int i = 0; i < this.qTableData.size(); ++i) {
                Vector row = (Vector)this.qTableData.get(i);
                String qName = (String)row.get(0);
                String qMgr = (String)row.get(1);
                if ((qName == null || qName.trim().equals("")) && qMgr != null && !qMgr.trim().equals("")) {
                    isValid = false;
                    break;
                }
                if (qName != null && !qName.trim().equals("") || qMgr != null && !qMgr.trim().equals("")) continue;
                ++emptyCount;
            }
            if (emptyCount == this.qTableData.size()) {
                isValid = false;
            }
        } else {
            isValid = false;
        }
        return isValid;
    }

    private String convertQTableDataToString() {
        String qTableStr = "";
        if (this.qTableData != null && this.qTableData.size() > 0) {
            for (int i = 0; i < this.qTableData.size(); ++i) {
                Vector row = (Vector)this.qTableData.get(i);
                String qName = (String)row.get(0);
                String qMgr = (String)row.get(1);
                if (qName == null || qName.trim().equals("")) {
                    qName = "";
                }
                if (qMgr == null || qMgr.trim().equals("")) {
                    qMgr = "";
                }
                if (qName == null || qName.trim().equals("")) continue;
                qTableStr = qTableStr + qName + "," + qMgr + ";";
            }
            qTableStr = qTableStr != null && !qTableStr.trim().equals("") ? qTableStr.substring(0, qTableStr.lastIndexOf(";")) : null;
        }
        return qTableStr;
    }

    private Vector convertStringToQTableData(String distributionListStr) {
        Vector qVector = new Vector();
        if (distributionListStr != null && !distributionListStr.trim().equals("")) {
            StringTokenizer tokenizer = new StringTokenizer(distributionListStr, ";");
            while (tokenizer.hasMoreTokens()) {
                String distribution = tokenizer.nextToken();
                StringTokenizer distTokenizer = new StringTokenizer(distribution, ",");
                String qName = null;
                String qMgr = null;
                while (distTokenizer.hasMoreTokens()) {
                    qName = distTokenizer.nextToken();
                    try {
                        qMgr = distTokenizer.nextToken();
                    }
                    catch (NoSuchElementException ne) {
                        // empty catch block
                    }
                    Vector<String> row = new Vector<String>();
                    row.add(qName);
                    row.add(qMgr);
                    qVector.add(row);
                }
            }
        }
        return qVector;
    }

    private int getQTableSize() {
        int size = 0;
        if (this.qTableData != null && this.qTableData.size() > 0) {
            for (int i = 0; i < this.qTableData.size(); ++i) {
                Vector row = (Vector)this.qTableData.get(i);
                String qName = (String)row.get(0);
                if (qName == null || qName.trim().equals("")) continue;
                ++size;
            }
        }
        return size;
    }

    private boolean validQueueNames() {
        if (this.qTableData == null && this.qTableData.size() < 1) {
            return false;
        }
        for (int i = 0; i < this.qTableData.size(); ++i) {
            Vector row = (Vector)this.qTableData.get(i);
            String qName = (String)row.get(0);
            String qMgr = (String)row.get(1);
            if (this.mqContext.queueNameHasInvalidChars(qName)) {
                return false;
            }
            if (!this.mqContext.queueNameHasInvalidChars(qMgr)) continue;
            return false;
        }
        return true;
    }

    private boolean queueNamesTooLong() {
        if (this.qTableData == null && this.qTableData.size() < 1) {
            return false;
        }
        for (int i = 0; i < this.qTableData.size(); ++i) {
            Vector row = (Vector)this.qTableData.get(i);
            String qName = (String)row.get(0);
            String qMgr = (String)row.get(1);
            if (this.mqContext.isQueueNameTooLong(qName)) {
                return true;
            }
            if (!this.mqContext.isQueueNameTooLong(qMgr)) continue;
            return true;
        }
        return false;
    }

    public void setFinishPage() {
        new MQAdapterFinishPanel(this.m_wcontext, this);
    }

    @Override
    public void buildWSDL() throws WSDLException {
        JcaOperation jop = this.m_wcontext._write_jca_operation;
        jop.setAttributeValue("InteractionSpec", "oracle.tip.adapter.mq.outbound.InteractionSpecImpl");
        int qTableSize = this.getQTableSize();
        if (qTableSize > 1) {
            String qTableStr = this.convertQTableDataToString();
            jop.setAttributeValue("DistributionList", qTableStr);
        } else if (qTableSize == 1) {
            Vector row = (Vector)this.qTableData.get(0);
            String qName = (String)row.get(0);
            String qMgr = (String)row.get(1);
            jop.setAttributeValue("QueueName", qName);
            if (qMgr != null && !qMgr.trim().equals("")) {
                jop.setAttributeValue("SecondaryQueueManagerName", qMgr);
            }
        }
        jop.setAttributeValue("MessageType", "NORMAL");
        jop.setAttributeValue("MessageFormat", this.messageFormatComboBox.getSelectedValue());
        jop.setAttributeValue("Priority", this.priorityComboBox.getSelectedValue());
        jop.setAttributeValue("Persistence", this.persistenceComboBox.getSelectedValue());
        jop.setAttributeValue("OnDeliveryFailure", this.deliveryFailureComboBox.getSelectedValue());
        if (this.partialDeliveryCheckBox.isSelected()) {
            jop.setAttributeValue("PartialDeliveryForDL", "true");
        } else {
            jop.setAttributeValue("PartialDeliveryForDL", "false");
        }
        if (this.segmentationCheckBox.isSelected()) {
            jop.setAttributeValue("SegmentIfRequired", "true");
        } else {
            jop.setAttributeValue("SegmentIfRequired", "false");
        }
        jop.setAttributeValue("Expiry", this.expiryPanel.getExpiry());
        if (this.noSchemaPage) {
            String predefSchema = null;
            if (this.mqContext.messageFormat.equals("CICS")) {
                predefSchema = "CICS Schema";
            } else if (this.mqContext.messageFormat.equals("IMS")) {
                predefSchema = "IMS Schema";
            }
            if (predefSchema != null) {
                this.mqContext.addSinglePredefinedSchema(predefSchema, false, true);
            }
        }
    }

    private class QTableSelectionListener
    implements ListSelectionListener {
        private QTableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            if (!lsm.isSelectionEmpty()) {
                MQAdapterPutMsgIntoMQPage.this.removeButton.setEnabled(true);
            } else {
                MQAdapterPutMsgIntoMQPage.this.removeButton.setEnabled(false);
            }
        }
    }
}

