/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.mq;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.wsdl.WSDLException;
import oracle.bali.ewt.event.Cancelable;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.bali.share.nls.StringUtils;
import oracle.tip.tools.ide.common.utils.MultiLineOptionPane;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.LimitDocument;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.mq.MQAdapterFinishPanel;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.mq.MQAdapterInOutSchemaPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.mq.MQAdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.mq.MQDeliveryFailureComboBox;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.mq.MQExpiryPanel;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.mq.MQMessageFormatComboBox;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.mq.MQPersistenceComboBox;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.mq.MQPriorityComboBox;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.techAdapterWizardPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.JcaOperation;

public class MQAdapterGetMsgResponsePage
extends techAdapterWizardPage {
    private MultiLineLabel introLabel;
    private JLabel fallbackQNameLabel;
    private JTextField fallbackQNameTextField;
    private JLabel fallbackQManagerLabel;
    private JTextField fallbackQManagerTextField;
    private JLabel priorityLabel;
    private MQPriorityComboBox priorityComboBox;
    private JLabel persistenceLabel;
    private MQPersistenceComboBox persistenceComboBox;
    private MQExpiryPanel expiryPanel;
    private JLabel msgTypeLabel;
    private JTextField msgTypeTextField;
    private JCheckBox segmentationCheckBox;
    private JLabel deliveryFailureLabel;
    private MQDeliveryFailureComboBox deliveryFailureComboBox;
    private JLabel messageFormatLabel;
    private MQMessageFormatComboBox messageFormatComboBox;
    private MQAdapterWizardContext mqContext;
    private boolean noSchemaPage;

    public MQAdapterGetMsgResponsePage(AdapterWizardContext wcontext, ImageWizardPage iwp) {
        try {
            this.setHelpTopicID("bpmjdev_adp_wiz_mq_get_response");
            this.setContextAndPage(wcontext, iwp);
            this.mqContext = (MQAdapterWizardContext)this.m_wcontext._ascontext;
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        String introText = this.getTranslatedString("MQ_GR_INTRO_PROMPT");
        String fbQNameText = this.getTranslatedString("MQ_GR_FALLBACK_Q_NAME");
        String fbQMgrText = this.getTranslatedString("MQ_GR_FALLBACK_Q_MGR");
        String qMgrTip = this.getTranslatedString("MQ_CM_QUEUE_MANAGER_TIP");
        String priorityText = this.getTranslatedString("MQ_CM_PRIORITY");
        String persText = this.getTranslatedString("MQ_CM_PERSISTENCE");
        String msgTypeText = this.getTranslatedString("MQ_CM_MESSAGE_TYPE");
        String fbQNameTip = this.getTranslatedString("MQ_CM_FALLBACK_Q_NAME_TIP");
        String fbQMgrTip = this.getTranslatedString("MQ_CM_FALLBACK_Q_MGR_TIP");
        String segmentationText = this.getTranslatedString("MQ_PM_ALLOW_SEGMENTATION");
        String segmentationTip = this.getTranslatedString("MQ_PM_ALLOW_SEGMENTATION_TIP");
        String deliveryFailureText = this.getTranslatedString("MQ_PM_DELIVERY_FAILURE");
        String deliveryFailureTip = this.getTranslatedString("MQ_PM_DELIVERY_FAILURE_TIP");
        String msgFormatText = this.getTranslatedString("MQ_CM_MESSAGE_FORMAT");
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(431, 326));
        this.introLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), introText);
        this.msgTypeLabel = new JLabel();
        this.msgTypeTextField = new JTextField();
        this.fallbackQNameLabel = new JLabel();
        this.fallbackQNameTextField = new JTextField();
        this.fallbackQNameTextField.setDocument(new LimitDocument(48));
        this.fallbackQManagerLabel = new JLabel();
        this.fallbackQManagerTextField = new JTextField();
        this.fallbackQManagerTextField.setDocument(new LimitDocument(48));
        this.messageFormatLabel = new JLabel();
        this.messageFormatComboBox = new MQMessageFormatComboBox(this.m_wcontext);
        this.priorityLabel = new JLabel();
        this.priorityComboBox = new MQPriorityComboBox(this.m_wcontext);
        this.persistenceLabel = new JLabel();
        this.persistenceComboBox = new MQPersistenceComboBox(this.m_wcontext);
        this.expiryPanel = new MQExpiryPanel(this.m_wcontext);
        this.segmentationCheckBox = new JCheckBox();
        this.deliveryFailureLabel = new JLabel();
        this.deliveryFailureComboBox = new MQDeliveryFailureComboBox(this.m_wcontext);
        this.msgTypeLabel.setText(StringUtils.stripMnemonic((String)msgTypeText));
        this.msgTypeLabel.setLabelFor(this.msgTypeTextField);
        this.msgTypeTextField.setEditable(false);
        this.msgTypeTextField.setText("REPLY");
        this.fallbackQNameLabel.setText(StringUtils.stripMnemonic((String)fbQNameText));
        this.fallbackQNameLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)fbQNameText));
        this.fallbackQNameLabel.setLabelFor(this.fallbackQNameTextField);
        this.fallbackQNameTextField.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)fbQNameText));
        this.fallbackQNameTextField.setToolTipText(fbQNameTip);
        this.fallbackQManagerLabel.setText(StringUtils.stripMnemonic((String)fbQMgrText));
        this.fallbackQManagerLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)fbQMgrText));
        this.fallbackQManagerLabel.setLabelFor(this.fallbackQManagerTextField);
        this.fallbackQManagerTextField.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)fbQMgrText));
        this.fallbackQManagerTextField.setToolTipText(qMgrTip);
        this.fallbackQManagerTextField.getAccessibleContext().setAccessibleDescription(qMgrTip);
        this.fallbackQManagerTextField.setToolTipText(fbQMgrTip);
        this.messageFormatLabel.setText(StringUtils.stripMnemonic((String)msgFormatText));
        this.messageFormatLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)msgFormatText));
        this.messageFormatLabel.setLabelFor(this.messageFormatComboBox);
        this.messageFormatComboBox.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)msgFormatText));
        this.priorityLabel.setText(StringUtils.stripMnemonic((String)priorityText));
        this.priorityLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)priorityText));
        this.priorityLabel.setLabelFor(this.priorityComboBox);
        this.priorityComboBox.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)priorityText));
        this.persistenceLabel.setText(StringUtils.stripMnemonic((String)persText));
        this.persistenceLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)persText));
        this.persistenceLabel.setLabelFor(this.persistenceComboBox);
        this.persistenceComboBox.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)persText));
        this.segmentationCheckBox.setText(StringUtils.stripMnemonic((String)segmentationText));
        this.segmentationCheckBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)segmentationText));
        this.segmentationCheckBox.getAccessibleContext().setAccessibleName(segmentationText);
        this.segmentationCheckBox.setToolTipText(segmentationTip);
        this.deliveryFailureLabel.setText(StringUtils.stripMnemonic((String)deliveryFailureText));
        this.deliveryFailureLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)deliveryFailureText));
        this.deliveryFailureLabel.setLabelFor(this.deliveryFailureComboBox);
        this.deliveryFailureComboBox.getAccessibleContext().setAccessibleName(deliveryFailureText);
        this.deliveryFailureComboBox.setToolTipText(deliveryFailureTip);
        this.add((Component)this.introLabel, new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 4, 0), 0, 0));
        this.add((Component)this.msgTypeLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.msgTypeTextField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this.fallbackQNameLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.fallbackQNameTextField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 18, 2, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this.fallbackQManagerLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.fallbackQManagerTextField, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 18, 2, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this.messageFormatLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.messageFormatComboBox, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 18, 2, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this.priorityLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.priorityComboBox, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 18, 2, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this.persistenceLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.persistenceComboBox, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 18, 2, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this.deliveryFailureLabel, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 18, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.deliveryFailureComboBox, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 18, 2, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this.segmentationCheckBox, new GridBagConstraints(0, 8, 2, 1, 0.0, 0.0, 18, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.expiryPanel, new GridBagConstraints(0, 9, 2, 1, 0.0, 1.0, 18, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.m_page.setInitialFocus((Component)this.fallbackQNameTextField);
        this.m_page.setCanAdvance(true);
        if (this.m_wcontext._read_service != null) {
            this.initFromWSDL();
        }
    }

    private void initFromWSDL() throws Exception {
        JcaOperation jop = null;
        jop = this.mqContext.serviceType.equals("Synchronous") ? this.m_wcontext._read_jca_operation : this.mqContext.outboundJcaOperation;
        if (jop != null) {
            String fbQName = jop.getAttributeValue("FallbackReplyToQueueName");
            String fbQMgr = jop.getAttributeValue("FallbackReplyToQueueManagerName");
            String msgFormat = jop.getAttributeValue("MessageFormat");
            String priority = jop.getAttributeValue("Priority");
            String persistence = jop.getAttributeValue("Persistence");
            String expiry = jop.getAttributeValue("Expiry");
            String msgType = jop.getAttributeValue("MessageType");
            String segment = jop.getAttributeValue("SegmentIfRequired");
            String deliveryFailure = jop.getAttributeValue("OnDeliveryFailure");
            if (msgType != null) {
                this.msgTypeTextField.setText(msgType);
            }
            if (fbQName != null) {
                this.fallbackQNameTextField.setText(fbQName);
            }
            if (fbQMgr != null) {
                this.fallbackQManagerTextField.setText(fbQMgr);
            }
            if (msgFormat != null) {
                this.messageFormatComboBox.setSelectedItemByValue(msgFormat);
            }
            if (priority != null) {
                this.priorityComboBox.setSelectedItemByValue(priority);
            }
            if (persistence != null) {
                this.persistenceComboBox.setSelectedItemByValue(persistence);
            }
            if (deliveryFailure != null) {
                this.deliveryFailureComboBox.setSelectedItemByValue(deliveryFailure);
            }
            if (segment != null && segment.equalsIgnoreCase("true")) {
                this.segmentationCheckBox.setSelected(true);
            } else {
                this.segmentationCheckBox.setSelected(false);
            }
            if (expiry != null) {
                this.expiryPanel.setExpiry(expiry, this.m_wcontext.TIME_SECONDS);
            }
        }
    }

    public void updatePage(MQAdapterWizardContext mqContext) {
        if (mqContext != null && mqContext.messageType != null) {
            if (mqContext.messageType.equals("NORMAL")) {
                this.msgTypeTextField.setText("REPORT");
                this.fallbackQNameLabel.setVisible(true);
                this.fallbackQNameTextField.setVisible(true);
                this.fallbackQManagerLabel.setVisible(true);
                this.fallbackQManagerTextField.setVisible(true);
            } else if (mqContext.messageType.equals("REQUEST")) {
                this.msgTypeTextField.setText("REPLY");
                this.fallbackQNameLabel.setVisible(false);
                this.fallbackQNameTextField.setVisible(false);
                this.fallbackQManagerLabel.setVisible(false);
                this.fallbackQManagerTextField.setVisible(false);
            }
        }
    }

    @Override
    public void wizardValidatePage(WizardEvent event) {
        this.removePages();
        if (this.mqContext.queueNameHasInvalidChars(this.fallbackQNameTextField.getText()) | this.mqContext.queueNameHasInvalidChars(this.fallbackQManagerTextField.getText())) {
            MultiLineOptionPane.showMessageDialog((Component)this, (Object)this.getTranslatedString("MQ_CM_INVALID_QNAME"), (String)this.getTranslatedString("MQ_CM_ERROR_TITLE"), (int)0);
            ((Cancelable)event).cancel();
        }
        this.mqContext.messageFormat = this.messageFormatComboBox.getSelectedValue();
        if (("CICS Schema".equals(this.mqContext.predefinedSchema) || "IMS Schema".equals(this.mqContext.predefinedSchema)) && ("CICS".equals(this.mqContext.messageFormat) || "IMS".equals(this.mqContext.messageFormat))) {
            this.addFinishPage();
            this.setFinishPage();
            this.noSchemaPage = true;
        } else {
            ImageWizardPage wp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("FA_SC_TITLE"));
            MQAdapterInOutSchemaPage inOutSchemaPage = new MQAdapterInOutSchemaPage(this.m_wcontext, wp);
            this.addFinishPage();
            this.noSchemaPage = false;
        }
    }

    public void setFinishPage() {
        new MQAdapterFinishPanel(this.m_wcontext, this);
    }

    @Override
    public void buildWSDL() throws WSDLException {
        JcaOperation jop = null;
        if (this.mqContext.serviceType.equals("Asynchronous")) {
            jop = this.mqContext.outboundJcaOperation;
            jop.setAttributeValue("InteractionSpec", "oracle.tip.adapter.mq.outbound.InteractionSpecImpl");
            jop.setAttributeValue("MessageType", this.msgTypeTextField.getText());
        } else {
            jop = this.m_wcontext._write_jca_operation;
        }
        if (!this.fallbackQNameTextField.getText().trim().equals("")) {
            jop.setAttributeValue("FallbackReplyToQueueName", this.fallbackQNameTextField.getText());
        }
        if (!this.fallbackQManagerTextField.getText().trim().equals("")) {
            jop.setAttributeValue("FallbackReplyToQueueManagerName", this.fallbackQManagerTextField.getText());
        }
        jop.setAttributeValue("MessageFormat", this.messageFormatComboBox.getSelectedValue());
        jop.setAttributeValue("Priority", this.priorityComboBox.getSelectedValue());
        jop.setAttributeValue("Persistence", this.persistenceComboBox.getSelectedValue());
        jop.setAttributeValue("OnDeliveryFailure", this.deliveryFailureComboBox.getSelectedValue());
        if (this.segmentationCheckBox.isSelected()) {
            jop.setAttributeValue("SegmentIfRequired", "true");
        } else {
            jop.setAttributeValue("SegmentIfRequired", "false");
        }
        jop.setAttributeValue("Expiry", this.expiryPanel.getExpiry());
        if (this.noSchemaPage) {
            if (this.mqContext.serviceType.equals("Synchronous")) {
                this.mqContext.addPredefinedSchemas(false);
            } else {
                this.mqContext.addPredefinedSchemas(true);
            }
        }
    }
}

