/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.mq;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.wsdl.WSDLException;
import oracle.bali.ewt.event.Cancelable;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.bali.share.nls.StringUtils;
import oracle.tip.tools.ide.common.utils.MultiLineOptionPane;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.LimitDocument;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.mq.MQAdapterFinishPanel;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.mq.MQAdapterSchemaPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.mq.MQAdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.mq.MQPredefinedSchemaPanel;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.techAdapterWizardPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.JcaOperation;

public class MQAdapterGetMsgFromMQPage
extends techAdapterWizardPage
implements DocumentListener,
ActionListener {
    private MultiLineLabel introLabel;
    private JLabel qNameLabel;
    private JTextField qNameTextField;
    private MQPredefinedSchemaPanel schemaOptionPanel;
    private MQAdapterWizardContext mqContext;
    private boolean noSchemaPage;
    private JLabel waitIntervalLabel = new JLabel();
    private NumericSpinBox waitNumSpinBox = new NumericSpinBox();
    private JLabel secondsLabel = new JLabel();

    public MQAdapterGetMsgFromMQPage(AdapterWizardContext wcontext, ImageWizardPage iwp) {
        try {
            this.setHelpTopicID("bpmjdev_adp_wiz_mq_get");
            this.setContextAndPage(wcontext, iwp);
            this.mqContext = (MQAdapterWizardContext)this.m_wcontext._ascontext;
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        String introText = this.getTranslatedString("MQ_GM_INTRO_PROMPT");
        String qNameText = this.getTranslatedString("MQ_CM_QUEUE_NAME");
        String waitIntervalText = this.getTranslatedString("MQ_CM_WAIT_INTERVAL");
        String secondsText = this.getTranslatedString("MQ_CM_SECONDS");
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(431, 326));
        this.introLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), introText);
        this.qNameLabel = new JLabel();
        this.qNameTextField = new JTextField();
        this.schemaOptionPanel = new MQPredefinedSchemaPanel(this.mqContext);
        this.qNameLabel.setText(StringUtils.stripMnemonic((String)qNameText));
        this.qNameLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)qNameText));
        this.qNameLabel.setLabelFor(this.qNameTextField);
        LimitDocument limitDoc = new LimitDocument(48);
        this.qNameTextField.setDocument(limitDoc);
        this.qNameTextField.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)qNameText));
        this.qNameTextField.getDocument().addDocumentListener(this);
        this.waitIntervalLabel.setText(waitIntervalText);
        this.secondsLabel.setText(secondsText);
        this.waitNumSpinBox = new NumericSpinBox(1, Integer.MAX_VALUE);
        this.add((Component)this.introLabel, new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.qNameLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.qNameTextField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this.waitIntervalLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.waitNumSpinBox, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this.secondsLabel, new GridBagConstraints(2, 2, 1, 1, 2.0, 0.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.schemaOptionPanel, new GridBagConstraints(0, 3, 0, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)new JLabel(), new GridBagConstraints(0, 4, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.m_page.setInitialFocus((Component)this.qNameTextField);
        this.m_page.setCanAdvance(false);
        if (this.m_wcontext._read_service != null) {
            this.initFromWSDL();
        }
        if (this.m_wcontext._importedWsdlInfo != null) {
            this.schemaOptionPanel.setVisible(false);
        }
        this.updateControls();
    }

    private void initFromWSDL() throws Exception {
        String waitIntervalInMillisec;
        JcaOperation jop = this.m_wcontext._read_jca_operation;
        String qName = jop.getAttributeValue("QueueName");
        this.mqContext.predefinedSchema = this.m_wcontext._read_jca_address.getAttributeValue("UIInPredefinedSchema");
        if (qName != null) {
            this.qNameTextField.setText(qName);
        }
        if (this.mqContext.serviceType != null && this.mqContext.serviceType.equals("Synchronous") && (waitIntervalInMillisec = jop.getAttributeValue("WaitInterval")) != null) {
            this.setWaitIntervalVisible(true);
            this.setWaitInterval(this.convertMillisecondsToSeconds(waitIntervalInMillisec));
        }
        this.schemaOptionPanel.updateControls(this.mqContext);
    }

    private void updateControls() {
        if (this.mqContext.serviceType != null && this.mqContext.serviceType.equals("Synchronous")) {
            this.setWaitIntervalVisible(true);
        } else {
            this.setWaitIntervalVisible(false);
        }
    }

    private void updateNavControls() {
        if (this.qNameTextField.getText() != null && !this.qNameTextField.getText().trim().equals("")) {
            this.m_page.setCanAdvance(true);
        } else {
            this.m_page.setCanAdvance(false);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateNavControls();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateNavControls();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateNavControls();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.updateNavControls();
    }

    @Override
    public void wizardValidatePage(WizardEvent event) {
        this.mqContext = this.schemaOptionPanel.getContext();
        this.removePages();
        if (this.mqContext.queueNameHasInvalidChars(this.qNameTextField.getText())) {
            MultiLineOptionPane.showMessageDialog((Component)this, (Object)this.getTranslatedString("MQ_CM_INVALID_QNAME"), (String)this.getTranslatedString("MQ_CM_ERROR_TITLE"), (int)0);
            ((Cancelable)event).cancel();
        }
        if (this.mqContext.predefinedSchema == null || this.mqContext.predefinedSchema.trim().equals("")) {
            ImageWizardPage tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("FA_SC_TITLE"));
            MQAdapterSchemaPage schemaPage = new MQAdapterSchemaPage(this.m_wcontext, tempwp);
            this.noSchemaPage = false;
        } else {
            this.noSchemaPage = true;
        }
        this.addFinishPage();
        this.setFinishPage();
    }

    public void setFinishPage() {
        new MQAdapterFinishPanel(this.m_wcontext, this);
    }

    private String convertSecondsToMilliseconds(String secondsStr) {
        if (secondsStr == null || secondsStr.trim().equals("")) {
            return null;
        }
        try {
            long seconds = Long.valueOf(secondsStr);
            long milliseconds = seconds * 1000L;
            return String.valueOf(milliseconds);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String convertMillisecondsToSeconds(String millisecondsStr) {
        if (millisecondsStr == null || millisecondsStr.trim().equals("")) {
            return null;
        }
        try {
            long milliseconds = Long.valueOf(millisecondsStr);
            long seconds = milliseconds / 1000L;
            return String.valueOf(seconds);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void buildWSDL() throws WSDLException {
        JcaOperation jop = this.m_wcontext._write_jca_operation;
        if (this.m_wcontext._isInboundOperation) {
            jop.setAttributeValue("ActivationSpec", "oracle.tip.adapter.mq.inbound.ActivationSpecImpl");
        } else if (this.mqContext.serviceType.equals("Synchronous")) {
            jop.setAttributeValue("InteractionSpec", "oracle.tip.adapter.mq.outbound.SyncInteractionSpecImpl");
        } else {
            jop.setAttributeValue("InteractionSpec", "oracle.tip.adapter.mq.outbound.InteractionSpecImpl");
        }
        jop.setAttributeValue("QueueName", this.qNameTextField.getText());
        if (this.mqContext.serviceType != null && this.mqContext.serviceType.equals("Synchronous")) {
            String waitIntervalInSec = this.getWaitTime();
            String waitIntervalInMillisec = this.convertSecondsToMilliseconds(waitIntervalInSec);
            jop.setAttributeValue("WaitInterval", waitIntervalInMillisec);
        }
        if (this.noSchemaPage) {
            this.mqContext.addSinglePredefinedSchema(this.mqContext.predefinedSchema, true, true);
            this.m_wcontext._write_jca_address.setAttributeValue("UIInPredefinedSchema", this.mqContext.predefinedSchema);
        }
    }

    private String getWaitTime() {
        String waitTimeVal = null;
        long waitTimeLongVal = this.getLong(this.waitNumSpinBox.getValue());
        waitTimeVal = String.valueOf(waitTimeLongVal);
        return waitTimeVal;
    }

    private void setWaitInterval(String waitTimeValInSec) {
        int waitIntVal = Integer.valueOf(waitTimeValInSec);
        this.waitNumSpinBox.setIntValue(waitIntVal);
    }

    private void setWaitIntervalVisible(boolean visible) {
        this.waitIntervalLabel.setVisible(visible);
        this.waitNumSpinBox.setVisible(visible);
        this.secondsLabel.setVisible(visible);
    }
}

