/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.mq;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.wsdl.Definition;
import javax.wsdl.PortType;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import oracle.bali.ewt.event.Cancelable;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.model.Project;
import oracle.tip.tools.ide.common.utils.MultiLineOptionPane;
import oracle.tip.tools.ide.fabric.api.WsdlInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.LimitDocument;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.mq.MQAdapterGetMsgResponsePage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.mq.MQAdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.mq.MQMessageTypeComboBox;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.mq.MQPredefinedSchemaPanel;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.techAdapterWizardPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.JcaOperation;

public class MQAdapterGetMsgAndSendReplyPage
extends techAdapterWizardPage
implements DocumentListener {
    private MultiLineLabel introLabel;
    private JLabel qNameLabel;
    private JTextField qNameTextField;
    private JLabel msgTypeLabel;
    private MQMessageTypeComboBox msgTypeComboBox;
    private MQPredefinedSchemaPanel schemaOptionPanel;
    private MQAdapterWizardContext mqContext;

    public MQAdapterGetMsgAndSendReplyPage(AdapterWizardContext wcontext, ImageWizardPage iwp) {
        try {
            this.setHelpTopicID("bpmjdev_adp_wiz_mq_get_send");
            this.setContextAndPage(wcontext, iwp);
            this.mqContext = (MQAdapterWizardContext)this.m_wcontext._ascontext;
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        String introText = this.getTranslatedString("MQ_GS_INTRO_PROMPT");
        String qNameText = this.getTranslatedString("MQ_CM_QUEUE_NAME");
        String msgTypeText = this.getTranslatedString("MQ_CM_MESSAGE_TYPE");
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(431, 326));
        this.introLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), introText);
        this.msgTypeLabel = new JLabel();
        this.msgTypeComboBox = new MQMessageTypeComboBox();
        this.qNameLabel = new JLabel();
        this.qNameTextField = new JTextField();
        this.schemaOptionPanel = new MQPredefinedSchemaPanel(this.mqContext);
        this.qNameLabel.setText(StringUtils.stripMnemonic((String)qNameText));
        this.qNameLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)qNameText));
        this.qNameLabel.setLabelFor(this.qNameTextField);
        LimitDocument limitDoc = new LimitDocument(48);
        this.qNameTextField.setDocument(limitDoc);
        this.qNameTextField.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)qNameText));
        this.qNameTextField.getDocument().addDocumentListener(this);
        this.msgTypeLabel.setText(StringUtils.stripMnemonic((String)msgTypeText));
        this.msgTypeLabel.setLabelFor(this.msgTypeComboBox);
        this.add((Component)this.introLabel, new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 4, 0), 0, 0));
        this.add((Component)this.msgTypeLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.msgTypeComboBox, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this.qNameLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.qNameTextField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 18, 2, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this.schemaOptionPanel, new GridBagConstraints(0, 3, 0, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)new JLabel(), new GridBagConstraints(0, 4, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.m_page.setInitialFocus((Component)this.qNameTextField);
        this.m_page.setCanAdvance(false);
        if (this.m_wcontext._read_service != null) {
            this.initFromWSDL();
        }
        if (this.m_wcontext._importedWsdlInfo != null) {
            this.schemaOptionPanel.setVisible(false);
        }
    }

    private void initFromWSDL() throws Exception {
        JcaOperation jop = null;
        jop = this.mqContext.serviceType.equals("Synchronous") ? this.m_wcontext._read_jca_operation : this.mqContext.inboundJcaOperation;
        if (jop != null) {
            String qName = jop.getAttributeValue("QueueName");
            String msgType = jop.getAttributeValue("MessageType");
            if (msgType != null) {
                this.msgTypeComboBox.setSelectedItemByValue(msgType);
            }
            if (qName != null) {
                this.qNameTextField.setText(qName);
            }
        }
        this.mqContext.predefinedSchema = this.m_wcontext._read_jca_address.getAttributeValue("UIInPredefinedSchema");
        this.schemaOptionPanel.updateControls(this.mqContext);
    }

    private void updateControls() {
        if (this.qNameTextField.getText() != null && !this.qNameTextField.getText().trim().equals("")) {
            this.m_page.setCanAdvance(true);
        } else {
            this.m_page.setCanAdvance(false);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateControls();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateControls();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateControls();
    }

    @Override
    public void wizardValidatePage(WizardEvent event) {
        this.mqContext = this.schemaOptionPanel.getContext();
        this.mqContext.messageType = this.msgTypeComboBox.getSelectedValue();
        if (this.mqContext.queueNameHasInvalidChars(this.qNameTextField.getText())) {
            MultiLineOptionPane.showMessageDialog((Component)this, (Object)this.getTranslatedString("MQ_CM_INVALID_QNAME"), (String)this.getTranslatedString("MQ_CM_ERROR_TITLE"), (int)0);
            ((Cancelable)event).cancel();
        }
        int currentPageIndex = this.m_wizard.getCurrentPageIndex();
        for (int i = currentPageIndex + 1; i < this.m_wizard.getPageCount(); ++i) {
            ImageWizardPage page = (ImageWizardPage)this.m_wizard.getPageAt(i);
            if (!(page.getInteractiveArea() instanceof MQAdapterGetMsgResponsePage)) continue;
            MQAdapterGetMsgResponsePage getMsgResPage = (MQAdapterGetMsgResponsePage)page.getInteractiveArea();
            getMsgResPage.updatePage(this.mqContext);
            break;
        }
    }

    @Override
    public void buildWSDL() throws WSDLException {
        String inboundPortTypeName = null;
        PortType inboundPortType = null;
        String outboundPortTypeName = null;
        PortType outboundPortType = null;
        JcaOperation jop = null;
        Definition def = this.m_wcontext._write_definition;
        if (this.mqContext.serviceType.equals("Asynchronous")) {
            if (this.m_wcontext._importedWsdlInfo != null) {
                inboundPortTypeName = this.m_wcontext._importedWsdlInfo.getRequestPorttype().getLocalPart();
                inboundPortType = WsdlInfo.getPorttypeByQname((Project)this.m_wcontext._project, (QName)this.m_wcontext._importedWsdlInfo.getRequestPorttype());
                outboundPortTypeName = this.m_wcontext._importedWsdlInfo.getReplyPorttype().getLocalPart();
                outboundPortType = WsdlInfo.getPorttypeByQname((Project)this.m_wcontext._project, (QName)this.m_wcontext._importedWsdlInfo.getReplyPorttype());
            } else {
                inboundPortTypeName = "Dequeue" + this.m_wcontext.PortType_suffix;
                inboundPortType = this.createPortType(inboundPortTypeName);
                outboundPortTypeName = "Enqueue" + this.m_wcontext.PortType_suffix;
                outboundPortType = this.createPortType(outboundPortTypeName);
            }
            this.mqContext.createWSDLBindingsForAsyncReqRes(inboundPortType, outboundPortType, this.mqContext.inboundOperationName, this.mqContext.outboundOperationName, "Solicit-response");
            this.createPartnerLinkType(this.mqContext.inboundOperationName, this.mqContext.outboundOperationName, inboundPortType, outboundPortType);
            jop = this.mqContext.inboundJcaOperation;
            jop.setAttributeValue("ActivationSpec", "oracle.tip.adapter.mq.inbound.ActivationSpecImpl");
        } else {
            this.mqContext.serviceType = "Synchronous";
            this.m_wcontext._isInboundOperation = true;
            this.createCommonOperationObjects(this.mqContext.inboundOperationName, "Solicit-response");
            jop = this.m_wcontext._write_jca_operation;
            jop.setAttributeValue("ActivationSpec", "oracle.tip.adapter.mq.inbound.SyncReqResActivationSpecImpl");
        }
        if (jop != null) {
            jop.setAttributeValue("MessageType", this.msgTypeComboBox.getSelectedValue());
            jop.setAttributeValue("QueueName", this.qNameTextField.getText());
        }
        if (this.mqContext.predefinedSchema != null) {
            this.m_wcontext._write_jca_address.setAttributeValue("UIInPredefinedSchema", this.mqContext.predefinedSchema);
        }
    }
}

