/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.mq;

import java.awt.Component;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import javax.xml.namespace.QName;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.jdevimpl.xml.schema.XmlSchemaNode;
import oracle.tip.tools.ide.common.utils.BPELWSDLNode;
import oracle.tip.tools.ide.common.utils.MultiLineOptionPane;
import oracle.tip.tools.ide.fabric.api.PropertyInfo;
import oracle.tip.tools.ide.fabric.api.SCAController;
import oracle.tip.tools.ide.fabric.api.SCAControllerImpl;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardFinishInterface;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.mq.MQAdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.mq.MQConstants;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.mq.PredefinedSchemaInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.WizardWSDLUtil;

public final class MQAdapterFinish
implements AdapterWizardFinishInterface {
    private static final String WSDL_PATH = "/oracle/tip/tools/ide/pm/modules/bizintegration/adapter/mq/";

    @Override
    public boolean beforeWSDL(AdapterWizardContext _wcontext) {
        MQAdapterWizardContext mqContext = (MQAdapterWizardContext)_wcontext._ascontext;
        this.copySchema(_wcontext, mqContext.predefinedSchema);
        if (mqContext.messageFormat != null) {
            String predefSchema = null;
            if (mqContext.messageFormat.equals("CICS")) {
                predefSchema = "CICS Schema";
            } else if (mqContext.messageFormat.equals("IMS")) {
                predefSchema = "IMS Schema";
            }
            if (predefSchema != null) {
                this.copySchema(_wcontext, predefSchema);
            }
        }
        return true;
    }

    @Override
    public void afterWSDL(AdapterWizardContext _wcontext) {
        if (!_wcontext._isInboundOperation) {
            this.updateSCAComposite(_wcontext);
        }
    }

    private void copySchema(AdapterWizardContext wcontext, String predefSchemaKey) {
        MQAdapterWizardContext mqContext = (MQAdapterWizardContext)wcontext._ascontext;
        PredefinedSchemaInfo info = (PredefinedSchemaInfo)mqContext.predefSchemaHash.get(predefSchemaKey);
        if (info != null) {
            String schemaFilename = info.getSchemaFilename();
            String schemaPath = MQConstants.SCHEMA_DIR + schemaFilename;
            this.copyFixedHeaders(wcontext, schemaPath, WSDL_PATH + schemaFilename);
        }
    }

    public void copyFixedHeaders(AdapterWizardContext _wcontext, String headFileName, String inputWSDLPath) {
        String filepath = _wcontext.getFilePath() + "/" + headFileName;
        URL headurl = URLFactory.newURL((String)filepath);
        File fileout = new File(headurl.getFile());
        if (!fileout.exists()) {
            try {
                InputStream inStream = MQAdapterFinish.class.getResourceAsStream(inputWSDLPath);
                WizardWSDLUtil.copyFile(inStream, fileout);
                fileout.setReadOnly();
            }
            catch (Exception ex) {
                MessageFormat msgformat = new MessageFormat(_wcontext._bundle.getString("CM_WZ_HEADER_WRITE_ERROR_MSG"));
                Object[] obj = new Object[]{headFileName, ex.getLocalizedMessage()};
                MultiLineOptionPane.showMessageDialog((Component)_wcontext._finish_page.getInteractiveArea(), (Object)msgformat.format(obj), (String)_wcontext._bundle.getString("CM_WZ_HEADER_WRITE_ERROR_TITLE"), (int)0);
            }
            if (_wcontext._project != null) {
                URL wurl = URLFactory.newFileURL((File)fileout);
                try {
                    Node wnode = null;
                    wnode = headFileName.endsWith("xsd") ? NodeFactory.findOrCreate(XmlSchemaNode.class, (URL)wurl) : NodeFactory.findOrCreate(BPELWSDLNode.class, (URL)wurl);
                    _wcontext._project.add((Element)wnode, true);
                    _wcontext.addURL(wurl);
                }
                catch (Exception except) {
                    except.printStackTrace();
                    MessageFormat msgformat = new MessageFormat(_wcontext._bundle.getString("CM_WZ_PROJECT_FILE_ERROR_MSG"));
                    Object[] obj = new Object[]{headFileName, except.getLocalizedMessage()};
                    MultiLineOptionPane.showMessageDialog((Component)_wcontext._finish_page.getInteractiveArea(), (Object)msgformat.format(obj), (String)_wcontext._bundle.getString("CM_WZ_PROJECT_FILE_ERROR_TITLE"), (int)0);
                }
            }
        }
    }

    public void updateSCAComposite(AdapterWizardContext wcontext) {
        MQAdapterWizardContext mqContext = (MQAdapterWizardContext)wcontext._ascontext;
        SCAController scon = SCAControllerImpl.getController((Project)wcontext._project);
        QName strQName = new QName("http://www.w3.org/2001/XMLSchema", "string");
        QName intQName = new QName("http://www.w3.org/2001/XMLSchema", "int");
        PropertyInfo propInfo = scon.getCompositePropertyInfo(wcontext._composite_service_name, "jca.retry.count");
        if (propInfo == null && mqContext.retryCount > 0) {
            propInfo = new PropertyInfo("jca.retry.count", intQName, false, null, PropertyInfo.OVERRIDE_MAY, null);
        } else {
            scon.deleteCompositeProperty(wcontext._composite_service_name, "jca.retry.count");
        }
        if (mqContext.retryCount > 0) {
            propInfo.setValue(Integer.toString(mqContext.retryCount));
            scon.addCompositeProperty(wcontext._composite_service_name, propInfo);
        }
        if ((propInfo = scon.getCompositePropertyInfo(wcontext._composite_service_name, "jca.retry.interval")) == null && mqContext.retryInterval > 0) {
            propInfo = new PropertyInfo("jca.retry.interval", intQName, false, null, PropertyInfo.OVERRIDE_MAY, null);
        } else {
            scon.deleteCompositeProperty(wcontext._composite_service_name, "jca.retry.interval");
        }
        if (mqContext.retryInterval > 0) {
            propInfo.setValue(Integer.toString(mqContext.retryInterval));
            scon.addCompositeProperty(wcontext._composite_service_name, propInfo);
        }
        if ((propInfo = scon.getCompositePropertyInfo(wcontext._composite_service_name, "jca.retry.backoff")) == null && mqContext.retryBackoff > 0) {
            propInfo = new PropertyInfo("jca.retry.backoff", intQName, false, null, PropertyInfo.OVERRIDE_MAY, null);
        } else {
            scon.deleteCompositeProperty(wcontext._composite_service_name, "jca.retry.backoff");
        }
        if (mqContext.retryBackoff > 0) {
            propInfo.setValue(Integer.toString(mqContext.retryBackoff));
            scon.addCompositeProperty(wcontext._composite_service_name, propInfo);
        }
    }
}

