/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.mq;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.share.nls.StringUtils;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.techAdapterWizardPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.JcaAddress;

public class MQAdapterConnectionPage
extends techAdapterWizardPage
implements DocumentListener {
    private MultiLineLabel introLabel;
    private JLabel mqConnectionLabel = new JLabel();
    private JTextField mqConnectionTextField = new JTextField();

    public MQAdapterConnectionPage(AdapterWizardContext wcontext, ImageWizardPage iwp) {
        try {
            this.setHelpTopicID("bpmjdev_adp_wiz_mq_servconn");
            this.setContextAndPage(wcontext, iwp);
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        String intro = this.getTranslatedString("MQ_CN_INTRO_PROMPT");
        String connectionText = this.getTranslatedString("MQ_CN_NAME_PROMPT");
        String connectionTip = this.getTranslatedString("MQ_CN_NAME_TIP");
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(431, 326));
        this.introLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), intro);
        this.mqConnectionLabel.setText(StringUtils.stripMnemonic((String)connectionText));
        this.mqConnectionLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)connectionText));
        this.mqConnectionLabel.setLabelFor(this.mqConnectionTextField);
        this.mqConnectionTextField.setSize(new Dimension(20, 20));
        this.mqConnectionTextField.setPreferredSize(new Dimension(20, 20));
        this.mqConnectionTextField.setToolTipText(connectionTip);
        this.mqConnectionTextField.getAccessibleContext().setAccessibleDescription(connectionTip);
        this.mqConnectionTextField.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)connectionText));
        this.mqConnectionTextField.setText("eis/" + "MQ" + "/MQSeriesAdapter");
        this.add((Component)this.introLabel, new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.mqConnectionLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.mqConnectionTextField, new GridBagConstraints(1, 1, 2, 1, 0.0, 5.0, 18, 2, new Insets(10, 10, 0, 0), 0, 0));
        this.mqConnectionTextField.getDocument().addDocumentListener(this);
        this.m_page.setInitialFocus((Component)this.mqConnectionTextField);
        this.m_page.setCanAdvance(true);
        if (this.m_wcontext._read_service != null) {
            this.m_page.setCanAdvance(true);
            if (this.m_wcontext._read_jca_address != null) {
                String wsdlMQServiceName = this.m_wcontext._read_jca_address.getAdapterInstanceJndi();
                this.mqConnectionTextField.setText(wsdlMQServiceName);
            }
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.checkDoc(e);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.checkDoc(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.checkDoc(e);
    }

    private void checkDoc(DocumentEvent e) {
        String mqServiceName = this.mqConnectionTextField.getText().trim();
        if (mqServiceName != null && mqServiceName.length() > 0) {
            this.m_page.setCanAdvance(true);
        } else {
            this.m_page.setCanAdvance(false);
        }
    }

    @Override
    public void buildWSDL() throws WSDLException {
        JcaAddress jcaa = (JcaAddress)this.m_wcontext._extReg.createExtension(JcaAddress.PARENT_CLASS, JcaAddress.FIELD_ELEMENT_TYPE);
        this.m_wcontext._write_port.addExtensibilityElement((ExtensibilityElement)jcaa);
        String mqServiceName = this.mqConnectionTextField.getText().trim();
        jcaa.setAdapterInstanceJndi(mqServiceName);
        this.m_wcontext._write_jca_address = jcaa;
    }
}

