/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.mq;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.model.Project;
import oracle.tip.tools.ide.fabric.api.PropertyInfo;
import oracle.tip.tools.ide.fabric.api.SCAController;
import oracle.tip.tools.ide.fabric.api.SCAControllerImpl;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.mq.MQAdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.techAdapterWizardPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.JcaOperation;
import oracle.toplink.workbench.uitools.swing.LabelArea;

public class MQAdapterAdvancedOptionsPage
extends techAdapterWizardPage
implements ActionListener {
    private MultiLineLabel instructionsLabel;
    private JPanel retryPanel;
    private LabelArea retryIntervalLabel;
    private JFormattedTextField retryIntervalField;
    private LabelArea retryCountLabel;
    private JFormattedTextField retryCountField;
    private LabelArea retryBackoffLabel;
    private JFormattedTextField retryBackoffField;
    public static final String JCA_RETRY_INTERVAL_PROP = "jca.retry.interval";
    public static final String JCA_RETRY_COUNT_PROP = "jca.retry.count";
    public static final String JCA_RETRY_BACKOFF_PROP = "jca.retry.backoff";
    private static final int DEFAULT_JCA_RETRY_INT = 1;
    private static final int DEFAULT_JCA_RETRY_CNT = 9;
    private static final int DEFAULT_JCA_RETRY_BCKOFF = 2;
    private MQAdapterWizardContext mqContext = null;

    public MQAdapterAdvancedOptionsPage(AdapterWizardContext context, ImageWizardPage page) {
        this.setHelpTopicID("bpmjdev_mq_advoptions");
        this.setContextAndPage(context, page);
        this.mqContext = (MQAdapterWizardContext)this.m_wcontext._ascontext;
        this.initialize();
    }

    public void initialize() {
        this.setLayout(new GridBagLayout());
        String instructionsText = this.getTranslatedString("DB_AO_INTRO_PROMPT");
        this.instructionsLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), instructionsText);
        boolean numOfPanels = true;
        this.retryPanel = new JPanel(new GridBagLayout());
        this.retryPanel.setBorder(BorderFactory.createTitledBorder(this.getTranslatedString("DB_AO_RETRY")));
        this.initializeRetryPanel(this.retryPanel);
        GridBagConstraints constraints = new GridBagConstraints();
        this.add((Component)this.instructionsLabel, new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.retryPanel, new GridBagConstraints(0, 1, 0, 0, 0.0, 0.0, 18, 0, new Insets(20, 0, 180, 0), 0, 0));
        if (this.m_wcontext._read_service != null) {
            this.initFromWSDL();
        }
    }

    private void initializeRetryPanel(JPanel retryPanel) {
        this.retryCountField = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.retryCountField.setMinimumSize(new Dimension(100, 20));
        this.retryCountField.setValue(9);
        String retryCountLabelString = this.getTranslatedString("DB_AO_RETRY_COUNT");
        this.retryCountLabel = new LabelArea(StringUtils.stripMnemonic((String)retryCountLabelString));
        this.retryCountLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)retryCountLabelString));
        this.retryCountLabel.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)retryCountLabelString));
        this.retryCountLabel.setLabelFor((Component)this.retryCountField);
        this.retryCountLabel.setPreferredWidth(100);
        this.retryIntervalField = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.retryIntervalField.setMinimumSize(new Dimension(100, 20));
        this.retryIntervalField.setValue(1);
        String retryIntervalLabelString = this.getTranslatedString("DB_AO_RETRY_INTERVAL");
        this.retryIntervalLabel = new LabelArea(StringUtils.stripMnemonic((String)retryIntervalLabelString));
        this.retryIntervalLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)retryIntervalLabelString));
        this.retryIntervalLabel.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)retryIntervalLabelString));
        this.retryIntervalLabel.setLabelFor((Component)this.retryIntervalField);
        this.retryIntervalLabel.setPreferredWidth(100);
        this.retryBackoffField = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.retryBackoffField.setMinimumSize(new Dimension(100, 20));
        this.retryBackoffField.setValue(2);
        String retryBackoffLabelString = this.getTranslatedString("DB_AO_RETRY_BACKOFF");
        this.retryBackoffLabel = new LabelArea(StringUtils.stripMnemonic((String)retryBackoffLabelString));
        this.retryBackoffLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)retryBackoffLabelString));
        this.retryBackoffLabel.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)retryBackoffLabelString));
        this.retryBackoffLabel.setLabelFor((Component)this.retryBackoffField);
        this.retryBackoffLabel.setPreferredWidth(100);
        retryPanel.add((Component)this.retryCountLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(12, 12, 0, 12), 0, 0));
        retryPanel.add((Component)this.retryCountField, new GridBagConstraints(1, 0, 1, 1, 10.0, 0.0, 18, 2, new Insets(12, 5, 0, 12), 100, 0));
        retryPanel.add((Component)this.retryIntervalLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(12, 12, 0, 12), 0, 0));
        retryPanel.add((Component)this.retryIntervalField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(12, 5, 0, 12), 0, 0));
        retryPanel.add((Component)this.retryBackoffLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(12, 12, 12, 12), 0, 0));
        retryPanel.add((Component)this.retryBackoffField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 18, 2, new Insets(12, 5, 12, 12), 0, 0));
    }

    private void initFromWSDL() {
        JcaOperation jop = this.m_wcontext._read_jca_operation;
        if (!this.m_wcontext._isInboundOperation) {
            boolean basicPropertiesSet = false;
            SCAController scon = SCAControllerImpl.getController((Project)this.m_wcontext._project);
            PropertyInfo propInfo = scon.getCompositePropertyInfo(this.m_wcontext._composite_service_name, JCA_RETRY_INTERVAL_PROP);
            if (propInfo != null) {
                this.retryIntervalField.setText(propInfo.getValue());
                basicPropertiesSet = true;
            }
            if ((propInfo = scon.getCompositePropertyInfo(this.m_wcontext._composite_service_name, JCA_RETRY_COUNT_PROP)) != null) {
                this.retryCountField.setText(propInfo.getValue());
                basicPropertiesSet = true;
            }
            if ((propInfo = scon.getCompositePropertyInfo(this.m_wcontext._composite_service_name, JCA_RETRY_BACKOFF_PROP)) != null) {
                this.retryBackoffField.setText(propInfo.getValue());
            } else if (basicPropertiesSet) {
                this.retryBackoffField.setText("1");
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.retryBackoffField) {
            // empty if block
        }
    }

    @Override
    public void wizardValidatePage(WizardEvent event) {
        int retryBackOffVal;
        int retryIntervalVal;
        int retryCountVal = Integer.parseInt(this.retryCountField.getText());
        if (retryCountVal > 0) {
            this.mqContext.retryCount = retryCountVal;
        }
        if ((retryIntervalVal = Integer.parseInt(this.retryIntervalField.getText())) > 0) {
            this.mqContext.retryInterval = retryIntervalVal;
        }
        if ((retryBackOffVal = Integer.parseInt(this.retryBackoffField.getText())) > 0) {
            this.mqContext.retryBackoff = retryBackOffVal;
        }
    }
}

