/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.JMX;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.naming.Context;
import javax.naming.InitialContext;
import oracle.jdeveloper.server.connection.AppServer;
import oracle.jdeveloper.server.connection.AppServerManager;
import oracle.rc.asadapter.connection.AppServerConnection;
import oracle.rc.asadapter.connection.ConnectionDescriptor;
import oracle.rc.asadapter.connection.Presentation;
import oracle.rc.asadapter.weblogic.connection.Weblogic10Descriptor;
import oracle.rc.asadapter.weblogic.connection.WeblogicPresentationType;
import oracle.rc.asadapter.weblogic.mbean.WeblogicServerMBeanModel;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JMSDataAccess;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JMSDataAccessBaseImpl;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JMSDestObject;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JMSDestObjectBaseImpl;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JMSParentObject;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.WLSJMSParentObjectImpl;
import weblogic.j2ee.descriptor.wl.DistributedQueueBean;
import weblogic.j2ee.descriptor.wl.DistributedTopicBean;
import weblogic.j2ee.descriptor.wl.JMSBean;
import weblogic.j2ee.descriptor.wl.JMSConnectionFactoryBean;
import weblogic.j2ee.descriptor.wl.QueueBean;
import weblogic.j2ee.descriptor.wl.TopicBean;
import weblogic.j2ee.descriptor.wl.UniformDistributedQueueBean;
import weblogic.j2ee.descriptor.wl.UniformDistributedTopicBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.JMSServerMBean;
import weblogic.management.configuration.JMSSystemResourceMBean;
import weblogic.management.configuration.SystemResourceMBean;
import weblogic.management.mbeanservers.domainruntime.DomainRuntimeServiceMBean;

public class WLSJMSDataAccessImpl
extends JMSDataAccessBaseImpl
implements JMSDataAccess {
    public static final String JMX_PROTOCOL_PROVIDER_PKG = "weblogic.management.remote";
    private static final String DEST_TYPE_QUEUE = "Queue";
    private static final String DEST_TYPE_TOPIC = "Topic";
    private List destList = null;
    protected List supportedQueueCFs = new ArrayList();
    protected List supportedTopicCFs = new ArrayList();
    protected List supportedQueues = new ArrayList();
    protected List supportedTopcs = new ArrayList();

    public WLSJMSDataAccessImpl() {
        this.supportedQueueCFs.add("weblogic.jms.ConnectionFactory");
        this.supportedQueueCFs.add("weblogic.jms.XAConnectionFactory");
    }

    @Override
    public List getJMSDestinations(String destinationType, String destinationName) throws Exception {
        if (destinationName != null && !destinationName.trim().equals("") || destinationType != null && !destinationType.equals("All Types")) {
            if (this.destList == null || this.destList.size() <= 0) {
                this.destList = this.getAllJMSDestinations();
            }
            return this.getJMSDestinations(destinationType, destinationName, this.destList);
        }
        this.destList = this.getAllJMSDestinations();
        return this.destList;
    }

    @Override
    public List getJMSConnectionFactoryLocations(boolean isTopic, String destObj) throws Exception {
        InitialContext jndiCtx = (InitialContext)this.getJMSConnection().getConnection();
        return this.getJMSConnectionFactoryLocations(jndiCtx, null, destObj);
    }

    @Override
    public JMSDestObject getJMSDestination(String fullDestinationName) throws Exception {
        JMSDestObject destObj = null;
        destObj = this.lookupDestination(fullDestinationName);
        return destObj;
    }

    private List getJMSConnectionFactoryLocations(Context jndiCtx, List factoryList, String parentName) throws Exception {
        if (factoryList == null) {
            factoryList = new ArrayList<String>();
        }
        try {
            WeblogicServerMBeanModel model = this.initWLMBeanConnection();
            DomainRuntimeServiceMBean drs = model.getDomainRuntimeService();
            DomainMBean dc = drs.getDomainConfiguration();
            SystemResourceMBean[] sysres = dc.getSystemResources();
            for (int i = 0; i < sysres.length; ++i) {
                if (!sysres[i].getType().equals("JMSSystemResource")) continue;
                JMSSystemResourceMBean jmsSysRes = (JMSSystemResourceMBean)sysres[i];
                JMSBean jmsBean = jmsSysRes.getJMSResource();
                String jmsModule = jmsSysRes.getName();
                if (!parentName.equals(jmsModule)) continue;
                JMSConnectionFactoryBean[] jmsConnFactories = jmsBean.getConnectionFactories();
                for (int j = 0; j < jmsConnFactories.length; ++j) {
                    String jndiName = jmsConnFactories[j].getJNDIName();
                    if (jndiName == null || jndiName.equals("")) continue;
                    factoryList.add(jndiName);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!factoryList.contains(this.supportedQueueCFs)) {
            factoryList.addAll(this.supportedQueueCFs);
        }
        return factoryList;
    }

    private List getAllJMSDestinations() throws Exception {
        ArrayList<WLSJMSParentObjectImpl> destList = new ArrayList<WLSJMSParentObjectImpl>();
        WeblogicServerMBeanModel model = this.initWLMBeanConnection();
        DomainRuntimeServiceMBean drs = model.getDomainRuntimeService();
        DomainMBean dc = drs.getDomainConfiguration();
        JMSServerMBean[] servers = dc.getJMSServers();
        SystemResourceMBean[] sysres = dc.getSystemResources();
        for (int i = 0; i < sysres.length; ++i) {
            if (!sysres[i].getType().equals("JMSSystemResource")) continue;
            JMSSystemResourceMBean jmsSysRes = (JMSSystemResourceMBean)sysres[i];
            String jmsModule = jmsSysRes.getName();
            WLSJMSParentObjectImpl jmsModuleObj = new WLSJMSParentObjectImpl(jmsModule, null, this.getJMSConnection(), this);
            JMSBean jmsBean = jmsSysRes.getJMSResource();
            QueueBean[] queues = jmsBean.getQueues();
            for (int j = 0; j < queues.length; ++j) {
                String qName = queues[j].getName();
                String jndiName = queues[j].getJNDIName();
                JMSDestObjectBaseImpl destObj = new JMSDestObjectBaseImpl(qName, false, jmsModuleObj);
                destObj.setJndiName(jndiName);
                jmsModuleObj.addToChildren(destObj);
            }
            TopicBean[] topics = jmsBean.getTopics();
            for (int j = 0; j < topics.length; ++j) {
                String tName = topics[j].getName();
                String jndiName = topics[j].getJNDIName();
                JMSDestObjectBaseImpl destObj = new JMSDestObjectBaseImpl(tName, true, jmsModuleObj);
                destObj.setJndiName(jndiName);
                jmsModuleObj.addToChildren(destObj);
            }
            DistributedQueueBean[] dqueues = jmsBean.getDistributedQueues();
            for (int j = 0; j < dqueues.length; ++j) {
                String dqName = dqueues[j].getName();
                String jndiName = dqueues[j].getJNDIName();
                JMSDestObjectBaseImpl destObj = new JMSDestObjectBaseImpl(dqName, false, jmsModuleObj);
                destObj.setJndiName(jndiName);
                jmsModuleObj.addToChildren(destObj);
            }
            DistributedTopicBean[] dtopics = jmsBean.getDistributedTopics();
            for (int j = 0; j < dtopics.length; ++j) {
                String dtName = dtopics[j].getName();
                String jndiName = dtopics[j].getJNDIName();
                JMSDestObjectBaseImpl destObj = new JMSDestObjectBaseImpl(dtName, true, jmsModuleObj);
                destObj.setJndiName(jndiName);
                jmsModuleObj.addToChildren(destObj);
            }
            UniformDistributedQueueBean[] uqueues = jmsBean.getUniformDistributedQueues();
            for (int j = 0; j < uqueues.length; ++j) {
                String uqName = uqueues[j].getName();
                String jndiName = uqueues[j].getJNDIName();
                JMSDestObjectBaseImpl destObj = new JMSDestObjectBaseImpl(uqName, false, jmsModuleObj);
                destObj.setJndiName(jndiName);
                jmsModuleObj.addToChildren(destObj);
            }
            UniformDistributedTopicBean[] utopics = jmsBean.getUniformDistributedTopics();
            for (int j = 0; j < utopics.length; ++j) {
                String utName = utopics[j].getName();
                String jndiName = utopics[j].getJNDIName();
                JMSDestObjectBaseImpl destObj = new JMSDestObjectBaseImpl(utName, true, jmsModuleObj);
                destObj.setJndiName(jndiName);
                jmsModuleObj.addToChildren(destObj);
            }
            if (jmsModuleObj.getChildren() == null) continue;
            destList.add(jmsModuleObj);
        }
        return destList;
    }

    private List getJMSDestinations(String type, String name, List destList) throws Exception {
        ArrayList<Object> filteredDestList = null;
        filteredDestList = new ArrayList<Object>();
        if (destList != null) {
            for (int i = 0; i < destList.size(); ++i) {
                WLSJMSParentObjectImpl parentObj;
                List filteredChildrenDestList;
                Object currentObj = destList.get(i);
                if (currentObj instanceof JMSDestObject) {
                    JMSDestObject currentDestObj = (JMSDestObject)currentObj;
                    if (name != null && !name.equals("")) {
                        String searchNameLower;
                        String destNameLower = currentDestObj.getName().toLowerCase();
                        if (destNameLower.startsWith(searchNameLower = name.toLowerCase()) && type.equals("All Types")) {
                            filteredDestList.add(currentDestObj);
                            continue;
                        }
                        if (destNameLower.startsWith(searchNameLower) && type.equals("Queues") && !currentDestObj.isTopic()) {
                            filteredDestList.add(currentDestObj);
                            continue;
                        }
                        if (!destNameLower.startsWith(searchNameLower) || !type.equals("Topics") || !currentDestObj.isTopic()) continue;
                        filteredDestList.add(currentDestObj);
                        continue;
                    }
                    if (type.equals("All Types")) {
                        filteredDestList.add(currentDestObj);
                        continue;
                    }
                    if (type.equals("Queues") && !currentDestObj.isTopic()) {
                        filteredDestList.add(currentDestObj);
                        continue;
                    }
                    if (!type.equals("Topics") || !currentDestObj.isTopic()) continue;
                    filteredDestList.add(currentDestObj);
                    continue;
                }
                if (!(currentObj instanceof JMSParentObject) || (filteredChildrenDestList = this.getJMSDestinations(type, name, (parentObj = (WLSJMSParentObjectImpl)currentObj).getChildren())) == null || filteredChildrenDestList.size() <= 0) continue;
                WLSJMSParentObjectImpl filteredParentObj = new WLSJMSParentObjectImpl(parentObj.getName(), parentObj.getParent(), parentObj.getJMSConnection(), parentObj.getJMSDataAccess());
                filteredParentObj.setChildren(filteredChildrenDestList);
                filteredDestList.add(filteredParentObj);
            }
        }
        return filteredDestList;
    }

    private JMSDestObject formDestinationObject(String fullDestName, boolean isTopic) {
        String DELIMITER = "!";
        JMSDestObjectBaseImpl destObj = null;
        if (fullDestName != null && !fullDestName.trim().equals("")) {
            StringTokenizer tokenizer = new StringTokenizer(fullDestName, DELIMITER);
            int tokenCount = tokenizer.countTokens();
            int i = 0;
            WLSJMSParentObjectImpl parent = null;
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (++i < tokenCount) {
                    WLSJMSParentObjectImpl currParent;
                    parent = currParent = new WLSJMSParentObjectImpl(token, parent, this.getJMSConnection(), this);
                    continue;
                }
                destObj = new JMSDestObjectBaseImpl(token, isTopic, parent);
            }
        }
        return destObj;
    }

    private MBeanServerConnection initWLConnection() {
        Hashtable<String, String> map = new Hashtable<String, String>();
        MBeanServerConnection connection = null;
        JMXConnector connector = null;
        String principal = null;
        String credential = null;
        String jmxprotocol = null;
        String jmxhost = null;
        String jmxport = null;
        try {
            ConnectionDescriptor connDesc = this.getJmsConnDescriptor();
            if (connDesc instanceof Weblogic10Descriptor) {
                Weblogic10Descriptor desc = (Weblogic10Descriptor)connDesc;
                jmxprotocol = "t3";
                jmxhost = desc.getJMXHostname();
                jmxport = desc.getJMXPort();
                principal = desc.getUserName();
                credential = desc.getPassword();
            }
            JMXServiceURL url = new JMXServiceURL(jmxprotocol, jmxhost, Integer.valueOf(jmxport), "/jndi/weblogic.management.mbeanservers.runtime");
            map.put("java.naming.security.principal", principal);
            map.put("java.naming.security.credentials", credential);
            map.put("jmx.remote.protocol.provider.pkgs", JMX_PROTOCOL_PROVIDER_PKG);
            connector = JMXConnectorFactory.connect(url, map);
            connection = connector.getMBeanServerConnection();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return connection;
    }

    private WeblogicServerMBeanModel initWLMBeanConnection() {
        AppServer selAppServ = AppServerManager.getInstance().getAppServer(this.getJmsConnName());
        AppServerConnection conn1 = selAppServ.getConnection();
        Presentation pres = conn1.getPresentation(WeblogicPresentationType.SERVER_MBEAN_MODEL);
        WeblogicServerMBeanModel model = (WeblogicServerMBeanModel)pres.get();
        return model;
    }

    private List updateDestinationList(String fullDestName, boolean isTopic, List destList, WLSJMSParentObjectImpl parent) {
        String DELIMITER = "!";
        JMSDestObjectBaseImpl destObj = null;
        if (fullDestName != null && !fullDestName.trim().equals("")) {
            StringTokenizer tokenizer = new StringTokenizer(fullDestName, DELIMITER);
            int tokenCount = tokenizer.countTokens();
            int i = 0;
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (++i < tokenCount) continue;
                destObj = new JMSDestObjectBaseImpl(token, isTopic, parent);
                if (tokenCount == 1) {
                    destList.add(destObj);
                    continue;
                }
                parent.addToChildren(destObj);
            }
        }
        return destList;
    }

    private WLSJMSParentObjectImpl isObjectInList(WLSJMSParentObjectImpl o, List lst) {
        if (lst != null) {
            for (Object obj : lst) {
                if (!(obj instanceof WLSJMSParentObjectImpl)) continue;
                WLSJMSParentObjectImpl po = (WLSJMSParentObjectImpl)obj;
                if (!o.getName().equals(po.getName())) continue;
                return po;
            }
        }
        return null;
    }

    private String getJNDIForDestination(String destName, boolean isTopic, MBeanServerConnection conn) {
        String jndiName = null;
        try {
            ObjectName drs = new ObjectName("com.bea:Name=DomainRuntimeService,Type=weblogic.management.mbeanservers.domainruntime.DomainRuntimeServiceMBean");
            ObjectName dcfg = (ObjectName)conn.getAttribute(drs, "DomainConfiguration");
            ObjectName[] sysres = (ObjectName[])conn.getAttribute(dcfg, "SystemResources");
            for (int i = 0; i < sysres.length; ++i) {
                ObjectName jmsRes = (ObjectName)conn.getAttribute(sysres[i], "JMSResource");
                JMSBean mbeanJmsProxy = JMX.newMBeanProxy(conn, sysres[i], JMSBean.class, true);
                if (!isTopic) {
                    QueueBean qBean = mbeanJmsProxy.lookupQueue(destName);
                    jndiName = qBean.getJNDIName();
                    continue;
                }
                TopicBean tBean = mbeanJmsProxy.lookupTopic(destName);
                jndiName = tBean.getJNDIName();
            }
        }
        catch (MBeanException e) {
        }
        catch (AttributeNotFoundException e) {
        }
        catch (InstanceNotFoundException e) {
        }
        catch (ReflectionException e) {
        }
        catch (IOException e) {
        }
        catch (MalformedObjectNameException e) {
            // empty catch block
        }
        return jndiName;
    }

    private JMSDestObject lookupDestination(String destName) throws Exception {
        JMSDestObjectBaseImpl destObj = null;
        try {
            WeblogicServerMBeanModel model = this.initWLMBeanConnection();
            DomainRuntimeServiceMBean drs = model.getDomainRuntimeService();
            DomainMBean dc = drs.getDomainConfiguration();
            SystemResourceMBean[] sysres = dc.getSystemResources();
            for (int i = 0; i < sysres.length; ++i) {
                if (!sysres[i].getType().equals("JMSSystemResource")) continue;
                JMSSystemResourceMBean jmsSysRes = (JMSSystemResourceMBean)sysres[i];
                JMSBean jmsBean = jmsSysRes.getJMSResource();
                String jmsModule = jmsSysRes.getName();
                WLSJMSParentObjectImpl jmsModuleObj = new WLSJMSParentObjectImpl(jmsModule, null, this.getJMSConnection(), this);
                QueueBean[] jmsQueues = jmsBean.getQueues();
                for (int j = 0; j < jmsQueues.length; ++j) {
                    String jndiName = jmsQueues[j].getJNDIName();
                    String qName = jmsQueues[j].getName();
                    if (!jndiName.equals(destName) && !qName.equals(destName)) continue;
                    destObj = new JMSDestObjectBaseImpl(qName, false, jmsModuleObj);
                    destObj.setJndiName(jndiName);
                }
                DistributedQueueBean[] jmsdQueues = jmsBean.getDistributedQueues();
                for (int j = 0; j < jmsdQueues.length; ++j) {
                    String jndiName = jmsdQueues[j].getJNDIName();
                    String dqName = jmsdQueues[j].getName();
                    if (!jndiName.equals(destName) && !dqName.equals(destName)) continue;
                    destObj = new JMSDestObjectBaseImpl(dqName, false, jmsModuleObj);
                    destObj.setJndiName(jndiName);
                }
                UniformDistributedQueueBean[] jmsuQueues = jmsBean.getUniformDistributedQueues();
                for (int j = 0; j < jmsuQueues.length; ++j) {
                    String jndiName = jmsuQueues[j].getJNDIName();
                    String uqName = jmsuQueues[j].getName();
                    if (!jndiName.equals(destName) && !uqName.equals(destName)) continue;
                    destObj = new JMSDestObjectBaseImpl(uqName, false, jmsModuleObj);
                    destObj.setJndiName(jndiName);
                }
                TopicBean[] jmsTopics = jmsBean.getTopics();
                for (int j = 0; j < jmsTopics.length; ++j) {
                    String jndiName = jmsTopics[j].getJNDIName();
                    String tName = jmsTopics[j].getName();
                    if (!jndiName.equals(destName) && !tName.equals(destName)) continue;
                    destObj = new JMSDestObjectBaseImpl(tName, true, jmsModuleObj);
                    destObj.setJndiName(jndiName);
                }
                DistributedTopicBean[] jmsdTopics = jmsBean.getDistributedTopics();
                for (int j = 0; j < jmsdTopics.length; ++j) {
                    String jndiName = jmsdTopics[j].getJNDIName();
                    String dtName = jmsdTopics[j].getName();
                    if (!jndiName.equals(destName) && !dtName.equals(destName)) continue;
                    destObj = new JMSDestObjectBaseImpl(dtName, true, jmsModuleObj);
                    destObj.setJndiName(jndiName);
                }
                UniformDistributedTopicBean[] jmsuTopics = jmsBean.getUniformDistributedTopics();
                for (int j = 0; j < jmsuTopics.length; ++j) {
                    String jndiName = jmsuTopics[j].getJNDIName();
                    String utName = jmsuTopics[j].getName();
                    if (!jndiName.equals(destName) && !utName.equals(destName)) continue;
                    destObj = new JMSDestObjectBaseImpl(utName, true, jmsModuleObj);
                    destObj.setJndiName(jndiName);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return destObj;
    }
}

