/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import javax.naming.Context;
import javax.naming.InitialContext;
import oracle.jdeveloper.server.connection.AppServer;
import oracle.jdeveloper.server.connection.AppServerManager;
import oracle.rc.asadapter.connection.AppServerConnection;
import oracle.rc.asadapter.connection.Presentation;
import oracle.rc.asadapter.weblogic.connection.WeblogicPresentationType;
import oracle.rc.asadapter.weblogic.mbean.WeblogicServerMBeanModel;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JMSDataAccess;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JMSDataAccessBaseImpl;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JMSDestObject;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JMSDestObjectBaseImpl;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JMSParentObject;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.OJMSParentObjectImpl;
import weblogic.j2ee.descriptor.wl.ForeignConnectionFactoryBean;
import weblogic.j2ee.descriptor.wl.ForeignDestinationBean;
import weblogic.j2ee.descriptor.wl.ForeignServerBean;
import weblogic.j2ee.descriptor.wl.JMSBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.JMSSystemResourceMBean;
import weblogic.management.configuration.SystemResourceMBean;
import weblogic.management.mbeanservers.domainruntime.DomainRuntimeServiceMBean;

public class OJMSDataAccessImpl
extends JMSDataAccessBaseImpl
implements JMSDataAccess {
    private static final String WILDCARD_CHAR = "%";
    private static final String srchQueueString = "Queues/";
    private static final String srchTopicString = "Topics/";
    private List destList = null;

    @Override
    public List getJMSDestinations(String destinationType, String destinationName) throws Exception {
        if (destinationName != null && !destinationName.trim().equals("") || destinationType != null && !destinationType.equals("All Types")) {
            if (this.destList == null || this.destList.size() <= 0) {
                this.destList = this.getAllAQJMSDestinations();
            }
            return this.getAQJMSDestinations(destinationType, destinationName, this.destList);
        }
        this.destList = this.getAllAQJMSDestinations();
        return this.destList;
    }

    private List getAQJMSDestinations(String type, String name, List destList) throws Exception {
        ArrayList<Object> filteredDestList = null;
        filteredDestList = new ArrayList<Object>();
        for (int i = 0; i < destList.size(); ++i) {
            OJMSParentObjectImpl parentObj;
            List filteredChildrenDestList;
            Object currentObj = destList.get(i);
            if (currentObj instanceof JMSDestObject) {
                JMSDestObject currentDestObj = (JMSDestObject)currentObj;
                if (name != null && !name.equals("")) {
                    String searchNameLower;
                    String destNameLower = currentDestObj.getName().toLowerCase();
                    if (destNameLower.startsWith(searchNameLower = name.toLowerCase()) && type.equals("All Types")) {
                        filteredDestList.add(currentDestObj);
                        continue;
                    }
                    if (destNameLower.startsWith(searchNameLower) && type.equals("Queues") && !currentDestObj.isTopic()) {
                        filteredDestList.add(currentDestObj);
                        continue;
                    }
                    if (!destNameLower.startsWith(searchNameLower) || !type.equals("Topics") || !currentDestObj.isTopic()) continue;
                    filteredDestList.add(currentDestObj);
                    continue;
                }
                if (type.equals("All Types")) {
                    filteredDestList.add(currentDestObj);
                    continue;
                }
                if (type.equals("Queues") && !currentDestObj.isTopic()) {
                    filteredDestList.add(currentDestObj);
                    continue;
                }
                if (!type.equals("Topics") || !currentDestObj.isTopic()) continue;
                filteredDestList.add(currentDestObj);
                continue;
            }
            if (!(currentObj instanceof JMSParentObject) || (filteredChildrenDestList = this.getAQJMSDestinations(type, name, (parentObj = (OJMSParentObjectImpl)currentObj).getChildren())) == null || filteredChildrenDestList.size() <= 0) continue;
            OJMSParentObjectImpl filteredParentObj = new OJMSParentObjectImpl(parentObj.getName(), parentObj.getParent(), parentObj.getJMSConnection(), parentObj.getJMSDataAccess());
            filteredParentObj.setChildren(filteredChildrenDestList);
            filteredDestList.add(filteredParentObj);
        }
        return filteredDestList;
    }

    private List getAllAQJMSDestinations() throws Exception {
        ArrayList<OJMSParentObjectImpl> destList = new ArrayList<OJMSParentObjectImpl>();
        WeblogicServerMBeanModel model = this.initWLMBeanConnection();
        DomainRuntimeServiceMBean drs = model.getDomainRuntimeService();
        DomainMBean dc = drs.getDomainConfiguration();
        SystemResourceMBean[] sysres = dc.getSystemResources();
        for (int i = 0; i < sysres.length; ++i) {
            if (!sysres[i].getType().equals("JMSSystemResource")) continue;
            JMSSystemResourceMBean jmsSysRes = (JMSSystemResourceMBean)sysres[i];
            String jmsModule = jmsSysRes.getName();
            JMSBean jmsBean = jmsSysRes.getJMSResource();
            ForeignServerBean[] foreignServers = jmsBean.getForeignServers();
            if (foreignServers.length <= 0) continue;
            for (int j = 0; j < foreignServers.length; ++j) {
                OJMSParentObjectImpl jmsModuleObj = new OJMSParentObjectImpl(jmsModule, null, this.getJMSConnection(), this);
                String foreignServerName = foreignServers[j].getName();
                OJMSParentObjectImpl serverObj = new OJMSParentObjectImpl(foreignServerName, jmsModuleObj, this.getJMSConnection(), this);
                jmsModuleObj.addToChildren(serverObj);
                ForeignDestinationBean[] foreignDests = foreignServers[j].getForeignDestinations();
                for (int k = 0; k < foreignDests.length; ++k) {
                    String destName = foreignDests[k].getName();
                    String remoteJNDIName = foreignDests[k].getRemoteJNDIName();
                    String localJNDIName = foreignDests[k].getLocalJNDIName();
                    JMSDestObjectBaseImpl destObj = null;
                    destObj = remoteJNDIName.startsWith(srchQueueString) ? new JMSDestObjectBaseImpl(destName, false, serverObj) : (remoteJNDIName.startsWith(srchTopicString) ? new JMSDestObjectBaseImpl(destName, true, serverObj) : new JMSDestObjectBaseImpl(destName, false, serverObj));
                    destObj.setJndiName(localJNDIName);
                    serverObj.addToChildren(destObj);
                }
                if (serverObj.getChildren() == null) continue;
                destList.add(jmsModuleObj);
            }
        }
        return destList;
    }

    private WeblogicServerMBeanModel initWLMBeanConnection() {
        AppServer selAppServ = AppServerManager.getInstance().getAppServer(this.getJmsConnName());
        AppServerConnection conn1 = selAppServ.getConnection();
        Presentation pres = conn1.getPresentation(WeblogicPresentationType.SERVER_MBEAN_MODEL);
        WeblogicServerMBeanModel model = (WeblogicServerMBeanModel)pres.get();
        return model;
    }

    @Override
    public List getJMSConnectionFactoryLocations(boolean isTopic, String destObj) throws Exception {
        InitialContext jndiCtx = (InitialContext)this.getJMSConnection().getConnection();
        return this.getJMSConnectionFactoryLocations(jndiCtx, null, destObj);
    }

    private List getJMSConnectionFactoryLocations(Context jndiCtx, List factoryList, String parentName) throws Exception {
        if (factoryList == null) {
            factoryList = new ArrayList<String>();
        }
        WeblogicServerMBeanModel model = this.initWLMBeanConnection();
        DomainRuntimeServiceMBean drs = model.getDomainRuntimeService();
        DomainMBean dc = drs.getDomainConfiguration();
        SystemResourceMBean[] sysres = dc.getSystemResources();
        for (int i = 0; i < sysres.length; ++i) {
            if (!sysres[i].getType().equals("JMSSystemResource")) continue;
            JMSSystemResourceMBean jmsSysRes = (JMSSystemResourceMBean)sysres[i];
            JMSBean jmsBean = jmsSysRes.getJMSResource();
            ForeignServerBean[] foreignServers = jmsBean.getForeignServers();
            for (int j = 0; j < foreignServers.length; ++j) {
                if (!foreignServers[j].getName().equals(parentName)) continue;
                ForeignConnectionFactoryBean[] foreignCFs = foreignServers[j].getForeignConnectionFactories();
                for (int k = 0; k < foreignCFs.length; ++k) {
                    String cfJNDIName = foreignCFs[k].getLocalJNDIName();
                    factoryList.add(cfJNDIName);
                }
            }
        }
        return factoryList;
    }

    @Override
    public JMSDestObject getJMSDestination(String fullDestinationName) throws Exception {
        JMSDestObject destObj = null;
        destObj = this.lookupDestination(fullDestinationName);
        return destObj;
    }

    private List generateDestinationObjects(ResultSet rs) throws Exception {
        ArrayList<JMSParentObject> destList = null;
        boolean isTopic = false;
        JMSParentObject currentParentObj = null;
        destList = new ArrayList<JMSParentObject>();
        if (rs != null) {
            while (rs.next()) {
                String name = rs.getString("NAME");
                String schema = rs.getString("OWNER");
                String recipients = rs.getString("RECIPIENTS");
                isTopic = recipients != null && recipients.equals("MULTIPLE");
                if (currentParentObj == null || !currentParentObj.getName().equals(schema)) {
                    currentParentObj = new OJMSParentObjectImpl(schema, null, this.getJMSConnection(), this);
                    destList.add(currentParentObj);
                }
                JMSDestObjectBaseImpl destObj = new JMSDestObjectBaseImpl(name, isTopic, currentParentObj);
                ((OJMSParentObjectImpl)currentParentObj).addToChildren(destObj);
            }
        }
        return destList;
    }

    private JMSDestObject lookupDestination(String destName) throws Exception {
        JMSDestObjectBaseImpl destObj = null;
        WeblogicServerMBeanModel model = this.initWLMBeanConnection();
        DomainRuntimeServiceMBean drs = model.getDomainRuntimeService();
        DomainMBean dc = drs.getDomainConfiguration();
        SystemResourceMBean[] sysres = dc.getSystemResources();
        for (int i = 0; i < sysres.length; ++i) {
            if (!sysres[i].getType().equals("JMSSystemResource")) continue;
            JMSSystemResourceMBean jmsSysRes = (JMSSystemResourceMBean)sysres[i];
            JMSBean jmsBean = jmsSysRes.getJMSResource();
            String jmsModule = jmsSysRes.getName();
            ForeignServerBean[] foreignServers = jmsBean.getForeignServers();
            if (foreignServers.length <= 0) continue;
            for (int j = 0; j < foreignServers.length; ++j) {
                OJMSParentObjectImpl jmsModuleObj = new OJMSParentObjectImpl(jmsModule, null, this.getJMSConnection(), this);
                String foreignServerName = foreignServers[j].getName();
                OJMSParentObjectImpl serverObj = new OJMSParentObjectImpl(foreignServerName, jmsModuleObj, this.getJMSConnection(), this);
                jmsModuleObj.addToChildren(serverObj);
                ForeignDestinationBean[] foreignDests = foreignServers[j].getForeignDestinations();
                for (int k = 0; k < foreignDests.length; ++k) {
                    String dest = foreignDests[k].getName();
                    String remoteJndiName = foreignDests[k].getRemoteJNDIName();
                    String localJndiName = foreignDests[k].getLocalJNDIName();
                    if (!localJndiName.equals(destName) && !dest.equals(destName)) continue;
                    destObj = new JMSDestObjectBaseImpl(destName, !remoteJndiName.startsWith(srchQueueString), serverObj);
                    destObj.setJndiName(localJndiName);
                    return destObj;
                }
            }
        }
        return destObj;
    }
}

