/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms;

import java.util.ArrayList;
import java.util.List;
import javax.naming.Context;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JMSConnection;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JMSDataAccess;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JMSDestObjectBaseImpl;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JMSParentObject;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JMSParentObjectBaseImpl;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.OC4JJMSDataAccessImpl;

public class OC4JJMSParentObjectImpl
extends JMSParentObjectBaseImpl
implements JMSParentObject {
    private List children = null;
    private Context jndiCtx = null;

    public OC4JJMSParentObjectImpl(String name, JMSParentObject parent, JMSConnection jmsConn, JMSDataAccess jmsDataAccess) {
        super(name, parent, jmsConn, jmsDataAccess);
    }

    @Override
    public List getChildren() throws Exception {
        OC4JJMSDataAccessImpl dataAccessImpl = (OC4JJMSDataAccessImpl)this.getJMSDataAccess();
        if (this.children != null) {
            return this.children;
        }
        NamingEnumeration<NameClassPair> list = this.jndiCtx.list("");
        while (list.hasMore()) {
            JMSDestObjectBaseImpl destObj;
            NameClassPair nc = list.next();
            String className = nc.getClassName();
            String name = nc.getName();
            if (name == null || name.equals("")) continue;
            if (dataAccessImpl.supportedQueues.contains(className)) {
                destObj = new JMSDestObjectBaseImpl(name, false, this);
                this.addToChildren(destObj);
            } else if (dataAccessImpl.supportedTopcs.contains(className)) {
                destObj = new JMSDestObjectBaseImpl(name, true, this);
                this.addToChildren(destObj);
            }
            if (!className.equals(Context.class.getName())) continue;
            OC4JJMSParentObjectImpl currentObj = new OC4JJMSParentObjectImpl(name, this, this.getJMSConnection(), this.getJMSDataAccess());
            currentObj.setJNDIContext((Context)this.getJNDIContext().lookup(name));
            List children = currentObj.getChildren();
            if (children == null || children.size() <= 0) continue;
            this.addToChildren(currentObj);
        }
        return this.children;
    }

    protected void addToChildren(Object jmsObject) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(jmsObject);
    }

    protected void setChildren(List children) {
        this.children = children;
    }

    protected void setJNDIContext(Context jndiCtx) {
        this.jndiCtx = jndiCtx;
    }

    protected Context getJNDIContext() {
        return this.jndiCtx;
    }

    protected boolean hasDestinationObjects() {
        boolean hasDestinationObjects = false;
        if (this.children != null) {
            for (int i = 0; i < this.children.size(); ++i) {
                Object currentObj = this.children.get(i);
                if (currentObj instanceof JMSDestObjectBaseImpl) {
                    hasDestinationObjects = true;
                    break;
                }
                if (!(currentObj instanceof OC4JJMSParentObjectImpl)) continue;
                OC4JJMSParentObjectImpl parentObj = (OC4JJMSParentObjectImpl)currentObj;
                hasDestinationObjects = parentObj.hasDestinationObjects();
            }
        }
        return hasDestinationObjects;
    }
}

