/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JMSDataAccess;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JMSDataAccessBaseImpl;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JMSDestObject;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JMSDestObjectBaseImpl;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JMSParentObject;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.OC4JJMSParentObjectImpl;

public class OC4JJMSDataAccessImpl
extends JMSDataAccessBaseImpl
implements JMSDataAccess {
    private List destList = null;
    protected List supportedQueueCFs = new ArrayList();
    protected List supportedTopicCFs = new ArrayList();
    protected List supportedQueues = new ArrayList();
    protected List supportedTopcs = new ArrayList();

    public OC4JJMSDataAccessImpl() {
        this.supportedTopcs.add("com.evermind.server.jms.EvermindTopic");
        this.supportedTopcs.add("oracle.j2ee.jms.v1.PermTopic");
        this.supportedQueues.add("com.evermind.server.jms.EvermindQueue");
        this.supportedQueues.add("oracle.j2ee.jms.v1.PermQueue");
        this.supportedTopicCFs.add("com.evermind.server.jms.EvermindTopicConnectionFactory");
        this.supportedTopicCFs.add("com.evermind.server.jms.EvermindXATopicConnectionFactory");
        this.supportedTopicCFs.add("oracle.j2ee.jms.v1.TopicConnectionFactoryImpl");
        this.supportedTopicCFs.add("oracle.j2ee.jms.v1.XATopicConnectionFactoryImpl");
        this.supportedQueueCFs.add("com.evermind.server.jms.EvermindQueueConnectionFactory");
        this.supportedQueueCFs.add("com.evermind.server.jms.EvermindXAQueueConnectionFactory");
        this.supportedQueueCFs.add("oracle.j2ee.jms.v1.QueueConnectionFactoryImpl");
        this.supportedQueueCFs.add("oracle.j2ee.jms.v1.XAQueueConnectionFactoryImpl");
    }

    @Override
    public List getJMSDestinations(String destinationType, String destinationName) throws Exception {
        if (destinationName != null && !destinationName.trim().equals("") || destinationType != null && !destinationType.equals("All Types")) {
            if (this.destList == null || this.destList.size() <= 0) {
                this.destList = this.getAllJMSDestinations();
            }
            return this.getJMSDestinations(destinationType, destinationName, this.destList);
        }
        this.destList = this.getAllJMSDestinations();
        return this.destList;
    }

    @Override
    public List getJMSConnectionFactoryLocations(boolean isTopic, String parent) throws Exception {
        InitialContext jndiCtx = (InitialContext)this.getJMSConnection().getConnection();
        return this.getJMSConnectionFactoryLocations(isTopic, jndiCtx, null, null);
    }

    @Override
    public JMSDestObject getJMSDestination(String fullDestinationName) throws Exception {
        JMSDestObject destObj = null;
        InitialContext ctx = (InitialContext)this.getJMSConnection().getConnection();
        Object obj = ctx.lookup(fullDestinationName);
        if (obj != null) {
            if (obj instanceof Topic) {
                destObj = this.formDestinationObject(fullDestinationName, true);
            } else if (obj instanceof Queue) {
                destObj = this.formDestinationObject(fullDestinationName, false);
            }
        }
        return destObj;
    }

    private List getJMSConnectionFactoryLocations(boolean isTopic, Context jndiCtx, List factoryList, String parentName) throws Exception {
        String thisParentName = parentName;
        if (jndiCtx != null) {
            if (factoryList == null) {
                factoryList = new ArrayList<String>();
            }
            NamingEnumeration<NameClassPair> list = jndiCtx.list("");
            while (list.hasMore()) {
                NameClassPair nc = list.next();
                String className = nc.getClassName();
                String name = nc.getName();
                if (name == null || name.equals("")) continue;
                if (isTopic && this.supportedTopicCFs.contains(className)) {
                    if (thisParentName == null) continue;
                    factoryList.add(thisParentName + "/" + name);
                    continue;
                }
                if (!isTopic && this.supportedQueueCFs.contains(className)) {
                    if (thisParentName == null) continue;
                    factoryList.add(thisParentName + "/" + name);
                    continue;
                }
                if (!className.equals(Context.class.getName())) continue;
                parentName = thisParentName != null ? parentName + "/" + name : name;
                Context currCtx = (Context)jndiCtx.lookup(name);
                factoryList = this.getJMSConnectionFactoryLocations(isTopic, currCtx, factoryList, parentName);
            }
        }
        return factoryList;
    }

    private List getAllJMSDestinations() throws Exception {
        ArrayList<Object> destList = new ArrayList<Object>();
        InitialContext ctx = (InitialContext)this.getJMSConnection().getConnection();
        NamingEnumeration<NameClassPair> list = ctx.list("");
        while (list.hasMore()) {
            JMSDestObjectBaseImpl destObj;
            NameClassPair nc = list.next();
            String className = nc.getClassName();
            String name = nc.getName();
            if (name == null || name.equals("")) continue;
            if (this.supportedQueues.contains(className)) {
                destObj = new JMSDestObjectBaseImpl(name, false, null);
                destList.add(destObj);
            } else if (this.supportedTopcs.contains(className)) {
                destObj = new JMSDestObjectBaseImpl(name, true, null);
                destList.add(destObj);
            }
            if (!className.equals(Context.class.getName())) continue;
            OC4JJMSParentObjectImpl currentParentObj = new OC4JJMSParentObjectImpl(name, null, this.getJMSConnection(), this);
            currentParentObj.setJNDIContext((Context)ctx.lookup(name));
            currentParentObj.getChildren();
            if (!currentParentObj.hasDestinationObjects()) continue;
            destList.add(currentParentObj);
        }
        return destList;
    }

    private List getJMSDestinations(String type, String name, List destList) throws Exception {
        ArrayList<Object> filteredDestList = null;
        filteredDestList = new ArrayList<Object>();
        for (int i = 0; i < destList.size(); ++i) {
            OC4JJMSParentObjectImpl parentObj;
            List filteredChildrenDestList;
            Object currentObj = destList.get(i);
            if (currentObj instanceof JMSDestObject) {
                JMSDestObject currentDestObj = (JMSDestObject)currentObj;
                if (name != null && !name.equals("")) {
                    String searchNameLower;
                    String destNameLower = currentDestObj.getName().toLowerCase();
                    if (destNameLower.startsWith(searchNameLower = name.toLowerCase()) && type.equals("All Types")) {
                        filteredDestList.add(currentDestObj);
                        continue;
                    }
                    if (destNameLower.startsWith(searchNameLower) && type.equals("Queues") && !currentDestObj.isTopic()) {
                        filteredDestList.add(currentDestObj);
                        continue;
                    }
                    if (!destNameLower.startsWith(searchNameLower) || !type.equals("Topics") || !currentDestObj.isTopic()) continue;
                    filteredDestList.add(currentDestObj);
                    continue;
                }
                if (type.equals("All Types")) {
                    filteredDestList.add(currentDestObj);
                    continue;
                }
                if (type.equals("Queues") && !currentDestObj.isTopic()) {
                    filteredDestList.add(currentDestObj);
                    continue;
                }
                if (!type.equals("Topics") || !currentDestObj.isTopic()) continue;
                filteredDestList.add(currentDestObj);
                continue;
            }
            if (!(currentObj instanceof JMSParentObject) || (filteredChildrenDestList = this.getJMSDestinations(type, name, (parentObj = (OC4JJMSParentObjectImpl)currentObj).getChildren())) == null || filteredChildrenDestList.size() <= 0) continue;
            OC4JJMSParentObjectImpl filteredParentObj = new OC4JJMSParentObjectImpl(parentObj.getName(), parentObj.getParent(), parentObj.getJMSConnection(), parentObj.getJMSDataAccess());
            filteredParentObj.setChildren(filteredChildrenDestList);
            filteredDestList.add(filteredParentObj);
        }
        return filteredDestList;
    }

    private JMSDestObject formDestinationObject(String fullDestName, boolean isTopic) {
        String DELIMITER = "/";
        JMSDestObjectBaseImpl destObj = null;
        if (fullDestName != null && !fullDestName.trim().equals("")) {
            StringTokenizer tokenizer = new StringTokenizer(fullDestName, DELIMITER);
            int tokenCount = tokenizer.countTokens();
            int i = 0;
            OC4JJMSParentObjectImpl parent = null;
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (++i < tokenCount) {
                    OC4JJMSParentObjectImpl currParent;
                    parent = currParent = new OC4JJMSParentObjectImpl(token, parent, this.getJMSConnection(), this);
                    continue;
                }
                destObj = new JMSDestObjectBaseImpl(token, isTopic, parent);
            }
        }
        return destObj;
    }
}

