/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.help.HelpSystem;
import oracle.tip.tools.ide.common.utils.MultiLineOptionPane;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AppServerConnectionPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.WsdlSelectionPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JMSContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JmsAdapterConnectionPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JmsAdapterConsumeParamPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JmsAdapterProduceParamPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.techAdapterWizardPage;

public class JmsAdapterProviderPage
extends techAdapterWizardPage
implements ActionListener,
FocusListener {
    private MultiLineLabel introLabel;
    private ButtonGroup providerGroup = new ButtonGroup();
    private JRadioButton oemsRadioButton = new JRadioButton();
    private JRadioButton thirdPartyRadioButton = new JRadioButton();
    private JComboBox oemsTypesComboBox = new JComboBox();

    public JmsAdapterProviderPage(AdapterWizardContext wcontext, ImageWizardPage iwp) {
        try {
            JMSContext jmsCtx = (JMSContext)wcontext._ascontext;
            if (jmsCtx.b2bContext != null) {
                this.setHelpTopicID("b2bjdev_wiz_jms_prov");
            } else {
                this.setHelpTopicID("bpmjdev_adp_wiz_jms_prvdr");
            }
            this.setContextAndPage(wcontext, iwp);
            this.jbInit();
        }
        catch (Exception e) {
            MultiLineOptionPane.showMessageDialog((Component)wcontext._parentFrame, (Object)this.getTranslatedString("JMS_PR_ERROR_MSG"), (String)this.getTranslatedString("JMS_ERROR"), (int)0);
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        String introText = this.getTranslatedString("JMS_PR_SELECT_PROVIDER_PROMPT");
        String oemsText = this.getTranslatedString("JMS_PR_OEMS");
        String thirdPartyText = this.getTranslatedString("JMS_PR_THIRD_PARTY");
        this.introLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), introText);
        this.oemsRadioButton.setText(StringUtils.stripMnemonic((String)oemsText));
        this.oemsRadioButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)oemsText));
        this.oemsRadioButton.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)oemsText));
        this.oemsRadioButton.setSelected(true);
        this.oemsRadioButton.addActionListener(this);
        this.thirdPartyRadioButton.setText(StringUtils.stripMnemonic((String)thirdPartyText));
        this.thirdPartyRadioButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)thirdPartyText));
        this.thirdPartyRadioButton.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)thirdPartyText));
        this.thirdPartyRadioButton.addActionListener(this);
        this.providerGroup.add(this.oemsRadioButton);
        this.providerGroup.add(this.thirdPartyRadioButton);
        this.initOEMSTypesComboBox();
        this.add((Component)this.introLabel, new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.oemsRadioButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.oemsTypesComboBox, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this.thirdPartyRadioButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 2.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.oemsTypesComboBox.addActionListener(this);
        this.oemsTypesComboBox.addFocusListener(this);
        this.m_page.setInitialFocus((Component)this.oemsTypesComboBox);
        this.addFinishPage();
        if (this.m_wcontext._read_service != null) {
            this.initFromWSDL();
        }
    }

    private void initOEMSTypesComboBox() {
        this.oemsTypesComboBox.addItem(new ProviderValue("NOT_SPECIFIED", this.getTranslatedString("CM_CN_NO_SELECTION_ITEM")));
        this.oemsTypesComboBox.addItem(new ProviderValue("WLSJMS", "Oracle Weblogic JMS"));
        this.oemsTypesComboBox.addItem(new ProviderValue("OJMS", "Oracle Advanced Queueing"));
    }

    private void initFromWSDL() {
        JMSContext jmsContext = (JMSContext)this.m_wcontext._ascontext;
        String wsdlJMSProvider = this.m_wcontext._read_jca_address.getAttributeValue("UIJmsProvider");
        if (wsdlJMSProvider != null) {
            jmsContext.jmsProvider = wsdlJMSProvider;
            if (wsdlJMSProvider.equals("THIRDPARTY")) {
                this.thirdPartyRadioButton.setSelected(true);
            } else {
                this.oemsRadioButton.setSelected(true);
                int size = this.oemsTypesComboBox.getItemCount();
                if (size > 0) {
                    for (int i = 0; i < size; ++i) {
                        ProviderValue curItem = (ProviderValue)this.oemsTypesComboBox.getItemAt(i);
                        if (!wsdlJMSProvider.equals(curItem.providerID)) continue;
                        this.oemsTypesComboBox.setSelectedIndex(i);
                    }
                }
            }
        }
    }

    private void updateControls() {
        JMSContext jmsContext = (JMSContext)this.m_wcontext._ascontext;
        if (this.oemsRadioButton.isSelected()) {
            this.oemsTypesComboBox.setEnabled(true);
            ProviderValue providerVal = (ProviderValue)this.oemsTypesComboBox.getSelectedItem();
            if (providerVal != null) {
                if (providerVal.providerID.equals("NOT_SPECIFIED")) {
                    this.m_page.setCanAdvance(false);
                } else {
                    jmsContext.jmsProvider = providerVal.providerID;
                    this.m_page.setCanAdvance(true);
                }
            }
        } else if (this.thirdPartyRadioButton.isSelected()) {
            this.oemsTypesComboBox.setEnabled(false);
            jmsContext.jmsProvider = "THIRDPARTY";
            this.m_page.setCanAdvance(true);
        }
    }

    private void disableAllControls() {
        this.oemsRadioButton.setEnabled(false);
        this.oemsTypesComboBox.setEnabled(false);
        this.thirdPartyRadioButton.setEnabled(false);
    }

    @Override
    public void wizardValidatePage(WizardEvent event) {
        JMSContext jmsContext = (JMSContext)this.m_wcontext._ascontext;
        this.removePages();
        if (jmsContext.jmsProvider.equals("WLSJMS")) {
            this.setPagesForWLSJMS();
        } else if (jmsContext.jmsProvider.equals("OJMS")) {
            this.setPagesForOJMS();
        } else if (jmsContext.jmsProvider.equals("THIRDPARTY")) {
            this.setPagesForThirdPartyJMS();
        }
    }

    private void setPagesForWLSJMS() {
        ImageWizardPage tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("CM_CN_PAGE_TITLE"));
        AppServerConnectionPage ascp = new AppServerConnectionPage(this.m_wcontext, tempwp);
        JMSContext jmsCtx = (JMSContext)this.m_wcontext._ascontext;
        if (jmsCtx.b2bContext != null && !AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)tempwp.getContent(), "b2bjdev_wiz_serv_conn_var1");
        }
        this.addCommonPages();
    }

    private void setPagesForOJMS() {
        ImageWizardPage tempwp = null;
        tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("CM_CN_PAGE_TITLE"));
        AppServerConnectionPage ascp = new AppServerConnectionPage(this.m_wcontext, tempwp);
        ascp.setIntroLabel(this.getTranslatedString("CM_AQJMS_APP_CN_INTRO_PROMPT"));
        this.addCommonPages();
    }

    private void setPagesForThirdPartyJMS() {
        ImageWizardPage tempwp = null;
        tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("JMS_CN_PAGE_TITLE"));
        if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)tempwp.getContent(), "bpmjdev_adp_wiz_jms_conn");
        }
        JmsAdapterConnectionPage cp = new JmsAdapterConnectionPage(this.m_wcontext, tempwp);
        this.addCommonPages();
    }

    private void addCommonPages() {
        JMSContext jmsCtx = (JMSContext)this.m_wcontext._ascontext;
        if (jmsCtx.b2bContext != null) {
            if (jmsCtx.b2bContext.isInbound()) {
                this.setPagesForConsumeOperation();
            } else {
                this.setPagesForProduceOperation();
            }
            return;
        }
        ImageWizardPage wsdlSelectionPage = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("WS_PAGE_TITLE"));
        if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)wsdlSelectionPage.getContent(), "bpmjdev_adp_wiz_interface");
        }
        new WsdlSelectionPage(this.m_wcontext, wsdlSelectionPage);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.updateControls();
    }

    @Override
    public void focusGained(FocusEvent event) {
        this.updateControls();
    }

    @Override
    public void focusLost(FocusEvent event) {
    }

    private void setPagesForProduceOperation() {
        JMSContext jmsCtx = (JMSContext)this.m_wcontext._ascontext;
        ImageWizardPage tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("JMS_PP_TITLE"));
        if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
            if (jmsCtx.b2bContext != null) {
                HelpSystem.getHelpSystem().registerTopic((JComponent)tempwp.getContent(), "b2bjdev_wiz_op_params");
            } else {
                HelpSystem.getHelpSystem().registerTopic((JComponent)tempwp.getContent(), "bpmjdev_adp_wiz_jms_prod");
            }
        }
        JmsAdapterProduceParamPage dsp2 = new JmsAdapterProduceParamPage(this.m_wcontext, tempwp);
        tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("JMS_SC_TITLE"));
        this.addFinishPage();
        if (jmsCtx.b2bContext != null && !AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)this.m_wcontext._finish_page.getContent(), "b2bjdev_wiz_fin");
        }
    }

    private void setPagesForConsumeOperation() {
        JMSContext jmsCtx = (JMSContext)this.m_wcontext._ascontext;
        ImageWizardPage tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("JMS_CP_TITLE"));
        if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
            if (jmsCtx.b2bContext != null) {
                HelpSystem.getHelpSystem().registerTopic((JComponent)tempwp.getContent(), "b2bjdev_wiz_cons_params");
            } else {
                HelpSystem.getHelpSystem().registerTopic((JComponent)tempwp.getContent(), "bpmjdev_adp_wiz_jms_cons");
            }
        }
        JmsAdapterConsumeParamPage dsp2 = new JmsAdapterConsumeParamPage(this.m_wcontext, tempwp);
        tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("JMS_SC_TITLE"));
        this.addFinishPage();
        if (jmsCtx.b2bContext != null && !AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)this.m_wcontext._finish_page.getContent(), "b2bjdev_wiz_fin");
        }
    }

    private class ProviderValue {
        String providerID;
        String providerDisplayName;

        public ProviderValue(String providerID, String providerDisplayName) {
            this.providerID = providerID;
            this.providerDisplayName = providerDisplayName;
        }

        public String toString() {
            return this.providerDisplayName;
        }
    }
}

