/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Project;
import oracle.tip.tools.ide.common.ui.NCNameField;
import oracle.tip.tools.ide.fabric.api.WsdlInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JMSContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JmsAdapterConsumeParamPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JmsAdapterInOutSchemaPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JmsAdapterProduceParamPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JmsAdapterReqReplyParamPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JmsAdapterSchemaPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.techAdapterWizardPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.JcaBinding;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.JcaOperation;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.PCInboundBinding;

public class JmsAdapterOperationPage
extends techAdapterWizardPage
implements ActionListener,
DocumentListener {
    ButtonGroup group = new ButtonGroup();
    private MultiLineLabel introPrompt;
    private JLabel operationTypePrompt = new JLabel();
    private JRadioButton consumeRB = new JRadioButton();
    private JRadioButton produceRB = new JRadioButton();
    private JRadioButton reqrespRB = new JRadioButton();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JLabel operationNamePrompt = new JLabel();
    private NCNameField operationName = new NCNameField();
    private JPanel syncAsyncPanel = new JPanel();
    private ButtonGroup syncAsyncGroup = new ButtonGroup();
    private JRadioButton syncRadioButton = new JRadioButton();
    private JRadioButton asyncRadioButton = new JRadioButton();
    private NCNameField reqOpNameTextField = new NCNameField();
    private NCNameField repOpNameTextField = new NCNameField();
    private JLabel reqOpNameLabel = new JLabel();
    private JLabel repOpNameLabel = new JLabel();
    private JMSContext jmsContext;

    public JmsAdapterOperationPage(AdapterWizardContext wcontext, ImageWizardPage iwp) {
        try {
            this.setContextAndPage(wcontext, iwp);
            this.jmsContext = (JMSContext)this.m_wcontext._ascontext;
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        String intro = this.getTranslatedString("JMS_OP_INTRO_PROMPT");
        String opprompt = this.getTranslatedString("JMS_OP_TYPE_PROMPT");
        String consumeRBtext = this.getTranslatedString("JMS_OP_CONSUME_PROMPT");
        String consumeTip = this.getTranslatedString("JMS_OP_CONSUME_TIP");
        String produceRBtext = this.getTranslatedString("JMS_OP_PRODUCE_PROMPT");
        String produceTip = this.getTranslatedString("JMS_OP_PRODUCE_TIP");
        String reqrspRBtext = this.getTranslatedString("JMS_OP_REQRSP_PROMPT");
        String reqrspTip = this.getTranslatedString("JMS_OP_REQRSP_TIP");
        String opname = this.getTranslatedString("JMS_OP_NAME_PROMPT");
        String opnameTip = this.getTranslatedString("JMS_OP_NAME_TIP");
        String repOpNameText = this.getTranslatedString("JMS_OP_REP_PROMPT");
        String reqOpNameText = this.getTranslatedString("JMS_OP_REQ_PROMPT");
        String opNameStrippedText = StringUtils.stripMnemonic((String)opname);
        String repOpNameStrippedText = StringUtils.stripMnemonic((String)repOpNameText);
        String reqOpNameStrippedText = StringUtils.stripMnemonic((String)reqOpNameText);
        String syncText = this.getTranslatedString("JMS_OP_SYNC");
        String asyncText = this.getTranslatedString("JMS_OP_ASYNC");
        this.setLayout(this.gridBagLayout1);
        this.introPrompt = new MultiLineLabel(WordWrapper.getTextWrapper(), intro);
        this.operationTypePrompt.setText(opprompt);
        this.operationTypePrompt.setLabelFor(this.consumeRB);
        this.consumeRB.setText(StringUtils.stripMnemonic((String)consumeRBtext));
        this.consumeRB.setMnemonic(StringUtils.getMnemonicKeyCode((String)consumeRBtext));
        this.consumeRB.setToolTipText(consumeTip);
        this.consumeRB.getAccessibleContext().setAccessibleDescription(consumeTip);
        this.consumeRB.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)consumeRBtext));
        this.produceRB.setText(StringUtils.stripMnemonic((String)produceRBtext));
        this.produceRB.setMnemonic(StringUtils.getMnemonicKeyCode((String)produceRBtext));
        this.produceRB.setToolTipText(produceTip);
        this.produceRB.getAccessibleContext().setAccessibleDescription(produceTip);
        this.produceRB.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)produceRBtext));
        this.reqrespRB.setText(StringUtils.stripMnemonic((String)reqrspRBtext));
        this.reqrespRB.setMnemonic(StringUtils.getMnemonicKeyCode((String)reqrspRBtext));
        this.reqrespRB.setToolTipText(reqrspTip);
        this.reqrespRB.getAccessibleContext().setAccessibleDescription(reqrspTip);
        this.reqrespRB.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)reqrspRBtext));
        this.operationNamePrompt.setText(StringUtils.stripMnemonic((String)opname));
        this.operationNamePrompt.setLabelFor((Component)this.operationName);
        this.operationNamePrompt.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)opname));
        this.operationName.setToolTipText(opnameTip);
        this.operationName.getAccessibleContext().setAccessibleDescription(opnameTip);
        this.operationName.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)opname));
        this.operationName.getDocument().addDocumentListener(this);
        this.repOpNameLabel.setText(repOpNameStrippedText);
        this.repOpNameLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)repOpNameText));
        this.repOpNameLabel.setLabelFor((Component)this.repOpNameTextField);
        this.repOpNameTextField.setText("Reply");
        this.repOpNameTextField.getDocument().addDocumentListener(this);
        this.reqOpNameLabel.setText(reqOpNameStrippedText);
        this.reqOpNameLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)reqOpNameText));
        this.reqOpNameLabel.setLabelFor((Component)this.reqOpNameTextField);
        this.reqOpNameTextField.setText("Request");
        this.reqOpNameTextField.getDocument().addDocumentListener(this);
        Border bd = BorderFactory.createLineBorder(Color.GRAY);
        this.syncAsyncPanel.setLayout(new GridBagLayout());
        this.syncAsyncPanel.setBorder(BorderFactory.createTitledBorder(bd, opNameStrippedText));
        this.syncRadioButton.setText(StringUtils.stripMnemonic((String)syncText));
        this.syncRadioButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)syncText));
        this.asyncRadioButton.setText(StringUtils.stripMnemonic((String)asyncText));
        this.asyncRadioButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)asyncText));
        this.syncAsyncGroup.add(this.syncRadioButton);
        this.syncAsyncGroup.add(this.asyncRadioButton);
        this.syncRadioButton.addActionListener(this);
        this.asyncRadioButton.addActionListener(this);
        this.asyncRadioButton.setSelected(true);
        this.buildSyncAsyncPanel();
        this.syncAsyncPanel.setVisible(false);
        this.add((Component)this.produceRB, new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 12, 0, 0), 0, 0));
        this.add((Component)this.consumeRB, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 16, 0, new Insets(0, 12, 0, 0), 0, 0));
        this.add((Component)this.reqrespRB, new GridBagConstraints(3, 5, 1, 1, 0.0, 0.0, 16, 0, new Insets(0, 12, 0, 0), 0, 0));
        this.add((Component)this.operationTypePrompt, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 0, 5, 0), 0, 0));
        this.add((Component)this.introPrompt, new GridBagConstraints(1, 0, 0, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.operationNamePrompt, new GridBagConstraints(1, 6, 1, 1, 0.0, 1.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.operationName, new GridBagConstraints(3, 6, 0, 1, 1.0, 0.0, 18, 2, new Insets(10, 12, 0, 0), 0, 0));
        this.add((Component)this.syncAsyncPanel, new GridBagConstraints(1, 7, 0, 1, 0.0, 4.0, 18, 2, new Insets(20, 0, 0, 0), 0, 0));
        this.group.add(this.consumeRB);
        this.group.add(this.produceRB);
        this.group.add(this.reqrespRB);
        this.consumeRB.addActionListener(this);
        this.produceRB.addActionListener(this);
        this.reqrespRB.addActionListener(this);
        this.operationName.setText(null);
        this.m_page.setInitialFocus((Component)this.consumeRB);
        this.m_page.setCanAdvance(false);
        if (this.m_wcontext._read_service != null) {
            this.m_page.setCanAdvance(true);
            String operType = this.getUITransmissionPrimitiveFromWSDL();
            if (operType != null) {
                this.reqrespRB.setSelected(true);
                this.jmsContext.isRequestReply = true;
                String UiOperationMode = this.m_wcontext._read_jca_address.getAttributeValue("UiOperationMode");
                if (UiOperationMode != null) {
                    if (UiOperationMode.equals("Synchronous")) {
                        this.jmsContext.IsSyncOperation = true;
                        this.syncRadioButton.setSelected(true);
                    } else {
                        this.jmsContext.IsSyncOperation = false;
                        this.asyncRadioButton.setSelected(true);
                        this.initFromWSDLMultiOp();
                    }
                    this.displaySyncAsyncOperations();
                    this.setPagesForReqReplyOperation();
                }
            } else if (this.m_wcontext._isInboundOperation) {
                this.consumeRB.setSelected(true);
                this.operationName.setText(this.m_wcontext._read_operation_name);
                this.setPagesForconsumeOperation();
            } else {
                this.produceRB.setSelected(true);
                this.operationName.setText(this.m_wcontext._read_operation_name);
                this.setPagesForproduceOperation();
            }
            this.disableAllControls();
        }
        if (this.m_wcontext._importedWsdlInfo != null) {
            this.setOperationTypeForExistingWSDL();
        }
    }

    private void setOperationTypeForExistingWSDL() {
        if (this.m_wcontext._importedWsdlInfo.getReplyPorttype() != null) {
            this.reqrespRB.setSelected(true);
            this.consumeRB.setEnabled(false);
            this.produceRB.setEnabled(false);
            this.jmsContext.selectedDestinationObject = null;
            this.m_wcontext._isInboundOperation = false;
            this.jmsContext.isRequestReply = true;
            this.jmsContext.IsSyncOperation = false;
            this.asyncRadioButton.setSelected(true);
            this.reqOpNameTextField.setText(this.m_wcontext._write_operation_name);
            this.repOpNameTextField.setText(this.m_wcontext._write_operation2_name);
            this.displaySyncAsyncOperations();
            this.setPagesForReqReplyOperation();
            this.m_page.setCanAdvance(true);
        } else {
            this.operationName.setText(this.m_wcontext._write_operation_name);
            this.operationName.setEditable(false);
            if (this.m_wcontext._isOutboundRead) {
                this.reqrespRB.setSelected(true);
                this.consumeRB.setEnabled(false);
                this.produceRB.setEnabled(false);
                this.jmsContext.selectedDestinationObject = null;
                this.m_wcontext._isInboundOperation = false;
                this.jmsContext.isRequestReply = true;
                this.jmsContext.IsSyncOperation = true;
                this.syncRadioButton.setSelected(true);
                this.displaySyncAsyncOperations();
                this.setPagesForReqReplyOperation();
                this.m_page.setCanAdvance(true);
            } else {
                this.reqrespRB.setEnabled(false);
                this.consumeRB.setEnabled(true);
                this.produceRB.setEnabled(true);
            }
        }
    }

    private String getUITransmissionPrimitiveFromWSDL() {
        String uiTransmissionPrimitive = null;
        Definition def = this.m_wcontext._read_definition;
        Map bindings = def.getBindings();
        for (Binding bind : bindings.values()) {
            List bext = bind.getExtensibilityElements();
            for (Object ext : bext) {
                if (ext instanceof JcaBinding) {
                    JcaBinding jbind = (JcaBinding)ext;
                    uiTransmissionPrimitive = jbind.getAttributeValue("UITransmissionPrimitive");
                } else if (ext instanceof PCInboundBinding) {
                    PCInboundBinding pcbind = (PCInboundBinding)ext;
                    uiTransmissionPrimitive = pcbind.getAttributeValue("UITransmissionPrimitive");
                }
                if (uiTransmissionPrimitive == null || uiTransmissionPrimitive.trim().equals("")) continue;
                return uiTransmissionPrimitive;
            }
        }
        return uiTransmissionPrimitive;
    }

    public void initFromWSDLMultiOp() throws WSDLException {
        if (this.m_wcontext._update_wsdl_path != null) {
            Definition def = this.m_wcontext._read_definition;
            Map services = def.getServices();
            if (services == null || services.size() == 0) {
                throw new WSDLException("INVALID_WSDL", this.m_wcontext._bundle.getString("CM_WZ_WSDL_NO_SERVICE_ERROR"));
            }
            Map bindings = this.m_wcontext._read_definition.getBindings();
            Iterator bindingI = bindings.values().iterator();
            Operation currentOp = null;
            while (bindingI.hasNext()) {
                boolean isInbound;
                Binding bind = (Binding)bindingI.next();
                List boperations = bind.getBindingOperations();
                Iterator boperI = boperations.iterator();
                if (!boperI.hasNext()) continue;
                BindingOperation bop = (BindingOperation)boperI.next();
                currentOp = bop.getOperation();
                List extElements = bind.getExtensibilityElements();
                if (extElements.size() > 0 && extElements.get(0) instanceof PCInboundBinding) {
                    this.jmsContext.inboundOperation = currentOp;
                    this.repOpNameTextField.setText(this.jmsContext.inboundOperation.getName());
                    isInbound = true;
                } else {
                    this.jmsContext.outboundOperation = currentOp;
                    this.reqOpNameTextField.setText(this.jmsContext.outboundOperation.getName());
                    isInbound = false;
                }
                List bextElements = bop.getExtensibilityElements();
                for (Object obj : bextElements) {
                    if (!(obj instanceof JcaOperation)) continue;
                    if (isInbound) {
                        this.jmsContext.inboundJcaOperation = (JcaOperation)obj;
                        continue;
                    }
                    this.jmsContext.outboundJcaOperation = (JcaOperation)obj;
                }
            }
            if (this.jmsContext.inboundOperation != null && this.jmsContext.outboundOperation != null) {
                this.m_wcontext._isInboundOperation = false;
            }
        }
    }

    private void buildSyncAsyncPanel() {
        this.syncAsyncPanel.add((Component)this.asyncRadioButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.syncAsyncPanel.add((Component)this.syncRadioButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.syncAsyncPanel.add((Component)this.reqOpNameLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 10, 0), 0, 0));
        this.syncAsyncPanel.add((Component)this.reqOpNameTextField, new GridBagConstraints(1, 2, 1, 1, 4.0, 0.0, 18, 2, new Insets(10, 10, 10, 0), 0, 0));
        this.syncAsyncPanel.add((Component)this.repOpNameLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.syncAsyncPanel.add((Component)this.repOpNameTextField, new GridBagConstraints(1, 3, 1, 1, 4.0, 0.0, 18, 2, new Insets(0, 10, 0, 0), 0, 0));
    }

    private void disableAllControls() {
        this.consumeRB.setEnabled(false);
        this.produceRB.setEnabled(false);
        this.reqrespRB.setEnabled(false);
        this.operationName.setEditable(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String tempOpName = this.operationName.getText().trim();
        this.removePages();
        this.m_page.setCanAdvance(true);
        if (e.getSource() == this.consumeRB) {
            this.jmsContext.selectedDestinationObject = null;
            this.m_wcontext._isInboundOperation = true;
            this.jmsContext.isRequestReply = false;
            if (this.m_wcontext._importedWsdlInfo == null) {
                this.operationName.setText(this.getTranslatedString("JMS_OP_NAME_CONSUME_SUFFIX"));
            }
            this.displaySingleOperation();
            this.setPagesForconsumeOperation();
        } else if (e.getSource() == this.produceRB) {
            this.jmsContext.selectedDestinationObject = null;
            this.m_wcontext._isInboundOperation = false;
            this.jmsContext.isRequestReply = false;
            if (this.m_wcontext._importedWsdlInfo == null) {
                this.operationName.setText(this.getTranslatedString("JMS_OP_NAME_PRODUCE_SUFFIX"));
            }
            this.displaySingleOperation();
            this.setPagesForproduceOperation();
        } else {
            this.jmsContext.selectedDestinationObject = null;
            this.m_wcontext._isInboundOperation = false;
            this.jmsContext.isRequestReply = true;
            this.displaySyncAsyncOperations();
            this.setPagesForReqReplyOperation();
        }
    }

    private void displaySingleOperation() {
        this.syncAsyncPanel.setVisible(false);
        this.operationNamePrompt.setVisible(true);
        this.operationName.setVisible(true);
    }

    private void displaySyncAsyncOperations() {
        JMSContext jmsContext = (JMSContext)this.m_wcontext._ascontext;
        String reqrepText = this.getTranslatedString("JMS_OP_NAME_REQREPLY_SUFFIX");
        this.syncAsyncPanel.setVisible(true);
        this.operationNamePrompt.setVisible(false);
        this.operationName.setVisible(false);
        if (this.syncRadioButton.isSelected()) {
            this.reqOpNameTextField.setText(reqrepText);
            if (this.m_wcontext._read_service != null) {
                this.reqOpNameTextField.setText(this.m_wcontext._write_operation_name);
            }
            if (this.m_wcontext._importedWsdlInfo != null) {
                this.reqOpNameTextField.setText(this.m_wcontext._write_operation_name);
            }
            this.reqOpNameLabel.setText(StringUtils.stripMnemonic((String)this.getTranslatedString("JMS_OP_NAME_PROMPT")));
            this.repOpNameLabel.setVisible(false);
            this.repOpNameTextField.setVisible(false);
            this.reqOpNameLabel.setVisible(true);
            this.reqOpNameTextField.setVisible(true);
            jmsContext.IsSyncOperation = true;
        } else if (this.asyncRadioButton.isSelected()) {
            this.reqOpNameTextField.setText("Request");
            this.repOpNameTextField.setText("Reply");
            if (this.m_wcontext._read_service != null) {
                this.reqOpNameTextField.setText(this.m_wcontext._write_operation_name);
                this.repOpNameTextField.setText(this.m_wcontext._write_operation2_name);
            }
            if (this.m_wcontext._importedWsdlInfo != null) {
                this.reqOpNameTextField.setText(this.m_wcontext._write_operation_name);
                this.repOpNameTextField.setText(this.m_wcontext._write_operation2_name);
            }
            this.repOpNameLabel.setText(StringUtils.stripMnemonic((String)this.getTranslatedString("JMS_OP_REP_PROMPT")));
            this.reqOpNameLabel.setText(StringUtils.stripMnemonic((String)this.getTranslatedString("JMS_OP_REQ_PROMPT")));
            this.reqOpNameLabel.setVisible(true);
            this.reqOpNameTextField.setVisible(true);
            this.repOpNameLabel.setVisible(true);
            this.repOpNameTextField.setVisible(true);
            jmsContext.IsSyncOperation = false;
        }
    }

    private void setPagesForconsumeOperation() {
        ImageWizardPage tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("JMS_CP_TITLE"));
        if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)tempwp.getContent(), "bpmjdev_adp_wiz_jms_cons");
        }
        JmsAdapterConsumeParamPage dsp2 = new JmsAdapterConsumeParamPage(this.m_wcontext, tempwp);
        tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("JMS_SC_TITLE"));
        if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)tempwp.getContent(), "bpmjdev_adp_wiz_message");
        }
        JmsAdapterSchemaPage dsp3 = new JmsAdapterSchemaPage(this.m_wcontext, tempwp);
        this.addFinishPage();
    }

    private void setPagesForproduceOperation() {
        ImageWizardPage tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("JMS_PP_TITLE"));
        if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)tempwp.getContent(), "bpmjdev_adp_wiz_jms_prod");
        }
        JmsAdapterProduceParamPage dsp2 = new JmsAdapterProduceParamPage(this.m_wcontext, tempwp);
        tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("JMS_SC_TITLE"));
        if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)tempwp.getContent(), "bpmjdev_adp_wiz_message");
        }
        JmsAdapterSchemaPage dsp3 = new JmsAdapterSchemaPage(this.m_wcontext, tempwp);
        this.addFinishPage();
    }

    private void setPagesForReqReplyOperation() {
        techAdapterWizardPage dsp2;
        ImageWizardPage tempwp = null;
        if (this.jmsContext.IsSyncOperation) {
            tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("JMS_RR_TITLE"));
            if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
                HelpSystem.getHelpSystem().registerTopic((JComponent)tempwp.getContent(), "bpmjdev_adp_wiz_jms_reqrep");
            }
            dsp2 = new JmsAdapterReqReplyParamPage(this.m_wcontext, tempwp);
            tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("JMS_SC_TITLE"));
        } else {
            tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("JMS_REQ_TITLE"));
            if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
                HelpSystem.getHelpSystem().registerTopic((JComponent)tempwp.getContent(), "bpmjdev_adp_wiz_jms_req");
            }
            dsp2 = new JmsAdapterProduceParamPage(this.m_wcontext, tempwp);
            tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("JMS_REP_TITLE"));
            if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
                HelpSystem.getHelpSystem().registerTopic((JComponent)tempwp.getContent(), "bpmjdev_adp_wiz_jms_rep");
            }
            JmsAdapterConsumeParamPage jmsAdapterConsumeParamPage = new JmsAdapterConsumeParamPage(this.m_wcontext, tempwp);
        }
        tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("JMS_SC_TITLE"));
        if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)tempwp.getContent(), "bpmjdev_adp_wiz_jms_message");
        }
        JmsAdapterInOutSchemaPage dsp3 = new JmsAdapterInOutSchemaPage(this.m_wcontext, tempwp);
        this.addFinishPage();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.checkDoc(e);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.checkDoc(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.checkDoc(e);
    }

    private void checkDoc(DocumentEvent e) {
        if (this.consumeRB.isSelected() || this.produceRB.isSelected()) {
            String opNameStr = this.operationName.getText().trim();
            if (opNameStr != null && opNameStr.length() > 0) {
                this.m_page.setCanAdvance(true);
            } else {
                this.m_page.setCanAdvance(false);
            }
        } else if (this.reqrespRB.isSelected()) {
            if (this.syncRadioButton.isSelected()) {
                String opNameStr = this.reqOpNameTextField.getText().trim();
                if (opNameStr != null && opNameStr.length() > 0) {
                    this.m_page.setCanAdvance(true);
                } else {
                    this.m_page.setCanAdvance(false);
                }
            }
            if (this.asyncRadioButton.isSelected()) {
                String reqOpNameStr = this.reqOpNameTextField.getText().trim();
                String repOpNameStr = this.repOpNameTextField.getText().trim();
                if (reqOpNameStr != null && reqOpNameStr.length() > 0 && repOpNameStr != null && repOpNameStr.length() > 0) {
                    this.m_page.setCanAdvance(true);
                } else {
                    this.m_page.setCanAdvance(false);
                }
            }
        }
    }

    @Override
    public void buildWSDL() throws WSDLException {
        JMSContext jmsContext = (JMSContext)this.m_wcontext._ascontext;
        if (this.consumeRB.isSelected() || this.produceRB.isSelected()) {
            this.createCommonOperationObjects(this.operationName.getText().trim());
        } else if (this.reqrespRB.isSelected()) {
            this.buildReqReplyOperationObjects();
            if (this.syncRadioButton.isSelected()) {
                this.m_wcontext._write_jca_address.setAttributeValue("UiOperationMode", "Synchronous");
            } else if (this.asyncRadioButton.isSelected()) {
                this.m_wcontext._write_jca_address.setAttributeValue("UiOperationMode", "Asynchronous");
            }
        }
        this.m_wcontext._write_jca_address.setAttributeValue("UIJmsProvider", jmsContext.jmsProvider);
    }

    private void buildReqReplyOperationObjects() throws WSDLException {
        this.m_wcontext._write_definition.addNamespace(AdapterWizardContext.PC_NAMESPACE, AdapterWizardContext.PC_NAMESPACE_URI);
        String inboundPortTypeName = null;
        PortType inboundPortType = null;
        String outboundPortTypeName = null;
        PortType outboundPortType = null;
        JcaOperation jop = null;
        String inboundOperationName = this.repOpNameTextField.getText().trim();
        String outboundOperationName = this.reqOpNameTextField.getText().trim();
        if (!this.jmsContext.IsSyncOperation) {
            if (this.m_wcontext._importedWsdlInfo != null) {
                outboundPortTypeName = this.m_wcontext._importedWsdlInfo.getRequestPorttype().getLocalPart();
                outboundPortType = WsdlInfo.getPorttypeByQname((Project)this.m_wcontext._project, (QName)this.m_wcontext._importedWsdlInfo.getRequestPorttype());
                inboundPortTypeName = this.m_wcontext._importedWsdlInfo.getReplyPorttype().getLocalPart();
                inboundPortType = WsdlInfo.getPorttypeByQname((Project)this.m_wcontext._project, (QName)this.m_wcontext._importedWsdlInfo.getReplyPorttype());
            } else {
                inboundPortTypeName = "Reply" + this.m_wcontext.PortType_suffix;
                inboundPortType = this.createPortType(inboundPortTypeName);
                outboundPortTypeName = "Request" + this.m_wcontext.PortType_suffix;
                outboundPortType = this.createPortType(outboundPortTypeName);
            }
            this.createWSDLBindingsForAsyncReqRes(inboundPortType, outboundPortType, inboundOperationName, outboundOperationName, "Request-response");
            this.createPartnerLinkType(inboundOperationName, outboundOperationName, inboundPortType, outboundPortType);
            jop = this.jmsContext.outboundJcaOperation;
        } else {
            this.m_wcontext._isInboundOperation = false;
            this.createCommonOperationObjects(outboundOperationName, "Request-response");
        }
    }

    public void createWSDLBindingsForAsyncReqRes(PortType inboundPortType, PortType outboundPortType, String inboundOperationName, String outboundOperationName, String uiTransmissionPrimitive) throws WSDLException {
        Definition def = this.m_wcontext._write_definition;
        Service service = this.m_wcontext._write_service;
        Operation inboundOp = null;
        if (this.m_wcontext._importedWsdlInfo == null) {
            inboundOp = def.createOperation();
            inboundOp.setName(inboundOperationName);
            inboundOp.setUndefined(false);
            inboundPortType.addOperation(inboundOp);
        } else {
            inboundOp = inboundPortType.getOperation(inboundOperationName, null, null);
        }
        this.m_wcontext._write_operation2_name = inboundOperationName;
        this.jmsContext.inboundOperation = inboundOp;
        Binding inboundBinding = def.createBinding();
        inboundBinding.setPortType(inboundPortType);
        inboundBinding.setQName(new QName(this.m_wcontext._target_namespace, inboundOperationName + this.m_wcontext.Binding_suffix));
        inboundBinding.setUndefined(false);
        def.addBinding(inboundBinding);
        PCInboundBinding pcib = (PCInboundBinding)this.m_wcontext._extReg.createExtension(PCInboundBinding.PARENT_CLASS, PCInboundBinding.FIELD_ELEMENT_TYPE);
        pcib.setAttributeValue("UITransmissionPrimitive", uiTransmissionPrimitive);
        inboundBinding.addExtensibilityElement((ExtensibilityElement)pcib);
        BindingOperation inboundBindingOp = def.createBindingOperation();
        inboundBindingOp.setName(inboundOperationName);
        inboundBinding.addBindingOperation(inboundBindingOp);
        this.m_wcontext._write_operation_physical = inboundBindingOp;
        JcaOperation injop = (JcaOperation)this.m_wcontext._extReg.createExtension(JcaOperation.PARENT_CLASS, JcaOperation.FIELD_ELEMENT_TYPE);
        this.m_wcontext._write_operation_physical.addExtensibilityElement((ExtensibilityElement)injop);
        this.jmsContext.inboundJcaOperation = injop;
        Port inPort = this.m_wcontext._write_port;
        inPort.setName(inboundOperationName + this.m_wcontext.Port_suffix);
        inPort.setBinding(inboundBinding);
        Operation outboundOp = null;
        if (this.m_wcontext._importedWsdlInfo == null) {
            outboundOp = def.createOperation();
            outboundOp.setName(outboundOperationName);
            outboundOp.setUndefined(false);
            outboundPortType.addOperation(outboundOp);
        } else {
            outboundOp = outboundPortType.getOperation(outboundOperationName, null, null);
        }
        this.m_wcontext._write_operation_name = outboundOperationName;
        this.jmsContext.outboundOperation = outboundOp;
        Binding outboundBinding = def.createBinding();
        outboundBinding.setPortType(outboundPortType);
        outboundBinding.setQName(new QName(this.m_wcontext._target_namespace, outboundOperationName + this.m_wcontext.Binding_suffix));
        outboundBinding.setUndefined(false);
        def.addBinding(outboundBinding);
        JcaBinding jcaBinding = (JcaBinding)this.m_wcontext._extReg.createExtension(JcaBinding.PARENT_CLASS, JcaBinding.FIELD_ELEMENT_TYPE);
        jcaBinding.setAttributeValue("UITransmissionPrimitive", uiTransmissionPrimitive);
        outboundBinding.addExtensibilityElement((ExtensibilityElement)jcaBinding);
        BindingOperation outboundBindingOp = def.createBindingOperation();
        outboundBindingOp.setName(outboundOperationName);
        outboundBinding.addBindingOperation(outboundBindingOp);
        this.m_wcontext._write_operation_physical = outboundBindingOp;
        JcaOperation outjop = (JcaOperation)this.m_wcontext._extReg.createExtension(JcaOperation.PARENT_CLASS, JcaOperation.FIELD_ELEMENT_TYPE);
        this.m_wcontext._write_operation_physical.addExtensibilityElement((ExtensibilityElement)outjop);
        this.jmsContext.outboundJcaOperation = outjop;
        Port outPort = def.createPort();
        outPort.setName(outboundOperationName + this.m_wcontext.Port_suffix);
        outPort.setBinding(outboundBinding);
        service.addPort(outPort);
        this.m_wcontext._write_port2 = outPort;
        this.m_wcontext._write_port2.addExtensibilityElement((ExtensibilityElement)this.m_wcontext._write_jca_address);
    }
}

