/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.PortType;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;
import oracle.bali.ewt.event.Cancelable;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.schema.OracleSchema;
import oracle.bali.xml.grammar.schema.OracleSchemaFactory;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.tip.tools.ide.common.utils.MultiLineOptionPane;
import oracle.tip.tools.ide.fabric.api.WsdlInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.CommonSchemaPanel;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.FocusRequester;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.QNameDisplay;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JMSContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JmsAdapterFinishPanel;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.techAdapterWizardPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.ImportSchema;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.JcaOperation;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.OpaqueSchema;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.WizardWSDLUtil;

public class JmsAdapterInOutSchemaPage
extends techAdapterWizardPage
implements DocumentListener {
    public static final String WSDL = "wsdl";
    public static final String IN_MESSAGE = "msg_in";
    public static final String OUT_MESSAGE = "msg_out";
    public static final String IN_OUT_MESSAGE = "msg_in_out";
    public static final String IN_MSG_SUFFIX = "_msg_in";
    public static final String OUT_MSG_SUFFIX = "_msg_out";
    private MultiLineLabel introLabel;
    private CommonSchemaPanel inboundSchemaPanel;
    private CommonSchemaPanel outboundSchemaPanel;
    private JPanel spacer;
    private JMSContext jmsContext;

    public JmsAdapterInOutSchemaPage(AdapterWizardContext wcontext, ImageWizardPage iwp) {
        try {
            this.setHelpTopicID("bpmjdev_adp_wiz_jms_message");
            this.setContextAndPage(wcontext, iwp);
            this.jmsContext = (JMSContext)this.m_wcontext._ascontext;
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        String introText = this.getTranslatedString("JMS_SC_INTRO_PROMPT");
        this.setLayout(new GridBagLayout());
        this.introLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), introText);
        this.inboundSchemaPanel = new CommonSchemaPanel(this.m_wcontext._project, this.m_wcontext.getFilePath(), this.m_wcontext._bundle, this.m_wcontext._parentFrame, this.m_wcontext, this.m_wcontext._write_service_name, true, this.getTranslatedString("JMS_SC_REQ_MSG_SCHEMA"), this, true, false, null);
        this.outboundSchemaPanel = new CommonSchemaPanel(this.m_wcontext._project, this.m_wcontext.getFilePath(), this.m_wcontext._bundle, this.m_wcontext._parentFrame, this.m_wcontext, this.m_wcontext._write_service_name, true, this.getTranslatedString("JMS_SC_REP_MSG_SCHEMA"), this, true, false, null);
        this.spacer = new JPanel();
        this.add((Component)this.introLabel, new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 3, 0), 0, 0));
        this.add((Component)this.inboundSchemaPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.outboundSchemaPanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.spacer, new GridBagConstraints(0, 3, 1, 1, 0.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_page.setCanAdvance(false);
        if (this.m_wcontext._importedWsdlInfo != null) {
            this.setEnabledAll(this.outboundSchemaPanel, false);
            this.setEnabledAll(this.inboundSchemaPanel, false);
            Definition def1 = WsdlInfo.readWSDL((Frame)this.m_wcontext._parentFrame, (Project)this.m_wcontext._project, (WsdlInfo)this.m_wcontext._importedWsdlInfo);
            PortType requestPortt = WsdlInfo.getPorttypeByQname((Project)this.m_wcontext._project, (QName)this.m_wcontext._importedWsdlInfo.getRequestPorttype());
            PortType replyPortt = WsdlInfo.getPorttypeByQname((Project)this.m_wcontext._project, (QName)this.m_wcontext._importedWsdlInfo.getReplyPorttype());
            this.inboundSchemaPanel.setSchemaForOperation(this.m_wcontext._importedWsdlInfo.getWsdlLocation(), def1, requestPortt, this.m_wcontext._write_operation_name, false);
            if (replyPortt != null) {
                this.outboundSchemaPanel.setSchemaForOperation(this.m_wcontext._importedWsdlInfo.getWsdlLocation(), def1, replyPortt, this.m_wcontext._write_operation2_name, false);
            } else {
                this.outboundSchemaPanel.setSchemaForOperation(this.m_wcontext._importedWsdlInfo.getWsdlLocation(), def1, requestPortt, this.m_wcontext._write_operation_name, true);
            }
        } else if (this.m_wcontext._read_service != null) {
            this.initFromWSDL();
        }
        this.updateControls();
    }

    private void updateControls() {
        boolean canAdvance = false;
        if (this.jmsContext.isMapMessage || this.jmsContext.isAttachment) {
            this.outboundSchemaPanel.setVisible(false);
            this.outboundSchemaPanel.setOpaqueSchemaSelected(false);
        }
        if (this.jmsContext.isMapMessage2 || this.jmsContext.isAttachment2) {
            this.inboundSchemaPanel.setVisible(false);
            this.inboundSchemaPanel.setOpaqueSchemaSelected(false);
        }
        if (this.outboundSchemaPanel.isVisible()) {
            canAdvance = this.outboundSchemaPanel.getSchemaLocation() != null && !this.outboundSchemaPanel.getSchemaLocation().equals("") || this.outboundSchemaPanel.isOpaqueSchemaSelected();
        }
        if (this.inboundSchemaPanel.isVisible()) {
            canAdvance = this.inboundSchemaPanel.getSchemaLocation() != null && !this.inboundSchemaPanel.getSchemaLocation().equals("") || this.inboundSchemaPanel.isOpaqueSchemaSelected();
        }
        this.m_page.setCanAdvance(canAdvance);
    }

    private void setEnabledAll(CommonSchemaPanel csp, boolean value) {
        csp.setEnabledAll(value);
        csp.opaqueCB.setEnabled(value);
    }

    @Override
    public void wizardValidatePage(WizardEvent event) {
        QNameDisplay seldef;
        String elnamespace;
        if (this.inboundSchemaPanel.isVisible() && !this.inboundSchemaPanel.opaqueCB.isSelected() && ((elnamespace = (seldef = (QNameDisplay)this.inboundSchemaPanel.elementCB.getSelectedItem()).getNamespaceURI()) == null || elnamespace.length() == 0)) {
            MessageFormat msgformat = new MessageFormat(this.m_wcontext._bundle.getString("CM_SC_SCHEMA_NAMESPACE_ERROR_MSG"));
            Object[] obj = new Object[]{this.inboundSchemaPanel.schemaLoc.getText().trim()};
            MultiLineOptionPane.showMessageDialog((Component)this.m_wcontext._parentFrame, (Object)msgformat.format(obj), (String)this.m_wcontext._bundle.getString("CM_SC_NAMESPACE_ERROR_TITLE"), (int)0);
            new FocusRequester(this.inboundSchemaPanel.schemaLoc);
            ((Cancelable)event).cancel();
            return;
        }
        if (this.outboundSchemaPanel.isVisible() && !this.outboundSchemaPanel.opaqueCB.isSelected() && ((elnamespace = (seldef = (QNameDisplay)this.outboundSchemaPanel.elementCB.getSelectedItem()).getNamespaceURI()) == null || elnamespace.length() == 0)) {
            MessageFormat msgformat = new MessageFormat(this.m_wcontext._bundle.getString("CM_SC_SCHEMA_NAMESPACE_ERROR_MSG"));
            Object[] obj = new Object[]{this.outboundSchemaPanel.schemaLoc.getText().trim()};
            MultiLineOptionPane.showMessageDialog((Component)this.m_wcontext._parentFrame, (Object)msgformat.format(obj), (String)this.m_wcontext._bundle.getString("CM_SC_NAMESPACE_ERROR_TITLE"), (int)0);
            new FocusRequester(this.outboundSchemaPanel.schemaLoc);
            ((Cancelable)event).cancel();
            return;
        }
        this.setFinishPage();
    }

    public void setFinishPage() {
        new JmsAdapterFinishPanel(this.m_wcontext, this);
    }

    /*
     * Unable to fully structure code
     */
    private void initFromWSDL() {
        inboundMsg = this.getMessageBySuffix("_msg_out");
        inboundNamespace = this.getNamespace(inboundMsg);
        inboundSchemaLoc = this.getSchemaFilename(inboundNamespace.getNamespaceURI());
        inboundSchemaElement = this.getSchemaElement(inboundMsg, inboundNamespace.getNamespaceURI());
        if (inboundSchemaElement == null) ** GOTO lbl-1000
        if (inboundSchemaElement.equals("opaque")) {
            this.inboundSchemaPanel.setOpaqueSchemaSelected(true);
        } else if (inboundSchemaLoc != null) {
            this.inboundSchemaPanel.setSchemaLocationText(inboundSchemaLoc);
            if (inboundSchemaLoc.toLowerCase().endsWith("wsdl")) {
                this.inboundSchemaPanel.addSchemaElement(inboundNamespace);
                this.inboundSchemaPanel.setSelectedSchemaElement(inboundSchemaElement);
            } else {
                this.loadSchemaElements(inboundSchemaLoc, false, this.inboundSchemaPanel);
                this.inboundSchemaPanel.setSelectedSchemaElement(inboundSchemaElement);
            }
        }
        outboundMsg = this.getMessageBySuffix("_msg_in");
        outboundNamespace = this.getNamespace(outboundMsg);
        outboundSchemaLoc = this.getSchemaFilename(outboundNamespace.getNamespaceURI());
        outboundSchemaElement = this.getSchemaElement(outboundMsg, outboundNamespace.getNamespaceURI());
        if (outboundSchemaElement == null) ** GOTO lbl-1000
        if (outboundSchemaElement.equals("opaque")) {
            this.outboundSchemaPanel.setOpaqueSchemaSelected(true);
        } else if (outboundSchemaLoc != null) {
            this.outboundSchemaPanel.setSchemaLocationText(outboundSchemaLoc);
            if (outboundSchemaLoc.toLowerCase().endsWith("wsdl")) {
                this.outboundSchemaPanel.addSchemaElement(outboundNamespace);
                this.outboundSchemaPanel.setSelectedSchemaElement(outboundSchemaElement);
            } else {
                this.loadSchemaElements(outboundSchemaLoc, false, this.outboundSchemaPanel);
                this.outboundSchemaPanel.setSelectedSchemaElement(outboundSchemaElement);
            }
        }
        this.m_page.setCanAdvance(true);
    }

    protected String getSchemaElement(Message msg, String namespace) {
        String element = null;
        Map partsMap = msg.getParts();
        for (Object partKey : partsMap.keySet()) {
            Part part = (Part)partsMap.get(partKey);
            element = part.getName();
            QName qName = part.getTypeName();
            if (qName == null) {
                qName = part.getElementName();
            }
            if (!qName.getNamespaceURI().equals(namespace)) continue;
            return element;
        }
        return null;
    }

    protected QName getNamespace(Message msg) {
        if (msg != null) {
            Map partsMap = msg.getParts();
            for (Object partKey : partsMap.keySet()) {
                Part part = (Part)partsMap.get(partKey);
                QName partQName = part.getTypeName();
                if (partQName == null) {
                    partQName = part.getElementName();
                }
                if (partQName == null) continue;
                return partQName;
            }
        }
        return null;
    }

    protected String getSchemaFilename(String namespace) {
        List importList;
        String schemaURI = null;
        Definition def = this.m_wcontext._read_definition;
        schemaURI = WizardWSDLUtil.getSchemaLocation(def, namespace);
        if (schemaURI == null && (importList = def.getImports(namespace)) != null && importList.size() > 0) {
            Import imp = (Import)importList.get(0);
            schemaURI = imp.getLocationURI();
        }
        return schemaURI;
    }

    protected Message getMessageBySuffix(String msgNameSuffix) {
        if (msgNameSuffix != null) {
            Definition def = this.m_wcontext._read_definition;
            Map mmap = def.getMessages();
            for (QName msgKey : mmap.keySet()) {
                String msgName = msgKey.getLocalPart();
                if (msgName == null || !msgName.endsWith(msgNameSuffix)) continue;
                return (Message)mmap.get(msgKey);
            }
        }
        return null;
    }

    private void loadSchemaElements(String urlstr_in, boolean errorAlert, CommonSchemaPanel schemaPanel) {
        String filename;
        String urlstr = urlstr_in;
        schemaPanel.elementCB.removeAllItems();
        if (urlstr.toLowerCase().startsWith("file:./")) {
            filename = urlstr_in.substring("file:./".length());
            urlstr = "file:" + this.m_wcontext.getFilePath() + "/" + filename;
        } else if (urlstr.toLowerCase().startsWith("file:")) {
            urlstr = urlstr_in.substring(5);
        } else if (urlstr.lastIndexOf(":") < 0) {
            filename = urlstr_in;
            urlstr = "file:" + this.m_wcontext.getFilePath() + "/" + filename;
        }
        URL u1 = URLFactory.newURL((String)urlstr);
        OracleSchema[] xsdSchema = null;
        try {
            OracleSchemaFactory orclSchemaFactory = new OracleSchemaFactory();
            orclSchemaFactory.clearCache();
            xsdSchema = orclSchemaFactory.buildSchemas(u1);
        }
        catch (Exception ex) {
            if (errorAlert) {
                ex.printStackTrace();
                MessageFormat msgformat = new MessageFormat(this.m_wcontext._bundle.getString("CM_SC_SCHEMA_LOCATION_ERROR_MSG"));
                Object[] obj = new Object[]{urlstr};
                MultiLineOptionPane.showMessageDialog((Component)this.m_wcontext._parentFrame, (Object)msgformat.format(obj), (String)this.m_wcontext._bundle.getString("CM_SC_URL_ERROR_TITLE"), (int)0);
            }
            return;
        }
        String targetNamespace = null;
        for (int j = 0; j < xsdSchema.length; ++j) {
            Collection col = xsdSchema[j].getElementDefs();
            if (targetNamespace == null) {
                targetNamespace = xsdSchema[j].getTargetNamespace();
            }
            for (ElementDef elementDef : col) {
                schemaPanel.addSchemaElement(elementDef.getQualifiedName());
            }
        }
        if (schemaPanel.elementCB.getItemCount() == 0 && errorAlert) {
            MessageFormat msgformat = new MessageFormat(this.m_wcontext._bundle.getString("CM_SC_SCHEMA_ELEMENT_ERROR_MSG"));
            Object[] obj = new Object[]{urlstr};
            MultiLineOptionPane.showMessageDialog((Component)this.m_wcontext._parentFrame, (Object)msgformat.format(obj), (String)this.m_wcontext._bundle.getString("CM_SC_URL_ERROR_TITLE"), (int)0);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.checkDoc(e);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.checkDoc(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.checkDoc(e);
    }

    private void checkDoc(DocumentEvent e) {
        if (this.inboundSchemaPanel.isVisible() && !this.inboundSchemaPanel.checkPanel() || this.outboundSchemaPanel.isVisible() && !this.outboundSchemaPanel.checkPanel()) {
            this.m_page.setCanAdvance(false);
        } else {
            this.m_page.setCanAdvance(true);
        }
    }

    private static void addOpaqueSchema(AdapterWizardContext wcontext, Definition def) throws WSDLException {
        def.addNamespace("opaque", "http://xmlns.oracle.com/pcbpel/adapter/opaque/");
        Types types = wcontext.getWriteTypes();
        OpaqueSchema opschema = (OpaqueSchema)wcontext._extReg.createExtension(OpaqueSchema.PARENT_CLASS, OpaqueSchema.FIELD_ELEMENT_TYPE);
        opschema.setContext(wcontext);
        types.addExtensibilityElement((ExtensibilityElement)opschema);
    }

    public static void addSchema(AdapterWizardContext wcontext, Definition def, String namespacePrefix, String elementNamespace, String schemaLocation) throws WSDLException {
        if (elementNamespace != null && elementNamespace.length() > 0) {
            def.addNamespace(namespacePrefix, elementNamespace);
        } else {
            def.addNamespace(null, null);
        }
        if (schemaLocation.toLowerCase().endsWith("xsd")) {
            Types types = wcontext.getWriteTypes();
            ImportSchema impschema = (ImportSchema)wcontext._extReg.createExtension(ImportSchema.PARENT_CLASS, ImportSchema.FIELD_ELEMENT_TYPE);
            impschema.setContext(wcontext);
            impschema.setNamespace(elementNamespace);
            impschema.setLocation(schemaLocation);
            types.addExtensibilityElement((ExtensibilityElement)impschema);
        } else if (schemaLocation.toLowerCase().endsWith(WSDL)) {
            Import imp = def.createImport();
            imp.setLocationURI(schemaLocation);
            imp.setNamespaceURI(elementNamespace);
            def.addImport(imp);
        }
    }

    public static Message addOpaqueMessageAttributes(AdapterWizardContext _wcontext, Definition def, boolean isInbound, Operation operation, String operationName) throws WSDLException {
        Message msg = def.createMessage();
        if (isInbound) {
            msg.setQName(new QName(_wcontext._target_namespace, operationName + IN_MSG_SUFFIX));
        } else {
            msg.setQName(new QName(_wcontext._target_namespace, operationName + OUT_MSG_SUFFIX));
        }
        msg.setUndefined(false);
        Part part = def.createPart();
        part.setName("opaque");
        part.setElementName(new QName("http://xmlns.oracle.com/pcbpel/adapter/opaque/", "opaqueElement"));
        msg.addPart(part);
        def.addMessage(msg);
        return msg;
    }

    public static Message addSchemaMessageAttributes(AdapterWizardContext _wcontext, Definition def, boolean isInbound, Operation operation, CommonSchemaPanel schemaPanel) throws WSDLException {
        String elname = schemaPanel.getSchemaElement();
        String elnamespace = schemaPanel.getSchemaElementNamespaceURI();
        return JmsAdapterInOutSchemaPage.addSchemaMessageAttributes(_wcontext, def, isInbound, operation, elnamespace, elname);
    }

    public static Message addSchemaMessageAttributes(AdapterWizardContext _wcontext, Definition def, boolean isInbound, Operation operation, String elnamespace, String elname) throws WSDLException {
        Message msg = def.createMessage();
        if (isInbound) {
            msg.setQName(new QName(_wcontext._target_namespace, elname + IN_MSG_SUFFIX));
        } else {
            msg.setQName(new QName(_wcontext._target_namespace, elname + OUT_MSG_SUFFIX));
        }
        msg.setUndefined(false);
        Part part = def.createPart();
        part.setName(elname);
        part.setElementName(new QName(elnamespace, elname));
        msg.addPart(part);
        def.addMessage(msg);
        return msg;
    }

    private void buildWSDLForReqReply() throws WSDLException {
        boolean inboundSchemaPredefined = false;
        boolean outboundSchemaPredefined = false;
        boolean addOutboundSchema = true;
        Definition def = this.m_wcontext._write_definition;
        String inboundSchemaLoc = null;
        String outboundSchemaLoc = null;
        String inboundNamespacePrefix = IN_MESSAGE;
        String outboundNamespacePrefix = OUT_MESSAGE;
        if (this.inboundSchemaPanel.isVisible() && !this.inboundSchemaPanel.isOpaqueSchemaSelected()) {
            inboundSchemaLoc = this.inboundSchemaPanel.getSchemaLocation();
            inboundSchemaPredefined = false;
        }
        if (this.outboundSchemaPanel.isVisible() && !this.outboundSchemaPanel.isOpaqueSchemaSelected()) {
            outboundSchemaLoc = this.outboundSchemaPanel.getSchemaLocation();
            outboundSchemaPredefined = false;
        }
        if (inboundSchemaLoc != null && outboundSchemaLoc != null && inboundSchemaLoc.equals(outboundSchemaLoc)) {
            inboundNamespacePrefix = IN_OUT_MESSAGE;
            outboundNamespacePrefix = IN_OUT_MESSAGE;
            addOutboundSchema = false;
        }
        Operation operation = null;
        JcaOperation jcaOp = null;
        String operationName = null;
        if (!this.jmsContext.IsSyncOperation) {
            operation = this.jmsContext.outboundOperation;
            jcaOp = this.jmsContext.outboundJcaOperation;
            operationName = operation.getName();
        } else {
            operation = this.m_wcontext._write_operation_abstract;
            jcaOp = this.m_wcontext._write_jca_operation;
            operationName = this.m_wcontext._write_operation_name;
        }
        if (this.inboundSchemaPanel.isOpaqueSchemaSelected()) {
            JmsAdapterInOutSchemaPage.addOpaqueSchema(this.m_wcontext, def);
            Message msg = JmsAdapterInOutSchemaPage.addOpaqueMessageAttributes(this.m_wcontext, def, false, operation, operationName);
            Input input = def.createInput();
            input.setMessage(msg);
            operation.setInput(input);
        } else if (this.inboundSchemaPanel.isVisible() && this.m_wcontext._importedWsdlInfo == null) {
            String elnamespace = this.inboundSchemaPanel.getSchemaElementNamespaceURI();
            String schemaLoc = this.inboundSchemaPanel.getSchemaLocation();
            JmsAdapterInOutSchemaPage.addSchema(this.m_wcontext, def, outboundNamespacePrefix, elnamespace, schemaLoc);
            Message msg = JmsAdapterInOutSchemaPage.addSchemaMessageAttributes(this.m_wcontext, def, false, operation, this.inboundSchemaPanel);
            Input input = def.createInput();
            input.setMessage(msg);
            operation.setInput(input);
        }
        boolean isInput = true;
        if (!this.jmsContext.IsSyncOperation) {
            operation = this.jmsContext.inboundOperation;
            jcaOp = this.jmsContext.inboundJcaOperation;
            operationName = operation.getName();
        } else {
            operation = this.m_wcontext._write_operation_abstract;
            jcaOp = this.m_wcontext._write_jca_operation;
            operationName = this.m_wcontext._write_operation_name;
            isInput = false;
        }
        if (this.outboundSchemaPanel.isOpaqueSchemaSelected()) {
            if (!this.inboundSchemaPanel.isOpaqueSchemaSelected()) {
                JmsAdapterInOutSchemaPage.addOpaqueSchema(this.m_wcontext, def);
            }
            Message msg = JmsAdapterInOutSchemaPage.addOpaqueMessageAttributes(this.m_wcontext, def, true, operation, operationName);
            if (!this.jmsContext.IsSyncOperation) {
                Input input = def.createInput();
                input.setMessage(msg);
                operation.setInput(input);
            } else {
                Output output = def.createOutput();
                output.setMessage(msg);
                operation.setOutput(output);
            }
        } else if (this.outboundSchemaPanel.isVisible() && this.m_wcontext._importedWsdlInfo == null) {
            String elnamespace = this.outboundSchemaPanel.getSchemaElementNamespaceURI();
            String schemaLoc = this.outboundSchemaPanel.getSchemaLocation();
            if (this.inboundSchemaPanel.isVisible()) {
                if (this.inboundSchemaPanel.isOpaqueSchemaSelected() || !this.inboundSchemaPanel.isOpaqueSchemaSelected() && !schemaLoc.equals(this.inboundSchemaPanel.getSchemaLocation())) {
                    JmsAdapterInOutSchemaPage.addSchema(this.m_wcontext, def, inboundNamespacePrefix, elnamespace, schemaLoc);
                }
            } else if (addOutboundSchema) {
                JmsAdapterInOutSchemaPage.addSchema(this.m_wcontext, def, inboundNamespacePrefix, elnamespace, schemaLoc);
            }
            Message msg = JmsAdapterInOutSchemaPage.addSchemaMessageAttributes(this.m_wcontext, def, true, operation, this.outboundSchemaPanel);
            if (!this.jmsContext.IsSyncOperation) {
                Input input = def.createInput();
                input.setMessage(msg);
                operation.setInput(input);
            } else {
                Output output = def.createOutput();
                output.setMessage(msg);
                operation.setOutput(output);
            }
        }
    }

    @Override
    public void buildWSDL() throws WSDLException {
        if (this.jmsContext.isRequestReply) {
            this.buildWSDLForReqReply();
        }
    }
}

