/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms;

import java.awt.Component;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFactory;
import oracle.jdevimpl.xml.schema.XmlSchemaNode;
import oracle.tip.tools.ide.common.utils.BPELWSDLNode;
import oracle.tip.tools.ide.common.utils.MultiLineOptionPane;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardFinishInterface;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JMSConstants;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JMSContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.WizardWSDLUtil;

public final class JmsAdapterFinish
implements AdapterWizardFinishInterface {
    private static final String WSDL_PATH = "/oracle/tip/tools/ide/pm/modules/bizintegration/adapter/jms/";

    @Override
    public boolean beforeWSDL(AdapterWizardContext _wcontext) {
        this.copySchema(_wcontext);
        return true;
    }

    @Override
    public void afterWSDL(AdapterWizardContext _wcontext) {
    }

    private void copySchema(AdapterWizardContext wcontext) {
        String schemaPath;
        String schemaFilename;
        JMSContext jmsContext = (JMSContext)wcontext._ascontext;
        if (jmsContext.isMapMessage || jmsContext.isMapMessage2) {
            schemaFilename = "JmsAdapterMapMessage.xsd";
            schemaPath = JMSConstants.SCHEMA_DIR + schemaFilename;
            this.copyFixedHeaders(wcontext, schemaPath, WSDL_PATH + schemaFilename);
        }
        if (jmsContext.isAttachment || jmsContext.isAttachment2) {
            schemaFilename = "JmsAdapterAttachment.xsd";
            schemaPath = JMSConstants.SCHEMA_DIR + schemaFilename;
            this.copyFixedHeaders(wcontext, schemaPath, WSDL_PATH + schemaFilename);
        }
        if (jmsContext.b2bContext != null) {
            WizardWSDLUtil wsdlUtil = new WizardWSDLUtil(wcontext);
            try {
                wsdlUtil.createB2BSchemaFile(jmsContext.b2bContext);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void copyFixedHeaders(AdapterWizardContext _wcontext, String headFileName, String inputWSDLPath) {
        String filepath = _wcontext.getFilePath() + "/" + headFileName;
        URL headurl = URLFactory.newURL((String)filepath);
        File fileout = new File(headurl.getFile());
        if (!fileout.exists()) {
            try {
                InputStream inStream = JmsAdapterFinish.class.getResourceAsStream(inputWSDLPath);
                WizardWSDLUtil.copyFile(inStream, fileout);
                fileout.setReadOnly();
            }
            catch (Exception ex) {
                MessageFormat msgformat = new MessageFormat(_wcontext._bundle.getString("CM_WZ_HEADER_WRITE_ERROR_MSG"));
                Object[] obj = new Object[]{headFileName, ex.getLocalizedMessage()};
                MultiLineOptionPane.showMessageDialog((Component)_wcontext._finish_page.getInteractiveArea(), (Object)msgformat.format(obj), (String)_wcontext._bundle.getString("CM_WZ_HEADER_WRITE_ERROR_TITLE"), (int)0);
            }
            if (_wcontext._project != null) {
                URL wurl = URLFactory.newFileURL((File)fileout);
                try {
                    Node wnode = null;
                    wnode = headFileName.endsWith("xsd") ? NodeFactory.findOrCreate(XmlSchemaNode.class, (URL)wurl) : NodeFactory.findOrCreate(BPELWSDLNode.class, (URL)wurl);
                    _wcontext._project.add((Element)wnode, true);
                    _wcontext.addURL(wurl);
                }
                catch (Exception except) {
                    except.printStackTrace();
                    MessageFormat msgformat = new MessageFormat(_wcontext._bundle.getString("CM_WZ_PROJECT_FILE_ERROR_MSG"));
                    Object[] obj = new Object[]{headFileName, except.getLocalizedMessage()};
                    MultiLineOptionPane.showMessageDialog((Component)_wcontext._finish_page.getInteractiveArea(), (Object)msgformat.format(obj), (String)_wcontext._bundle.getString("CM_WZ_PROJECT_FILE_ERROR_TITLE"), (int)0);
                }
            }
        }
    }
}

