/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.wsdl.Definition;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.wsdl.PortType;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;
import oracle.bali.ewt.event.Cancelable;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Project;
import oracle.tip.tools.ide.common.ui.statusglasspane.StatusGlassPane;
import oracle.tip.tools.ide.common.utils.MultiLineOptionPane;
import oracle.tip.tools.ide.common.utils.PreviewUtil;
import oracle.tip.tools.ide.fabric.api.WsdlInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.b2b.B2BContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.file.FileAdapterSchemaPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JMSContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JMSDestObject;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JmsAdapterBrowseDestDialog;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JmsAdapterFinishPanel;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JmsAdapterInOutSchemaPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JmsAdapterSchemaPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.techAdapterWizardPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.B2BUIExtensions;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.ImportSchema;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.JcaOperation;

public class JmsAdapterConsumeParamPage
extends techAdapterWizardPage
implements DocumentListener,
ActionListener {
    public static final String s_msgSelector = "MessageSelector";
    public static final String s_durableSubscriber = "DurableSubscriber";
    public static final String s_msgListener = "UseMessageListener";
    public static final String s_payloadType = "PayloadType";
    public static final String s_textType = "TextMessage";
    public static final String s_bytesType = "BytesMessage";
    public static final String s_streamType = "StreamMessage";
    public static final String s_mapType = "MapMessage";
    public static final String s_streaming = "EnableStreaming";
    public static final String s_payload = "PayloadEntry";
    public static final String s_attachmentList = "AttachmentList";
    public static final String TOPIC_SUFFIX = "(Topic)";
    public static final String QUEUE_SUFFIX = "(Queue)";
    private static final String DEFAULT_TOPIC_CONN_FACTORY = "jms/TopicConnectionFactory";
    private static final String DEFAULT_QUEUE_CONN_FACTORY = "jms/QueueConnectionFactory";
    private static final String DEFAULT_WL_CONN_FACTORY = "weblogic.jms.ConnectionFactory";
    private static final String DEFAULT_TOPIC_JNDI_NAME = "eis/wls/Topic";
    private static final String DEFAULT_QUEUE_JNDI_NAME = "eis/wls/Queue";
    private static final String DEFAULT_AQJMS_TOPIC_JNDI_NAME = "eis/aqjms/Topic";
    private static final String DEFAULT_AQJMS_QUEUE_JNDI_NAME = "eis/aqjms/Queue";
    private static final String BODY_PART_NAME = "body";
    public static final String SCHEMA_RELATIVE_LOCATION = "xsd";
    public static final String IN_MSG_SUFFIX = "_msg_in";
    private String textRBtext;
    private String streamRBtext;
    private String mapRBtext;
    private String bytesRBtext;
    private String msgListTrueText;
    private String msgListFalseText;
    private String destinationLB;
    private String destNameTopicText;
    private String destNameQueueText;
    private MultiLineLabel introPrompt;
    private JTextField durableSubscriber = new JTextField();
    private JLabel durableSubscriberLB = new JLabel();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JLabel msgListenerLB = new JLabel();
    private JComboBox msgListenerList;
    private JLabel messageSelectorLB = new JLabel();
    private JLabel messageSelectorIntroTxt = new JLabel();
    private JTextField messageSelector = new JTextField();
    private JLabel msgTypeLB = new JLabel();
    private JComboBox msgTypeList;
    private JLabel destinationNameLB = new JLabel();
    private JTextField destinationName = new JTextField();
    private JButton browseDestButton = new JButton();
    private JLabel resourceProviderLabel = new JLabel();
    private JTextField resourceProviderTextField = new JTextField();
    private JLabel connectionFactoryLabel = new JLabel();
    private JComboBox connectionFactoryComboBox = new JComboBox();
    private JPanel spacerPanel = new JPanel();
    private JMSContext jmsContext;
    private MultiLineLabel jndiInstanceIntroLabel;
    private JLabel jndiNameLabel = new JLabel();
    private JTextField jndiNameTextField = new JTextField();
    private JCheckBox streamingCB = new JCheckBox();
    private JLabel payloadLabel = new JLabel();
    private JTextField payloadTextField = new JTextField();
    private JCheckBox attachCB = new JCheckBox();
    private boolean initFromWSDLDone = false;

    public JmsAdapterConsumeParamPage(AdapterWizardContext wcontext, ImageWizardPage iwp) {
        try {
            this.setContextAndPage(wcontext, iwp);
            this.jmsContext = (JMSContext)wcontext._ascontext;
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        String intro = this.getTranslatedString("JMS_CP_INTRO_PROMPT");
        if (this.jmsContext.isRequestReply) {
            intro = this.getTranslatedString("JMS_REP_INTRO_PROMPT");
        }
        this.destinationLB = this.getTranslatedString("JMS_PP_DESTINATION_NAME");
        this.destNameTopicText = this.getTranslatedString("JMS_PP_DEST_NAME_TOPIC");
        this.destNameQueueText = this.getTranslatedString("JMS_PP_DEST_NAME_QUEUE");
        String destinationTip = this.getTranslatedString("JMS_CP_DESTINATION_TIP");
        String msgSelectorLB = this.getTranslatedString("JMS_CP_MSG_SELECTOR_PROMPT");
        String msgSelectorInlineTxt = this.getTranslatedString("JMS_CP_MSG_SELECTOR_EG");
        String msgSelectorTip = this.getTranslatedString("JMS_CP_MSG_SELECTOR_TIP");
        String durableSubscriberLBTX = this.getTranslatedString("JMS_CP_DURABLE_SUBSCRIBER_PROMPT");
        String durableSubscriberTip = this.getTranslatedString("JMS_CP_DURABLE_SUBSCRIBER_TIP");
        String msgListenerLBTX = this.getTranslatedString("JMS_CP_MESSAGE_LISTENER_PROMPT");
        String msgListenerTip = this.getTranslatedString("JMS_CP_MESSAGE_LISTENER_TIP");
        String connFactoryLocText = this.getTranslatedString("JMS_CONNECTION_FACTORY_LOCATION");
        String msgTypePrompt = this.getTranslatedString("JMS_CP_MSG_TYPE_PROMPT");
        String msgTypeHint = this.getTranslatedString("JMS_CP_MSG_TYPE_TIP");
        this.textRBtext = this.getTranslatedString("JMS_CP_TEXT_TYPE");
        this.streamRBtext = this.getTranslatedString("JMS_CP_STREAM_TYPE");
        this.mapRBtext = this.getTranslatedString("JMS_CP_MAP_TYPE");
        this.bytesRBtext = this.getTranslatedString("JMS_CP_BYTES_TYPE");
        this.msgListTrueText = this.getTranslatedString("JMS_CP_MESSAGE_LISTENER_TRUE");
        this.msgListFalseText = this.getTranslatedString("JMS_CP_MESSAGE_LISTENER_FALSE");
        String jndiPrompt = this.getTranslatedString("CM_APP_CN_JNDI_NAME");
        String jndiNameTip = this.getTranslatedString("CM_APP_JNDI_TIP");
        String jndiIntroText = this.getTranslatedString("JMS_CN_INTRO_PROMPT");
        String streamingCBText = this.getTranslatedString("JMS_CP_STREAM_TEXT");
        String payloadText = this.getTranslatedString("JMS_PAYLOAD_TEXT");
        String attachmentCBText = this.getTranslatedString("JMS_CP_ATTACHCB_TEXT");
        String browseText = StringUtils.stripMnemonic((String)this.getTranslatedString("JMS_CP_BROWSE"));
        String resourceProviderText = this.getTranslatedString("JMS_CP_RESOURCE_PROVIDER");
        String resourceProviderTip = this.getTranslatedString("JMS_CP_RESOURCE_PROVIDER_TIP");
        String[] msgListenerValues = new String[]{this.msgListTrueText, this.msgListFalseText};
        String[] msgTypeValues = new String[]{this.textRBtext, this.bytesRBtext, this.mapRBtext};
        this.setLayout(this.gridBagLayout1);
        this.introPrompt = new MultiLineLabel(WordWrapper.getTextWrapper(), intro);
        this.introPrompt.setMinimumSize(new Dimension(442, 14));
        this.introPrompt.setPreferredSize(new Dimension(442, 14));
        this.introPrompt.setSize(new Dimension(497, 28));
        this.resourceProviderLabel.setText(StringUtils.stripMnemonic((String)resourceProviderText));
        this.resourceProviderLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)resourceProviderText));
        this.resourceProviderLabel.setLabelFor(this.resourceProviderTextField);
        this.resourceProviderTextField.setToolTipText(resourceProviderTip);
        this.resourceProviderTextField.getDocument().addDocumentListener(this);
        this.resourceProviderTextField.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)resourceProviderText));
        this.destinationNameLB.setText(StringUtils.stripMnemonic((String)this.destinationLB));
        this.destinationNameLB.setLabelFor(this.destinationName);
        this.destinationName.setToolTipText(destinationTip);
        this.destinationName.getAccessibleContext().setAccessibleDescription(destinationTip);
        this.destinationName.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)this.destinationLB));
        this.destinationName.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (JmsAdapterConsumeParamPage.this.m_wcontext._read_service != null && !JmsAdapterConsumeParamPage.this.initFromWSDLDone) {
                    try {
                        JmsAdapterConsumeParamPage.this.initFromWSDL();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.connectionFactoryLabel.setText(StringUtils.stripMnemonic((String)connFactoryLocText));
        this.connectionFactoryLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)connFactoryLocText));
        this.connectionFactoryLabel.setLabelFor(this.connectionFactoryComboBox);
        this.connectionFactoryComboBox.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)connFactoryLocText));
        this.connectionFactoryComboBox.addActionListener(this);
        this.messageSelectorLB.setText(StringUtils.stripMnemonic((String)msgSelectorLB));
        this.messageSelectorLB.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)msgSelectorLB));
        this.messageSelectorLB.setLabelFor(this.messageSelector);
        this.messageSelector.setToolTipText(msgSelectorTip);
        this.messageSelector.getAccessibleContext().setAccessibleDescription(msgSelectorTip);
        this.messageSelector.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)msgSelectorLB));
        this.messageSelectorIntroTxt.setText(msgSelectorInlineTxt);
        this.msgListenerList = new JComboBox<String>(msgListenerValues);
        this.msgListenerLB.setText(StringUtils.stripMnemonic((String)msgListenerLBTX));
        this.msgListenerLB.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)msgListenerLBTX));
        this.msgListenerLB.setLabelFor(this.msgListenerList);
        this.msgListenerList.setToolTipText(msgListenerTip);
        this.msgListenerList.getAccessibleContext().setAccessibleDescription(msgListenerTip);
        this.msgListenerList.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)msgListenerLBTX));
        this.msgListenerList.setMinimumSize(new Dimension(60, 20));
        this.msgListenerList.setPreferredSize(new Dimension(100, 20));
        this.msgListenerList.setSelectedItem(this.msgListFalseText);
        this.durableSubscriberLB.setText(StringUtils.stripMnemonic((String)durableSubscriberLBTX));
        this.durableSubscriberLB.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)durableSubscriberLBTX));
        this.durableSubscriberLB.setLabelFor(this.durableSubscriber);
        this.durableSubscriber.setToolTipText(durableSubscriberTip);
        this.durableSubscriber.getAccessibleContext().setAccessibleDescription(durableSubscriberTip);
        this.durableSubscriber.getAccessibleContext().setAccessibleName(durableSubscriberLBTX);
        this.msgTypeList = new JComboBox<String>(msgTypeValues);
        this.msgTypeLB.setText(StringUtils.stripMnemonic((String)msgTypePrompt));
        this.msgTypeLB.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)msgTypePrompt));
        this.msgTypeLB.setLabelFor(this.msgTypeList);
        this.msgTypeList.setMinimumSize(new Dimension(100, 20));
        this.msgTypeList.setToolTipText(msgTypeHint);
        this.msgTypeList.addActionListener(this);
        this.payloadLabel.setText(StringUtils.stripMnemonic((String)payloadText));
        this.payloadLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)payloadText));
        this.payloadLabel.setLabelFor(this.payloadTextField);
        this.payloadTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                JmsAdapterConsumeParamPage.this.payloadDocumentEventHandler();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                JmsAdapterConsumeParamPage.this.payloadDocumentEventHandler();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                JmsAdapterConsumeParamPage.this.payloadDocumentEventHandler();
            }
        });
        this.attachCB.setText(StringUtils.stripMnemonic((String)attachmentCBText));
        this.attachCB.setMnemonic(StringUtils.getMnemonicKeyCode((String)attachmentCBText));
        this.browseDestButton.setText(browseText);
        int browseMN = StringUtils.getMnemonicKeyCode((String)this.getTranslatedString("JMS_CP_BROWSE"));
        this.browseDestButton.setMnemonic(browseMN);
        this.browseDestButton.getAccessibleContext().setAccessibleName(browseText);
        this.browseDestButton.addActionListener(this);
        this.jndiInstanceIntroLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), jndiIntroText);
        this.jndiNameLabel.setText(StringUtils.stripMnemonic((String)jndiPrompt));
        this.jndiNameLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)jndiPrompt));
        this.jndiNameLabel.setLabelFor(this.jndiNameTextField);
        this.jndiNameTextField.setSize(new Dimension(20, 20));
        this.jndiNameTextField.setPreferredSize(new Dimension(20, 20));
        this.jndiNameTextField.setToolTipText(jndiNameTip);
        this.jndiNameTextField.getAccessibleContext().setAccessibleDescription(jndiNameTip);
        this.jndiNameTextField.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)jndiPrompt));
        this.jndiNameTextField.getDocument().addDocumentListener(this);
        this.streamingCB.setText(StringUtils.stripMnemonic((String)streamingCBText));
        this.streamingCB.setToolTipText(StringUtils.stripMnemonic((String)streamingCBText));
        this.streamingCB.setMnemonic(StringUtils.getMnemonicKeyCode((String)streamingCBText));
        this.add((Component)this.introPrompt, new GridBagConstraints(0, 0, 0, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.resourceProviderLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.resourceProviderTextField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this.destinationNameLB, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.destinationName, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this.browseDestButton, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.connectionFactoryLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.connectionFactoryComboBox, new GridBagConstraints(1, 3, 2, 1, 2.0, 0.0, 18, 2, new Insets(8, 10, 0, 0), 0, 0));
        this.add((Component)this.msgTypeLB, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.msgTypeList, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 18, 2, new Insets(8, 10, 0, 0), 0, 0));
        this.add((Component)this.payloadLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.payloadTextField, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 18, 2, new Insets(8, 10, 0, 0), 0, 0));
        this.add((Component)this.attachCB, new GridBagConstraints(2, 5, 1, 1, 1.0, 0.0, 18, 2, new Insets(8, 5, 0, 0), 0, 0));
        this.add((Component)this.messageSelectorLB, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.messageSelector, new GridBagConstraints(1, 7, 1, 1, 1.0, 0.0, 18, 2, new Insets(8, 10, 0, 0), 0, 0));
        this.add((Component)this.messageSelectorIntroTxt, new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.msgListenerLB, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.msgListenerList, new GridBagConstraints(1, 9, 1, 1, 1.0, 0.0, 18, 2, new Insets(8, 10, 0, 0), 0, 0));
        this.add((Component)this.durableSubscriberLB, new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.durableSubscriber, new GridBagConstraints(1, 10, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this.jndiInstanceIntroLabel, new GridBagConstraints(0, 11, 0, 1, 0.0, 0.0, 18, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.jndiNameLabel, new GridBagConstraints(0, 12, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.jndiNameTextField, new GridBagConstraints(1, 12, 0, 1, 1.0, 0.0, 18, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.spacerPanel, new GridBagConstraints(0, 13, 1, 1, 0.0, 6.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.streamingCB, new GridBagConstraints(0, 14, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.initControls();
        this.m_page.setCanAdvance(false);
        this.m_page.setInitialFocus((Component)this.destinationName);
    }

    private void payloadDocumentEventHandler() {
        if (this.payloadTextField.getText().equals("")) {
            this.attachCB.setEnabled(false);
            this.attachCB.setSelected(false);
        } else {
            this.attachCB.setEnabled(true);
        }
    }

    private void initControls() {
        this.resourceProviderLabel.setVisible(false);
        this.resourceProviderTextField.setVisible(false);
        this.browseDestButton.setVisible(false);
        this.durableSubscriberLB.setVisible(false);
        this.durableSubscriber.setVisible(false);
        this.connectionFactoryLabel.setVisible(false);
        this.connectionFactoryComboBox.setVisible(false);
        this.jndiInstanceIntroLabel.setVisible(false);
        this.jndiNameLabel.setVisible(false);
        this.jndiNameTextField.setVisible(false);
        this.payloadLabel.setVisible(false);
        this.payloadTextField.setVisible(false);
        this.attachCB.setVisible(false);
        if (this.jmsContext.jmsProvider.equals("OJMS")) {
            this.destinationName.setEditable(false);
            this.browseDestButton.setVisible(true);
            if (PreviewUtil.isInPreviewMode()) {
                this.connectionFactoryLabel.setVisible(true);
                this.connectionFactoryComboBox.setVisible(true);
                this.connectionFactoryComboBox.setEnabled(false);
                this.connectionFactoryComboBox.addItem(this.getTranslatedString("CM_CN_NO_SELECTION_ITEM"));
            }
            this.jndiInstanceIntroLabel.setVisible(true);
            this.jndiNameLabel.setVisible(true);
            this.jndiNameTextField.setVisible(true);
            if (this.jmsContext.selectedDestinationObject != null && this.jmsContext.selectedDestinationObject.isTopic()) {
                this.durableSubscriberLB.setVisible(true);
                this.durableSubscriber.setVisible(true);
            }
        } else if (this.jmsContext.jmsProvider.equals("OC4JJMS") || this.jmsContext.jmsProvider.equals("WLSJMS")) {
            this.destinationName.setEditable(false);
            this.browseDestButton.setVisible(true);
            if (PreviewUtil.isInPreviewMode()) {
                this.connectionFactoryLabel.setVisible(true);
                this.connectionFactoryComboBox.setVisible(true);
                this.connectionFactoryComboBox.setEnabled(false);
                this.connectionFactoryComboBox.addItem(this.getTranslatedString("CM_CN_NO_SELECTION_ITEM"));
            }
            this.jndiInstanceIntroLabel.setVisible(true);
            this.jndiNameLabel.setVisible(true);
            this.jndiNameTextField.setVisible(true);
            this.msgListenerList.setSelectedItem(this.msgListFalseText);
            this.msgListenerList.setEnabled(false);
            if (this.jmsContext.selectedDestinationObject != null && this.jmsContext.selectedDestinationObject.isTopic()) {
                this.durableSubscriberLB.setVisible(true);
                this.durableSubscriber.setVisible(true);
            }
        } else {
            this.destinationNameLB.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)this.getTranslatedString("JMS_PP_DESTINATION_NAME")));
            this.destinationName.setEditable(true);
            this.durableSubscriberLB.setVisible(true);
            this.durableSubscriber.setVisible(true);
            this.destinationName.getDocument().addDocumentListener(this);
        }
        if (this.m_wcontext._importedWsdlInfo != null) {
            this.msgTypeList.removeItem(this.mapRBtext);
            this.payloadTextField.setEnabled(false);
        }
    }

    private void initFromWSDL() throws Exception {
        String tempstr;
        JcaOperation jop = null;
        jop = this.jmsContext.isRequestReply && !this.jmsContext.IsSyncOperation ? this.jmsContext.inboundJcaOperation : this.m_wcontext._read_jca_operation;
        this.jmsContext.destinationName = jop.getAttributeValue("DestinationName");
        if (this.jmsContext.jmsProvider != null && (this.jmsContext.jmsProvider.equals("OJMS") || this.jmsContext.jmsProvider.equals("OC4JJMS") || this.jmsContext.jmsProvider.equals("WLSJMS"))) {
            final StatusGlassPane status = new StatusGlassPane((Component)this);
            status.enableUserInput(false);
            status.setStatusMessage(this.getTranslatedString("CM_PROCESSING"), this.getTranslatedString("JMS_DEST_INFO_MSG"));
            Runnable r = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        JmsAdapterConsumeParamPage.this.jmsContext.initDataAccess(JmsAdapterConsumeParamPage.this.m_wcontext);
                        ((JmsAdapterConsumeParamPage)JmsAdapterConsumeParamPage.this).jmsContext.selectedDestinationObject = ((JmsAdapterConsumeParamPage)JmsAdapterConsumeParamPage.this).jmsContext.dataAccess.getJMSDestination(((JmsAdapterConsumeParamPage)JmsAdapterConsumeParamPage.this).jmsContext.destinationName);
                    }
                    catch (Exception e) {
                        ((JmsAdapterConsumeParamPage)JmsAdapterConsumeParamPage.this).jmsContext.selectedDestinationObject = null;
                        status.enableUserInput(true);
                    }
                    finally {
                        status.enableUserInput(true);
                        JmsAdapterConsumeParamPage.this.initFromWSDLDone = true;
                    }
                }
            };
            new Thread(r).start();
        }
        if ((tempstr = jop.getAttributeValue(s_msgListener)) == null || tempstr.equals("true")) {
            this.msgListenerList.setSelectedItem(this.msgListTrueText);
        } else {
            this.msgListenerList.setSelectedItem(this.msgListFalseText);
        }
        tempstr = jop.getAttributeValue(s_msgSelector);
        if (tempstr != null && tempstr.length() > 0) {
            this.messageSelector.setText(tempstr);
        }
        tempstr = jop.getAttributeValue(s_payloadType);
        String paystr = null;
        if (tempstr.equals(s_textType)) {
            paystr = this.textRBtext;
        } else if (tempstr.equals(s_bytesType)) {
            paystr = this.bytesRBtext;
        } else if (tempstr.equals(s_mapType)) {
            paystr = this.mapRBtext;
        } else if (tempstr.equals(s_streamType)) {
            paystr = this.streamRBtext;
        }
        this.msgTypeList.setSelectedItem(paystr);
        String streamingStr = jop.getAttributeValue(s_streaming);
        if (streamingStr != null) {
            if (jop.getAttributeValue(s_streaming).equals("true")) {
                this.streamingCB.setSelected(true);
            } else {
                this.streamingCB.setSelected(false);
            }
        }
        if (paystr.equals(s_mapType)) {
            this.jmsContext.isMapMessage = true;
            if (jop.getAttributeValue(s_payload) != null && !jop.getAttributeValue(s_payload).equals("")) {
                this.payloadTextField.setText(jop.getAttributeValue(s_payload));
                this.jmsContext.isMapMessage = false;
            }
            if (jop.getAttributeValue(s_attachmentList) != null && !jop.getAttributeValue(s_attachmentList).equals("")) {
                this.payloadTextField.setText(jop.getAttributeValue(s_attachmentList));
                this.attachCB.setSelected(true);
                this.jmsContext.isAttachment = true;
                this.jmsContext.isMapMessage = false;
            }
        } else {
            this.jmsContext.isMapMessage = false;
        }
        if (this.jmsContext.jmsProvider != null && this.jmsContext.jmsProvider.equals("OJMS")) {
            boolean isTopic = true;
            String isTopicStr = null;
            if (PreviewUtil.isInPreviewMode()) {
                isTopicStr = this.m_wcontext._read_jca_address.getAttributeValue("mcf.IsTopic");
            } else {
                try {
                    isTopicStr = String.valueOf(this.jmsContext.selectedDestinationObject.isTopic());
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (isTopicStr != null) {
                isTopic = isTopicStr.equals("true");
            }
            String durableSubVal = jop.getAttributeValue(s_durableSubscriber);
            if (isTopic || durableSubVal != null) {
                this.durableSubscriberLB.setVisible(true);
                this.durableSubscriber.setVisible(true);
                this.durableSubscriber.setText(durableSubVal);
            }
            this.jmsContext.mcfConnectionFactoryLocation = this.m_wcontext._read_jca_address.getAttributeValue("mcf.ConnectionFactoryLocation");
            this.jmsContext.initDataAccess(this.m_wcontext);
            if (PreviewUtil.isInPreviewMode()) {
                List connFactoryList = this.jmsContext.dataAccess.getJMSConnectionFactoryLocations(isTopic, this.jmsContext.selectedDestinationObject.getParent().getName());
                this.connectionFactoryComboBox.removeAllItems();
                this.connectionFactoryComboBox.addItem(this.getTranslatedString("CM_CN_NO_SELECTION_ITEM"));
                if (connFactoryList != null) {
                    for (int i = 0; i < connFactoryList.size(); ++i) {
                        String currConnFactory = (String)connFactoryList.get(i);
                        this.connectionFactoryComboBox.addItem(currConnFactory);
                        if (!currConnFactory.equals(this.jmsContext.mcfConnectionFactoryLocation)) continue;
                        this.connectionFactoryComboBox.setSelectedItem(currConnFactory);
                    }
                }
            }
            if (this.jndiNameTextField.isVisible()) {
                String jndiName = this.m_wcontext._read_jca_address.getAdapterInstanceJndi();
                this.jndiNameTextField.setText(jndiName);
            }
        } else if (this.jmsContext.jmsProvider != null && (this.jmsContext.jmsProvider.equals("OC4JJMS") || this.jmsContext.jmsProvider.equals("WLSJMS"))) {
            boolean isTopic = true;
            String isTopicStr = null;
            if (PreviewUtil.isInPreviewMode()) {
                isTopicStr = this.m_wcontext._read_jca_address.getAttributeValue("mcf.IsTopic");
            } else {
                try {
                    isTopicStr = String.valueOf(this.jmsContext.selectedDestinationObject.isTopic());
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (isTopicStr != null) {
                isTopic = isTopicStr.equals("true");
            }
            this.jmsContext.mcfConnectionFactoryLocation = this.m_wcontext._read_jca_address.getAttributeValue("mcf.ConnectionFactoryLocation");
            this.jmsContext.initDataAccess(this.m_wcontext);
            if (PreviewUtil.isInPreviewMode()) {
                List connFactoryList = this.jmsContext.dataAccess.getJMSConnectionFactoryLocations(isTopic, this.jmsContext.selectedDestinationObject.getParent().getName());
                this.connectionFactoryComboBox.removeAllItems();
                this.connectionFactoryComboBox.addItem(this.getTranslatedString("CM_CN_NO_SELECTION_ITEM"));
                if (connFactoryList != null) {
                    for (int i = 0; i < connFactoryList.size(); ++i) {
                        String currConnFactory = (String)connFactoryList.get(i);
                        this.connectionFactoryComboBox.addItem(currConnFactory);
                        if (!currConnFactory.equals(this.jmsContext.mcfConnectionFactoryLocation)) continue;
                        this.connectionFactoryComboBox.setSelectedItem(currConnFactory);
                    }
                }
            }
            if (this.jndiNameTextField.isVisible()) {
                String jndiName = this.m_wcontext._read_jca_address.getAdapterInstanceJndi();
                this.jndiNameTextField.setText(jndiName);
            }
            String durableSubVal = jop.getAttributeValue(s_durableSubscriber);
            if (isTopic || durableSubVal != null) {
                this.durableSubscriberLB.setVisible(true);
                this.durableSubscriber.setVisible(true);
                this.durableSubscriber.setText(durableSubVal);
            }
        } else if (this.jmsContext.jmsProvider != null && this.jmsContext.jmsProvider.equals("THIRDPARTY")) {
            this.durableSubscriberLB.setVisible(true);
            this.durableSubscriber.setVisible(true);
            String durableSubVal = jop.getAttributeValue(s_durableSubscriber);
            this.durableSubscriber.setText(durableSubVal);
        }
        Runnable r1 = new Runnable(){

            @Override
            public void run() {
                JmsAdapterConsumeParamPage.this.destinationName.setText(((JmsAdapterConsumeParamPage)JmsAdapterConsumeParamPage.this).jmsContext.destinationName);
                JmsAdapterConsumeParamPage.this.destinationName.setToolTipText(JmsAdapterConsumeParamPage.this.destinationName.getText());
                JmsAdapterConsumeParamPage.this.canAdvance();
            }
        };
        SwingUtilities.invokeLater(r1);
    }

    private void updateControls() {
        String resProv = this.resourceProviderTextField.getText().trim();
        if (this.jmsContext.jmsProvider.equals("OJMS")) {
            if (!this.destinationName.getText().equals("")) {
                this.destinationName.setToolTipText(this.destinationName.getText());
            }
            if (this.jmsContext.selectedDestinationObject != null) {
                if (this.jmsContext.selectedDestinationObject.isTopic()) {
                    this.destinationNameLB.setText(this.destNameTopicText);
                } else {
                    this.destinationNameLB.setText(this.destNameQueueText);
                }
            } else {
                this.destinationNameLB.setText(StringUtils.stripMnemonic((String)this.destinationLB));
            }
            if (this.jmsContext.selectedDestinationObject != null && this.jmsContext.selectedDestinationObject.isTopic()) {
                this.durableSubscriberLB.setVisible(true);
                this.durableSubscriber.setVisible(true);
            } else {
                this.durableSubscriberLB.setVisible(false);
                this.durableSubscriber.setVisible(false);
            }
        } else if (this.jmsContext.jmsProvider.equals("OC4JJMS") || this.jmsContext.jmsProvider.equals("WLSJMS")) {
            if (this.jmsContext.selectedDestinationObject != null) {
                if (this.jmsContext.selectedDestinationObject.isTopic()) {
                    this.destinationNameLB.setText(this.destNameTopicText);
                } else {
                    this.destinationNameLB.setText(this.destNameQueueText);
                }
            } else {
                this.destinationNameLB.setText(StringUtils.stripMnemonic((String)this.destinationLB));
            }
            this.destinationName.setToolTipText(this.destinationName.getText());
            if (this.jmsContext.selectedDestinationObject != null && this.jmsContext.selectedDestinationObject.isTopic()) {
                this.durableSubscriberLB.setVisible(true);
                this.durableSubscriber.setVisible(true);
            } else {
                this.durableSubscriberLB.setVisible(false);
                this.durableSubscriber.setVisible(false);
            }
        }
        this.canAdvance();
    }

    private void canAdvance() {
        String destName = this.destinationName.getText().trim();
        if (this.jmsContext.jmsProvider.equals("OJMS") || this.jmsContext.jmsProvider.equals("OC4JJMS") || this.jmsContext.jmsProvider.equals("WLSJMS")) {
            if (PreviewUtil.isInPreviewMode()) {
                this.updateConnFactoryComboBox();
            } else if (destName != null && !destName.trim().equals("") && this.jndiNameTextField.getText() != null && !this.jndiNameTextField.getText().trim().equals("")) {
                this.m_page.setCanAdvance(true);
            }
        } else if (destName != null && !destName.trim().equals("")) {
            this.m_page.setCanAdvance(true);
        } else {
            this.m_page.setCanAdvance(false);
        }
    }

    private void updateConnFactoryComboBox() {
        String destName = this.destinationName.getText().trim();
        if (destName != null && !destName.trim().equals("") && this.jndiNameTextField.getText() != null && !this.jndiNameTextField.getText().trim().equals("")) {
            this.connectionFactoryComboBox.setEnabled(true);
            String selConnFactory = (String)this.connectionFactoryComboBox.getSelectedItem();
            if (this.connectionFactoryComboBox.isEnabled() && selConnFactory != null && !selConnFactory.equals(this.getTranslatedString("CM_CN_NO_SELECTION_ITEM"))) {
                this.connectionFactoryComboBox.setToolTipText((String)this.connectionFactoryComboBox.getSelectedItem());
                this.jmsContext.mcfConnectionFactoryLocation = selConnFactory;
                this.m_page.setCanAdvance(true);
            } else {
                this.m_page.setCanAdvance(false);
            }
        } else {
            this.connectionFactoryComboBox.setEnabled(false);
            this.m_page.setCanAdvance(false);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateControls();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateControls();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateControls();
    }

    @Override
    public void buildWSDL() throws WSDLException {
        if (this.jmsContext.b2bContext != null) {
            this.setB2BSchema();
        }
        Definition def1 = this.m_wcontext._write_definition;
        JcaOperation jop = null;
        jop = this.jmsContext.isRequestReply && !this.jmsContext.IsSyncOperation ? this.jmsContext.inboundJcaOperation : this.m_wcontext._write_jca_operation;
        jop.setAttributeValue("ActivationSpec", "oracle.tip.adapter.jms.inbound.JmsConsumeActivationSpec");
        jop.setAttributeValue("DestinationName", this.destinationName.getText().trim());
        String tempstr = (String)this.msgListenerList.getSelectedItem();
        if (tempstr.equals(this.msgListTrueText)) {
            jop.setAttributeValue(s_msgListener, "true");
        } else {
            jop.setAttributeValue(s_msgListener, "false");
        }
        if (this.durableSubscriber.isVisible() && (tempstr = this.durableSubscriber.getText().trim()) != null && tempstr.length() > 0) {
            jop.setAttributeValue(s_durableSubscriber, tempstr);
        }
        if ((tempstr = this.messageSelector.getText().trim()) != null && tempstr.length() > 0) {
            jop.setAttributeValue(s_msgSelector, tempstr);
        }
        tempstr = (String)this.msgTypeList.getSelectedItem();
        String paystr = null;
        if (tempstr.equals(this.textRBtext)) {
            paystr = s_textType;
        } else if (tempstr.equals(this.bytesRBtext)) {
            paystr = s_bytesType;
        } else if (tempstr.equals(this.mapRBtext)) {
            paystr = s_mapType;
        } else if (tempstr.equals(this.streamRBtext)) {
            paystr = s_streamType;
        }
        jop.setAttributeValue(s_payloadType, paystr);
        if (paystr.equals(s_mapType)) {
            jop.setAttributeValue("ActivationSpec", "oracle.tip.adapter.jms.inbound.JmsMapMessageConsumeActivationSpec");
            if (!this.payloadTextField.getText().equals("")) {
                if (this.attachCB.isSelected()) {
                    String schemaNamespace = "implatt";
                    String schemaUri = "http://xmlns.oracle.com/pcbpel/adapter/jms/attachment/";
                    String schemaXsd = "xsd/JmsAdapterAttachment.xsd";
                    String schemaElement = "attachmentElement";
                    this.importAttachmentMapMessageSchema(def1, schemaNamespace, schemaUri, schemaXsd, schemaElement);
                    jop.setAttributeValue(s_attachmentList, this.payloadTextField.getText());
                } else {
                    jop.setAttributeValue(s_payload, this.payloadTextField.getText());
                }
            } else {
                String schemaNamespace = "implmap";
                String schemaUri = "http://xmlns.oracle.com/pcbpel/adapter/jms/MapMessage";
                String schemaXsd = "xsd/JmsAdapterMapMessage.xsd";
                String schemaElement = s_mapType;
                this.importAttachmentMapMessageSchema(def1, schemaNamespace, schemaUri, schemaXsd, schemaElement);
            }
        }
        if (this.jndiNameTextField.isVisible() && this.m_wcontext._write_jca_address != null) {
            this.m_wcontext._write_jca_address.setAdapterInstanceJndi(this.m_wcontext._jndiName);
        }
        if (this.streamingCB.isSelected()) {
            jop.setAttributeValue(s_streaming, "true");
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.connectionFactoryComboBox) {
            this.updateControls();
        } else if (event.getSource() == this.msgTypeList) {
            if (((String)this.msgTypeList.getSelectedItem()).equals(s_mapType)) {
                this.payloadLabel.setVisible(true);
                this.payloadTextField.setVisible(true);
                this.attachCB.setVisible(true);
                if (this.payloadTextField.getText().equals("")) {
                    this.attachCB.setEnabled(false);
                } else {
                    this.attachCB.setEnabled(true);
                }
            } else {
                this.payloadLabel.setVisible(false);
                this.payloadTextField.setVisible(false);
                this.attachCB.setVisible(false);
            }
        } else if (event.getSource() == this.browseDestButton) {
            try {
                JmsAdapterBrowseDestDialog browseDestDialog = new JmsAdapterBrowseDestDialog(this.m_wcontext);
                if (browseDestDialog.runDialog()) {
                    if (this.jmsContext.selectedDestinationObject != null) {
                        if (this.jmsContext.jmsProvider.equals("OJMS")) {
                            this.setCursor(new Cursor(3));
                            this.destinationName.setText(this.jmsContext.formDestinationNameAQJMS());
                            if (PreviewUtil.isInPreviewMode()) {
                                new Thread(new getJMSDestinationList()).start();
                            } else {
                                this.setCursor(new Cursor(0));
                            }
                            if (this.jmsContext.selectedDestinationObject.isTopic()) {
                                this.jndiNameTextField.setText(DEFAULT_AQJMS_TOPIC_JNDI_NAME);
                            } else {
                                this.jndiNameTextField.setText(DEFAULT_AQJMS_QUEUE_JNDI_NAME);
                            }
                            this.updateControls();
                        } else if (this.jmsContext.jmsProvider.equals("OC4JJMS") || this.jmsContext.jmsProvider.equals("WLSJMS")) {
                            this.setCursor(new Cursor(3));
                            if (this.jmsContext.jmsProvider.equals("OC4JJMS")) {
                                this.destinationName.setText(this.jmsContext.formDestinationNameOC4JJMS());
                            } else {
                                this.destinationName.setText(this.jmsContext.formDestinationNameWLJMS());
                            }
                            if (PreviewUtil.isInPreviewMode()) {
                                new Thread(new getJMSDestinationList()).start();
                            } else {
                                this.setCursor(new Cursor(0));
                            }
                            if (this.jmsContext.selectedDestinationObject.isTopic()) {
                                this.jndiNameTextField.setText(DEFAULT_TOPIC_JNDI_NAME);
                            } else {
                                this.jndiNameTextField.setText(DEFAULT_QUEUE_JNDI_NAME);
                            }
                            this.updateControls();
                        }
                    }
                    if (this.jmsContext.jmsProvider.equals("OC4JJMS") || this.jmsContext.jmsProvider.equals("WLSJMS") || this.jmsContext.jmsProvider.equals("OJMS")) {
                        final StatusGlassPane status = new StatusGlassPane((Component)this);
                        status.enableUserInput(false);
                        status.setStatusMessage(this.getTranslatedString("CM_PROCESSING"), this.getTranslatedString("JMS_DEST_INFO_MSG"));
                        final JmsAdapterConsumeParamPage currentPage = this;
                        Runnable r = new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                try {
                                    JmsAdapterConsumeParamPage.this.jmsContext.initDataAccess(JmsAdapterConsumeParamPage.this.m_wcontext);
                                    JMSDestObject destObj = ((JmsAdapterConsumeParamPage)JmsAdapterConsumeParamPage.this).jmsContext.dataAccess.getJMSDestination(JmsAdapterConsumeParamPage.this.destinationName.getText());
                                    if (((JmsAdapterConsumeParamPage)JmsAdapterConsumeParamPage.this).jmsContext.selectedDestinationObject == null) {
                                        ((JmsAdapterConsumeParamPage)JmsAdapterConsumeParamPage.this).jmsContext.selectedDestinationObject = destObj;
                                    }
                                    if (destObj == null) {
                                        MultiLineOptionPane.showMessageDialog((Component)currentPage, (Object)JmsAdapterConsumeParamPage.this.getTranslatedString("JMS_DEST_NOT_FOUND"), (String)JmsAdapterConsumeParamPage.this.getTranslatedString("JMS_FP_ERROR"), (int)0);
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    status.enableUserInput(true);
                                    MultiLineOptionPane.showMessageDialog((Component)currentPage, (Object)JmsAdapterConsumeParamPage.this.getTranslatedString("JMS_DEST_NOT_FOUND"), (String)JmsAdapterConsumeParamPage.this.getTranslatedString("JMS_FP_ERROR"), (int)0);
                                }
                                finally {
                                    status.enableUserInput(true);
                                }
                            }
                        };
                        new Thread(r).start();
                    }
                }
            }
            catch (Exception e) {
                MultiLineOptionPane.showMessageDialog((Component)this.m_wcontext._parentFrame, (Object)this.getTranslatedString("JMS_CP_ERROR_DEST_BROWSE"), (String)this.getTranslatedString("JMS_ERROR"), (int)0);
                e.printStackTrace();
            }
        }
    }

    @Override
    public void wizardValidatePage(WizardEvent event) {
        block11: {
            if (this.m_wcontext._read_service != null && (this.jmsContext.jmsProvider.equals("OC4JJMS") || this.jmsContext.jmsProvider.equals("OJMS") || this.jmsContext.jmsProvider.equals("WLSJMS"))) {
                try {
                    Object[] obj;
                    MessageFormat msgformat;
                    int ret;
                    if (this.jmsContext.selectedDestinationObject == null && (ret = MultiLineOptionPane.showMessageDialog((Component)this, (Object)(msgformat = new MessageFormat(this.m_wcontext._bundle.getString("JMS_DEST_NOT_FOUND_QUES"))).format(obj = new Object[]{this.destinationName.getText()}), (String)this.getTranslatedString("JMS_FP_WARNING"), (int)2, (int)0, null)) == 1) {
                        ((Cancelable)event).cancel();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    MessageFormat msgformat = new MessageFormat(this.m_wcontext._bundle.getString("JMS_DEST_NOT_FOUND_QUES"));
                    Object[] obj = new Object[]{this.destinationName.getText()};
                    int ret = MultiLineOptionPane.showMessageDialog((Component)this, (Object)msgformat.format(obj), (String)this.getTranslatedString("JMS_FP_WARNING"), (int)2, (int)0, null);
                    if (ret != 1) break block11;
                    ((Cancelable)event).cancel();
                }
            }
        }
        this.jmsContext.resourceProviderName = this.resourceProviderTextField.getText();
        if (this.jndiNameTextField.isVisible()) {
            this.m_wcontext._jndiName = this.jndiNameTextField.getText();
        }
        if (((String)this.msgTypeList.getSelectedItem()).equals(s_mapType)) {
            if (!this.payloadTextField.getText().equals("")) {
                if (this.attachCB.isSelected()) {
                    this.setupPagesForMapMessagePayload(false, true);
                } else {
                    this.setupPagesForMapMessagePayload(false, false);
                }
            } else {
                this.setupPagesForMapMessagePayload(true, false);
            }
        } else {
            this.setupPagesForMapMessagePayload(false, false);
        }
    }

    private void setupPagesForMapMessagePayload(boolean mapmsg, boolean attach) {
        if (mapmsg || attach) {
            if (!this.jmsContext.isRequestReply) {
                if (mapmsg) {
                    this.jmsContext.isMapMessage = true;
                    this.jmsContext.isAttachment = false;
                } else if (attach) {
                    this.jmsContext.isAttachment = true;
                    this.jmsContext.isMapMessage = false;
                }
                this.removePages();
                this.addFinishPage();
                this.setFinishPage();
            } else {
                if (mapmsg) {
                    this.jmsContext.isMapMessage2 = true;
                    this.jmsContext.isAttachment2 = false;
                } else if (attach) {
                    this.jmsContext.isAttachment2 = true;
                    this.jmsContext.isMapMessage2 = false;
                }
                if (this.jmsContext.isMapMessage && this.jmsContext.isMapMessage2 || this.jmsContext.isAttachment && this.jmsContext.isAttachment2 || this.jmsContext.isMapMessage && this.jmsContext.isAttachment2 || this.jmsContext.isAttachment && this.jmsContext.isMapMessage2) {
                    this.removePages();
                    this.addFinishPage();
                    this.setFinishPage();
                } else {
                    this.removePages();
                    ImageWizardPage tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("JMS_SC_TITLE"));
                    if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
                        HelpSystem.getHelpSystem().registerTopic((JComponent)tempwp.getContent(), "bpmjdev_adp_wiz_jms_message");
                    }
                    JmsAdapterInOutSchemaPage dsp3 = new JmsAdapterInOutSchemaPage(this.m_wcontext, tempwp);
                    this.addFinishPage();
                    this.setFinishPage();
                }
            }
        } else {
            if (!this.jmsContext.isRequestReply) {
                this.jmsContext.isMapMessage = false;
                this.jmsContext.isAttachment = false;
            } else {
                this.jmsContext.isMapMessage2 = false;
                this.jmsContext.isAttachment2 = false;
            }
            if (this.jmsContext.b2bContext == null) {
                this.removePages();
                if (!this.jmsContext.isRequestReply) {
                    ImageWizardPage tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("JMS_SC_TITLE"));
                    if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
                        HelpSystem.getHelpSystem().registerTopic((JComponent)tempwp.getContent(), "bpmjdev_adp_wiz_message");
                    }
                    JmsAdapterSchemaPage schemapg = new JmsAdapterSchemaPage(this.m_wcontext, tempwp);
                } else {
                    ImageWizardPage tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("JMS_SC_TITLE"));
                    if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
                        HelpSystem.getHelpSystem().registerTopic((JComponent)tempwp.getContent(), "bpmjdev_adp_wiz_message");
                    }
                    JmsAdapterInOutSchemaPage dsp3 = new JmsAdapterInOutSchemaPage(this.m_wcontext, tempwp);
                }
                this.addFinishPage();
            } else {
                new JmsAdapterFinishPanel(this.m_wcontext, this);
            }
        }
    }

    private void setFinishPage() {
        new JmsAdapterFinishPanel(this.m_wcontext, this);
    }

    private void setNormalCursor() {
        this.setCursor(new Cursor(0));
    }

    private void importAttachmentMapMessageSchema(Definition def1, String schemaNamespace, String schemaUri, String schemaXsd, String schemaElement) throws WSDLException {
        PortType portt = null;
        if (this.m_wcontext._importedWsdlInfo != null) {
            portt = WsdlInfo.getPorttypeByQname((Project)this.m_wcontext._project, (QName)this.m_wcontext._importedWsdlInfo.getRequestPorttype());
        }
        if (this.m_wcontext._importedWsdlInfo == null) {
            boolean bImportSchema = true;
            if (this.jmsContext.isRequestReply && (this.jmsContext.isMapMessage || this.jmsContext.isAttachment)) {
                if (this.jmsContext.isMapMessage && this.jmsContext.isMapMessage2) {
                    bImportSchema = false;
                } else if (this.jmsContext.isAttachment && this.jmsContext.isAttachment2) {
                    bImportSchema = false;
                }
            }
            if (bImportSchema) {
                def1.addNamespace(schemaNamespace, schemaUri);
                Types types1 = this.m_wcontext.getWriteTypes();
                ImportSchema impschema = (ImportSchema)this.m_wcontext._extReg.createExtension(ImportSchema.PARENT_CLASS, ImportSchema.FIELD_ELEMENT_TYPE);
                impschema.setContext(this.m_wcontext);
                impschema.setNamespace(schemaUri);
                impschema.setLocation(schemaXsd);
                types1.addExtensibilityElement((ExtensibilityElement)impschema);
            }
            Message msg1 = def1.createMessage();
            if (this.jmsContext.isRequestReply && !this.jmsContext.IsSyncOperation) {
                msg1.setQName(new QName(this.m_wcontext._target_namespace, this.m_wcontext._write_operation2_name + IN_MSG_SUFFIX));
            } else {
                msg1.setQName(new QName(this.m_wcontext._target_namespace, this.m_wcontext._write_operation_name + this.m_wcontext.Message_suffix));
            }
            msg1.setUndefined(false);
            Part part1 = def1.createPart();
            part1.setName(BODY_PART_NAME);
            part1.setElementName(new QName(schemaUri, schemaElement));
            msg1.addPart(part1);
            def1.addMessage(msg1);
            Input input1 = def1.createInput();
            input1.setMessage(msg1);
            if (this.jmsContext.isRequestReply && !this.jmsContext.IsSyncOperation) {
                this.m_wcontext._write_operation_abstract = this.jmsContext.inboundOperation;
            }
            this.m_wcontext._write_operation_abstract.setInput(input1);
        }
    }

    private void setB2BSchema() throws WSDLException {
        Definition def1 = this.m_wcontext._write_definition;
        B2BContext ctx = this.jmsContext.b2bContext;
        Message msg1 = null;
        if (ctx.isOpaque()) {
            FileAdapterSchemaPage.buildOpaqueSchema(this.m_wcontext, def1);
        } else if (ctx.isAny()) {
            def1.addNamespace(SCHEMA_RELATIVE_LOCATION, "http://www.w3.org/2001/XMLSchema");
            msg1 = def1.createMessage();
            msg1.setQName(new QName(this.m_wcontext._target_namespace, this.m_wcontext._write_operation_name + this.m_wcontext.Message_suffix));
            msg1.setUndefined(false);
            Part part1 = def1.createPart();
            part1.setName(BODY_PART_NAME);
            part1.setTypeName(new QName("http://www.w3.org/2001/XMLSchema", "any"));
            msg1.addPart(part1);
            def1.addMessage(msg1);
            Input input1 = def1.createInput();
            input1.setMessage(msg1);
            this.m_wcontext._write_operation_abstract.setInput(input1);
        } else {
            def1.addNamespace("imp1", ctx.getSchemaTargetNamespace());
            Types types1 = this.m_wcontext.getWriteTypes();
            ImportSchema impschema = (ImportSchema)this.m_wcontext._extReg.createExtension(ImportSchema.PARENT_CLASS, ImportSchema.FIELD_ELEMENT_TYPE);
            impschema.setContext(this.m_wcontext);
            impschema.setNamespace(ctx.getSchemaTargetNamespace());
            String schemaURL = ctx.getDocumentDefinition().getDefinitionFilename();
            List xsdDirStructure = ctx.getXSDDirStructure(schemaURL);
            String relativeSchemaPath = ctx.getRelativeXsdDirStr(xsdDirStructure, true);
            String schemaFilename = ctx.getSchemaFilename(schemaURL);
            if (ctx.getMDSConnectionName() != null) {
                impschema.setLocation(schemaURL);
            } else {
                impschema.setLocation(SCHEMA_RELATIVE_LOCATION + relativeSchemaPath + schemaFilename);
            }
            types1.addExtensibilityElement((ExtensibilityElement)impschema);
            msg1 = def1.createMessage();
            msg1.setQName(new QName(this.m_wcontext._target_namespace, this.m_wcontext._write_operation_name + this.m_wcontext.Message_suffix));
            msg1.setUndefined(false);
            Part part1 = def1.createPart();
            part1.setName(BODY_PART_NAME);
            part1.setElementName(new QName(ctx.getSchemaTargetNamespace(), ctx.getSelectedRootElement()));
            msg1.addPart(part1);
            def1.addMessage(msg1);
            Input input1 = def1.createInput();
            input1.setMessage(msg1);
            this.m_wcontext._write_operation_abstract.setInput(input1);
        }
        def1.addNamespace(B2BUIExtensions.B2B_NAMESPACE, B2BUIExtensions.B2B_NAMESPACE_URI);
        B2BUIExtensions b2bExt = (B2BUIExtensions)this.m_wcontext._extReg.createExtension(B2BUIExtensions.PARENT_CLASS, B2BUIExtensions.FIELD_ELEMENT_TYPE);
        Hashtable ui_attrs = ctx.getOpAttributes();
        Enumeration e = ui_attrs.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String val = (String)ui_attrs.get(key);
            b2bExt.setAttributeValue(key, val);
        }
        this.m_wcontext._write_operation_abstract.addExtensibilityElement((ExtensibilityElement)b2bExt);
    }

    private final class getJMSDestinationList
    implements Runnable {
        private getJMSDestinationList() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                List connFactoryList = ((JmsAdapterConsumeParamPage)JmsAdapterConsumeParamPage.this).jmsContext.dataAccess.getJMSConnectionFactoryLocations(((JmsAdapterConsumeParamPage)JmsAdapterConsumeParamPage.this).jmsContext.selectedDestinationObject.isTopic(), ((JmsAdapterConsumeParamPage)JmsAdapterConsumeParamPage.this).jmsContext.selectedDestinationObject.getParent().getName());
                JmsAdapterConsumeParamPage.this.connectionFactoryComboBox.removeAllItems();
                JmsAdapterConsumeParamPage.this.connectionFactoryComboBox.addItem(JmsAdapterConsumeParamPage.this.getTranslatedString("CM_CN_NO_SELECTION_ITEM"));
                for (int i = 0; i < connFactoryList.size(); ++i) {
                    String currConnFactory = (String)connFactoryList.get(i);
                    JmsAdapterConsumeParamPage.this.connectionFactoryComboBox.addItem(currConnFactory);
                    if (currConnFactory.equals(((JmsAdapterConsumeParamPage)JmsAdapterConsumeParamPage.this).jmsContext.mcfConnectionFactoryLocation)) {
                        JmsAdapterConsumeParamPage.this.connectionFactoryComboBox.setSelectedItem(currConnFactory);
                    }
                    if (((JmsAdapterConsumeParamPage)JmsAdapterConsumeParamPage.this).jmsContext.jmsProvider.equals("OC4JJMS")) {
                        if (!currConnFactory.equals(JmsAdapterConsumeParamPage.DEFAULT_TOPIC_CONN_FACTORY) && !currConnFactory.equals(JmsAdapterConsumeParamPage.DEFAULT_QUEUE_CONN_FACTORY)) continue;
                        JmsAdapterConsumeParamPage.this.connectionFactoryComboBox.setSelectedItem(currConnFactory);
                        continue;
                    }
                    if (!((JmsAdapterConsumeParamPage)JmsAdapterConsumeParamPage.this).jmsContext.jmsProvider.equals("WLSJMS") || !currConnFactory.equals(JmsAdapterConsumeParamPage.DEFAULT_WL_CONN_FACTORY)) continue;
                    JmsAdapterConsumeParamPage.this.connectionFactoryComboBox.setSelectedItem(currConnFactory);
                }
            }
            catch (Exception e) {
                JmsAdapterConsumeParamPage.this.setNormalCursor();
                MultiLineOptionPane.showMessageDialog((Component)JmsAdapterConsumeParamPage.this.m_wcontext._parentFrame, (Object)JmsAdapterConsumeParamPage.this.getTranslatedString("JMS_CP_ERROR_DEST_BROWSE"), (String)JmsAdapterConsumeParamPage.this.getTranslatedString("JMS_ERROR"), (int)0);
            }
            finally {
                JmsAdapterConsumeParamPage.this.setNormalCursor();
            }
        }
    }
}

