/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.share.nls.StringUtils;
import oracle.tip.tools.ide.common.utils.PreviewUtil;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.FactoryPropsDialog;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JMSContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.techAdapterWizardPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.JcaAddress;

public class JmsAdapterConnectionPage
extends techAdapterWizardPage
implements DocumentListener,
ActionListener {
    public static final String MCF_MANAGED_CONNECTION_FACTORY = "ManagedConnectionFactory";
    public static final String MCF_MANAGED_CONNECTION_FACTORY_VALUE = "oracle.tip.adapter.jms.JmsManagedConnectionFactory";
    public static final String MCF_CONNECTION_FACTORY_LOCATION = "mcf.ConnectionFactoryLocation";
    public static final String MCF_FACTORY_PROPERTIES = "mcf.FactoryProperties";
    public static final String MCF_IS_TOPIC = "mcf.IsTopic";
    public static final String MCF_IS_TRANSACTED = "mcf.IsTransacted";
    public static final String MCF_USERNAME = "mcf.Username";
    public static final String MCF_PASSWORD = "mcf.Password";
    private static final String TOPIC = "Topic";
    private static final String QUEUE = "Queue";
    private MultiLineLabel introPrompt;
    private MultiLineLabel jndiIntroPrompt;
    private JLabel jmsServiceLB = new JLabel();
    private JTextField jmsServiceName = new JTextField();
    private JLabel connFactoryLocLabel = new JLabel();
    private JTextField connFactoryLocTextField = new JTextField();
    private JLabel factoryPropsLabel = new JLabel();
    private JTextField factoryPropsTextField = new JTextField();
    private JButton factoryPropsEditButton = new JButton();
    private JLabel transactedLabel = new JLabel();
    private JLabel destTypeLabel = new JLabel();
    private JComboBox transactedComboBox = new JComboBox();
    private JComboBox destTypeComboBox = new JComboBox();
    private JLabel usernameLabel = new JLabel();
    private JTextField usernameTextField = new JTextField();
    private JLabel passwordLabel = new JLabel();
    private JPasswordField passwordTextField = new JPasswordField();

    public JmsAdapterConnectionPage(AdapterWizardContext wcontext, ImageWizardPage iwp) {
        try {
            this.setContextAndPage(wcontext, iwp);
            this.createComponents();
            if (PreviewUtil.isInPreviewMode()) {
                this.layoutInPreviewMode();
            } else {
                this.layoutInNormalMode();
            }
            this.initialize();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createComponents() throws Exception {
        String intro = this.getTranslatedString("JMS_CN_CONNECTION_INTRO_PROMPT");
        String connFactoryLocText = this.getTranslatedString("JMS_CONNECTION_FACTORY_LOCATION");
        String connFactoryLocTip = this.getTranslatedString("JMS_CONNECTION_FACTORY_LOCATION_TIP");
        String factoryPropsText = this.getTranslatedString("JMS_CN_FACTORY_PROPERTIES");
        String factoryPropsTip = this.getTranslatedString("JMS_CN_FACTORY_PROPERTIES_TIP");
        String editText = this.getTranslatedString("JMS_CN_EDIT");
        String usernameText = this.getTranslatedString("CM_CN_USER_NAME_PROMPT");
        String passwordText = this.getTranslatedString("CM_CN_CONNECTION_PASSWORD");
        String jndiIntroText = this.getTranslatedString("JMS_CN_INTRO_PROMPT");
        String serverNameLB = this.getTranslatedString("JMS_CN_NAME_PROMPT");
        String serverNameTip = this.getTranslatedString("JMS_CN_NAME_TIP");
        String destTypeText = this.getTranslatedString("JMS_CP_DESTINATION_TYPE");
        String transactedText = this.getTranslatedString("JMS_CP_TRANSACTED");
        this.introPrompt = new MultiLineLabel(WordWrapper.getTextWrapper(), intro);
        this.connFactoryLocLabel.setText(StringUtils.stripMnemonic((String)connFactoryLocText));
        this.connFactoryLocLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)connFactoryLocText));
        this.connFactoryLocLabel.setLabelFor(this.connFactoryLocTextField);
        this.connFactoryLocTextField.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)connFactoryLocText));
        this.connFactoryLocTextField.getDocument().addDocumentListener(this);
        this.connFactoryLocTextField.setToolTipText(connFactoryLocTip);
        this.factoryPropsLabel.setText(factoryPropsText);
        this.factoryPropsLabel.setLabelFor(this.factoryPropsTextField);
        this.factoryPropsTextField.getAccessibleContext().setAccessibleName(factoryPropsText);
        this.factoryPropsTextField.setEditable(false);
        this.factoryPropsTextField.setToolTipText(factoryPropsTip);
        this.factoryPropsTextField.getDocument().addDocumentListener(this);
        this.factoryPropsEditButton.setText(StringUtils.stripMnemonic((String)editText));
        this.factoryPropsEditButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)editText));
        this.factoryPropsEditButton.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)editText));
        this.factoryPropsEditButton.addActionListener(this);
        this.usernameLabel.setText(StringUtils.stripMnemonic((String)usernameText));
        this.usernameLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)usernameText));
        this.usernameLabel.setLabelFor(this.usernameTextField);
        this.usernameTextField.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)usernameText));
        this.passwordLabel.setText(StringUtils.stripMnemonic((String)passwordText));
        this.passwordLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)passwordText));
        this.passwordLabel.setLabelFor(this.passwordTextField);
        this.passwordTextField.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)passwordText));
        this.transactedLabel.setText(StringUtils.stripMnemonic((String)transactedText));
        this.transactedLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)transactedText));
        this.transactedLabel.setLabelFor(this.transactedComboBox);
        this.transactedComboBox.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)transactedText));
        this.transactedComboBox.addItem("true");
        this.transactedComboBox.addItem("false");
        this.destTypeLabel.setText(StringUtils.stripMnemonic((String)destTypeText));
        this.destTypeLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)destTypeText));
        this.destTypeLabel.setLabelFor(this.destTypeComboBox);
        this.destTypeComboBox.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)destTypeText));
        this.destTypeComboBox.addItem(QUEUE);
        this.destTypeComboBox.addItem(TOPIC);
        this.jndiIntroPrompt = new MultiLineLabel(WordWrapper.getTextWrapper(), jndiIntroText);
        this.jmsServiceLB.setText(StringUtils.stripMnemonic((String)serverNameLB));
        this.jmsServiceLB.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)serverNameLB));
        this.jmsServiceLB.setLabelFor(this.jmsServiceName);
        this.jmsServiceName.setSize(new Dimension(20, 20));
        this.jmsServiceName.setPreferredSize(new Dimension(20, 20));
        this.jmsServiceName.setToolTipText(serverNameTip);
        this.jmsServiceName.getAccessibleContext().setAccessibleDescription(serverNameTip);
        this.jmsServiceName.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)serverNameLB));
        this.jmsServiceName.setText("eis/" + "Jms" + "/JmsAdapter");
    }

    private void initialize() {
        if (this.m_wcontext._read_service != null) {
            this.initFromWSDL();
        }
        this.validateInput();
    }

    private void layoutInPreviewMode() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.introPrompt, new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.factoryPropsLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.factoryPropsTextField, new GridBagConstraints(1, 1, 2, 1, 2.0, 0.0, 18, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.factoryPropsEditButton, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 12, 0, new Insets(8, 5, 0, 0), 0, 0));
        this.add((Component)this.connFactoryLocLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.connFactoryLocTextField, new GridBagConstraints(1, 2, 0, 1, 0.0, 0.0, 18, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.transactedLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.transactedComboBox, new GridBagConstraints(1, 3, 0, 1, 0.0, 0.0, 18, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.destTypeLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.destTypeComboBox, new GridBagConstraints(1, 4, 0, 1, 0.0, 0.0, 18, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.usernameLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.usernameTextField, new GridBagConstraints(1, 5, 0, 1, 0.0, 0.0, 18, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.passwordLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.passwordTextField, new GridBagConstraints(1, 6, 0, 1, 0.0, 0.0, 18, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.jndiIntroPrompt, new GridBagConstraints(0, 7, 0, 1, 1.0, 0.0, 18, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.jmsServiceLB, new GridBagConstraints(0, 8, 1, 1, 0.0, 2.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.jmsServiceName, new GridBagConstraints(1, 8, 0, 1, 0.0, 2.0, 18, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.usernameTextField.getDocument().addDocumentListener(this);
        this.passwordTextField.getDocument().addDocumentListener(this);
        this.jmsServiceName.getDocument().addDocumentListener(this);
        this.m_page.setCanAdvance(false);
    }

    private void layoutInNormalMode() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.jndiIntroPrompt, new GridBagConstraints(0, 7, 0, 1, 1.0, 0.0, 18, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.jmsServiceLB, new GridBagConstraints(0, 8, 1, 1, 0.0, 2.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.jmsServiceName, new GridBagConstraints(1, 8, 0, 1, 0.0, 2.0, 18, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.jmsServiceName.getDocument().addDocumentListener(this);
        this.m_page.setCanAdvance(false);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.validateInput();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.validateInput();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.validateInput();
    }

    private void validateInput() {
        if (!PreviewUtil.isInPreviewMode() && this.jmsServiceName.getText() != null && !this.jmsServiceName.getText().trim().equals("")) {
            this.m_page.setCanAdvance(true);
        } else if (PreviewUtil.isInPreviewMode() && this.factoryPropsTextField.getText() != null && !this.factoryPropsTextField.getText().trim().equals("") && this.connFactoryLocTextField.getText() != null && !this.connFactoryLocTextField.getText().trim().equals("") && this.jmsServiceName.getText() != null && !this.jmsServiceName.getText().trim().equals("")) {
            this.m_page.setCanAdvance(true);
        } else {
            this.m_page.setCanAdvance(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.factoryPropsEditButton) {
            FactoryPropsDialog factoryPropsDialog = new FactoryPropsDialog(this.m_wcontext);
            factoryPropsDialog.runDialog();
            this.factoryPropsTextField.setText(this.getMCFFactoryPropertiesValue());
            this.setFactoryProps(this.factoryPropsTextField.getText());
            String factoryPropsVal = this.factoryPropsTextField.getText();
            if (factoryPropsVal != null && !factoryPropsVal.trim().equals("")) {
                this.factoryPropsTextField.setToolTipText(factoryPropsVal);
            }
        }
    }

    private void initFromWSDL() {
        this.m_page.setCanAdvance(true);
        JMSContext jmsContext = (JMSContext)this.m_wcontext._ascontext;
        if (this.m_wcontext._read_jca_address != null && jmsContext != null) {
            JcaAddress jcaa = this.m_wcontext._read_jca_address;
            String mcfFactoryPropsVal = jcaa.getAttributeValue(MCF_FACTORY_PROPERTIES);
            this.factoryPropsTextField.setText(mcfFactoryPropsVal);
            this.setFactoryProps(mcfFactoryPropsVal);
            if (mcfFactoryPropsVal != null && !mcfFactoryPropsVal.trim().equals("")) {
                this.factoryPropsTextField.setToolTipText(this.factoryPropsTextField.getText());
            }
            String mcfConnectionFactoryLocation = jcaa.getAttributeValue(MCF_CONNECTION_FACTORY_LOCATION);
            this.connFactoryLocTextField.setText(mcfConnectionFactoryLocation);
            String mcfIsTransacted = jcaa.getAttributeValue(MCF_IS_TRANSACTED);
            this.transactedComboBox.setSelectedItem(mcfIsTransacted);
            String mcfDestType = jcaa.getAttributeValue(MCF_IS_TOPIC);
            if ("true".equals(mcfDestType)) {
                this.destTypeComboBox.setSelectedItem(TOPIC);
            } else {
                this.destTypeComboBox.setSelectedItem(QUEUE);
            }
            String jmsServiceNameText = jcaa.getAdapterInstanceJndi();
            this.jmsServiceName.setText(jmsServiceNameText);
            String username = jcaa.getAttributeValue(MCF_USERNAME);
            this.usernameTextField.setText(username);
            String password = jcaa.getAttributeValue(MCF_PASSWORD);
            this.passwordTextField.setText(password);
        }
    }

    private String getMCFFactoryPropertiesValue() {
        String DELIMITER = ";";
        String EQUAL = "=";
        String mcfFactoryPropsValue = "";
        int propCount = 0;
        JMSContext jmsContext = (JMSContext)this.m_wcontext._ascontext;
        if (jmsContext != null && jmsContext.factoryProps != null && jmsContext.factoryProps.size() > 0) {
            for (int i = 0; i < jmsContext.factoryProps.size(); ++i) {
                Vector currentRow = (Vector)jmsContext.factoryProps.get(i);
                if (currentRow == null || currentRow.size() <= 0) continue;
                String name = (String)currentRow.get(0);
                String value = (String)currentRow.get(1);
                if (name == null || name.trim().equals("") || value == null || value.trim().equals("")) continue;
                mcfFactoryPropsValue = ++propCount == 1 ? name + "=" + value : mcfFactoryPropsValue + ";" + name + "=" + value;
            }
        }
        return mcfFactoryPropsValue;
    }

    private void setFactoryProps(String mcfFactoryProps) {
        JMSContext jmsContext = (JMSContext)this.m_wcontext._ascontext;
        jmsContext.factoryProps = null;
        if (mcfFactoryProps != null && !mcfFactoryProps.trim().equals("")) {
            jmsContext.factoryProps = new Vector();
            if (mcfFactoryProps != null && !mcfFactoryProps.trim().equals("")) {
                StringTokenizer strTokenizer = new StringTokenizer(mcfFactoryProps, ";");
                while (strTokenizer.hasMoreTokens()) {
                    String currentToken = strTokenizer.nextToken();
                    StringTokenizer nameValuePairToken = new StringTokenizer(currentToken, "=");
                    String name = null;
                    String value = null;
                    if (nameValuePairToken.hasMoreTokens()) {
                        name = nameValuePairToken.nextToken();
                    }
                    if (nameValuePairToken.hasMoreTokens()) {
                        value = nameValuePairToken.nextToken();
                    }
                    if (name == null) continue;
                    Vector<String> row = new Vector<String>();
                    row.add(name);
                    row.add(value);
                    jmsContext.factoryProps.add(row);
                }
            }
        }
    }

    @Override
    public void buildWSDL() throws WSDLException {
        JcaAddress jcaa = (JcaAddress)this.m_wcontext._extReg.createExtension(JcaAddress.PARENT_CLASS, JcaAddress.FIELD_ELEMENT_TYPE);
        this.m_wcontext._write_port.addExtensibilityElement((ExtensibilityElement)jcaa);
        String jndiStr = this.jmsServiceName.getText().trim();
        jcaa.setAdapterInstanceJndi(jndiStr);
        if (PreviewUtil.isInPreviewMode()) {
            jcaa.setAttributeValue(MCF_MANAGED_CONNECTION_FACTORY, MCF_MANAGED_CONNECTION_FACTORY_VALUE);
            jcaa.setAttributeValue(MCF_CONNECTION_FACTORY_LOCATION, this.connFactoryLocTextField.getText());
            jcaa.setAttributeValue(MCF_FACTORY_PROPERTIES, this.factoryPropsTextField.getText());
            String selectedDestType = (String)this.destTypeComboBox.getSelectedItem();
            if (selectedDestType != null && selectedDestType.equals(TOPIC)) {
                jcaa.setAttributeValue(MCF_IS_TOPIC, "true");
            } else if (selectedDestType != null && selectedDestType.equals(QUEUE)) {
                jcaa.setAttributeValue(MCF_IS_TOPIC, "false");
            }
            jcaa.setAttributeValue(MCF_IS_TRANSACTED, (String)this.transactedComboBox.getSelectedItem());
            jcaa.setAttributeValue(MCF_USERNAME, this.usernameTextField.getText());
            jcaa.setAttributeValue(MCF_PASSWORD, new String(this.passwordTextField.getPassword()));
        }
        this.m_wcontext._write_jca_address = jcaa;
    }
}

