/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.share.nls.StringUtils;
import oracle.tip.tools.ide.common.utils.MultiLineOptionPane;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JMSContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JMSDestObject;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JMSDestTree;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JMSParentObject;

public class JmsAdapterBrowseDestPanel
extends JPanel
implements ActionListener {
    private AdapterWizardContext m_wcontext;
    private MultiLineLabel introLabel;
    private JPanel destTreePanel = new JPanel();
    private JPanel searchPanel = new JPanel();
    private JPanel searchButtonPanel = new JPanel();
    private JButton searchButton = new JButton();
    private JButton showAllButton = new JButton();
    private JTextField destNameTextField = new JTextField();
    private JLabel destNameLabel = new JLabel();
    private JLabel destTypeLabel = new JLabel();
    private JComboBox destTypeComboBox;
    private JScrollPane destTreeView;
    private JMSDestTree destTree;
    private JMSContext jmsContext;
    private JEWTDialog parentDialog;

    public JmsAdapterBrowseDestPanel(AdapterWizardContext wcontext, JEWTDialog parentDialog) throws Exception {
        this.m_wcontext = wcontext;
        this.parentDialog = parentDialog;
        this.jmsContext = (JMSContext)this.m_wcontext._ascontext;
        this.jmsContext.initDataAccess(this.m_wcontext);
        this.jbInit();
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        String introText = this.getTranslatedString("JMS_DD_INTRO_PROMPT");
        String searchText = this.getTranslatedString("JMS_DD_SEARCH");
        String searchTip = this.getTranslatedString("JMS_DD_SEARCH_TIP");
        String destNameText = this.getTranslatedString("JMS_DD_DESTINATION_NAME");
        String destTypeText = this.getTranslatedString("JMS_DD_DESTINATION_TYPE");
        String destTypeTip = this.getTranslatedString("JMS_DD_DESTINATION_TYPE_TIP");
        String destNameTip = this.getTranslatedString("JMS_DD_DESTINATION_NAME_TIP");
        String showAllText = this.getTranslatedString("JMS_DD_SHOW_ALL");
        String showAllTip = this.getTranslatedString("JMS_DD_SHOW_ALL_TIP");
        String destText = this.getTranslatedString("JMS_DD_DESTINATIONS");
        this.introLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), introText);
        this.searchButton.setText(StringUtils.stripMnemonic((String)searchText));
        this.searchButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)searchText));
        this.searchButton.setToolTipText(searchTip);
        this.searchButton.getAccessibleContext().setAccessibleDescription(searchTip);
        this.searchButton.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)searchText));
        this.searchButton.addActionListener(this);
        this.showAllButton.setText(StringUtils.stripMnemonic((String)showAllText));
        this.showAllButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)showAllText));
        this.showAllButton.setToolTipText(showAllTip);
        this.showAllButton.getAccessibleContext().setAccessibleDescription(showAllTip);
        this.showAllButton.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)showAllText));
        this.showAllButton.addActionListener(this);
        this.destTypeComboBox = new JComboBox();
        this.destTypeLabel.setText(StringUtils.stripMnemonic((String)destTypeText));
        this.destTypeLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)destTypeText));
        this.destTypeLabel.setLabelFor(this.destTypeComboBox);
        this.destTypeComboBox.setToolTipText(destTypeTip);
        this.destTypeComboBox.getAccessibleContext().setAccessibleDescription(destTypeTip);
        this.destTypeComboBox.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)destTypeText));
        this.initDestTypeComboBox();
        this.destNameLabel.setText(StringUtils.stripMnemonic((String)destNameText));
        this.destNameLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)destNameText));
        this.destNameLabel.setLabelFor(this.destNameTextField);
        this.destNameTextField.setToolTipText(destNameTip);
        this.destNameTextField.getAccessibleContext().setAccessibleDescription(destNameTip);
        this.destNameTextField.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)destNameText));
        this.destTree = new JMSDestTree(this.m_wcontext, (String)this.destTypeComboBox.getSelectedItem(), this);
        this.destTreeView = new JScrollPane(this.destTree);
        this.destTreeView.getAccessibleContext().setAccessibleName(destText);
        this.searchButtonPanel.setLayout(new GridBagLayout());
        this.searchButtonPanel.add((Component)this.searchButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.searchButtonPanel.add((Component)this.showAllButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.searchPanel.setLayout(new GridBagLayout());
        this.searchPanel.setBorder(BorderFactory.createTitledBorder(StringUtils.stripMnemonic((String)searchText)));
        this.searchPanel.add((Component)this.destTypeLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 10, 5, 0), 0, 0));
        this.searchPanel.add((Component)this.destTypeComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 10, 5, 20), 0, 0));
        this.searchPanel.add((Component)this.destNameLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 10, 5, 0), 0, 0));
        this.searchPanel.add((Component)this.destNameTextField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 10, 5, 20), 0, 0));
        this.searchPanel.add((Component)this.searchButtonPanel, new GridBagConstraints(1, 2, 3, 1, 0.0, 0.0, 16, 0, new Insets(5, 190, 5, 0), 0, 0));
        this.destTreePanel.setLayout(new GridBagLayout());
        this.destTreePanel.setBorder(BorderFactory.createTitledBorder(StringUtils.stripMnemonic((String)destText)));
        this.destTreePanel.add((Component)this.destTreeView, new GridBagConstraints(0, 0, 0, 4, 3.0, 2.0, 18, 1, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.introLabel, new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.searchPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.destTreePanel, new GridBagConstraints(0, 2, 0, 4, 3.0, 2.0, 18, 1, new Insets(10, 0, 0, 0), 0, 0));
    }

    private void initDestTypeComboBox() {
        if (this.destTypeComboBox != null) {
            this.destTypeComboBox.addItem("All Types");
            this.destTypeComboBox.addItem("Queues");
            this.destTypeComboBox.addItem("Topics");
        }
    }

    public String getTranslatedString(String messageKey) {
        return this.m_wcontext._bundle.getString(messageKey);
    }

    protected void updateControls(boolean close) {
        Object userObject;
        this.showAllButton.setEnabled(true);
        this.searchButton.setEnabled(true);
        this.parentDialog.setOKButtonEnabled(false);
        if (this.jmsContext.selectedDestTreeNode != null && (userObject = this.jmsContext.selectedDestTreeNode.getUserObject()) instanceof JMSDestObject) {
            this.parentDialog.setOKButtonEnabled(true);
        }
        this.setCursor(new Cursor(0));
        if (close) {
            this.parentDialog.dispose();
        }
    }

    private void performSearch(JMSParentObject parentObj, String destType, String destName, String displayMsg) throws Exception {
        this.setCursor(new Cursor(3));
        this.jmsContext.selectedDestTreeNode = null;
        this.showAllButton.setEnabled(false);
        this.searchButton.setEnabled(false);
        this.parentDialog.setOKButtonEnabled(false);
        this.destTree.displayMessage(displayMsg);
        this.destTree.setRootText(destType);
        Thread worker = new Thread(new Searcher(destType, destName));
        worker.start();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.searchButton) {
            try {
                Object selJMSObj;
                JMSParentObject parentObj = null;
                if (this.jmsContext.selectedDestTreeNode != null && (selJMSObj = this.jmsContext.selectedDestTreeNode.getUserObject()) != null) {
                    if (selJMSObj instanceof JMSParentObject) {
                        parentObj = (JMSParentObject)this.jmsContext.selectedDestTreeNode.getUserObject();
                    } else if (selJMSObj instanceof JMSDestObject) {
                        JMSDestObject destObj = (JMSDestObject)selJMSObj;
                        parentObj = destObj.getParent();
                    }
                }
                String destType = (String)this.destTypeComboBox.getSelectedItem();
                String destName = this.destNameTextField.getText();
                this.performSearch(parentObj, destType, destName, this.getTranslatedString("JMS_DD_SEARCHING"));
            }
            catch (Exception e) {
                this.destTree.displayMessage(this.getTranslatedString("JMS_DD_ERROR_OCCURRED"));
                MultiLineOptionPane.showMessageDialog((Component)this.m_wcontext._parentFrame, (Object)this.getTranslatedString("JMS_DD_SEARCH_ERROR"), (String)this.getTranslatedString("JMS_ERROR"), (int)0);
                e.printStackTrace();
            }
        } else if (event.getSource() == this.showAllButton) {
            try {
                this.performSearch(null, "All Types", null, this.getTranslatedString("JMS_DD_RELOADING"));
            }
            catch (Exception e) {
                this.destTree.displayMessage(this.getTranslatedString("JMS_DD_ERROR_OCCURRED"));
                MultiLineOptionPane.showMessageDialog((Component)this.m_wcontext._parentFrame, (Object)this.getTranslatedString("JMS_DD_SEARCH_ERROR"), (String)this.getTranslatedString("JMS_ERROR"), (int)0);
                e.printStackTrace();
            }
        }
    }

    private void setCurrentCursor(int cursor) {
        this.setCursor(new Cursor(cursor));
    }

    private final class SearchResultsUpdater
    implements Runnable {
        private List searchResults = null;
        private Exception e = null;

        public SearchResultsUpdater(List searchResults) {
            this.searchResults = searchResults;
        }

        public SearchResultsUpdater(Exception e) {
            this.e = e;
        }

        @Override
        public void run() {
            try {
                if (this.e == null) {
                    JmsAdapterBrowseDestPanel.this.destTree.showSearchResults(this.searchResults);
                    JmsAdapterBrowseDestPanel.this.updateControls(false);
                } else {
                    JmsAdapterBrowseDestPanel.this.destTree.displayMessage(JmsAdapterBrowseDestPanel.this.getTranslatedString("JMS_DD_ERROR_OCCURRED"));
                    JmsAdapterBrowseDestPanel.this.updateControls(false);
                    this.displaySearchErrorDialog();
                    this.e.printStackTrace();
                }
            }
            catch (Exception e) {
                JmsAdapterBrowseDestPanel.this.updateControls(false);
                JmsAdapterBrowseDestPanel.this.destTree.displayMessage(JmsAdapterBrowseDestPanel.this.getTranslatedString("JMS_DD_ERROR_OCCURRED"));
                this.displaySearchErrorDialog();
                e.printStackTrace();
            }
        }

        private void displaySearchErrorDialog() {
            String errTitle = JmsAdapterBrowseDestPanel.this.getTranslatedString("JMS_DD_ERROR");
            String errMsg = JmsAdapterBrowseDestPanel.this.getTranslatedString("JMS_DD_SEARCH_ERROR");
            MultiLineOptionPane.showMessageDialog((Component)((JmsAdapterBrowseDestPanel)JmsAdapterBrowseDestPanel.this).m_wcontext._parentFrame, (Object)errMsg, (String)errTitle, (int)0);
        }
    }

    private final class Searcher
    implements Runnable {
        private String destType;
        private String destName;

        public Searcher(String destinationType, String destinationName) {
            this.destType = destinationType;
            this.destName = destinationName;
        }

        @Override
        public void run() {
            try {
                JmsAdapterBrowseDestPanel.this.setCurrentCursor(3);
                List searchResults = ((JmsAdapterBrowseDestPanel)JmsAdapterBrowseDestPanel.this).jmsContext.dataAccess.getJMSDestinations(this.destType, this.destName);
                SwingUtilities.invokeLater(new SearchResultsUpdater(searchResults));
            }
            catch (Exception e) {
                SwingUtilities.invokeLater(new SearchResultsUpdater(e));
                JmsAdapterBrowseDestPanel.this.setCurrentCursor(0);
            }
        }
    }
}

