/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JTree;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import oracle.tip.tools.ide.common.ui.DoubleClickListener;
import oracle.tip.tools.ide.common.utils.MultiLineOptionPane;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JMSContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JMSDataAccess;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JMSDestObject;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JMSParentObject;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JMSTreeNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JmsAdapterBrowseDestPanel;

public class JMSDestTree
extends JTree
implements TreeExpansionListener,
TreeSelectionListener {
    private DefaultMutableTreeNode root = null;
    private DefaultTreeModel treeModel = null;
    private AdapterWizardContext m_wcontext = null;
    private String rootText;
    private JMSContext jmsContext;
    private JMSDataAccess dataAccess;
    private JmsAdapterBrowseDestPanel parentPanel;
    protected EventListenerList m_doubleClickListenerList = new EventListenerList();

    public JMSDestTree(AdapterWizardContext wcontext, String rootText, JmsAdapterBrowseDestPanel parentPnl) throws Exception {
        this.setVisible(true);
        this.setRootVisible(true);
        this.addTreeExpansionListener(this);
        this.addTreeSelectionListener(this);
        this.addDoubleClickListener(new DoubleClickListener(){

            public void onDoubleClick(Object src) {
                if (src instanceof JMSDestTree) {
                    ((JMSDestTree)JMSDestTree.this).jmsContext.selectedDestTreeNode = (JMSTreeNode)((JMSDestTree)src).getLastSelectedPathComponent();
                    ((JMSDestTree)JMSDestTree.this).jmsContext.selectedDestinationObject = JMSDestTree.this.getSelectedDestinationObject(((JMSDestTree)JMSDestTree.this).jmsContext.selectedDestTreeNode);
                    JMSDestTree.this.parentPanel.updateControls(true);
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    JMSDestTree.this.fireDoubleClickEvent();
                }
            }
        });
        this.getSelectionModel().setSelectionMode(1);
        this.m_wcontext = wcontext;
        this.parentPanel = parentPnl;
        this.jmsContext = (JMSContext)this.m_wcontext._ascontext;
        this.dataAccess = this.jmsContext.dataAccess;
        this.setRootText(rootText);
        this.displayMessage(this.getTranslatedString("JMS_DD_LOAD_DEST"));
        this.setCurrentCursor(3);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    JMSDestTree.this.createNodes();
                    JMSDestTree.this.setCurrentCursor(0);
                }
                catch (Exception e) {
                    DefaultMutableTreeNode root = new DefaultMutableTreeNode(JMSDestTree.this.getTranslatedString("JMS_DD_NO_DESTINATIONS_FOUND"));
                    JMSDestTree.this.treeModel.setRoot(root);
                    JMSDestTree.this.setTreeModel(JMSDestTree.this.treeModel);
                    JMSDestTree.this.setCurrentCursor(0);
                    JMSDestTree.this.displayMessage(JMSDestTree.this.getTranslatedString("JMS_DD_ERROR_OCCURRED"));
                    MultiLineOptionPane.showMessageDialog((Component)((JMSDestTree)JMSDestTree.this).m_wcontext._parentFrame, (Object)JMSDestTree.this.getTranslatedString("JMS_DD_SEARCH_ERROR"), (String)JMSDestTree.this.getTranslatedString("JMS_ERROR"), (int)0);
                    e.printStackTrace();
                }
            }
        };
        new Thread(r).start();
    }

    public void createNodes() throws Exception {
        this.root = new DefaultMutableTreeNode(this.getRootText());
        this.treeModel = new DefaultTreeModel(this.root);
        List objList = this.dataAccess.getJMSDestinations(null, null);
        if (objList != null && objList.size() > 0) {
            for (int i = 0; i < objList.size(); ++i) {
                Object currentObj = objList.get(i);
                JMSTreeNode treeNode = new JMSTreeNode(currentObj);
                this.root.add(treeNode);
            }
        } else {
            String text = this.getTranslatedString("JMS_DD_NO_DESTINATIONS_FOUND");
            DefaultMutableTreeNode root = new DefaultMutableTreeNode(text);
            this.treeModel.setRoot(root);
        }
        this.setModel(this.treeModel);
        if (objList != null && objList.size() <= 50) {
            this.expandAll();
        } else {
            this.expandRow(0);
        }
        this.setSelectionPath(this.getPathForRow(0));
        this.jmsContext.selectedDestTreeNode = null;
    }

    protected void showSearchResults(List objList) throws Exception {
        this.treeModel = new DefaultTreeModel(null);
        if (objList != null && objList.size() > 0) {
            DefaultMutableTreeNode root = new DefaultMutableTreeNode(this.getRootText());
            this.buildTree(root, objList);
            this.treeModel.setRoot(root);
        } else {
            String searchResultsText = this.getTranslatedString("JMS_DD_NO_DESTINATIONS_FOUND");
            DefaultMutableTreeNode root = new DefaultMutableTreeNode(searchResultsText);
            this.treeModel.setRoot(root);
        }
        this.setModel(this.treeModel);
        if (objList != null && objList.size() <= 50) {
            this.expandAll();
        }
        this.setSelectionPath(this.getPathForRow(0));
    }

    private void buildTree(DefaultMutableTreeNode node, List objList) throws Exception {
        for (int i = 0; i < objList.size(); ++i) {
            JMSTreeNode currTreeNode;
            Object currentObj = objList.get(i);
            if (currentObj instanceof JMSParentObject) {
                JMSParentObject parentObj = (JMSParentObject)currentObj;
                currTreeNode = new JMSTreeNode(parentObj);
                node.add(currTreeNode);
                List children = parentObj.getChildren();
                if (children == null || children.size() <= 0) continue;
                this.buildTree(currTreeNode, children);
                continue;
            }
            if (!(currentObj instanceof JMSDestObject)) continue;
            JMSDestObject destObj = (JMSDestObject)currentObj;
            currTreeNode = new JMSTreeNode(destObj);
            node.add(currTreeNode);
        }
    }

    private void expandAll() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.expandRow(i);
        }
    }

    public void displayMessage(String message) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(message);
        this.treeModel = new DefaultTreeModel(root);
        this.setModel(this.treeModel);
    }

    public String getTranslatedString(String messageKey) {
        return this.m_wcontext._bundle.getString(messageKey);
    }

    public void setRootText(String text) {
        this.rootText = text;
    }

    public String getRootText() {
        return this.rootText;
    }

    private void removeChildren(JMSTreeNode treeNode) {
        int childrenCount;
        if (treeNode != null && (childrenCount = this.treeModel.getChildCount(treeNode)) > 0) {
            --childrenCount;
            while (childrenCount >= 0) {
                JMSTreeNode currTreeNode = (JMSTreeNode)this.treeModel.getChild(treeNode, childrenCount);
                this.treeModel.removeNodeFromParent(currTreeNode);
                --childrenCount;
            }
        }
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
    }

    @Override
    public void treeExpanded(TreeExpansionEvent event) {
        try {
            TreePath treePath = event.getPath();
            if (treePath != null) {
                this.jmsContext.selectedDestTreeNode = this.getSelectedTreeNode(treePath);
                Object[] selectedPath = treePath.getPath();
                if (treePath.getPathCount() > 1) {
                    JMSParentObject parentObj;
                    List objList;
                    JMSTreeNode selTreeNode = (JMSTreeNode)treePath.getLastPathComponent();
                    this.removeChildren(selTreeNode);
                    Object currentUserObj = selTreeNode.getUserObject();
                    if (currentUserObj instanceof JMSParentObject && (objList = (parentObj = (JMSParentObject)selTreeNode.getUserObject()).getChildren()) != null) {
                        for (int i = 0; i < objList.size(); ++i) {
                            Object dataObj = objList.get(i);
                            JMSTreeNode jmsTreeNode = new JMSTreeNode(dataObj);
                            this.treeModel.insertNodeInto(jmsTreeNode, selTreeNode, i);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            MultiLineOptionPane.showMessageDialog((Component)this.m_wcontext._parentFrame, (Object)this.getTranslatedString("JMS_DD_GET_DEST_ERROR"), (String)this.getTranslatedString("JMS_ERROR"), (int)0);
            e.printStackTrace();
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent event) {
        TreePath treePath = event.getPath();
        this.jmsContext.selectedDestTreeNode = this.getSelectedTreeNode(treePath);
        this.jmsContext.selectedDestinationObject = this.getSelectedDestinationObject(this.jmsContext.selectedDestTreeNode);
        this.parentPanel.updateControls(false);
    }

    private JMSTreeNode getSelectedTreeNode(TreePath treePath) {
        MutableTreeNode currentNode;
        JMSTreeNode jmsTreeNode = null;
        if (treePath != null && (currentNode = (MutableTreeNode)treePath.getLastPathComponent()) != null && currentNode instanceof JMSTreeNode) {
            jmsTreeNode = (JMSTreeNode)currentNode;
        }
        return jmsTreeNode;
    }

    private JMSDestObject getSelectedDestinationObject(JMSTreeNode jmsTreeNode) {
        Object jmsObj;
        JMSDestObject destObj = null;
        if (jmsTreeNode != null && (jmsObj = jmsTreeNode.getUserObject()) instanceof JMSDestObject) {
            destObj = (JMSDestObject)jmsObj;
        }
        return destObj;
    }

    private void setCurrentCursor(int cursor) {
        this.parentPanel.setCursor(new Cursor(cursor));
    }

    private void setTreeModel(DefaultTreeModel model) {
        this.setModel(model);
    }

    public void addDoubleClickListener(DoubleClickListener l) {
        this.m_doubleClickListenerList.add(DoubleClickListener.class, l);
    }

    protected void fireDoubleClickEvent() {
        Object[] listeners = this.m_doubleClickListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DoubleClickListener.class) continue;
            ((DoubleClickListener)listeners[i + 1]).onDoubleClick((Object)this);
        }
    }
}

