/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms;

import java.io.InputStream;
import java.util.Properties;
import oracle.rc.asadapter.connection.ConnectionDescriptor;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JMSConnection;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JMSDataAccess;

public class JMSDataAccessFactory {
    public static final String JMS_WIZARD_PROPERTIES = "oracle/tip/tools/ide/pm/modules/bizintegration/adapter/jms/jms_wizard.properties";

    public static JMSDataAccess getDataAccessInstance(String jmsProvider, JMSConnection jmsConn, ConnectionDescriptor jmsConnDesc, String connName) throws Exception {
        String dataAccessClassName = JMSDataAccessFactory.getDataAccessClassName(jmsProvider);
        if (dataAccessClassName != null && !dataAccessClassName.trim().equals("")) {
            JMSDataAccess jmsDataAccess = (JMSDataAccess)Class.forName(dataAccessClassName).newInstance();
            jmsDataAccess.setJMSConnection(jmsConn);
            jmsDataAccess.setJmsConnDescriptor(jmsConnDesc);
            jmsDataAccess.setJmsConnName(connName);
            return jmsDataAccess;
        }
        return null;
    }

    private static String getDataAccessClassName(String jmsProvider) throws Exception {
        Properties props = new Properties();
        InputStream stream = null;
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            stream = cl.getResourceAsStream(JMS_WIZARD_PROPERTIES);
            if (stream != null) {
                props.load(stream);
            } else {
                System.out.println("ERROR: could not open oracle/tip/tools/ide/pm/modules/bizintegration/adapter/jms/jms_wizard.properties");
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
        return props.getProperty(jmsProvider);
    }
}

