/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms;

import java.util.Vector;
import javax.wsdl.Operation;
import oracle.jdeveloper.server.connection.AppServer;
import oracle.jdeveloper.server.connection.AppServerManager;
import oracle.rc.asadapter.connection.AppServerConnection;
import oracle.rc.asadapter.connection.ConnectionDescriptor;
import oracle.rc.asadapter.connection.Presentation;
import oracle.rc.asadapter.weblogic.connection.WeblogicPresentationType;
import oracle.rc.asadapter.weblogic.mbean.WeblogicServerMBeanModel;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.b2b.B2BContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JMSConnection;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JMSDataAccess;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JMSDataAccessFactory;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JMSDestObject;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JMSParentObject;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JMSTreeNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.JcaOperation;

public class JMSContext {
    public String destinationName = null;
    public String jmsProvider = null;
    public JMSConnection jmsConnection = null;
    public ConnectionDescriptor jmsConnDesc = null;
    public JMSDataAccess dataAccess = null;
    public JMSTreeNode selectedDestTreeNode = null;
    public JMSDestObject selectedDestinationObject = null;
    public JMSDestObject replyDestinationObject = null;
    public String mcfConnectionFactoryLocation = null;
    public String resourceProviderName = null;
    public boolean isTopic;
    public boolean isTransacted;
    public boolean isMapMessage;
    public boolean isRequestReply = false;
    public boolean isAttachment = false;
    public B2BContext b2bContext = null;
    public boolean IsSyncOperation = true;
    public Operation inboundOperation;
    public Operation outboundOperation;
    public JcaOperation inboundJcaOperation;
    public JcaOperation outboundJcaOperation;
    public boolean isMapMessage2 = false;
    public boolean isAttachment2 = false;
    public Vector factoryProps;

    public String formDestinationNameOJMS(String resourceProviderName) {
        String schema = null;
        String type = null;
        String name = null;
        String fullDestName = null;
        if (resourceProviderName == null || resourceProviderName.trim().equals("")) {
            resourceProviderName = "<ENTER_RESOURCE_PROVIDER_NAME>";
        }
        if (this.selectedDestinationObject != null) {
            type = this.selectedDestinationObject.isTopic() ? "Topics" : "Queues";
            if (this.selectedDestinationObject.getParent() != null) {
                schema = this.selectedDestinationObject.getParent().getName();
            }
            name = this.selectedDestinationObject.getName();
        } else if (this.destinationName != null) {
            type = this.getDestTypeOJMS(this.destinationName);
            schema = this.getSchemaOJMS(this.destinationName);
            name = this.getQueueOrTopicNameOJMS(this.destinationName);
        }
        if (type != null && schema != null && name != null) {
            fullDestName = "java:comp/resource/" + resourceProviderName + "/" + type + "/" + schema + "." + name;
        }
        return fullDestName;
    }

    public String formDestinationNameAQJMS() {
        String jndiName = null;
        String destName = null;
        if (this.selectedDestinationObject != null) {
            destName = this.selectedDestinationObject.getName();
            jndiName = this.selectedDestinationObject.getJndiName();
            if (jndiName == null || jndiName.equals("")) {
                jndiName = destName;
            }
        }
        return jndiName;
    }

    public String getDestTypeOJMS(String destName) {
        String parsedStr = null;
        String type = null;
        if (destName != null && destName.length() > 0) {
            String pattern = "java:comp/resource/";
            parsedStr = destName.substring(pattern.length());
            int start = parsedStr.indexOf("/");
            int end = parsedStr.indexOf("/", ++start);
            if (start > 0 && start < end) {
                type = parsedStr.substring(start, end);
                parsedStr = parsedStr.substring(end + 1);
            }
        }
        return type;
    }

    public String getSchemaOJMS(String destName) {
        int end;
        int start;
        String schema = null;
        if (destName != null && destName.length() > 0 && (start = destName.lastIndexOf("/", destName.length()) + 1) > -1 && start < (end = destName.indexOf("."))) {
            schema = destName.substring(start, end);
        }
        return schema;
    }

    public String getQueueOrTopicNameOJMS(String fullDestName) {
        int end;
        int start;
        String name = null;
        if (fullDestName != null && !fullDestName.trim().equals("") && (start = fullDestName.lastIndexOf(".", fullDestName.length()) + 1) > -1 && start < (end = fullDestName.length())) {
            name = fullDestName.substring(start, end);
        }
        return name;
    }

    public String getResourceProviderNameOJMS(String fullDestination) {
        String pattern;
        String resourceProviderName = null;
        if (fullDestination != null && fullDestination.length() > 0 && fullDestination.startsWith(pattern = "java:comp/resource/")) {
            int start = pattern.length();
            int end = fullDestination.indexOf("/", start);
            if (start > 0 && end > start) {
                resourceProviderName = fullDestination.substring(start, end);
            }
        }
        return resourceProviderName;
    }

    public String formDestinationNameOC4JJMS() {
        String fullDestName = null;
        String SEPARATOR = "/";
        if (this.selectedDestinationObject != null) {
            fullDestName = this.selectedDestinationObject.getName();
            for (JMSParentObject parentObj = this.selectedDestinationObject.getParent(); parentObj != null; parentObj = parentObj.getParent()) {
                fullDestName = parentObj.getName() + "/" + fullDestName;
            }
        }
        return fullDestName;
    }

    public String formConnectionFactoryLocationOJMS(String resourceProvider, boolean isTopic) {
        if (resourceProvider != null && !resourceProvider.trim().equals("")) {
            if (isTopic) {
                return "java:comp/resource/" + resourceProvider + "/TopicConnectionFactories/TCF";
            }
            return "java:comp/resource/" + resourceProvider + "/QueueConnectionFactories/QCF";
        }
        return null;
    }

    public void initDataAccess(AdapterWizardContext wcontext) throws Exception {
        if (this.jmsProvider.equals("OJMS")) {
            this.jmsConnection = new JMSConnection(wcontext._connection);
        } else if (this.jmsProvider.equals("OC4JJMS") || this.jmsProvider.equals("WLSJMS")) {
            this.jmsConnection = new JMSConnection(wcontext._appServerConnection);
            this.jmsConnDesc = wcontext._connDescriptor;
        }
        this.dataAccess = JMSDataAccessFactory.getDataAccessInstance(this.jmsProvider, this.jmsConnection, this.jmsConnDesc, wcontext._uiConnectionName);
    }

    public String formDestinationNameWLJMS() {
        String jndiName = null;
        String destName = null;
        if (this.selectedDestinationObject != null) {
            destName = this.selectedDestinationObject.getName();
            jndiName = this.selectedDestinationObject.getJndiName();
            if (jndiName == null || jndiName.equals("")) {
                jndiName = destName;
            }
        }
        return jndiName;
    }

    private WeblogicServerMBeanModel initWLMBeanConnection(String connName) {
        AppServer selAppServ = AppServerManager.getInstance().getAppServer(connName);
        AppServerConnection conn1 = selAppServ.getConnection();
        Presentation pres = conn1.getPresentation(WeblogicPresentationType.SERVER_MBEAN_MODEL);
        WeblogicServerMBeanModel model = (WeblogicServerMBeanModel)pres.get();
        return model;
    }
}

