/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.help.HelpSystem;
import oracle.tip.tools.ide.common.utils.MultiLineOptionPane;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.jms.JMSContext;

public class FactoryPropsDialog
extends JEWTDialog
implements ActionListener {
    public static final String MCF_FACTORY_PROPERTIES = "mcf.FactoryProperties";
    private AdapterWizardContext wcontext;
    private JPanel mainPanel;
    private MultiLineLabel introLabel;
    private JButton addButton;
    private JButton removeButton;
    private JButton resetButton;
    private JTable factoryPropsTable;
    private JScrollPane factoryPropsPane;
    private JPanel spacer;
    private DefaultTableModel factPropsTableModel;
    private Vector tableData;
    private Vector columnNames;
    private JMSContext jmsContext;
    private JPanel buttonPanel;

    public FactoryPropsDialog(AdapterWizardContext wcontext) {
        try {
            this.wcontext = wcontext;
            this.jmsContext = (JMSContext)wcontext._ascontext;
            if (this.jmsContext == null) {
                this.jmsContext = new JMSContext();
            }
            if (this.jmsContext.factoryProps != null && this.jmsContext.factoryProps.size() > 0) {
                this.tableData = this.copyTableData(this.jmsContext.factoryProps);
            }
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
            MultiLineOptionPane.showMessageDialog((Component)((Object)this), (Object)this.getTranslatedString("JMS_FP_GENERIC_ERROR"), (String)this.getTranslatedString("JMS_FP_ERROR"), (int)0);
        }
    }

    private void init() throws Exception {
        String introText = this.getTranslatedString("JMS_FP_INTRO_PROMPT");
        String factoryPropsText = this.getTranslatedString("JMS_FP_FACTORY_PROPERTIES_TITLE");
        String addText = this.getTranslatedString("JMS_FP_ADD");
        String removeText = this.getTranslatedString("JMS_FP_REMOVE");
        String resetText = this.getTranslatedString("JMS_FP_RESET");
        String resetTip = this.getTranslatedString("JMS_FP_RESET_TIP");
        String nameText = this.getTranslatedString("JMS_FP_NAME");
        String valueText = this.getTranslatedString("JMS_FP_VALUE");
        this.setPreferredSize(425, 405);
        this.setTitle(factoryPropsText);
        this.setModal(true);
        this.setLocationRelativeTo(this.getParent());
        this.setButtonMask(7);
        this.setOKButtonEnabled(true);
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridBagLayout());
        this.setContent(this.mainPanel);
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new GridBagLayout());
        if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.wcontext.isStandalone()) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)this.mainPanel, "bpmjdev_adp_wiz_jms_fact_props");
        }
        this.introLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), introText);
        this.addButton = new JButton(StringUtils.stripMnemonic((String)addText));
        this.addButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)addText));
        this.addButton.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)addText));
        this.addButton.addActionListener(this);
        this.removeButton = new JButton(StringUtils.stripMnemonic((String)removeText));
        this.removeButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)removeText));
        this.removeButton.setEnabled(false);
        this.removeButton.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)removeText));
        this.removeButton.addActionListener(this);
        this.resetButton = new JButton(StringUtils.stripMnemonic((String)resetText));
        this.resetButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)resetText));
        this.resetButton.setToolTipText(resetTip);
        this.resetButton.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)resetText));
        this.resetButton.addActionListener(this);
        this.factoryPropsTable = new JTable();
        this.factoryPropsPane = new JScrollPane(this.factoryPropsTable);
        this.factoryPropsPane.getAccessibleContext().setAccessibleName(factoryPropsText);
        this.columnNames = new Vector(2);
        this.columnNames.add(nameText);
        this.columnNames.add(valueText);
        this.factPropsTableModel = new DefaultTableModel();
        this.factoryPropsTable.setModel(this.factPropsTableModel);
        if (this.tableData == null || this.tableData.size() < 1) {
            this.initTableData();
        }
        ListSelectionModel lsm = this.factoryPropsTable.getSelectionModel();
        lsm.addListSelectionListener(new FactoryPropsTableSelectionListener());
        this.reloadFactoryPropsModel();
        this.spacer = new JPanel();
        this.buttonPanel.add((Component)this.addButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.buttonPanel.add((Component)this.removeButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 3, 0, 0), 0, 0));
        this.buttonPanel.add((Component)this.resetButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 3, 0, 0), 0, 0));
        this.mainPanel.add((Component)this.introLabel, new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.mainPanel.add((Component)this.buttonPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 12, 13, new Insets(10, 0, 1, 0), 0, 0));
        this.mainPanel.add((Component)this.factoryPropsPane, new GridBagConstraints(0, 2, 0, 1, 2.0, 2.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.mainPanel.add((Component)this.spacer, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void reloadFactoryPropsModel() {
        int[] selRows = this.factoryPropsTable.getSelectedRows();
        this.factPropsTableModel.setDataVector(this.tableData, this.columnNames);
        this.factoryPropsTable.setModel(this.factPropsTableModel);
        this.selectRows(selRows);
    }

    private void initTableData() {
        this.tableData = new Vector();
        this.addRow("java.naming.factory.initial", "");
        this.addRow("java.naming.provider.url", "");
        this.addRow("java.naming.security.principal", "");
        this.addRow("java.naming.security.credentials", "");
    }

    private void addRow(String name, String value) {
        if (this.tableData != null) {
            Vector<String> row = new Vector<String>(2);
            row.add(name);
            row.add(value);
            this.tableData.add(row);
            this.factPropsTableModel.fireTableRowsInserted(this.tableData.size(), this.tableData.size());
        }
    }

    private void removeRows(int[] selectedRows) {
        if (selectedRows.length > 0) {
            for (int i = selectedRows.length - 1; i >= 0; --i) {
                this.tableData.remove(selectedRows[i]);
            }
            this.reloadFactoryPropsModel();
        }
    }

    private String getMCFFactoryPropertiesValue() {
        String DELIMITER = ";";
        String EQUAL = "=";
        String mcfFactoryPropsValue = "";
        int propCount = 0;
        if (this.tableData != null && this.tableData.size() > 0) {
            for (int i = 0; i < this.tableData.size(); ++i) {
                Vector currentRow = (Vector)this.tableData.get(i);
                if (currentRow == null || currentRow.size() <= 0) continue;
                String name = (String)currentRow.get(0);
                String value = (String)currentRow.get(1);
                if (name == null || name.trim().equals("") || value == null || value.trim().equals("")) continue;
                mcfFactoryPropsValue = ++propCount == 1 ? name + "=" + value : mcfFactoryPropsValue + ";" + name + "=" + value;
            }
        }
        return mcfFactoryPropsValue;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int ret;
        if (e.getSource() == this.addButton) {
            this.addRow("", "");
            int row = this.factoryPropsTable.getRowCount() - 1;
            int col = 0;
            this.editCell(this.factoryPropsTable, row, col);
        } else if (e.getSource() == this.removeButton) {
            this.removeRows(this.factoryPropsTable.getSelectedRows());
        } else if (e.getSource() == this.resetButton && (ret = JOptionPane.showConfirmDialog((Component)((Object)this), this.getTranslatedString("JMS_FP_RESET_WARNING"), this.getTranslatedString("JMS_FP_WARNING"), 0)) == 0) {
            this.initTableData();
            this.reloadFactoryPropsModel();
        }
    }

    public String getTranslatedString(String messageKey) {
        return this.wcontext._bundle.getString(messageKey);
    }

    private Vector copyTableData(Vector tableData) {
        Vector copyTableData = null;
        if (tableData != null && tableData.size() > 0) {
            copyTableData = new Vector();
            for (int i = 0; i < tableData.size(); ++i) {
                Vector row = (Vector)tableData.get(i);
                if (row == null) continue;
                String name = (String)row.get(0);
                String value = (String)row.get(1);
                Vector<String> copyRow = new Vector<String>(2);
                copyRow.add(name);
                copyRow.add(value);
                copyTableData.add(copyRow);
            }
        }
        return copyTableData;
    }

    private boolean validUserInput() {
        int validRowCount = 0;
        if (this.tableData != null && this.tableData.size() > 0) {
            for (int i = 0; i < this.tableData.size(); ++i) {
                Vector row = (Vector)this.tableData.get(i);
                if (row == null || row.size() <= 1) continue;
                String name = (String)row.get(0);
                String value = (String)row.get(1);
                if (name == null || name.trim().equals("") || value == null || value.trim().equals("")) continue;
                ++validRowCount;
            }
        }
        return validRowCount != 0;
    }

    protected void dismissDialog(boolean cancelled) {
        if (!cancelled) {
            TableCellEditor cellEditor = this.factoryPropsTable.getCellEditor();
            if (cellEditor != null) {
                cellEditor.stopCellEditing();
            }
            this.jmsContext.factoryProps = this.tableData;
            if (!this.validUserInput()) {
                MultiLineOptionPane.showMessageDialog((Component)((Object)this), (Object)this.getTranslatedString("JMS_FP_INVALID_INPUT_ERROR"), (String)this.getTranslatedString("JMS_FP_ERROR"), (int)0);
            } else {
                super.dismissDialog(cancelled);
            }
        } else {
            super.dismissDialog(cancelled);
        }
    }

    private void editCell(JTable table, int row, int col) {
        if (table.editCellAt(row, col)) {
            table.changeSelection(row, col, false, false);
            Component editor = table.getEditorComponent();
            if (editor != null) {
                editor.requestFocusInWindow();
            }
        }
    }

    private void selectRows(int[] selectedRows) {
        if (selectedRows.length > 0) {
            for (int i = 0; i < selectedRows.length; ++i) {
                int curRow = selectedRows[i];
                this.factoryPropsTable.addRowSelectionInterval(curRow, curRow);
            }
        }
    }

    private class FactoryPropsTableSelectionListener
    implements ListSelectionListener {
        private FactoryPropsTableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            if (!lsm.isSelectionEmpty()) {
                FactoryPropsDialog.this.removeButton.setEnabled(true);
            } else {
                FactoryPropsDialog.this.removeButton.setEnabled(false);
            }
        }
    }
}

