/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.http;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.bali.ewt.event.Cancelable;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.GridSelectionManager;
import oracle.bali.ewt.grid.NumericSpinBoxInputHandler;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.bali.ewt.model.ArrayTwoDModel;
import oracle.bali.ewt.model.OneDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.ewt.table.TableEditListener;
import oracle.bali.ewt.table.TableEvent;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.http.SchemaCBColumnInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.http.SchemaColumnInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.http.SchemaStringColumnInfo;

public class HttpSchemaElementPanel
extends JPanel
implements TableEditListener {
    public static final int FIELD_NAME_COL = 0;
    public static final int FIELD_TYPE_COL = 1;
    public static final int FIELD_MIN_OCCURS = 2;
    public static final int FIELD_MAX_OCCURS = 3;
    private static final int MIN_FONT_SIZE = 12;
    private static final String MONOFONT = "Monospaced";
    private static String[] _xmlDataTypes = new String[]{"string", "date", "dateTime", "decimal", "double", "int", "integer", "long", "positiveInteger", "short"};
    private static String[] _minOccursList = new String[]{"0", "1"};
    private static String[] _maxOccursList = new String[]{"1", "unbounded"};
    private ArrayOneDModel _fieldGridHeaderDs;
    private ArrayTwoDModel _fieldGridDs;
    private SpreadTable _fieldGridTable;
    private Grid _fieldGrid;
    private JScrollPane _fieldGridScrollBox;
    private NumericSpinBoxInputHandler _lengthHandler;
    private JPanel _buttonPanel;
    private JButton _addButton;
    private JButton _deleteButton;
    private JPanel _nextRecTypeButtonPanel;
    private String savedDatatype;
    private static final String FIELD_EDIT_ICN = "images/edit16.png";
    private AdapterWizardContext w_context;

    public HttpSchemaElementPanel(AdapterWizardContext ctx, ArrayTwoDModel fldModel) {
        this.w_context = ctx;
        if (fldModel != null) {
            this._fieldGridDs = fldModel;
        }
        this.buildFieldProperties();
    }

    public void buildFieldProperties() {
        this.setLayout(new GridBagLayout());
        this.buildButtons();
        if (this._fieldGridDs == null) {
            this._fieldGridDs = new ArrayTwoDModel(0, 0);
        }
        this._fieldGridTable = new SpreadTable((TwoDModel)this._fieldGridDs, null, null);
        Grid grid = this._fieldGridTable.getGrid();
        if (grid != null) {
            grid.setName("FieldsGrid");
        }
        this._fieldGridScrollBox = new JScrollPane((Component)this._fieldGridTable, 20, 30);
        JPanel fieldGridPanel = new JPanel(new GridLayout(1, 1));
        fieldGridPanel.add(this._fieldGridScrollBox);
        fieldGridPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), this.getTranslatedString("HTTP_SC_FLDGRID_BORDERTXT")));
        fieldGridPanel.setPreferredSize(new Dimension(300, 50));
        this.add((Component)fieldGridPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 3, 3, 3), 0, 55));
        this._fieldGridTable.addEditListener((TableEditListener)this);
        this._fieldGrid = this._fieldGridTable.getGrid();
        this._fieldGrid.setGridSelectionManager((GridSelectionManager)new GeneralGridSelectionManager(0, 1, 0));
        this.processRecordSelection();
        this.setVisible(true);
    }

    public void buildButtons() {
        Insets insets = new Insets(0, 3, 0, 3);
        GridLayout gridLayout = new GridLayout(1, 1, 10, 1);
        this._buttonPanel = new JPanel();
        this._buttonPanel.setLayout(gridLayout);
        gridLayout.setHgap(6);
        this.add((Component)this._buttonPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 13, 0, insets, 0, 0));
        this._addButton = UIHelper.createModelerButton((Icon)new ImageIcon(UIHelper.loadImage((String)"images/add16.png", UIHelper.class)));
        this._addButton.setToolTipText(this.getTranslatedString("HTTP_SC_ADDBTN_TIP"));
        insets = new Insets(5, 2, 5, 5);
        this._buttonPanel.add(this._addButton);
        ActionListener _addButtonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HttpSchemaElementPanel.this.addBtnAction();
            }
        };
        this._addButton.addActionListener(_addButtonListener);
        this._deleteButton = UIHelper.createModelerButton((Icon)new ImageIcon(UIHelper.loadImage((String)"images/delete.png", UIHelper.class)));
        this._deleteButton.setToolTipText(this.getTranslatedString("HTTP_SC_DELBTN_TIP"));
        this._buttonPanel.add(this._deleteButton);
        ActionListener _deleteButtonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HttpSchemaElementPanel.this.deleteBtnAction();
            }
        };
        this._deleteButton.addActionListener(_deleteButtonListener);
        this._deleteButton.setEnabled(false);
    }

    public void initializeFrom() {
    }

    public void validateFields() {
    }

    public void processRecordSelection() {
        SchemaColumnInfo[] fieldPropertiesInfo = this.getFieldPropertiesInfo();
        int fieldPropertiesCount = fieldPropertiesInfo.length;
        if (this._fieldGridHeaderDs == null || this._fieldGridHeaderDs.getItemCount() != fieldPropertiesCount) {
            this._fieldGridHeaderDs = new ArrayOneDModel(fieldPropertiesCount);
            for (int i = 0; i < fieldPropertiesCount; ++i) {
                this._fieldGridHeaderDs.setData(i, (Object)fieldPropertiesInfo[i].getHeader());
            }
        }
        if (this._fieldGridDs.getRowCount() == 0) {
            this._fieldGridDs = new ArrayTwoDModel(this.getFieldPropertiesInfo().length, 0);
        }
        this._fieldGridTable.setModels((TwoDModel)this._fieldGridDs, (OneDModel)this._fieldGridHeaderDs, null);
        int fieldCount = this._fieldGridDs.getRowCount();
        Font currFont = this._fieldGrid.getFont();
        if (currFont == null) {
            currFont = HttpSchemaElementPanel.getMonoFont(0, 12);
        }
        FontMetrics currFontMetrics = this._fieldGrid.getFontMetrics(currFont);
        for (int col = 0; col < fieldPropertiesCount; ++col) {
            int dataWidth;
            this._fieldGrid.setColumnVisible(col, true);
            this._fieldGridTable.getColumnHeader().setItemVisible(col, true);
            int maxWidth = currFontMetrics.stringWidth(fieldPropertiesInfo[col].getHeader() + "W");
            if (fieldPropertiesInfo[col] instanceof SchemaCBColumnInfo) {
                SchemaCBColumnInfo info = (SchemaCBColumnInfo)fieldPropertiesInfo[col];
                Object[] choices = info.getChoices();
                for (int i = 0; i < choices.length; ++i) {
                    dataWidth = currFontMetrics.stringWidth((String)choices[i] + "WW");
                    if (maxWidth >= dataWidth) continue;
                    maxWidth = dataWidth;
                }
            }
            for (int row = 0; row < fieldCount; ++row) {
                Object o = this._fieldGridDs.getData(col, row);
                String data = null;
                if (o != null) {
                    data = o + "W";
                }
                if (data == null || maxWidth >= (dataWidth = currFontMetrics.stringWidth(data))) continue;
                maxWidth = dataWidth;
            }
            this._fieldGridTable.setColumnWidth(col, maxWidth);
            if (!fieldPropertiesInfo[col].isEditable()) continue;
            this._fieldGridTable.getGrid().setColumnCellInputHandler(col, fieldPropertiesInfo[col].getInputHandler());
        }
        if (this._fieldGridDs.getRowCount() == 0) {
            this.addBtnAction();
        }
    }

    public void addBtnAction() {
        GridSelectionManager tableGridSelection = this._fieldGrid.getGridSelectionManager();
        int rowsSelected = tableGridSelection.getSelection().getRowSelection().getSelectedItemAtIndex(0);
        int row = rowsSelected > -1 ? rowsSelected + 1 : this._fieldGridDs.getRowCount();
        this._fieldGridDs.addRows(row, 1);
        this.initFieldPropertiesRow(this._fieldGridDs, row);
        try {
            tableGridSelection.setSelection(new TwoDSelection(row, true), null);
            tableGridSelection.setSelection(new TwoDSelection(row, 0), null);
        }
        catch (PropertyVetoException e) {
            // empty catch block
        }
        this._fieldGridTable.getGrid().startCellEdit(0, row);
    }

    public void deleteBtnAction() {
        GridSelectionManager tableGridSelection = this._fieldGrid.getGridSelectionManager();
        int rowsSelected = tableGridSelection.getSelection().getRowSelection().getSelectedItemAtIndex(0);
        if (rowsSelected > -1) {
            int row = rowsSelected;
            this._fieldGridDs.removeRows(row, 1);
            int rowCount = this._fieldGridDs.getRowCount();
            if (rowCount > 0) {
                int nextShowRow;
                for (nextShowRow = row; nextShowRow < rowCount && !this._fieldGridTable.isRowVisible(nextShowRow); ++nextShowRow) {
                }
                try {
                    if (nextShowRow < rowCount) {
                        tableGridSelection.setSelection(new TwoDSelection(nextShowRow, true), null);
                    } else {
                        tableGridSelection.setSelection(new TwoDSelection(0, true), null);
                    }
                }
                catch (PropertyVetoException e) {
                    // empty catch block
                }
            }
        }
    }

    public void cellEdited(TableEvent e) {
        int row = e.getRow();
        int column = e.getColumn();
        boolean len = false;
        boolean precision = false;
        if (column == 1) {
            String data_type = (String)this._fieldGridDs.getData(1, row);
        }
    }

    public void cellEditing(TableEvent e) {
        if (this._deleteButton != null) {
            this._deleteButton.setEnabled(true);
        }
        if (e.getSource() == this._fieldGridTable) {
            String data_type;
            int row = e.getRow();
            int column = e.getColumn();
            this.savedDatatype = data_type = (String)this._fieldGridDs.getData(1, row);
            boolean cancel = false;
            if (cancel && e instanceof Cancelable) {
                ((Cancelable)e).cancel();
            }
        }
    }

    public JButton getAddButton() {
        return this._addButton;
    }

    public JPanel getButtonPanel() {
        return this._buttonPanel;
    }

    public SpreadTable getFieldGrid() {
        return this._fieldGridTable;
    }

    public void resetColumnData(int colNum) {
        for (int i = 0; i < this._fieldGridDs.getRowCount(); ++i) {
            this._fieldGridDs.setData(colNum, i, null);
        }
    }

    public void resizeColumns(int colNum) {
        Font currFont = this._fieldGrid.getFont();
        if (currFont == null) {
            currFont = HttpSchemaElementPanel.getMonoFont(0, 12);
        }
        FontMetrics currFontMetrics = this._fieldGrid.getFontMetrics(currFont);
        ArrayTwoDModel fieldProps = this._fieldGridDs;
        int num_columns = fieldProps.getRowCount();
        int charSize = currFontMetrics.charWidth('w');
        int maxWidth = 5 * charSize;
        String columnName = "";
        int colWidth = 0;
        for (int i = 0; i < num_columns; ++i) {
            try {
                columnName = (String)fieldProps.getData(colNum, i);
                colWidth = (columnName.length() + 1) * charSize;
            }
            catch (Exception e1) {
                // empty catch block
            }
            if (colWidth <= maxWidth) continue;
            maxWidth = colWidth;
        }
        this._fieldGridTable.setColumnWidth(colNum, maxWidth);
    }

    private String[] addArrayElement(String[] strarray, String name) {
        String[] newarray = new String[strarray.length + 1];
        for (int i = 0; i < strarray.length; ++i) {
            newarray[i] = strarray[i];
        }
        newarray[strarray.length] = name;
        return newarray;
    }

    public void setFieldGridHeaderDs(ArrayOneDModel fieldGridHeaderDs) {
        this._fieldGridHeaderDs = fieldGridHeaderDs;
    }

    public ArrayOneDModel getFieldGridHeaderDs() {
        return this._fieldGridHeaderDs;
    }

    public ArrayTwoDModel getFieldGridDs() {
        return this._fieldGridDs;
    }

    private String getTranslatedString(String messageKey) {
        return this.w_context._bundle.getString(messageKey);
    }

    public SchemaColumnInfo[] getFieldPropertiesInfo() {
        Vector _rawFieldPropertiesInfo = this.getRawFieldPropertiesInfo();
        Object[] rawFieldPropertiesInfo = new SchemaColumnInfo[_rawFieldPropertiesInfo.size()];
        _rawFieldPropertiesInfo.copyInto(rawFieldPropertiesInfo);
        SchemaColumnInfo[] fieldPropertiesInfo = new SchemaColumnInfo[]{rawFieldPropertiesInfo[0], rawFieldPropertiesInfo[1], rawFieldPropertiesInfo[2], rawFieldPropertiesInfo[3]};
        return fieldPropertiesInfo;
    }

    private Vector getRawFieldPropertiesInfo() {
        Vector<SchemaStringColumnInfo> _rawFieldPropertiesInfo = new Vector<SchemaStringColumnInfo>(4);
        int maxSize = 0;
        maxSize = 1000;
        SchemaColumnInfo colInfo = new SchemaStringColumnInfo(this.getTranslatedString("HTTP_SC_FLDGRID_NAME"), -999, 0);
        _rawFieldPropertiesInfo.addElement((SchemaStringColumnInfo)colInfo);
        colInfo = new SchemaCBColumnInfo(this.getTranslatedString("HTTP_SC_FLDGRID_TYPE"), -999, _xmlDataTypes);
        _rawFieldPropertiesInfo.addElement((SchemaStringColumnInfo)colInfo);
        colInfo = new SchemaCBColumnInfo(this.getTranslatedString("HTTP_SC_FLDGRID_MIN"), -999, _minOccursList);
        _rawFieldPropertiesInfo.addElement((SchemaStringColumnInfo)colInfo);
        colInfo = new SchemaCBColumnInfo(this.getTranslatedString("HTTP_SC_FLDGRID_MAX"), -999, _maxOccursList);
        _rawFieldPropertiesInfo.addElement((SchemaStringColumnInfo)colInfo);
        return _rawFieldPropertiesInfo;
    }

    public static Font getMonoFont(int style, int size) {
        return new Font(MONOFONT, style, size);
    }

    public void initFieldPropertiesRow(ArrayTwoDModel propertiesDs, int row) {
        if (propertiesDs != null) {
            propertiesDs.setData(0, row, (Object)(this.getTranslatedString("HTTP_SC_FLDGRID_COLNAME_PREFIX") + (row + 1)));
            propertiesDs.setData(1, row, (Object)"string");
            propertiesDs.setData(2, row, (Object)"1");
            propertiesDs.setData(3, row, (Object)"1");
        }
    }
}

