/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.http;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Stack;

public class HttpSchemaBuilder {
    public static final int UNBOUNDED = 0x7FFFFFF8;
    public static final short S_SCHEMA = 0;
    public static final short S_ELEMENT = 1;
    public static final short S_COMPLEX_TYPE = 2;
    private static final Short S_MODEL_GROUP = 4;
    public static final Short S_SEQUENCE = 5;
    private BufferedWriter fWriter;
    private int fIndent;
    private final int INDENT_SIZE = 2;
    private Stack fStack;
    private static final short START_SCHEMA_DOC_EVENT = 0;
    private static final short END_SCHEMA_DOC_EVENT = 1;
    private static final short START_ELEMENT_EVENT = 2;
    private static final short END_ELEMENT_EVENT = 3;
    private static final short START_CT_EVENT = 4;
    private static final short END_CT_EVENT = 5;
    private static final short START_MG_EVENT = 8;
    private static final short END_MG_EVENT = 9;
    private static final short START_MG_SEQ_EVENT = 10;
    private static final short END_MG_SEQ_EVENT = 11;
    private short fLastEvent = (short)-1;

    public HttpSchemaBuilder(OutputStream os) throws Exception {
        try {
            this.fWriter = new BufferedWriter(new OutputStreamWriter(os));
            this.fWriter.write("<?xml version=\"1.0\" ?>");
            this.fWriter.newLine();
            this.fStack = new Stack();
            this.fIndent -= 2;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public HttpSchemaBuilder(OutputStream os, String encoding) throws Exception {
        try {
            this.fWriter = new BufferedWriter(new OutputStreamWriter(os, encoding));
            this.fWriter.write("<?xml version=\"1.0\" encoding=\"" + encoding + "\" ?>");
            this.fWriter.newLine();
            this.fStack = new Stack();
            this.fIndent -= 2;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void startSchemaDocument(String targetNamespace, boolean elementFormDefaultQualified, boolean attributeFormDefaultQualified) throws Exception {
        this.fLastEvent = 0;
        this.fStack.push((short)0);
        this.write("<xsd:schema xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
        this.newLine();
        if (targetNamespace != null) {
            this.newLine();
            this.write("            xmlns:tns=\"" + targetNamespace + "\"");
            this.newLine();
            this.write("            targetNamespace=\"" + targetNamespace + "\"");
            if (elementFormDefaultQualified) {
                this.newLine();
                this.write("            elementFormDefault=\"qualified\"");
            } else {
                this.newLine();
                this.write("            elementFormDefault=\"unqualified\"");
            }
            if (attributeFormDefaultQualified) {
                this.newLine();
                this.write("            attributeFormDefault=\"qualified\"");
            } else {
                this.newLine();
                this.write("            attributeFormDefault=\"unqualified\"");
            }
            this.newLine();
            this.newLine();
        }
    }

    public void startElement(String name, String type, String ref, boolean isBuiltin) throws Exception {
        this.startElement(name, type, ref, -1, -1, null, null, isBuiltin);
    }

    public void startElement(String name, String type, String ref, int minOccurs, int maxOccurs, String defaultVal, String fixedVal, boolean isBuiltin) throws Exception {
        this.write(">");
        if (this.fLastEvent == 0) {
            this.newLine();
            this.newLine();
        }
        this.fLastEvent = (short)2;
        this.fStack.push((short)1);
        this.write("<xsd:element");
        this.write(name != null ? " name=\"" + name + "\"" : "");
        if (type != null) {
            this.write(isBuiltin ? " type=\"xsd:" + type + "\"" : " type=\"tns:" + type + "\"");
        }
        this.write(ref != null ? " ref=\"tns:" + ref + "\"" : "");
        if (minOccurs >= 0) {
            this.write(minOccurs == 0x7FFFFFF8 ? " minOccurs=\"unbounded\"" : " minOccurs=\"" + minOccurs + "\"");
        }
        if (maxOccurs >= 0) {
            this.write(maxOccurs == 0x7FFFFFF8 ? " maxOccurs=\"unbounded\"" : " maxOccurs=\"" + maxOccurs + "\"");
        }
        this.write(defaultVal != null ? " default=\"" + defaultVal + "\"" : "");
        this.write(fixedVal != null ? " fixed=\"" + fixedVal + "\"" : "");
    }

    public void startComplexType(String name) throws Exception {
        this.write(">");
        if (this.fLastEvent == 0) {
            this.newLine();
            this.newLine();
        }
        this.fLastEvent = (short)4;
        this.fStack.push((short)2);
        this.write("<xsd:complexType");
        this.write(name != null ? " name=\"" + name + "\"" : "");
    }

    public void startModelGroup(short modelGroup) throws Exception {
        this.startModelGroup(modelGroup, -1, -1);
    }

    public void startModelGroup(short modelGroup, int minOccurs, int maxOccurs) throws Exception {
        this.write(">");
        if (modelGroup == S_SEQUENCE) {
            this.fLastEvent = (short)10;
            this.fStack.push(S_SEQUENCE);
            this.write("<xsd:sequence");
        }
        if (minOccurs >= 0) {
            this.write(minOccurs == 0x7FFFFFF8 ? " minOccurs=\"unbounded\"" : " minOccurs=\"" + minOccurs + "\"");
        }
        if (maxOccurs >= 0) {
            this.write(maxOccurs == 0x7FFFFFF8 ? " maxOccurs=\"unbounded\"" : " maxOccurs=\"" + maxOccurs + "\"");
        }
    }

    public void startModelGroup(String name, String ref, int minOccurs, int maxOccurs) throws Exception {
        this.write(">");
        if (this.fLastEvent == 0) {
            this.newLine();
            this.newLine();
        }
        this.fLastEvent = (short)8;
        this.fStack.push(S_MODEL_GROUP);
        if (name != null) {
            this.write("<xsd:group name=\"" + name + "\"");
        } else if (ref != null) {
            this.write("<xsd:group ref=\"tns:" + ref + "\"");
        }
        if (minOccurs >= 0) {
            this.write(minOccurs == 0x7FFFFFF8 ? " minOccurs=\"unbounded\"" : " minOccurs=\"" + minOccurs + "\"");
        }
        if (maxOccurs >= 0) {
            this.write(maxOccurs == 0x7FFFFFF8 ? " maxOccurs=\"unbounded\"" : " maxOccurs=\"" + maxOccurs + "\"");
        }
    }

    public void endModelGroup(short modelGroup) throws Exception {
        this.write(">");
        if (this.fStack.empty()) {
            throw new Exception("Malformed Modal Group");
        }
        Short construct = (Short)this.fStack.pop();
        if (modelGroup == S_SEQUENCE) {
            this.fLastEvent = (short)11;
            if (construct.shortValue() != S_SEQUENCE.shortValue()) {
                throw new Exception("Malformed xsd sequence");
            }
            this.write("</xsd:sequence");
        }
    }

    public void endModelGroup() throws Exception {
        if (this.fStack.empty()) {
            throw new Exception("Malformed Modal Group");
        }
        Short construct = (Short)this.fStack.pop();
        if (construct.shortValue() != S_MODEL_GROUP.shortValue()) {
            throw new Exception("Malformed xsd group");
        }
        if (this.fLastEvent == 8) {
            this.write(" /");
            this.fIndent -= 2;
        } else {
            this.write(">");
            this.write("</xsd:group");
        }
        this.fLastEvent = (short)9;
    }

    public void endComplexType() throws Exception {
        this.fLastEvent = (short)5;
        this.write(">");
        if (this.fStack.empty()) {
            throw new Exception("Malformed Complex Type");
        }
        Short construct = (Short)this.fStack.pop();
        if (construct != 2) {
            throw new Exception("Malformed xsd complexType");
        }
        this.write("</xsd:complexType");
    }

    public void endElement() throws Exception {
        if (this.fStack.empty()) {
            throw new Exception("Malformed Element");
        }
        Short construct = (Short)this.fStack.pop();
        if (construct != 1) {
            throw new Exception("Malformed xsd element");
        }
        if (this.fLastEvent == 2) {
            this.write(" /");
            this.fIndent -= 2;
        } else {
            this.write(">");
            this.write("</xsd:element");
        }
        this.fLastEvent = (short)3;
    }

    public void endSchemaDocument() throws Exception {
        this.fLastEvent = 1;
        this.write(">");
        this.newLine();
        if (this.fStack.empty()) {
            throw new Exception("Malformed schema document");
        }
        Short construct = (Short)this.fStack.pop();
        if (construct != 0) {
            throw new Exception("Malformed xsd schema tag");
        }
        this.write("</xsd:schema>");
        try {
            this.fWriter.flush();
            this.fWriter.close();
        }
        catch (IOException ioe) {
            throw new Exception("Error closing stream");
        }
    }

    private void write(String str) throws Exception {
        try {
            if (str.startsWith("</")) {
                this.fWriter.newLine();
                this.indent();
                this.fIndent -= 2;
            } else if (str.startsWith("<")) {
                this.fIndent += 2;
                this.fWriter.newLine();
                this.indent();
            }
            this.fWriter.write(str);
        }
        catch (IOException ioe) {
            throw new Exception("Error writing stream");
        }
    }

    private void newLine() throws Exception {
        try {
            this.fWriter.newLine();
        }
        catch (IOException ioe) {
            throw new Exception("Error writing stream");
        }
    }

    private void indent() throws Exception {
        try {
            for (int i = 0; i < this.fIndent; ++i) {
                this.fWriter.write(" ");
            }
        }
        catch (IOException ioe) {
            throw new Exception("Error writing stream");
        }
    }

    private String getSchemaConstructName(int type) {
        String nodeName = "unknown-schema-construct";
        switch (type) {
            case 3: {
                nodeName = "element";
                break;
            }
            case 1: {
                nodeName = "complexType";
            }
        }
        return nodeName;
    }

    private String getModelGroupName(int type) {
        String nodeName = "unknown-model-group";
        switch (type) {
            case 0: {
                nodeName = "sequence";
            }
        }
        return nodeName;
    }

    public void globalDone() {
        this.fLastEvent = 0;
    }
}

