/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.http;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.PortType;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;
import oracle.bali.ewt.event.Cancelable;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.ewt.wizard.Wizard;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Project;
import oracle.tip.tools.ide.common.ui.NCNameField;
import oracle.tip.tools.ide.common.utils.MultiLineOptionPane;
import oracle.tip.tools.ide.fabric.api.BindingInfo;
import oracle.tip.tools.ide.fabric.api.BindingInfoWS;
import oracle.tip.tools.ide.fabric.api.PropertyInfo;
import oracle.tip.tools.ide.fabric.api.SCAController;
import oracle.tip.tools.ide.fabric.api.SCAControllerImpl;
import oracle.tip.tools.ide.fabric.api.WsdlInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.ServiceNamePage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.http.HttpAdapterContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.http.HttpSchemaPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.techAdapterWizardPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.JcaAddress;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.PartnerLinkType;

public class HttpOperationTypePage
extends techAdapterWizardPage
implements DocumentListener,
ActionListener,
ItemListener {
    ButtonGroup group = new ButtonGroup();
    private MultiLineLabel introPrompt;
    private JLabel operationTypePrompt = new JLabel();
    private JRadioButton onewayRB = new JRadioButton();
    private JRadioButton reqrspRB = new JRadioButton();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JLabel operationNamePrompt = new JLabel();
    private NCNameField operationName = new NCNameField();
    private JLabel typeLB = new JLabel();
    private JComboBox typeCB = new JComboBox();
    private JLabel verbPrompt = new JLabel();
    private JComboBox verbCB = new JComboBox();
    private JLabel payloadPrompt = new JLabel();
    private JComboBox payloadCB = new JComboBox();
    private JLabel endpointPrompt = new JLabel();
    private JTextField endpointName = new JTextField();
    private JPanel spacerPanel = new JPanel();
    private HttpAdapterContext httpCtx;
    private boolean m_isExternalReference;
    private String m_typeService;
    private String m_typeReference;

    public HttpOperationTypePage(AdapterWizardContext wcontext, ImageWizardPage iwp) {
        this.setContextAndPage(wcontext, iwp);
        if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)this.m_page.getContent(), "f1_soahttpbindcnfg_html");
        }
        this.httpCtx = (HttpAdapterContext)wcontext._ascontext;
        this.m_isExternalReference = !this.m_wcontext._isInboundOperation;
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        String intro = this.getTranslatedString("HTTP_OP_INTRO_PROMPT");
        String opprompt = this.getTranslatedString("CM_OP_TYPE_PROMPT");
        String typeText = StringUtils.stripMnemonic((String)this.getTranslatedString("HTTP_OP_TYPE_PROMPT"));
        int typeMN = StringUtils.getMnemonicKeyCode((String)this.getTranslatedString("HTTP_OP_TYPE_PROMPT"));
        String typeTip = this.getTranslatedString("HTTP_OP_TYPE_TIP");
        this.m_typeService = this.getTranslatedString("HTTP_OP_TYPE_SERVICE");
        this.m_typeReference = this.getTranslatedString("HTTP_OP_TYPE_REFERENCE");
        String onewayRBtext = StringUtils.stripMnemonic((String)this.getTranslatedString("HTTP_OP_ONEWAY_TYPE"));
        int onewayMN = StringUtils.getMnemonicKeyCode((String)this.getTranslatedString("HTTP_OP_ONEWAY_TYPE"));
        String onewayTip = this.getTranslatedString("HTTP_OP_ONEWAY_TIP");
        String reqrspRBtext = StringUtils.stripMnemonic((String)this.getTranslatedString("HTTP_OP_RR_TYPE"));
        int reqrspMN = StringUtils.getMnemonicKeyCode((String)this.getTranslatedString("HTTP_OP_RR_TYPE"));
        String reqrspTip = this.getTranslatedString("HTTP_OP_RR_TIP");
        String opname = StringUtils.stripMnemonic((String)this.getTranslatedString("CM_OP_NAME_PROMPT"));
        int opMN = StringUtils.getMnemonicKeyCode((String)this.getTranslatedString("CM_OP_NAME_PROMPT"));
        String opnameTip = this.getTranslatedString("CM_OP_NAME_TIP");
        String verbText = StringUtils.stripMnemonic((String)this.getTranslatedString("HTTP_OP_VERB_PROMPT"));
        int verbMN = StringUtils.getMnemonicKeyCode((String)this.getTranslatedString("HTTP_OP_VERB_PROMPT"));
        String verbTip = this.getTranslatedString("HTTP_OP_VERB_TIP");
        String payloadText = StringUtils.stripMnemonic((String)this.getTranslatedString("HTTP_OP_PL_PROMPT"));
        int payloadMN = StringUtils.getMnemonicKeyCode((String)this.getTranslatedString("HTTP_OP_PL_PROMPT"));
        String payloadTip = this.getTranslatedString("HTTP_OP_PL_TIP");
        String endpointText = StringUtils.stripMnemonic((String)this.getTranslatedString("HTTP_OP_EP_PROMPT"));
        int endpointMN = StringUtils.getMnemonicKeyCode((String)this.getTranslatedString("HTTP_OP_EP_PROMPT"));
        String endpointTip = this.getTranslatedString("HTTP_OP_EP_TIP");
        this.setLayout(this.gridBagLayout1);
        this.introPrompt = new MultiLineLabel(WordWrapper.getTextWrapper(), intro);
        this.operationTypePrompt.setText(opprompt);
        this.operationTypePrompt.setLabelFor(this.onewayRB);
        this.onewayRB.setText(onewayRBtext);
        this.onewayRB.setMnemonic(onewayMN);
        this.onewayRB.setToolTipText(onewayTip);
        this.onewayRB.getAccessibleContext().setAccessibleDescription(onewayTip);
        this.onewayRB.getAccessibleContext().setAccessibleName(onewayRBtext);
        this.onewayRB.addActionListener(this);
        this.reqrspRB.setText(reqrspRBtext);
        this.reqrspRB.setMnemonic(reqrspMN);
        this.reqrspRB.setToolTipText(reqrspTip);
        this.reqrspRB.getAccessibleContext().setAccessibleDescription(reqrspTip);
        this.reqrspRB.getAccessibleContext().setAccessibleName(reqrspRBtext);
        this.reqrspRB.addActionListener(this);
        this.operationNamePrompt.setText(opname);
        this.operationNamePrompt.setLabelFor((Component)this.operationName);
        this.operationNamePrompt.setDisplayedMnemonic(opMN);
        this.operationName.setToolTipText(opnameTip);
        this.operationName.getAccessibleContext().setAccessibleDescription(opnameTip);
        this.operationName.getAccessibleContext().setAccessibleName(opname);
        this.operationName.getDocument().addDocumentListener(this);
        this.typeLB.setText(StringUtils.stripMnemonic((String)typeText));
        this.typeLB.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)typeText));
        this.typeLB.setLabelFor(this.typeCB);
        this.typeCB.setToolTipText(typeTip);
        this.typeCB.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)typeText));
        this.typeCB.getAccessibleContext().setAccessibleDescription(typeTip);
        this.typeCB.setPreferredSize(new Dimension(100, 20));
        this.typeCB.addItem(this.m_typeService);
        this.typeCB.addItem(this.m_typeReference);
        this.typeCB.setName("typeCB");
        if (this.m_isExternalReference) {
            this.typeCB.setSelectedIndex(1);
        }
        this.typeCB.addActionListener(this);
        this.verbPrompt.setText(StringUtils.stripMnemonic((String)verbText));
        this.verbPrompt.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)verbText));
        this.verbPrompt.setLabelFor(this.verbCB);
        this.verbCB.setToolTipText(verbTip);
        this.verbCB.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)verbText));
        this.verbCB.getAccessibleContext().setAccessibleDescription(verbTip);
        this.verbCB.setPreferredSize(new Dimension(100, 20));
        this.verbCB.addItem("GET");
        this.verbCB.addItem("POST");
        this.verbCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    if (HttpOperationTypePage.this.verbCB.getSelectedItem().equals("GET")) {
                        HttpOperationTypePage.this.payloadCB.setSelectedItem("url-encoded");
                        HttpOperationTypePage.this.payloadCB.setEnabled(false);
                    } else {
                        HttpOperationTypePage.this.payloadCB.setEnabled(true);
                    }
                }
            }
        });
        this.verbCB.setName("verbCB");
        this.payloadPrompt.setText(StringUtils.stripMnemonic((String)payloadText));
        this.payloadPrompt.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)payloadText));
        this.payloadPrompt.setLabelFor(this.payloadCB);
        this.payloadCB.setToolTipText(payloadTip);
        this.payloadCB.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)payloadText));
        this.payloadCB.getAccessibleContext().setAccessibleDescription(payloadTip);
        this.payloadCB.setPreferredSize(new Dimension(100, 20));
        this.payloadCB.addItem("xml");
        this.payloadCB.addItem("url-encoded");
        this.payloadCB.setName("payloadCB");
        this.endpointPrompt.setText(endpointText);
        this.endpointPrompt.setLabelFor(this.endpointName);
        this.endpointPrompt.setDisplayedMnemonic(endpointMN);
        this.endpointName.setToolTipText(endpointTip);
        this.endpointName.getAccessibleContext().setAccessibleDescription(endpointTip);
        this.endpointName.getAccessibleContext().setAccessibleName(endpointText);
        this.endpointName.getDocument().addDocumentListener(this);
        this.group.add(this.onewayRB);
        this.group.add(this.reqrspRB);
        this.add((Component)this.introPrompt, new GridBagConstraints(0, 0, 0, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.typeLB, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(8, 0, 0, 0), 0, 0));
        this.add((Component)this.typeCB, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(8, 8, 0, 0), 0, 0));
        this.add((Component)this.operationTypePrompt, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(16, 0, 0, 0), 0, 0));
        this.add((Component)this.onewayRB, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(16, 8, 0, 0), 0, 0));
        this.add((Component)this.reqrspRB, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(16, 16, 0, 0), 0, 0));
        this.add((Component)this.operationNamePrompt, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(16, 0, 0, 0), 0, 0));
        this.add((Component)this.operationName, new GridBagConstraints(1, 3, 0, 1, 1.0, 0.0, 18, 2, new Insets(16, 8, 0, 0), 0, 0));
        this.add((Component)this.verbPrompt, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(16, 0, 0, 0), 0, 0));
        this.add((Component)this.verbCB, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 18, 2, new Insets(16, 8, 0, 0), 0, 0));
        this.add((Component)this.payloadPrompt, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 18, 0, new Insets(16, 0, 0, 0), 0, 0));
        this.add((Component)this.payloadCB, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 18, 2, new Insets(16, 8, 0, 0), 0, 0));
        this.add((Component)this.endpointPrompt, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 18, 0, new Insets(16, 0, 0, 0), 0, 0));
        this.add((Component)this.endpointName, new GridBagConstraints(1, 6, 0, 1, 1.0, 0.0, 18, 2, new Insets(16, 8, 0, 0), 0, 0));
        this.add((Component)this.spacerPanel, new GridBagConstraints(0, 7, 1, 1, 0.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.typeValueChanged();
        if (this.m_wcontext._read_service != null) {
            this.initFromExistingWSDL();
        }
        if (this.m_wcontext._importedWsdlInfo != null) {
            this.operationName.setText(this.m_wcontext._write_operation_name);
            this.operationName.setEditable(false);
            PortType pt = WsdlInfo.getPorttypeByQname((Project)this.m_wcontext._project, (QName)this.m_wcontext._importedWsdlInfo.getRequestPorttype());
            List opList = pt.getOperations();
            Operation op = (Operation)opList.get(0);
            if (op != null) {
                if (op.getStyle().equals(OperationType.ONE_WAY)) {
                    this.onewayRB.setSelected(true);
                    this.httpCtx._isOneWay = true;
                } else {
                    this.reqrspRB.setSelected(true);
                    this.httpCtx._isOneWay = false;
                }
            }
        }
        this.initControls();
    }

    protected void initFromExistingWSDL() {
        if (this.m_wcontext._read_operation != null && !this.m_wcontext.isStandalone() && !AdapterWizardContext.IS_STANDALONE_TESTING) {
            Operation op;
            String opName = this.m_wcontext._read_operation_name;
            if (opName != null && opName.length() > 0) {
                this.operationName.setText(opName);
            }
            if ((op = this.m_wcontext._read_operation) != null) {
                if (op.getStyle().equals(OperationType.ONE_WAY)) {
                    this.onewayRB.setSelected(true);
                    this.httpCtx._isOneWay = true;
                } else {
                    this.reqrspRB.setSelected(true);
                    this.httpCtx._isOneWay = false;
                }
            }
            this.typeCB.setEnabled(false);
            this.operationName.setEnabled(false);
            SCAController scon = SCAControllerImpl.getController((Project)this.m_wcontext._project);
            List bindingList = scon.getEndpointBindingInfo(this.m_wcontext._read_service_name);
            if (bindingList.get(0) instanceof BindingInfoWS) {
                BindingInfoWS bindingInfo = (BindingInfoWS)bindingList.get(0);
                List propInfoList = scon.getBindingProperties(this.m_wcontext._read_service_name, (BindingInfo)bindingInfo);
                for (int i = 0; i < propInfoList.size(); ++i) {
                    String endpoint;
                    PropertyInfo propInfo = (PropertyInfo)propInfoList.get(i);
                    if (propInfo.getName().equals("http.verb")) {
                        String verb = propInfo.getValue();
                        if (verb == null) continue;
                        this.verbCB.setSelectedItem(verb);
                        if (verb.equals("GET")) {
                            this.httpCtx._isGet = true;
                            continue;
                        }
                        this.httpCtx._isGet = false;
                        continue;
                    }
                    if (propInfo.getName().equals("http.payload")) {
                        String payload = propInfo.getValue();
                        if (payload == null) continue;
                        this.payloadCB.setSelectedItem(payload);
                        this.httpCtx._payloadType = payload;
                        continue;
                    }
                    if (!propInfo.getName().equals("endpointURI") || (endpoint = propInfo.getValue()) == null) continue;
                    this.endpointName.setText(endpoint);
                    this.httpCtx._endpoint = endpoint;
                }
            }
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.initControls();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.initControls();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.initControls();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.m_wcontext._importedWsdlInfo == null) {
            if (this.onewayRB.isSelected()) {
                this.operationName.setText("Send");
            } else {
                this.operationName.setText("Request-Response");
            }
        } else {
            this.initControls();
        }
        if (e.getSource() == this.typeCB) {
            this.typeValueChanged();
        }
        if (e.getSource() == this.verbCB) {
            if (this.verbCB.getSelectedItem().equals("GET")) {
                this.payloadCB.setSelectedItem("url-encoded");
                this.payloadCB.setEnabled(false);
            } else {
                this.payloadCB.setEnabled(true);
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.typeValueChanged();
        }
    }

    private void initControls() {
        if (this.endpointName.isVisible()) {
            if (!this.endpointName.getText().trim().equals("")) {
                this.m_page.setCanAdvance(true);
            } else {
                this.m_page.setCanAdvance(false);
            }
        } else {
            this.m_page.setCanAdvance(true);
        }
        if (this.verbCB.getSelectedItem().equals("GET")) {
            this.payloadCB.setSelectedItem("url-encoded");
            this.payloadCB.setEnabled(false);
        } else {
            this.payloadCB.setEnabled(true);
        }
    }

    private void typeValueChanged() {
        if (this.typeCB.getSelectedItem().equals(this.m_typeReference)) {
            this.onewayRB.setEnabled(false);
            this.reqrspRB.setEnabled(false);
            this.endpointPrompt.setVisible(true);
            this.endpointName.setVisible(true);
        } else {
            if (this.m_wcontext._read_service == null) {
                this.onewayRB.setEnabled(true);
                this.reqrspRB.setEnabled(true);
            } else {
                this.onewayRB.setEnabled(false);
                this.reqrspRB.setEnabled(false);
            }
            this.endpointPrompt.setVisible(false);
            this.endpointName.setVisible(false);
        }
        if (this.m_wcontext._read_service == null && this.m_wcontext._importedWsdlInfo == null) {
            this.reqrspRB.setSelected(true);
            this.operationName.setText("Request-Response");
        } else if (this.m_wcontext._importedWsdlInfo != null) {
            this.initControls();
        }
    }

    public void createWSDLOperationObjects(String operationName) throws WSDLException {
        this.m_wcontext._write_operation_name = operationName;
        Definition def1 = this.m_wcontext._write_definition;
        PortType portt = null;
        if (this.m_wcontext._importedWsdlInfo == null) {
            portt = def1.createPortType();
            QName portt_qname = new QName(this.m_wcontext._target_namespace, ServiceNamePage.getCleanName(operationName) + this.m_wcontext.PortType_suffix);
            portt.setQName(portt_qname);
            portt.setUndefined(false);
            def1.addPortType(portt);
            Operation oper1 = def1.createOperation();
            oper1.setName(operationName);
            oper1.setUndefined(false);
            portt.addOperation(oper1);
            this.m_wcontext._write_operation_abstract = oper1;
        } else {
            portt = WsdlInfo.getPorttypeByQname((Project)this.m_wcontext._project, (QName)this.m_wcontext._importedWsdlInfo.getRequestPorttype());
        }
        PartnerLinkType plt = (PartnerLinkType)this.m_wcontext._extReg.createExtension(PartnerLinkType.PARENT_CLASS, PartnerLinkType.FIELD_ELEMENT_TYPE);
        def1.addExtensibilityElement((ExtensibilityElement)plt);
        plt.setContext(this.m_wcontext);
        String pltname = portt.getQName().getLocalPart();
        if (pltname.endsWith(this.m_wcontext.PortType_suffix)) {
            pltname = pltname.substring(0, pltname.length() - this.m_wcontext.PortType_suffix.length());
        }
        this.m_wcontext._partnerLinkType_name = pltname + this.m_wcontext.PartnerLinkType_suffix;
        this.m_wcontext._role_name = operationName + this.m_wcontext.Role_suffix;
        plt.setPartnerLinkTypeName(this.m_wcontext._partnerLinkType_name);
        plt.setRoleName(this.m_wcontext._role_name);
        plt.setPortName(portt.getQName().getLocalPart());
        if (this.m_wcontext._importedWsdlInfo != null) {
            def1.addNamespace("imp1", portt.getQName().getNamespaceURI());
            plt.setPortNSPrefix("imp1");
        }
    }

    @Override
    public void wizardValidatePage(WizardEvent wizardEvent) {
        this.httpCtx._isOneWay = this.onewayRB.isSelected();
        this.httpCtx._isGet = this.verbCB.getSelectedItem().equals("GET");
        if (this.typeCB.getSelectedItem().equals(this.m_typeService)) {
            this.m_wcontext._isInboundOperation = true;
        } else {
            this.m_wcontext._isInboundOperation = false;
            if (this.endpointName.getText().trim().equals("")) {
                MultiLineOptionPane.showMessageDialog((Component)this, (Object)this.getTranslatedString("HTTP_EP_NOT_FOUND_ERR"));
                ((Cancelable)wizardEvent).cancel();
            } else {
                this.httpCtx._endpoint = this.endpointName.getText().trim();
            }
        }
        this.httpCtx._payloadType = (String)this.payloadCB.getSelectedItem();
        Wizard _wiz = this.m_wcontext._wizard;
        int pagecnt = _wiz.getPageCount();
        for (int pagenum = 0; pagenum < pagecnt; ++pagenum) {
            ImageWizardPage iwizpag = (ImageWizardPage)_wiz.getPageAt(pagenum);
            Component com1 = iwizpag.getInteractiveArea();
            if (!(com1 instanceof HttpSchemaPage)) continue;
            HttpSchemaPage schemapg = (HttpSchemaPage)com1;
            schemapg.updateControls();
        }
    }

    @Override
    public void buildWSDL() throws WSDLException, Exception {
        this.createCommonOperationObjects(this.operationName.getText().trim());
        JcaAddress jcaa = (JcaAddress)this.m_wcontext._extReg.createExtension(JcaAddress.PARENT_CLASS, JcaAddress.FIELD_ELEMENT_TYPE);
        this.m_wcontext._write_port.addExtensibilityElement((ExtensibilityElement)jcaa);
        this.m_wcontext._write_jca_address = jcaa;
    }
}

