/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.http;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.model.ArrayTwoDModel;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.javatools.util.BundleLoader;
import oracle.tip.tools.ide.common.sca.CommonScaUtils;
import oracle.tip.tools.ide.common.ui.NCNameField;
import oracle.tip.tools.ide.common.ui.ToolBar;
import oracle.tip.tools.ide.common.utils.MultiLineOptionPane;
import oracle.tip.tools.ide.fabric.addin.SCAProject;
import oracle.tip.tools.ide.fabric.api.SCAController;
import oracle.tip.tools.ide.fabric.api.SCAControllerImpl;
import oracle.tip.tools.ide.fabric.common.CommonUtils;
import oracle.tip.tools.ide.fabric.common.ScaCommonDialog;
import oracle.tip.tools.ide.fabric.resource.SCAResourceLookup;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.FocusRequester;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.http.HttpAdapterContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.http.HttpSchemaBuilder;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.http.HttpSchemaElementPanel;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.techAdapterWizard;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XMLSchemaNode;
import oracle.xml.parser.schema.XSDBuilder;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.schema.XSDSimpleType;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;

public class HttpGenNVSchemaPanel
extends JPanel
implements DocumentListener,
ActionListener,
MouseListener {
    public static final String XSD_SUFFIX = ".xsd";
    private static final String SCHEMA_NAMESPACE_URI = "http://TargetNamespace.com/http";
    private static final String DEFAULT_ROOT_ELEM = "root";
    private static int _SEQ = 1;
    private static int _UNBOUNDED = 0x7FFFFFF8;
    public static EmptyBorder s_emptyBorder = new EmptyBorder(2, 2, 2, 2);
    public static EtchedBorder s_etchedBorder = new EtchedBorder();
    JEWTDialog m_currdiag;
    Frame m_parentFrame;
    String m_scaDir;
    public AdapterWizardContext m_context = null;
    HttpAdapterContext httpCtx;
    Project m_project;
    SCAController m_scon;
    SCAProject m_scaproj;
    String m_serviceName;
    String m_xsdFileName;
    ArrayTwoDModel m_fldModel = new ArrayTwoDModel(0, 0);
    String m_wsdl_relpath;
    public Definition m_wdef = null;
    public static Point s_last_dialog_loc = null;
    public static Dimension s_last_dialog_size = null;
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JLabel introPrompt = new JLabel();
    private HttpSchemaElementPanel m_ElementGridPanel;
    ToolBar btnPnl = new ToolBar();
    private JLabel namespaceLabel = new JLabel();
    private JTextField namespaceField = new JTextField();
    private JLabel rootElementLabel = new JLabel();
    private NCNameField rootElement = new NCNameField();
    private JLabel schemaFileLabel = new JLabel();
    private JTextField schemaFile = new JTextField();
    private JLabel dummy1 = new JLabel();
    public static boolean MAIN_DEBUG = false;

    public HttpGenNVSchemaPanel(AdapterWizardContext context, JEWTDialog parentDialog, String schemaFileName) throws Exception {
        this.m_context = context;
        this.httpCtx = (HttpAdapterContext)context._ascontext;
        this.m_xsdFileName = schemaFileName;
        this.m_currdiag = parentDialog;
        try {
            if (!MAIN_DEBUG) {
                this.m_project = this.m_context._project;
                this.m_scon = SCAControllerImpl.getController((Project)this.m_project);
                this.m_scaproj = SCAProject.getSCAProject((Project)this.m_project);
                this.m_scaDir = SCAProject.getScaDirectoryPath((Project)this.m_project);
            } else {
                this.m_scaDir = "c:\\tmp";
            }
            if (this.m_xsdFileName != null) {
                this.schemaFile.setText(this.m_xsdFileName);
                this.parseSchemaFile(this.m_xsdFileName);
            }
            this.jbInit();
            if (!MAIN_DEBUG) {
                HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_med_createservicewsdl_html");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    private void jbInit() throws Exception {
        String introprompt = this.getTranslatedString("HTTP_SC_CREATE_INTRO");
        introprompt = !this.m_context._isInboundOperation && this.httpCtx._payloadType.equals("url-encoded") ? this.getTranslatedString("HTTP_SC_CREATE_INTRO_REF") : this.getTranslatedString("HTTP_SC_CREATE_INTRO");
        String namespaceText = this.getTranslatedString("HTTP_SC_CREATE_NAMESPACE_TXT");
        String namespaceTip = this.getTranslatedString("HTTP_SC_CREATE_NAMESPACE_TIP");
        String schemaFileText = this.getTranslatedString("HTTP_SC_SCHEMAFILE_TXT");
        String schemaFileTip = this.getTranslatedString("HTTP_SC_SCHEMAFILE_TIP");
        String rootElemText = this.getTranslatedString("HTTP_SC_CREATE_ROOTELEM_TXT");
        String rootElemTip = this.getTranslatedString("HTTP_SC_CREATE_ROOTELEM_TIP");
        this.setLayout(this.gridBagLayout1);
        this.introPrompt.setText(introprompt);
        this.m_ElementGridPanel = new HttpSchemaElementPanel(this.m_context, this.m_fldModel);
        this.m_ElementGridPanel.setName("m_ElementGridPanel");
        this.schemaFileLabel.setText(StringUtils.stripMnemonic((String)schemaFileText));
        this.schemaFileLabel.setLabelFor(this.schemaFile);
        this.schemaFileLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)schemaFileText));
        this.schemaFile.setToolTipText(schemaFileTip);
        this.schemaFile.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)schemaFileText));
        this.schemaFile.getAccessibleContext().setAccessibleDescription(schemaFileTip);
        this.schemaFile.getDocument().addDocumentListener(this);
        this.namespaceLabel.setText(StringUtils.stripMnemonic((String)namespaceText));
        this.namespaceLabel.setLabelFor(this.namespaceField);
        this.namespaceLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)namespaceText));
        this.namespaceField.setToolTipText(namespaceTip);
        this.namespaceField.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)namespaceText));
        this.namespaceField.getAccessibleContext().setAccessibleDescription(namespaceTip);
        this.namespaceField.setName("namespaceField");
        this.namespaceField.getDocument().addDocumentListener(this);
        this.rootElementLabel.setText(StringUtils.stripMnemonic((String)rootElemText));
        this.rootElementLabel.setLabelFor((Component)this.rootElement);
        this.rootElementLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)rootElemText));
        this.rootElement.setToolTipText(rootElemTip);
        this.rootElement.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)rootElemText));
        this.rootElement.getAccessibleContext().setAccessibleDescription(rootElemTip);
        this.rootElement.getDocument().addDocumentListener(this);
        this.rootElement.setName("rootElement");
        this.rootElement.setMaximumCharacterLength(248);
        this.add((Component)this.introPrompt, new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 10, 0), 0, 0));
        int leftpad = 5;
        int toppad = 10;
        this.add((Component)this.namespaceLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(20, leftpad, 0, 6), 0, 0));
        this.add((Component)this.namespaceField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(20, 0, 0, leftpad), 0, 0));
        this.add((Component)this.rootElementLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(toppad, leftpad, 0, 6), 0, 0));
        this.add((Component)this.rootElement, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(toppad, 0, toppad, leftpad), 0, 0));
        this.add((Component)this.m_ElementGridPanel, new GridBagConstraints(0, 3, 0, 1, 1.0, 0.0, 18, 2, new Insets(toppad, 0, 0, 0), 0, 0));
        this.add((Component)this.schemaFileLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(toppad, leftpad, 0, 6), 0, 0));
        this.add((Component)this.schemaFile, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(toppad, 0, 0, leftpad), 0, 0));
        this.add((Component)this.dummy1, new GridBagConstraints(0, 5, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        if (this.namespaceField.getText().trim().equals("")) {
            this.namespaceField.setText(SCHEMA_NAMESPACE_URI);
        }
        if (this.rootElement.getText().trim().equals("")) {
            this.rootElement.setText(DEFAULT_ROOT_ELEM);
        }
        if (this.m_xsdFileName.equals("")) {
            Project project = this.m_context._project;
            String schemapath = SCAProject.getScaSchemaDirectoryPath((Project)project);
            this.m_xsdFileName = this.m_context._write_service_name + "_" + this.getNextSeq() + XSD_SUFFIX;
            String fullSchemaFilename = schemapath + File.separatorChar + this.m_xsdFileName;
            while (new File(fullSchemaFilename).exists()) {
                this.m_xsdFileName = this.m_context._write_service_name + "_" + this.getNextSeq() + XSD_SUFFIX;
                fullSchemaFilename = schemapath + File.separatorChar + this.m_xsdFileName;
            }
            this.schemaFile.setText(this.m_xsdFileName);
        }
    }

    public static String getDefaultNamespace(Context context, String namespacePrefix, String namespaceSuffix) {
        if (!MAIN_DEBUG) {
            return namespacePrefix + CommonScaUtils.getEncodedName((String)HttpGenNVSchemaPanel.getApplicationShortName(context)) + "/" + CommonScaUtils.getEncodedName((String)HttpGenNVSchemaPanel.getProjectShortName(context)) + "/" + CommonScaUtils.getEncodedName((String)namespaceSuffix);
        }
        return namespacePrefix + namespaceSuffix;
    }

    public static String getProjectShortName(Context context) {
        Project jproject = context.getProject();
        String projectName = jproject.toString();
        projectName = projectName.substring(0, projectName.lastIndexOf("."));
        return projectName;
    }

    public static String getApplicationShortName(Context context) {
        Workspace work1 = context.getWorkspace();
        String appName = work1.getShortLabel();
        appName = appName.substring(0, appName.lastIndexOf("."));
        return appName;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        JButton button;
        Object object = e.getSource();
        if (object instanceof JButton && (button = (JButton)object).isEnabled()) {
            button.setBorder(s_etchedBorder);
            button.setCursor(Cursor.getPredefinedCursor(12));
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        Object object = e.getSource();
        if (object instanceof JButton) {
            JButton button = (JButton)object;
            button.setBorder(s_emptyBorder);
            button.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void focusGained(FocusEvent e) {
    }

    private void checkXmlName(JTextField field) {
        if (!SCAControllerImpl.isNameValidForXml((String)field.getText().trim())) {
            MultiLineOptionPane.showMessageDialog((Component)this.m_parentFrame, (Object)SCAResourceLookup.getString((String)"CM_NAME_FIELD_ERROR"), (String)SCAResourceLookup.getString((String)"CM_NAME_FIELD_ERROR_TITLE"), (int)0);
            new FocusRequester(field);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.checkDoc(e);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.checkDoc(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.checkDoc(e);
    }

    private void checkDoc(DocumentEvent e) {
        if (!this.rootElement.getText().equals("") && !this.namespaceField.getText().equals("")) {
            this.m_currdiag.setOKButtonEnabled(true);
        } else {
            this.m_currdiag.setOKButtonEnabled(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
    }

    public boolean generateSchema() {
        String schemapath = null;
        String xsdFilename = null;
        this.m_xsdFileName = this.schemaFile.getText().trim();
        if (!MAIN_DEBUG) {
            Project project = this.m_context._project;
            schemapath = SCAProject.getScaSchemaDirectoryPath((Project)project);
            xsdFilename = schemapath + File.separatorChar + this.m_xsdFileName;
        } else {
            schemapath = "c:\\tmp" + File.separatorChar + this.m_xsdFileName;
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            HttpSchemaBuilder schemaBuilder = new HttpSchemaBuilder(baos);
            schemaBuilder.startSchemaDocument(this.getTargetNamespace(), true, false);
            schemaBuilder.startElement(this.getRootElement(), null, null, false);
            schemaBuilder.startComplexType(null);
            schemaBuilder.startModelGroup(HttpSchemaBuilder.S_SEQUENCE);
            ArrayTwoDModel fldGrid = this.getFieldGrid();
            for (int row = 0; row < fldGrid.getRowCount(); ++row) {
                String fldName = (String)fldGrid.getData(0, row);
                String fldType = (String)fldGrid.getData(1, row);
                String s_minOccurs = (String)fldGrid.getData(2, row);
                Integer i_minOccurs = Integer.valueOf(s_minOccurs);
                if (i_minOccurs == 1) {
                    i_minOccurs = -1;
                }
                String s_maxOccurs = (String)fldGrid.getData(3, row);
                Integer i_maxOccurs = 1;
                if (s_maxOccurs.equals("unbounded")) {
                    i_maxOccurs = 0x7FFFFFF8;
                } else if (s_maxOccurs.equals("1")) {
                    i_maxOccurs = -1;
                }
                schemaBuilder.startElement(fldName, fldType, null, i_minOccurs, i_maxOccurs, null, null, true);
                schemaBuilder.endElement();
            }
            schemaBuilder.endModelGroup(HttpSchemaBuilder.S_SEQUENCE);
            schemaBuilder.endComplexType();
            schemaBuilder.endElement();
            schemaBuilder.endSchemaDocument();
            String xsdContents = baos.toString();
            if (!HttpGenNVSchemaPanel.isSchemaFileNew(this.m_parentFrame, xsdFilename)) {
                return false;
            }
            this.saveXSD(xsdFilename, xsdContents);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        return true;
    }

    private boolean saveXSD(String fileUri, String xsdContents) {
        String encoding = "UTF-8";
        boolean success = false;
        try {
            FileOutputStream out_stream = new FileOutputStream(fileUri);
            OutputStreamWriter outWriter = new OutputStreamWriter((OutputStream)out_stream, encoding);
            BufferedWriter writer = new BufferedWriter(outWriter);
            writer.write(xsdContents);
            writer.flush();
            writer.close();
            outWriter.close();
            out_stream.close();
            success = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return success;
    }

    public static boolean isSchemaFileNew(Frame frame, String filepath) {
        File testfile = new File(filepath);
        if (testfile.exists()) {
            ResourceBundle rbundle = BundleLoader.getBundle((String)techAdapterWizard.RESOURCE_BUNDLE);
            MessageFormat msgformat = new MessageFormat(rbundle.getString("HTTP_SC_SCHEMA_EXISTS_ERROR"));
            Object[] obj = new Object[]{filepath};
            int ret = JOptionPane.showOptionDialog(frame, msgformat.format(obj), rbundle.getString("HTTP_SC_SCHEMA_EXISTS_TITLE"), 0, 3, null, null, null);
            if (ret == 1) {
                return false;
            }
            if (ret == 0) {
                return true;
            }
        }
        return true;
    }

    private boolean checkElementNamespace(String xsdLoc, QName elemQname, JTextField schemaField) {
        return CommonUtils.checkElementNamespace((Frame)this.m_parentFrame, (String)xsdLoc, (QName)elemQname, (JTextField)schemaField);
    }

    public static HttpGenNVSchemaPanel displayDialog(Frame parentFrame, AdapterWizardContext context, String schemaFile) {
        HttpGenNVSchemaPanel schemaPanel = null;
        try {
            if (MAIN_DEBUG) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        ScaCommonDialog diag1 = new ScaCommonDialog(parentFrame, "Create Schema", 7, null);
        diag1.setResizable(true);
        if (s_last_dialog_size != null) {
            diag1.setPreferredSize(s_last_dialog_size);
        } else {
            diag1.setPreferredSize(500, 380);
        }
        try {
            schemaPanel = new HttpGenNVSchemaPanel(context, (JEWTDialog)diag1, schemaFile);
        }
        catch (Exception exp) {
            return null;
        }
        HelpSystem.getHelpSystem().registerTopic((JComponent)schemaPanel, "f1_soahttpcreatesch_html");
        diag1.setContent((Component)schemaPanel);
        diag1.setCancelButtonText("Cancel");
        while (true) {
            boolean validated = false;
            boolean ok = false;
            ok = diag1.runDialog();
            if (!ok) break;
            validated = schemaPanel.generateSchema();
            if (validated) {
                return schemaPanel;
            }
            new FocusRequester((Component)schemaPanel.rootElement);
        }
        return null;
    }

    private String getTranslatedString(String messageKey) {
        return this.m_context._bundle.getString(messageKey);
    }

    public String getTargetNamespace() {
        return this.namespaceField.getText().trim();
    }

    public String getRootElement() {
        return this.rootElement.getText().trim();
    }

    public ArrayTwoDModel getFieldGrid() {
        return this.m_ElementGridPanel.getFieldGridDs();
    }

    public String getXSDFileName() {
        return this.m_xsdFileName;
    }

    private void parseSchemaFile(String schemaFile) {
        FileInputStream fis = null;
        Project project = this.m_context._project;
        String schemapath = SCAProject.getScaSchemaDirectoryPath((Project)project);
        String xsdFilename = schemapath + File.separatorChar + schemaFile;
        try {
            fis = new FileInputStream(xsdFilename);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            DOMParser domparser = new DOMParser();
            domparser.parse((InputStream)fis);
            XMLDocument doc = domparser.getDocument();
            XSDBuilder builder = new XSDBuilder();
            XMLSchema schema = builder.build(doc, null);
            this.namespaceField.setText(schema.getSchemaTargetNS());
            XMLSchemaNode schemaNode = schema.getSchemaByTargetNS(schema.getSchemaTargetNS());
            XSDNode[] globalElements = schemaNode.getElementSet();
            this.extractDef(globalElements[0]);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void extractDef(XSDNode node) {
        ArrayTwoDModel fldElements = new ArrayTwoDModel(4, 0);
        if (node.getNodeType() == 3) {
            XSDElement element = (XSDElement)node;
            this.rootElement.setText(element.getName());
            XSDNode[] childElements = element.getChildElements();
            fldElements.addRows(0, childElements.length);
            for (int i = 0; i < childElements.length; ++i) {
                element = (XSDElement)childElements[i];
                int row = fldElements.getRowCount();
                fldElements.setData(0, i, (Object)element.getName());
                XSDSimpleType simpleType = (XSDSimpleType)element.getType();
                if (simpleType != null) {
                    fldElements.setData(1, i, (Object)simpleType.getName());
                }
                if (element.getMinOccurs() > -1) {
                    fldElements.setData(2, i, (Object)String.valueOf(element.getMinOccurs()));
                }
                if (element.getMaxOccurs() <= -1) continue;
                fldElements.setData(3, i, (Object)String.valueOf(element.getMaxOccurs()));
            }
        }
        this.m_fldModel = fldElements;
    }

    private synchronized int getNextSeq() {
        return _SEQ++;
    }
}

