/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.http;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URL;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.UIManager;
import javax.wsdl.WSDLException;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.ewt.wizard.WelcomeWizardPage;
import oracle.bali.ewt.wizard.Wizard;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.bali.ewt.wizard.WizardListener;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.ide.Context;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Project;
import oracle.ide.model.TechId;
import oracle.ide.model.TechnologyRegistry;
import oracle.ide.model.TechnologyScope;
import oracle.ide.model.TechnologyScopeConfiguration;
import oracle.ide.net.URLFactory;
import oracle.ide.wizard.WizardWelcomePage;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.BundleLoader;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.utils.MultiLineOptionPane;
import oracle.tip.tools.ide.fabric.addin.SCAProject;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardDialog;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.ServiceTypePage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.AdapterWsdlInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.WizardWSDLUtil;

public class HttpBindingWizard
implements WizardListener {
    public static String RESOURCE_BUNDLE = "oracle.tip.tools.ide.pm.modules.bizintegration.adapter.techAdapterResource";
    public static String TECH_ADAPTER_WELCOME_PAGE_KEY = "bpm_modeler_tech_adapter_wizard_welcome4";
    private static final Color[] WIZARD_HEADER_GRADIENT = new Color[]{new Color(254, 254, 254), new Color(206, 223, 230)};
    public static String S_wsdl_in = null;
    public static String S_testing_filedir = "c:\\tmp";
    AdapterWizardDialog _wizardDialog;
    AdapterWizardContext _wcontext = new AdapterWizardContext();
    Context m_jcontext = null;
    Wizard _wizard;
    Image _image;
    WizardWSDLUtil m_wsdlUtil;
    WelcomeWizardPage m_wpage;
    boolean m_isWelcomeShown = true;
    boolean okToGo = true;
    Project _proj = null;

    public HttpBindingWizard(Frame parentFrame, String update_wsdl_path, String adapter, Project proj, boolean isExternalReference) throws WSDLException {
        this._wcontext._isInboundOperation = !isExternalReference;
        this._proj = proj;
        if (update_wsdl_path == null && this.isValidAdapter(adapter)) {
            this._wcontext._service_type = adapter;
        }
        this.init(parentFrame, update_wsdl_path);
    }

    public HttpBindingWizard(Frame parentFrame, String update_wsdl_path, String adapter, String composite_service_name, Project proj, boolean isExternalReference) throws WSDLException {
        this(parentFrame, update_wsdl_path, adapter, proj, isExternalReference);
        this._wcontext._composite_service_name = composite_service_name;
    }

    private void init(Frame parentFrame, String update_wsdl_path) throws WSDLException {
        this._wcontext._bundle = BundleLoader.getBundle((String)RESOURCE_BUNDLE);
        this._wcontext.initializeTranslatableStrings();
        if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this._wcontext.isStandalone()) {
            if (this._proj == null) {
                this.m_jcontext = Context.newIdeContext();
                this._wcontext._project = this.m_jcontext.getProject();
            } else {
                this._wcontext._project = this._proj;
            }
            this.m_isWelcomeShown = WizardWelcomePage.isWelcomeShown((String)TECH_ADAPTER_WELCOME_PAGE_KEY);
            this._wcontext.setFilePath(SCAProject.getScaWSDLDirectoryPath((Project)this._wcontext._project));
            this._wcontext.setSchemaFilePath(SCAProject.getScaSchemaDirectoryPath((Project)this._wcontext._project));
            TechnologyScope ts = TechnologyScopeConfiguration.getInstance((PropertyStorage)this._wcontext._project).getTechnologyScope();
            TechId bpm = TechnologyRegistry.getInstance().getTechId("BPM");
            this._wcontext.setIsBPM(bpm != null && ts.contains(bpm));
        }
        this._wcontext._parentFrame = parentFrame == null ? new Frame() : parentFrame;
        this._wcontext._update_wsdl_path = update_wsdl_path = this.getAbsolutePath(update_wsdl_path);
        this._wcontext._write_wsdl_name = update_wsdl_path;
        this._wcontext._wsdlUtil = this.m_wsdlUtil = new WizardWSDLUtil(this._wcontext);
        int retcod = this.m_wsdlUtil.initWSDL();
        if (retcod != 0) {
            this.okToGo = false;
            return;
        }
        this._createWizard();
        this._wizardDialog = new AdapterWizardDialog(this._wizard, parentFrame);
        if (this._wcontext._service_type.equals("Http")) {
            this._wizardDialog.setWizardTitle(this._wcontext._bundle.getString("CM_HTTP_WZ_TITLE"));
        }
        this._wizardDialog.setWelcomePageIncluded(this.m_isWelcomeShown);
        this._wizardDialog.setFinishPageIncluded(true);
        this._wizardDialog.getAccessibleContext().setAccessibleDescription(this._wizardDialog.getWizardTitle());
    }

    private String getAbsolutePath(String filePath) {
        try {
            String absolutePath = null;
            if (filePath != null) {
                URL wurl = URLFactory.newURL((String)filePath);
                String tempPath = wurl.getFile();
                if (System.getProperty("os.name").toUpperCase().startsWith("WINDOWS") && (tempPath.startsWith("/") || tempPath.startsWith("\\"))) {
                    tempPath = tempPath.substring(1);
                }
                absolutePath = tempPath;
            }
            return absolutePath;
        }
        catch (Exception e) {
            return filePath;
        }
    }

    public void display() {
        if (this.okToGo) {
            this._wizardDialog.runDialog();
        }
    }

    public AdapterWizardContext getAdapterWizardContext() {
        return this._wcontext;
    }

    public AdapterWsdlInfo getAdapterWsdlInfo() {
        AdapterWsdlInfo wsdlInfo = null;
        try {
            wsdlInfo = WizardWSDLUtil.getAdapterWsdlInfoNoJca(this._wcontext);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return wsdlInfo;
    }

    public String getScaName() {
        return this._wcontext._scaName;
    }

    private void _createWizard() {
        try {
            if (AdapterWizardContext.IS_STANDALONE_TESTING) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this._wcontext._wizard = this._wizard = new Wizard();
        this._wizard.addWizardListener((WizardListener)this);
        HttpBindingWizard httpBindingWizard = this;
        this._wizard.setLogoImage(httpBindingWizard._wcontext._getImage());
        this._wizard.setHeaderGradientBackground(WIZARD_HEADER_GRADIENT);
        String welcometxt = this._wcontext._bundle.getString("CM_WZ_WELCOME_TEXT");
        if (this._wcontext._read_definition != null) {
            welcometxt = this._wcontext._bundle.getString("CM_WZ_WELCOME_HTTP_TEXT_UPD");
        } else if (this._wcontext._read_definition == null && this._wcontext._service_type != null) {
            welcometxt = this.getWelcomeMessage(this._wcontext._service_type);
        }
        String welcomePageIntroTxt = null;
        if (this._wcontext._service_type.equals("Http")) {
            welcomePageIntroTxt = this._wcontext._bundle.getString("CM_WZ_HTTP_WELCOME_PAGE_INTRO");
        }
        HttpBindingWizard httpBindingWizard2 = this;
        this.m_wpage = new WelcomeWizardPage(httpBindingWizard2._wcontext._getImage(), welcomePageIntroTxt, welcometxt);
        if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this._wcontext.isStandalone() && this._wcontext._service_type.equals("Http")) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)this.m_wpage.getContent(), "f1_soahttpbindwel_html");
        }
        this._wizard.addPage((WizardPage)this.m_wpage);
        HttpBindingWizard httpBindingWizard3 = this;
        ImageWizardPage iwp = new ImageWizardPage(null, httpBindingWizard3._wcontext._getImage(), this._wcontext._bundle.getString("CM_ST_PAGE_TITLE"));
        if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this._wcontext.isStandalone()) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)iwp.getContent(), "bpmjdev_adp_wiz_type");
        }
        ServiceTypePage dsp0 = new ServiceTypePage(this._wcontext, iwp);
        if (!this.m_isWelcomeShown) {
            this._wizard.setCurrentPageIndex(1);
            this.m_wpage.setSkipNextTime(true);
        }
    }

    private boolean isValidAdapter(String adapter) {
        return "Http".equals(adapter);
    }

    private String getWelcomeMessage(String adapter) {
        if ("Http".equals(adapter)) {
            return this._wcontext._bundle.getString("CM_WZ_WELCOME_TEXT_HTTP");
        }
        return this._wcontext._bundle.getString("CM_WZ_WELCOME_TEXT");
    }

    public void wizardSelectionChanged(WizardEvent event) {
    }

    public void wizardApplyState(WizardEvent event) {
    }

    public void wizardCanceled(WizardEvent event) {
        Dimension newsize = this._wizardDialog.getSize();
        this._wizardDialog.setPreferredSize(newsize);
        this._wcontext._wsdlFileURL = null;
        this.closeConnection();
    }

    public void wizardFinished(WizardEvent event) {
        Dimension newsize = this._wizardDialog.getSize();
        this._wizardDialog.setPreferredSize(newsize);
        if (this.m_wpage != null && !AdapterWizardContext.IS_STANDALONE_TESTING && !this._wcontext.isStandalone()) {
            boolean skipit = this.m_wpage.isSkipNextTime();
            WizardWelcomePage.setWelcomeShown((!skipit ? 1 : 0) != 0, (String)TECH_ADAPTER_WELCOME_PAGE_KEY);
        }
        String progressTitleStr = this._wcontext._bundle.getString("CM_PROCESSING");
        FinishProgressBarDialog progressDialog = new FinishProgressBarDialog(this._wcontext._parentFrame, progressTitleStr, this);
    }

    public void processFinishTask() {
        try {
            boolean ok;
            if (this._wcontext._adapterWizardFinish != null && !(ok = this._wcontext._adapterWizardFinish.beforeWSDL(this._wcontext))) {
                this.closeConnection();
                return;
            }
            if (this._wcontext._service_type.equals("Http")) {
                this.m_wsdlUtil.createWSDL();
                this.m_wsdlUtil.saveHttpBindingWSDLFile();
            } else {
                this.m_wsdlUtil.createWSDL();
                this.m_wsdlUtil.saveWSDLFile();
            }
            if (this._wcontext._adapterWizardFinish != null) {
                this._wcontext._adapterWizardFinish.afterWSDL(this._wcontext);
            }
            if (this._wcontext.isBPM() && this._wcontext.getPromoteToBusinessCatalog()) {
                this.invokeAdapterBpmExtension();
            }
            this.closeConnection();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            MessageFormat msgformat = new MessageFormat(this._wcontext._bundle.getString("CM_WZ_WSDL_WRITE_ERROR_MSG"));
            Object[] obj = new Object[]{this._wcontext._write_wsdl_name, ex.getMessage()};
            MultiLineOptionPane.showMessageDialog((Component)this._wcontext._finish_page.getInteractiveArea(), (Object)msgformat.format(obj), (String)this._wcontext._bundle.getString("CM_WZ_WSDL_WRITE_ERROR_TITLE"), (int)0);
            this.closeConnection();
        }
    }

    public void invokeAdapterBpmExtension() {
        try {
            Class<?> bcpDialog = Class.forName("oracle.bpm.fusion.soa.ui.extension.BusinessCatalogPromotionDialog");
            Class[] paramTypes = new Class[]{JFrame.class, Context.class, String.class, String.class, Boolean.TYPE};
            Constructor<?> constr = bcpDialog.getConstructor(paramTypes);
            Context ctx = Context.newIdeContext();
            JFrame parentFrame = GraphUtils.getFrame((Component)ctx.getView().getGUI());
            File wsdlFile = new File(new URI(this._wcontext._wsdlFileURL.toString()));
            String relativeWsdlPath = wsdlFile.getName();
            String serviceName = this._wcontext._composite_service_name;
            Object[] args = new Object[]{parentFrame, ctx, relativeWsdlPath, serviceName, false};
            Object bcpDialogInstance = constr.newInstance(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            MultiLineOptionPane.showMessageDialog((Component)this._wcontext._finish_page.getInteractiveArea(), (Object)this._wcontext._bundle.getString("BPM_REFLECTION_LOAD_ERROR"), (String)this._wcontext._bundle.getString("BPM_ADAPTER_EXTENSION"), (int)0);
        }
    }

    public void closeConnection() {
        if (this._wcontext._connection != null && AdapterWizardContext.IS_STANDALONE_TESTING) {
            try {
                this._wcontext._connection.close();
            }
            catch (SQLException ex) {
                System.out.println(this._wcontext._bundle.getString("CM_CN_CONNECTION_CLOSE_ERROR") + ex.getLocalizedMessage());
            }
            this._wcontext._connection = null;
        }
    }

    public List getURLs() {
        return this._wcontext.getURLs();
    }

    private class FinishProgressBarDialog
    extends JDialog
    implements WindowListener {
        private JProgressBar progressBar;
        private boolean isTaskDone;
        protected FinishProgressBarDialog finishProgressBarDialog;
        private HttpBindingWizard httpBindingWizard;
        private JLabel progressLabel;
        private Thread worker;

        public FinishProgressBarDialog(Frame frame, String title, HttpBindingWizard adapterWizard) {
            super(frame, title, true);
            this.isTaskDone = false;
            this.worker = null;
            this.httpBindingWizard = adapterWizard;
            this.finishProgressBarDialog = this;
            this.init();
        }

        private void init() {
            String processingText = this.getTranslatedString("CM_PROCESSING_MSG");
            this.setDefaultCloseOperation(0);
            this.addWindowListener(this);
            this.setLocationRelativeTo(this.getParent());
            GridBagLayout gridBagLayout = new GridBagLayout();
            JPanel panel = new JPanel();
            panel.setLayout(gridBagLayout);
            panel.setSize(400, 500);
            this.progressLabel = new JLabel(processingText);
            this.progressBar = new JProgressBar();
            this.progressBar.setIndeterminate(true);
            panel.add((Component)this.progressLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(15, 20, 20, 20), 0, 0));
            panel.add((Component)this.progressBar, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 20, 20, 20), 0, 0));
            this.setContentPane(panel);
            this.runThread();
            if (!this.isTaskDone) {
                this.pack();
                this.setVisible(true);
            }
        }

        private void runThread() {
            this.worker = new Thread(new Runnable(){

                @Override
                public void run() {
                    FinishProgressBarDialog.this.httpBindingWizard.processFinishTask();
                    FinishProgressBarDialog.this.isTaskDone = true;
                    FinishProgressBarDialog.this.worker = null;
                    FinishProgressBarDialog.this.finishProgressBarDialog.dispose();
                }
            });
            this.worker.start();
        }

        public String getTranslatedString(String messageKey) {
            return this.httpBindingWizard._wcontext._bundle.getString(messageKey);
        }

        @Override
        public void windowClosing(WindowEvent e) {
            if (this.worker != null && !this.isTaskDone) {
                this.worker.interrupt();
            }
            this.worker = null;
            this.dispose();
        }

        @Override
        public void windowClosed(WindowEvent e) {
        }

        @Override
        public void windowOpened(WindowEvent e) {
        }

        @Override
        public void windowIconified(WindowEvent e) {
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
        }

        @Override
        public void windowActivated(WindowEvent e) {
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
        }

        public void windowGainedFocus(WindowEvent e) {
        }

        public void windowLostFocus(WindowEvent e) {
        }

        public void windowStateChanged(WindowEvent e) {
        }
    }
}

