/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.http;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.event.DocumentListener;
import oracle.ide.Context;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.jdevimpl.xml.schema.XmlSchemaNode;
import oracle.tip.tools.ide.common.datasources.CompoundDataSource;
import oracle.tip.tools.ide.common.datasources.schema.ProjectSchemaDataSource;
import oracle.tip.tools.ide.common.datasources.wsdl.ProjectWSDLDataSource;
import oracle.tip.tools.ide.common.typeexplorer.SchemaImportHandler;
import oracle.tip.tools.ide.common.typeexplorer.TypeChooser;
import oracle.tip.tools.ide.common.typeexplorer.TypeObject;
import oracle.tip.tools.ide.common.typeexplorer.WSDLImportHandler;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.ui.treeexplorer.TreeExplorerDataSource;
import oracle.tip.tools.ide.common.utils.MultiLineOptionPane;
import oracle.tip.tools.ide.pm.ide.bpel.jdeveloper.JDevBPELProject;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardSchemaImportHandler;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.CommonSchemaPanel;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.QNameDisplay;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.http.HttpGenNVSchemaPanel;
import oracle.tip.tools.ide.tx.addin.MapperWSDLImportHandler;

public class CommonHttpSchemaPanel
extends CommonSchemaPanel {
    public CommonHttpSchemaPanel(Project project, String projectDirectoryPath, ResourceBundle rbundle, Frame parentFrame, AdapterWizardContext wcontext, String serviceName, boolean hasBorder, String panelBorderText, DocumentListener doclisten, boolean hasOpaque, boolean futureUse, String futureUse2) {
        super(project, projectDirectoryPath, rbundle, parentFrame, wcontext, serviceName, hasBorder, panelBorderText, doclisten, hasOpaque, futureUse, futureUse2);
        String createSchemaBtnToolTip = this.m_bundle.getString("HTTP_SC_CREATE_BUTTON_TIP");
        this.createSchemaButton.setToolTipText(createSchemaBtnToolTip);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.browseSchemaButton) {
            this.handleBrowseSchema();
        } else if (src == this.createSchemaButton) {
            this.handleCreateSchema();
        }
    }

    public void setCreateSchemaButtonVisible(boolean b) {
        this.createSchemaButton.setVisible(b);
    }

    public void setCreateSchemaButtonEnabled(boolean b) {
        this.createSchemaButton.setEnabled(b);
    }

    private void handleCreateSchema() {
        this.m_lasturl = this.schemaLoc.getText().trim();
        HttpGenNVSchemaPanel schemaPanel = null;
        String tempstr = this.schemaLoc.getText().trim();
        if (tempstr != null && tempstr.length() > 0 && !tempstr.equals("xsd/singleString.xsd")) {
            String sepchar = File.separator;
            sepchar = "/";
            if (tempstr.contains(sepchar)) {
                tempstr = tempstr.substring(tempstr.lastIndexOf(sepchar) + 1);
            }
            schemaPanel = HttpGenNVSchemaPanel.displayDialog(this.m_parentFrame, this.m_wcontext, tempstr);
        } else {
            schemaPanel = HttpGenNVSchemaPanel.displayDialog(this.m_parentFrame, this.m_wcontext, tempstr);
        }
        if (schemaPanel != null) {
            this.m_schemaHasError = false;
            this.elementCB.removeAllItems();
            QNameDisplay qnd = new QNameDisplay(schemaPanel.getTargetNamespace(), schemaPanel.getRootElement());
            this.elementCB.addItem(qnd);
            this.elementCB.setSelectedItem(qnd);
            if (this.m_project != null) {
                URL xsdUrl = URLFactory.newURL((String)("file:" + this.m_newSchemaDirPath + "/" + schemaPanel.getXSDFileName()));
                URL projUrl = URLFactory.newURL((String)("file:" + this.m_projectDirectoryPath + "/"));
                tempstr = URLFileSystem.toRelativeSpec((URL)xsdUrl, (URL)projUrl);
                this.schemaLoc.setText(tempstr);
                try {
                    Node xsdNode = NodeFactory.findOrCreate(XmlSchemaNode.class, (URL)xsdUrl);
                    this.m_project.add((Element)xsdNode, true);
                }
                catch (Exception except) {
                    except.printStackTrace();
                    MessageFormat msgformat = new MessageFormat(this.m_bundle.getString("CM_WZ_PROJECT_FILE_ERROR_MSG"));
                    Object[] obj = new Object[]{xsdUrl.getFile(), except.getLocalizedMessage()};
                    MultiLineOptionPane.showMessageDialog((Component)this.m_parentFrame, (Object)msgformat.format(obj), (String)this.m_bundle.getString("CM_WZ_PROJECT_FILE_ERROR_TITLE"), (int)0);
                }
            }
            this.m_lasturl = this.schemaLoc.getText().trim();
        }
    }

    private void handleBrowseSchema() {
        this.m_lasturl = this.schemaLoc.getText().trim();
        Context jdevcontext = Context.newIdeContext();
        if (jdevcontext != null) {
            TypeChooser chooser = new TypeChooser(UIHelper.getFrame((Component)this));
            CompoundDataSource ds = new CompoundDataSource();
            ds.addDataSource((TreeExplorerDataSource)new ProjectSchemaDataSource(jdevcontext, false, true));
            ds.addDataSource((TreeExplorerDataSource)new ProjectWSDLDataSource(jdevcontext, false, true, false));
            chooser.getTypeExplorer().setSchemaImportHandler((SchemaImportHandler)new AdapterWizardSchemaImportHandler(new JDevBPELProject(this.m_project)));
            MapperWSDLImportHandler wimph = new MapperWSDLImportHandler(jdevcontext);
            wimph.setTargetDirLocation(this.m_wsdlDirUrl);
            chooser.getTypeExplorer().setWSDLImportHandler((WSDLImportHandler)wimph);
            chooser.setTargetSchemaDirLocation(this.m_newSchemaDirUrl);
            chooser.setTargetWSDLDirLocation(this.m_wsdlDirUrl);
            int rcint = chooser.display((TreeExplorerDataSource)ds);
            if (rcint == 0) {
                this.m_schemaHasError = false;
                TypeObject m_elementTypeObj = chooser.getTypeObject();
                URL fileUrl = (URL)m_elementTypeObj.getData("RESOURCE_URL_KEY");
                String file_type = (String)m_elementTypeObj.getData("FILE_TYPE_KEY");
                String file_name = CommonHttpSchemaPanel.convertUriRelativeProject(CommonHttpSchemaPanel.getBaseURL(this.m_projectDirectoryPath), fileUrl);
                if (file_type.equals("SCHEMA_FILE") && file_name.toLowerCase().endsWith("xsd")) {
                    this.loadSchemaElements(file_name, true);
                    String elname = m_elementTypeObj.getQName().getLocalPart();
                    for (int ii = this.elementCB.getItemCount(); ii > 0; --ii) {
                        QNameDisplay qn1 = (QNameDisplay)this.elementCB.getItemAt(ii - 1);
                        if (!elname.equals(qn1.toString())) continue;
                        this.elementCB.setSelectedItem(qn1);
                        break;
                    }
                } else {
                    this.elementCB.removeAllItems();
                    this.elementCB.addItem(new QNameDisplay(m_elementTypeObj.getQName()));
                }
                this.schemaLoc.setText(file_name);
                this.m_lasturl = this.schemaLoc.getText().trim();
                this.schemaLoc.requestFocus();
            }
        }
    }
}

