/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.ftp;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.wsdl.WSDLException;
import oracle.bali.ewt.event.Cancelable;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.bali.share.nls.StringUtils;
import oracle.tip.tools.ide.common.utils.MultiLineOptionPane;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.techAdapterWizardPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.JcaOperation;

public class FtpAdapterCreationTimePage
extends techAdapterWizardPage
implements ActionListener,
FocusListener,
DocumentListener {
    public static final String s_FileModificationTime = "FileModificationTime";
    public static final String s_FileSystem = "FileSystem";
    public static final String s_DirListing = "DirListing";
    public static final String s_Filename = "Filename";
    public static final String s_ModificationTimeFomat = "ModificationTimeFormat";
    public static final String s_ModificationTimeFormatOld = "ModificationTimeFormatOld";
    public static final String s_FileNameSubstringBegin = "FileNameSubstringBegin";
    public static final String s_FileNameSubstringEnd = "FileNameSubstringEnd";
    String save_format = null;
    ButtonGroup sourceGroup = new ButtonGroup();
    ButtonGroup substrGroup = new ButtonGroup();
    private MultiLineLabel introPrompt;
    private JRadioButton listingRB = new JRadioButton();
    private JRadioButton fileNameRB = new JRadioButton();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JLabel sourceLB = new JLabel();
    private JRadioButton systemRB = new JRadioButton();
    private JLabel oldListingFormatLB = new JLabel();
    private JTextField oldListingFormat = new JTextField();
    private JLabel newListingFormatLB = new JLabel();
    private JTextField newListingFormat = new JTextField();
    private JLabel beginSubstrLB = new JLabel();
    private JLabel endIndexLB = new JLabel();
    private NumericSpinBox beginIndex = new NumericSpinBox(0, Integer.MAX_VALUE);
    private NumericSpinBox endIndex = new NumericSpinBox(0, Integer.MAX_VALUE);
    private JLabel systemFormatLB = new JLabel();
    private JTextField systemFormat = new JTextField();
    private JLabel fileNameFormatLB = new JLabel();
    private JTextField fileNameFormat = new JTextField();

    public FtpAdapterCreationTimePage(AdapterWizardContext wcontext, ImageWizardPage iwp) {
        try {
            this.setContextAndPage(wcontext, iwp);
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        String intro = this.getTranslatedString("FTP_CT_INTRO_PROMPT");
        String sourcePrompt = this.getTranslatedString("FTP_CT_SOURCE_PROMPT");
        String systemRBtext = this.getTranslatedString("FTP_CT_SYSTEM_RB_PROMPT");
        String systemRBTip = this.getTranslatedString("FTP_CT_SYSTEM_RB_TIP");
        String systemFormatPrompt = this.getTranslatedString("FTP_CT_SYSTEM_FORMAT_PROMPT");
        String defaultSystemFormat = this.getTranslatedString("FTP_CT_DEFAULT_SYSTEM_FORMAT");
        String formatHint = this.getTranslatedString("FTP_CT_FORMAT_HINT");
        String listingRBtext = this.getTranslatedString("FTP_CT_LISTING_RB_PROMPT");
        String oldListingFormatPrompt = this.getTranslatedString("FTP_CT_OLD_LISTING_FORMAT_PROMPT");
        String defaultOldFormat = this.getTranslatedString("FTP_CT_DEFAULT_OLD_LISTING_FORMAT");
        String newListingFormatPrompt = this.getTranslatedString("FTP_CT_NEW_LISTING_FORMAT_PROMPT");
        String defaultNewFormat = this.getTranslatedString("FTP_CT_DEFAULT_NEW_LISTING_FORMAT");
        String listingTip = this.getTranslatedString("FTP_CT_LISTING_TIP");
        String fileNameSubstringPrompt = this.getTranslatedString("FTP_CT_SUBSTRING_PROMPT");
        String fileNameTip = this.getTranslatedString("FTP_CT_SUBSTRING_TIP");
        String beginPrompt = this.getTranslatedString("FTP_CT_BEGIN_INDEX_PROMPT");
        String beginIndexHint = this.getTranslatedString("FTP_CT_BEGIN_INDEX_TIP");
        String endPrompt = this.getTranslatedString("FTP_CT_END_INDEX_PROMPT");
        String endIndexHint = this.getTranslatedString("FTP_CT_END_INDEX_TIP");
        String fileFormatPrompt = this.getTranslatedString("FTP_CT_SUBSTRING_FORMAT_PROMPT");
        String defaultFileFormat = this.getTranslatedString("FTP_CT_DEFAULT_SUBSTRING_FORMAT");
        this.setLayout(this.gridBagLayout1);
        this.introPrompt = new MultiLineLabel(WordWrapper.getTextWrapper(), intro);
        this.sourceLB.setText(sourcePrompt);
        this.systemRB.setText(StringUtils.stripMnemonic((String)systemRBtext));
        this.systemRB.setMnemonic(StringUtils.getMnemonicKeyCode((String)systemRBtext));
        this.systemRB.setToolTipText(systemRBTip);
        this.systemRB.getAccessibleContext().setAccessibleDescription(systemRBTip);
        this.systemRB.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)systemRBtext));
        this.systemFormatLB.setText(StringUtils.stripMnemonic((String)systemFormatPrompt));
        this.systemFormatLB.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)systemFormatPrompt));
        this.systemFormatLB.setLabelFor(this.systemFormat);
        this.systemFormat.setText(defaultSystemFormat);
        this.systemFormat.setToolTipText(formatHint);
        this.systemFormat.addFocusListener(this);
        this.systemFormat.setMinimumSize(new Dimension(100, 20));
        this.systemFormat.setPreferredSize(new Dimension(100, 20));
        this.systemFormat.getDocument().addDocumentListener(this);
        this.listingRB.setText(StringUtils.stripMnemonic((String)listingRBtext));
        this.listingRB.setMnemonic(StringUtils.getMnemonicKeyCode((String)listingRBtext));
        this.listingRB.setToolTipText(listingTip);
        this.listingRB.getAccessibleContext().setAccessibleDescription(listingTip);
        this.listingRB.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)listingRBtext));
        this.oldListingFormatLB.setText(StringUtils.stripMnemonic((String)oldListingFormatPrompt));
        this.oldListingFormatLB.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)oldListingFormatPrompt));
        this.oldListingFormatLB.setLabelFor(this.oldListingFormat);
        this.oldListingFormat.setEditable(true);
        this.oldListingFormat.setToolTipText(formatHint);
        this.oldListingFormat.setText(defaultOldFormat);
        this.oldListingFormat.addFocusListener(this);
        this.oldListingFormat.setMinimumSize(new Dimension(100, 20));
        this.oldListingFormat.setSize(new Dimension(90, 20));
        this.oldListingFormat.setPreferredSize(new Dimension(100, 20));
        this.oldListingFormat.getDocument().addDocumentListener(this);
        this.newListingFormatLB.setText(StringUtils.stripMnemonic((String)newListingFormatPrompt));
        this.newListingFormatLB.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)newListingFormatPrompt));
        this.newListingFormatLB.setLabelFor(this.newListingFormat);
        this.newListingFormat.setText(defaultNewFormat);
        this.newListingFormat.setToolTipText(formatHint);
        this.newListingFormat.addFocusListener(this);
        this.newListingFormat.setPreferredSize(new Dimension(100, 20));
        this.newListingFormat.setMinimumSize(new Dimension(100, 20));
        this.newListingFormat.getDocument().addDocumentListener(this);
        this.fileNameRB.setText(StringUtils.stripMnemonic((String)fileNameSubstringPrompt));
        this.fileNameRB.setMnemonic(StringUtils.getMnemonicKeyCode((String)fileNameSubstringPrompt));
        this.fileNameRB.setToolTipText(fileNameTip);
        this.fileNameRB.getAccessibleContext().setAccessibleDescription(fileNameTip);
        this.fileNameRB.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)fileNameSubstringPrompt));
        this.beginSubstrLB.setText(StringUtils.stripMnemonic((String)beginPrompt));
        this.beginSubstrLB.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)beginPrompt));
        this.beginSubstrLB.setLabelFor((Component)this.beginIndex);
        this.beginIndex.setMinimumSize(new Dimension(60, 20));
        this.beginIndex.setPreferredSize(new Dimension(60, 20));
        this.beginIndex.setToolTipText(beginIndexHint);
        this.beginIndex.setIntValue(0);
        this.endIndexLB.setText(StringUtils.stripMnemonic((String)endPrompt));
        this.endIndexLB.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)endPrompt));
        this.endIndexLB.setLabelFor((Component)this.endIndex);
        this.endIndex.setMinimumSize(new Dimension(60, 20));
        this.endIndex.setPreferredSize(new Dimension(60, 20));
        this.endIndex.setToolTipText(endIndexHint);
        this.fileNameFormatLB.setText(StringUtils.stripMnemonic((String)fileFormatPrompt));
        this.fileNameFormatLB.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)fileFormatPrompt));
        this.fileNameFormatLB.setLabelFor(this.fileNameFormat);
        this.fileNameFormat.setText(defaultFileFormat);
        this.fileNameFormat.setToolTipText(formatHint);
        this.fileNameFormat.setMinimumSize(new Dimension(100, 20));
        this.fileNameFormat.setPreferredSize(new Dimension(100, 20));
        this.fileNameFormat.addFocusListener(this);
        this.fileNameFormat.getDocument().addDocumentListener(this);
        this.add((Component)this.fileNameRB, new GridBagConstraints(1, 11, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 12, 0, 0), 0, 0));
        this.add((Component)this.listingRB, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 16, 0, new Insets(12, 12, 0, 0), 0, 0));
        this.add((Component)this.introPrompt, new GridBagConstraints(1, 0, 0, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.sourceLB, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(12, 0, 0, 0), 0, 0));
        this.add((Component)this.systemRB, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 12, 0, 0), 0, 0));
        this.add((Component)this.oldListingFormatLB, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 32, 0, 0), 0, 0));
        this.add((Component)this.oldListingFormat, new GridBagConstraints(2, 7, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 12, 0, 0), 0, 0));
        this.add((Component)this.newListingFormatLB, new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 32, 0, 0), 0, 0));
        this.add((Component)this.newListingFormat, new GridBagConstraints(2, 8, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 12, 0, 0), 0, 0));
        this.add((Component)this.beginSubstrLB, new GridBagConstraints(1, 16, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 32, 0, 0), 0, 0));
        this.add((Component)this.endIndexLB, new GridBagConstraints(3, 16, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 0), 0, 0));
        this.add((Component)this.beginIndex, new GridBagConstraints(2, 16, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 12, 0, 0), 0, 0));
        this.add((Component)this.endIndex, new GridBagConstraints(4, 16, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 12, 0, 0), 0, 0));
        this.add((Component)this.systemFormatLB, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 32, 0, 0), 0, 0));
        this.add((Component)this.systemFormat, new GridBagConstraints(2, 5, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 12, 0, 0), 0, 0));
        this.add((Component)this.fileNameFormatLB, new GridBagConstraints(1, 20, 1, 1, 0.0, 1.0, 18, 0, new Insets(10, 32, 0, 0), 0, 0));
        this.add((Component)this.fileNameFormat, new GridBagConstraints(2, 20, 2, 1, 0.0, 0.0, 18, 2, new Insets(10, 12, 0, 0), 0, 0));
        this.sourceGroup.add(this.systemRB);
        this.sourceGroup.add(this.listingRB);
        this.sourceGroup.add(this.fileNameRB);
        this.listingRB.addActionListener(this);
        this.systemRB.addActionListener(this);
        this.fileNameRB.addActionListener(this);
        this.systemRB.setSelected(true);
        this.setSource(this.systemRB);
        this.m_page.setInitialFocus((Component)this.systemFormat);
        this.m_page.setCanAdvance(true);
        if (this.m_wcontext._read_service != null) {
            this.m_page.setCanAdvance(true);
            JcaOperation jop = this.m_wcontext._read_jca_operation;
            String tempstr = jop.getAttributeValue(s_FileModificationTime);
            String formatstr = jop.getAttributeValue(s_ModificationTimeFomat);
            if (tempstr == null || tempstr.equals(s_FileSystem)) {
                this.systemRB.setSelected(true);
                this.setSource(this.systemRB);
                this.systemFormat.setText(formatstr);
            } else if (tempstr.equals(s_DirListing)) {
                this.listingRB.setSelected(true);
                this.setSource(this.listingRB);
                this.newListingFormat.setText(formatstr);
                this.oldListingFormat.setText(jop.getAttributeValue(s_ModificationTimeFormatOld));
                this.m_page.setInitialFocus((Component)this.oldListingFormat);
            } else if (tempstr.equals(s_Filename)) {
                this.fileNameRB.setSelected(true);
                this.setSource(this.fileNameRB);
                this.fileNameFormat.setText(formatstr);
                this.m_page.setInitialFocus((Component)this.beginIndex);
                String tempstr1 = jop.getAttributeValue(s_FileNameSubstringBegin);
                this.beginIndex.setIntValue(Integer.valueOf(tempstr1).intValue());
                tempstr1 = jop.getAttributeValue(s_FileNameSubstringEnd);
                if (tempstr1 != null) {
                    this.endIndex.setIntValue(Integer.valueOf(tempstr1).intValue());
                }
            }
        }
    }

    private void setSource(JRadioButton selrb) {
        if (selrb.equals(this.systemRB)) {
            this.systemFormat.setEnabled(true);
            this.oldListingFormatLB.setEnabled(false);
            this.oldListingFormat.setEnabled(false);
            this.newListingFormatLB.setEnabled(false);
            this.newListingFormat.setEnabled(false);
            this.beginSubstrLB.setEnabled(false);
            this.beginIndex.setEnabled(false);
            this.endIndexLB.setEnabled(false);
            this.endIndex.setEnabled(false);
            this.fileNameFormatLB.setEnabled(false);
            this.fileNameFormat.setEnabled(false);
        } else if (selrb.equals(this.listingRB)) {
            this.systemFormat.setEnabled(false);
            this.oldListingFormatLB.setEnabled(true);
            this.oldListingFormat.setEnabled(true);
            this.newListingFormatLB.setEnabled(true);
            this.newListingFormat.setEnabled(true);
            this.beginSubstrLB.setEnabled(false);
            this.beginIndex.setEnabled(false);
            this.endIndexLB.setEnabled(false);
            this.endIndex.setEnabled(false);
            this.fileNameFormatLB.setEnabled(false);
            this.fileNameFormat.setEnabled(false);
        } else if (selrb.equals(this.fileNameRB)) {
            this.systemFormat.setEnabled(false);
            this.oldListingFormatLB.setEnabled(false);
            this.oldListingFormat.setEnabled(false);
            this.newListingFormatLB.setEnabled(false);
            this.newListingFormat.setEnabled(false);
            this.beginSubstrLB.setEnabled(true);
            this.beginIndex.setEnabled(true);
            this.endIndexLB.setEnabled(true);
            this.endIndex.setEnabled(true);
            this.fileNameFormatLB.setEnabled(true);
            this.fileNameFormat.setEnabled(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.systemRB || e.getSource() == this.listingRB || e.getSource() == this.fileNameRB) {
            this.setSource((JRadioButton)e.getSource());
            this.checkDoc();
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        JTextField format_field = (JTextField)e.getSource();
        this.save_format = format_field.getText().trim();
    }

    @Override
    public void focusLost(FocusEvent e) {
        JTextField format_field = (JTextField)e.getSource();
        String tempstr = null;
        if (format_field.equals(this.fileNameFormat)) {
            tempstr = this.fileNameFormat.getText().trim();
        } else if (format_field.equals(this.systemFormat)) {
            tempstr = this.systemFormat.getText().trim();
        } else if (format_field.equals(this.newListingFormat)) {
            tempstr = this.newListingFormat.getText().trim();
        } else if (format_field.equals(this.oldListingFormat)) {
            tempstr = this.oldListingFormat.getText().trim();
        }
        try {
            String tempstr_suffix = tempstr.substring(tempstr.length() - 4);
            String tempstr_prefix = tempstr_suffix.equalsIgnoreCase(",ucy") ? tempstr.substring(0, tempstr.length() - 4) : tempstr;
            SimpleDateFormat simpdate = new SimpleDateFormat(tempstr_prefix);
        }
        catch (Exception illex) {
            MessageFormat msgformat = new MessageFormat(this.m_wcontext._bundle.getString("FTP_CT_INVALID_DATETIME_FORMAT_ERROR_MSG"));
            Object[] obj = new Object[]{tempstr};
            MultiLineOptionPane.showMessageDialog((Component)this.m_wcontext._parentFrame, (Object)msgformat.format(obj), (String)this.m_wcontext._bundle.getString("CM_SC_URL_ERROR_TITLE"), (int)0);
            format_field.setText(this.save_format);
            format_field.requestFocus();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.checkDoc(e);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.checkDoc(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.checkDoc(e);
    }

    private void checkDoc(DocumentEvent e) {
        this.checkDoc();
    }

    private void checkDoc() {
        this.m_page.setCanAdvance(true);
        String formatstr = null;
        if (this.systemRB.isSelected()) {
            formatstr = this.systemFormat.getText().trim();
        } else if (this.listingRB.isSelected()) {
            formatstr = this.newListingFormat.getText().trim();
            String formatstr2 = this.oldListingFormat.getText().trim();
            if (formatstr2 == null || formatstr2.length() == 0) {
                this.m_page.setCanAdvance(false);
            }
        } else if (this.fileNameRB.isSelected()) {
            formatstr = this.fileNameFormat.getText().trim();
        }
        if (formatstr == null || formatstr.length() == 0) {
            this.m_page.setCanAdvance(false);
        }
    }

    @Override
    public void wizardValidatePage(WizardEvent event) {
        if (this.fileNameRB.isSelected() && this.endIndex.getValue() != null && this.getLong(this.beginIndex.getValue()) >= this.getLong(this.endIndex.getValue())) {
            MessageFormat msgformat = new MessageFormat(this.m_wcontext._bundle.getString("FTP_CT_INVALID_SUBSTRING_INDEX_ERROR_MSG"));
            Object[] obj = new Object[]{""};
            MultiLineOptionPane.showMessageDialog((Component)this.m_wcontext._parentFrame, (Object)msgformat.format(obj), (String)this.m_wcontext._bundle.getString("FTP_CT_INVALID_DATETIME_TITLE"), (int)0);
            this.endIndex.requestFocus();
            ((Cancelable)event).cancel();
            return;
        }
    }

    @Override
    public void buildWSDL() throws WSDLException {
        JcaOperation jop = this.m_wcontext._write_jca_operation;
        String sourcestr = null;
        String formatstr = null;
        if (this.systemRB.isSelected()) {
            sourcestr = s_FileSystem;
            formatstr = this.systemFormat.getText().trim();
        } else if (this.listingRB.isSelected()) {
            sourcestr = s_DirListing;
            formatstr = this.newListingFormat.getText().trim();
            jop.setAttributeValue(s_ModificationTimeFormatOld, this.oldListingFormat.getText().trim());
        } else if (this.fileNameRB.isSelected()) {
            sourcestr = s_Filename;
            formatstr = this.fileNameFormat.getText().trim();
            jop.setAttributeValue(s_FileNameSubstringBegin, Long.toString(this.getLong(this.beginIndex.getValue())));
            if (this.endIndex.getValue() != null) {
                jop.setAttributeValue(s_FileNameSubstringEnd, Long.toString(this.getLong(this.endIndex.getValue())));
            }
        }
        jop.setAttributeValue(s_FileModificationTime, sourcestr);
        jop.setAttributeValue(s_ModificationTimeFomat, formatstr);
    }
}

