/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.file;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import oracle.bali.share.nls.StringUtils;
import oracle.javatools.util.BundleLoader;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.file.FileAdapterContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.techAdapterWizard;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.techAdapterWizardPage;

public class MultipleDirPanel
extends JPanel
implements ActionListener,
FocusListener {
    private static final String RESOURCE_BUNDLE = techAdapterWizard.RESOURCE_BUNDLE;
    private ResourceBundle resourceBundle;
    private JButton dirBrowseButton = new JButton();
    private JButton addButton = new JButton();
    private JButton removeButton = new JButton();
    private JCheckBox recursiveCheckBox = new JCheckBox();
    private JTable dirTable;
    private JScrollPane dirTablePane;
    private DefaultTableModel dirTableModel;
    private Vector dirTableData;
    private Vector dirColumnNames;
    private FileAdapterContext fac;
    private techAdapterWizardPage parentPage;
    private String dirPrompt;
    private String dirPromptLogical;
    private String adapterType;
    private boolean pageInit = false;
    private JPanel buttonPanel = new JPanel();

    public MultipleDirPanel(techAdapterWizardPage parentPage, FileAdapterContext fac, String adapterType) {
        this.parentPage = parentPage;
        this.fac = fac == null ? new FileAdapterContext() : fac;
        this.adapterType = adapterType;
        this.init();
    }

    private void init() {
        this.resourceBundle = BundleLoader.getBundle((String)RESOURCE_BUNDLE);
        String addText = this.getTranslatedString("FA_RC_ADD");
        String addTip = this.getTranslatedString("FA_RC_ADD_TIP");
        String removeText = this.getTranslatedString("FA_RC_REMOVE");
        String removeTip = this.getTranslatedString("FA_RC_REMOVE_TIP");
        String browseText = this.getTranslatedString("FA_RC_BROWSE_BUTTON_TEXT");
        String browseTip = this.getTranslatedString("FA_RC_DIRECTORY_BROWSE_TIP");
        String recursiveText = this.getTranslatedString("FA_RC_RECURSIVE");
        String recursiveTip = this.getTranslatedString("FA_RC_RECURSIVE_TIP");
        this.dirPrompt = this.getTranslatedString("FA_RC_DIRECTORY_PROMPT");
        this.dirPromptLogical = this.getTranslatedString("FA_RC_DIRECTORY_PROMPT_LOGICAL");
        this.addButton.setText(StringUtils.stripMnemonic((String)addText));
        this.addButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)addText));
        this.addButton.setToolTipText(addTip);
        this.addButton.addActionListener(this);
        this.removeButton.setText(StringUtils.stripMnemonic((String)removeText));
        this.removeButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)removeText));
        this.removeButton.setToolTipText(removeTip);
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(this);
        this.dirBrowseButton.setText(StringUtils.stripMnemonic((String)browseText));
        this.dirBrowseButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)browseText));
        this.dirBrowseButton.setToolTipText(browseTip);
        this.dirBrowseButton.setEnabled(false);
        this.dirBrowseButton.addActionListener(this);
        this.recursiveCheckBox.setText(StringUtils.stripMnemonic((String)recursiveText));
        this.recursiveCheckBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)recursiveText));
        this.recursiveCheckBox.setToolTipText(recursiveTip);
        this.recursiveCheckBox.setSelected(true);
        this.dirTable = new JTable();
        this.dirTablePane = new JScrollPane(this.dirTable);
        this.dirColumnNames = new Vector(1);
        this.dirColumnNames.add(StringUtils.stripMnemonic((String)this.dirPrompt));
        this.dirTableModel = new DefaultTableModel();
        this.dirTableData = new Vector();
        ListSelectionModel lsm = this.dirTable.getSelectionModel();
        lsm.addListSelectionListener(new DirTableSelectionListener());
        this.dirTable.addFocusListener(this);
        this.buttonPanel.setLayout(new GridBagLayout());
        this.buttonPanel.add((Component)this.addButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.buttonPanel.add((Component)this.removeButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 3, 0, 0), 0, 0));
        this.buttonPanel.add((Component)this.dirBrowseButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 3, 0, 0), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.buttonPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 12, 13, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.dirTablePane, new GridBagConstraints(0, 1, 0, 1, 1.0, 1.0, 18, 1, new Insets(3, 0, 0, 0), 0, 0));
        this.add((Component)this.recursiveCheckBox, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(15, 0, 0, 0), 0, 0));
        this.updateControls(this.fac);
        if (this.fac.directoryList == null || this.fac.directoryList.size() < 1) {
            this.addRow("");
            this.pageInit = true;
            this.parentPage.m_page.setInitialFocus((Component)this.dirTable);
        }
        if (this.adapterType.equals("File")) {
            this.dirBrowseButton.setVisible(true);
        } else if (this.adapterType.equals("Ftp")) {
            this.dirBrowseButton.setVisible(false);
        }
    }

    private void setDirTableLabel(String text) {
        int[] selRows = this.dirTable.getSelectedRows();
        this.dirColumnNames = new Vector(1);
        this.dirColumnNames.add(StringUtils.stripMnemonic((String)text));
        this.setDirTableDataModel();
        this.selectRows(selRows);
    }

    private void setDirTableDataModel() {
        int[] selRows = this.dirTable.getSelectedRows();
        this.dirTableModel.setDataVector(this.dirTableData, this.dirColumnNames);
        this.dirTable.setModel(this.dirTableModel);
        this.selectRows(selRows);
    }

    private void addRow(String dir) {
        if (this.dirTableData == null) {
            this.dirTableData = new Vector();
        } else {
            Vector<String> row = new Vector<String>(1);
            row.add(dir);
            this.dirTableData.add(row);
            this.dirTableModel.fireTableRowsInserted(this.dirTableData.size(), this.dirTableData.size());
        }
    }

    private void removeRows(int[] selectedRows) {
        if (selectedRows.length > 0) {
            for (int i = selectedRows.length - 1; i >= 0; --i) {
                this.dirTableData.remove(selectedRows[i]);
            }
            this.setDirTableDataModel();
        }
    }

    private void selectRows(int[] selectedRows) {
        if (selectedRows.length > 0 && this.dirTable.getRowCount() > 0) {
            for (int i = 0; i < selectedRows.length; ++i) {
                int curRow = selectedRows[i];
                if (curRow >= this.dirTable.getRowCount()) continue;
                this.dirTable.addRowSelectionInterval(curRow, curRow);
            }
        }
    }

    public void updateControls(FileAdapterContext fac) {
        if (fac != null) {
            this.fac = fac;
            if (this.fac.isPhysicalDirectory) {
                this.setDirTableLabel(StringUtils.stripMnemonic((String)this.dirPrompt));
                if (this.adapterType.equals("File")) {
                    this.dirBrowseButton.setVisible(true);
                } else if (this.adapterType.equals("Ftp")) {
                    this.dirBrowseButton.setVisible(false);
                }
            } else {
                this.setDirTableLabel(StringUtils.stripMnemonic((String)this.dirPromptLogical));
                this.dirBrowseButton.setVisible(false);
            }
            this.dirTableData = this.convertToTableData(this.fac.directoryList);
            this.setDirTableDataModel();
            if (this.fac.recursive) {
                this.recursiveCheckBox.setSelected(true);
            } else {
                this.recursiveCheckBox.setSelected(false);
            }
        }
    }

    public FileAdapterContext getContext() {
        TableCellEditor cellEditor = this.dirTable.getCellEditor();
        if (cellEditor != null) {
            cellEditor.stopCellEditing();
        }
        this.fac.directoryList = this.convertToDirList(this.dirTableData);
        this.fac.recursive = this.recursiveCheckBox.isSelected();
        return this.fac;
    }

    private List convertToDirList(Vector dirVector) {
        ArrayList<String> dList = new ArrayList<String>();
        if (dirVector != null && dirVector.size() > 0) {
            for (int i = 0; i < dirVector.size(); ++i) {
                Vector row = (Vector)dirVector.get(i);
                if (row == null) continue;
                String curDir = (String)row.get(0);
                dList.add(curDir);
            }
        }
        return dList;
    }

    private Vector convertToTableData(List dirList) {
        Vector tableData = new Vector();
        if (dirList != null && dirList.size() > 0) {
            for (int i = 0; i < dirList.size(); ++i) {
                String curDir = (String)dirList.get(i);
                Vector<String> row = new Vector<String>(1);
                row.add(curDir);
                tableData.add(row);
            }
        }
        return tableData;
    }

    private String getTranslatedString(String messageKey) {
        return this.resourceBundle.getString(messageKey);
    }

    private void editCell(JTable table, int row, int col) {
        if (table.editCellAt(row, col)) {
            table.changeSelection(row, col, false, false);
            Component editor = table.getEditorComponent();
            if (editor != null) {
                editor.requestFocusInWindow();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.dirBrowseButton) {
            int[] selRows;
            String selDir = this.parentPage.selectDirectory();
            if (selDir != null && selDir.length() > 0 && (selRows = this.dirTable.getSelectedRows()).length > 0) {
                for (int i = 0; i < selRows.length; ++i) {
                    int curRow = selRows[i];
                    Vector<String> row = new Vector<String>(1);
                    row.add(selDir);
                    this.dirTableData.set(curRow, row);
                }
                this.setDirTableDataModel();
            }
        } else if (e.getSource() == this.addButton) {
            this.addRow("");
            int row = this.dirTable.getRowCount() - 1;
            int col = 0;
            this.editCell(this.dirTable, row, col);
        } else if (e.getSource() == this.removeButton) {
            this.removeRows(this.dirTable.getSelectedRows());
            if (this.dirTable.getSelectedRow() < 0) {
                int row = this.dirTable.getRowCount() - 1;
                this.dirTable.changeSelection(row, 0, false, false);
            }
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (e.getSource() == this.dirTable && this.pageInit) {
            this.editCell(this.dirTable, 0, 0);
            this.pageInit = false;
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    private class DirTableSelectionListener
    implements ListSelectionListener {
        private DirTableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            if (!lsm.isSelectionEmpty()) {
                MultipleDirPanel.this.dirBrowseButton.setEnabled(true);
                MultipleDirPanel.this.removeButton.setEnabled(true);
            } else {
                MultipleDirPanel.this.dirBrowseButton.setEnabled(false);
                MultipleDirPanel.this.removeButton.setEnabled(false);
            }
        }
    }
}

