/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.file;

import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class FileAdapterValidation {
    public static final byte UPPERCASE_LETTER = 1;
    public static final byte LOWERCASE_LETTER = 2;

    private static String getDynamicField(ResourceBundle rbundle, String fileName) {
        int len = fileName.length();
        int count = 0;
        int beginIndex = 0;
        int lastIndex = 0;
        for (int i = 0; i < len; ++i) {
            if (fileName.charAt(i) != '%') continue;
            ++count;
        }
        if (count == 0) {
            return null;
        }
        if (count == 2) {
            beginIndex = fileName.indexOf(37);
            lastIndex = fileName.lastIndexOf(37);
            return fileName.substring(beginIndex + 1, lastIndex);
        }
        if (count == 1) {
            throw new RuntimeException(rbundle.getString("FA_VL_INCORRECT_PERCENT_ERROR_MSG"));
        }
        if (count > 2) {
            throw new RuntimeException(rbundle.getString("FA_VL_MULTIPLE_DYNAMIC_PARTS_ERROR_MSG"));
        }
        return null;
    }

    private static boolean isValidDynamicField(ResourceBundle rbundle, String dynamicField) {
        if (dynamicField == null) {
            return true;
        }
        if (dynamicField.equals("SEQ")) {
            return true;
        }
        if (dynamicField.equals("")) {
            throw new RuntimeException(rbundle.getString("FA_VL_DYNAMIC_FIELD_CONTENT_ERROR_MSG"));
        }
        for (int i = 0; i < dynamicField.length(); ++i) {
            char c = dynamicField.charAt(i);
            if (Character.getType(c) == 1 || Character.getType(c) == 2) continue;
            throw new RuntimeException(rbundle.getString("FA_VL_DYNAMIC_FIELD_CONTENT_ERROR_MSG"));
        }
        try {
            new SimpleDateFormat(dynamicField);
        }
        catch (IllegalArgumentException iae) {
            throw new RuntimeException(rbundle.getString("FA_VL_DYNAMIC_FIELD_CONTENT_ERROR_MSG"));
        }
        return true;
    }

    public static boolean validateFileName(ResourceBundle rbundle, String fileName) {
        String dynamicField = FileAdapterValidation.getDynamicField(rbundle, fileName);
        return FileAdapterValidation.isValidDynamicField(rbundle, dynamicField);
    }

    public static boolean validateRegex(ResourceBundle rbundle, String regex, String beforeConvertExpression) {
        if (regex == null) {
            throw new RuntimeException("Invalid Regular Expression : Regular Expression is null.");
        }
        try {
            Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            if (beforeConvertExpression == null) {
                MessageFormat msgformat = new MessageFormat(rbundle.getString("FA_VL_INVALID_REGEX_ERROR_MSG"));
                Object[] obj = new Object[]{regex};
                throw new RuntimeException(msgformat.format(obj));
            }
            MessageFormat msgformat = new MessageFormat(rbundle.getString("FA_VL_INVALID_CONVERTED_REGEX_ERROR_MSG"));
            Object[] obj = new Object[]{beforeConvertExpression, regex};
            throw new RuntimeException(msgformat.format(obj));
        }
        return true;
    }
}

