/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.file;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.wsdl.WSDLException;
import oracle.bali.ewt.event.Cancelable;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.help.HelpSystem;
import oracle.tip.tools.ide.common.utils.MultiLineOptionPane;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.file.FileAdapterContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.file.FileAdapterReadFilteringPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.file.FileAdapterSchemaPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.ftp.FtpAdapterCreationTimePage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.techAdapterWizardPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.JcaAddress;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.JcaOperation;

public class FileAdapterReadPollingPage
extends techAdapterWizardPage
implements ItemListener,
ActionListener,
DocumentListener {
    private static final String WSDL_TRIGGER_PHYSICAL_DIR = "TriggerFilePhysicalDirectory";
    public static final String WSDL_TRIGGER_LOGICAL_DIR = "TriggerFileLogicalDirectory";
    private static final String WSDL_TRIGGER_FILE = "TriggerFile";
    private boolean pollSubDirs = false;
    String m_includePattern = null;
    String m_excludePattern = null;
    private MultiLineLabel introPrompt;
    private JCheckBox pollsubCheckbox = new JCheckBox();
    private JLabel pollFreqLabel = new JLabel();
    private JComboBox pollFreqUnits;
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private GridBagLayout gridBagLayout2 = new GridBagLayout();
    private NumericSpinBox pollFreq = new NumericSpinBox(1, Integer.MAX_VALUE);
    private JLabel minAgeLB = new JLabel();
    private NumericSpinBox minimumAge = new NumericSpinBox(0, Integer.MAX_VALUE);
    private JComboBox minimumAgeUnits;
    private JCheckBox useTriggerCB = new JCheckBox();
    private JPanel triggerPanel = new JPanel();
    private JCheckBox useInputDirCB = new JCheckBox();
    private JPanel spacer = new JPanel();
    private ButtonGroup dirTypeGroup = new ButtonGroup();
    private JRadioButton physicalRB = new JRadioButton();
    private JRadioButton logicalRB = new JRadioButton();
    private JLabel triggerPathLabel = new JLabel();
    private JTextField triggerPathTF = new JTextField();
    private JComboBox triggerPathCB = new JComboBox();
    private JLabel triggerFilenameLabel = new JLabel();
    private JTextField triggerFilenameTF = new JTextField();
    private String triggerPath = null;

    public FileAdapterReadPollingPage(AdapterWizardContext wcontext, ImageWizardPage iwp) {
        try {
            this.setContextAndPage(wcontext, iwp);
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        String intro = this.getTranslatedString("FA_RP_INTRO_PROMPT");
        String pollTX = StringUtils.stripMnemonic((String)this.getTranslatedString("FA_RC2_POLL_SUBDIR"));
        int pollsubCBNM = StringUtils.getMnemonicKeyCode((String)this.getTranslatedString("FA_RC2_POLL_SUBDIR"));
        String pollsubTip = this.getTranslatedString("FA_RC2_POLL_SUBDIR_TIP");
        String pollFreqLB = StringUtils.stripMnemonic((String)this.getTranslatedString("FA_RC2_POLL_FREQUENCY"));
        String pollFreqUnitsTip = this.getTranslatedString("FA_RC2_POLL_UNITS_TIP");
        String pollFreqUnitsName = this.getTranslatedString("FA_RC2_POLL_TIME_UNITS");
        int pollFreqMN = StringUtils.getMnemonicKeyCode((String)this.getTranslatedString("FA_RC2_POLL_FREQUENCY"));
        String pollFreqTip = this.getTranslatedString("FA_RC2_POLL_FREQ_TIP");
        String useTriggerText = this.getTranslatedString("FA_RP_USE_TRIGGER_FILE");
        String useTriggerTip = this.getTranslatedString("FA_RP_USE_TRIGGER_FILE_TIP");
        String triggerDetailsText = this.getTranslatedString("FA_RP_TRIGGER_FILE_DETAILS");
        String useInputDirText = this.getTranslatedString("FA_RP_USE_INPUT_DIR");
        String physicalPathText = this.getTranslatedString("FA_RC_PHYSICAL_PATH");
        String logicalPathText = this.getTranslatedString("FA_RC_LOGICAL_NAME_PROMPT");
        String triggerDirText = this.getTranslatedString("FA_RP_TRIGGER_FILE_DIR");
        String triggerFilenameText = this.getTranslatedString("FA_RP_TRIGGER_FILE_NAME");
        String minAgePrompt = StringUtils.stripMnemonic((String)this.getTranslatedString("FA_RC2_MIN_FILE_AGE"));
        int minAgeMN = StringUtils.getMnemonicKeyCode((String)this.getTranslatedString("FA_RC2_MIN_FILE_AGE"));
        String minAgeTip = this.getTranslatedString("FA_RC2_MIN_FILE_AGE_TIP");
        String minAgeUnitsTip = this.getTranslatedString("FA_RC2_MIN_AGE_UNITS_TIP");
        String minAgeUnitsName = this.getTranslatedString("FA_RC2_MIN_AGE_UNITS_NAME");
        if (this.m_wcontext._service_type.equals("Ftp")) {
            intro = this.getTranslatedString("FTP_RP_INTRO_PROMPT");
        }
        String[] time_intervals = new String[]{this.m_wcontext.TIME_SECONDS, this.m_wcontext.TIME_MINUTES, this.m_wcontext.TIME_HOURS, this.m_wcontext.TIME_DAYS, this.m_wcontext.TIME_WEEKS};
        this.setLayout(this.gridBagLayout1);
        this.introPrompt = new MultiLineLabel(WordWrapper.getTextWrapper(), intro);
        this.pollFreq.setIntValue(1);
        this.pollsubCheckbox.addItemListener(this);
        this.pollFreqLabel.setLabelFor((Component)this.pollFreq);
        this.pollFreqLabel.setDisplayedMnemonic(pollFreqMN);
        this.pollFreqLabel.setText(pollFreqLB);
        this.pollFreq.setToolTipText(pollFreqTip);
        this.pollFreq.getAccessibleContext().setAccessibleDescription(pollFreqTip);
        this.pollFreq.getAccessibleContext().setAccessibleName(pollFreqLB);
        this.pollFreqUnits = new JComboBox<String>(time_intervals);
        this.pollFreqUnits.setToolTipText(pollFreqUnitsTip);
        this.pollFreqUnits.getAccessibleContext().setAccessibleDescription(pollFreqUnitsTip);
        this.pollFreqUnits.getAccessibleContext().setAccessibleName(pollFreqUnitsName);
        this.pollsubCheckbox.setText(pollTX);
        this.pollsubCheckbox.setMnemonic(pollsubCBNM);
        this.pollsubCheckbox.setToolTipText(pollsubTip);
        this.pollsubCheckbox.getAccessibleContext().setAccessibleDescription(pollsubTip);
        this.pollsubCheckbox.getAccessibleContext().setAccessibleName(pollTX);
        this.pollsubCheckbox.setVisible(false);
        this.minAgeLB.setText(minAgePrompt);
        this.minAgeLB.setLabelFor((Component)this.minimumAge);
        this.minAgeLB.setDisplayedMnemonic(minAgeMN);
        this.minimumAge.setIntValue(0);
        this.minimumAge.setToolTipText(minAgeTip);
        this.minimumAge.getAccessibleContext().setAccessibleDescription(minAgeTip);
        this.minimumAge.getAccessibleContext().setAccessibleName(minAgePrompt);
        this.minimumAge.setMinimumSize(new Dimension(80, 20));
        this.minimumAge.setSize(new Dimension(60, 20));
        this.minimumAge.setPreferredSize(new Dimension(80, 20));
        this.minimumAgeUnits = new JComboBox<String>(time_intervals);
        this.minimumAgeUnits.setToolTipText(minAgeUnitsTip);
        this.minimumAgeUnits.getAccessibleContext().setAccessibleDescription(minAgeUnitsTip);
        this.minimumAgeUnits.getAccessibleContext().setAccessibleName(minAgeUnitsName);
        this.pollFreq.setPreferredSize(new Dimension(60, 20));
        this.pollFreq.setMinimumSize(new Dimension(40, 20));
        this.pollFreq.setSize(new Dimension(60, 20));
        this.useTriggerCB.setText(StringUtils.stripMnemonic((String)useTriggerText));
        this.useTriggerCB.setMnemonic(StringUtils.getMnemonicKeyCode((String)useTriggerText));
        this.useTriggerCB.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)useTriggerText));
        this.useTriggerCB.getAccessibleContext().setAccessibleDescription(useTriggerTip);
        this.useTriggerCB.addActionListener(this);
        Border bd = BorderFactory.createLineBorder(Color.GRAY);
        this.triggerPanel.setBorder(BorderFactory.createTitledBorder(bd, triggerDetailsText));
        this.triggerPanel.setVisible(false);
        this.useInputDirCB.setText(StringUtils.stripMnemonic((String)useInputDirText));
        this.useInputDirCB.setMnemonic(StringUtils.getMnemonicKeyCode((String)useInputDirText));
        this.useInputDirCB.addActionListener(this);
        this.physicalRB.setText(StringUtils.stripMnemonic((String)physicalPathText));
        this.physicalRB.setMnemonic(StringUtils.getMnemonicKeyCode((String)physicalPathText));
        this.physicalRB.setSelected(true);
        this.logicalRB.setText(StringUtils.stripMnemonic((String)logicalPathText));
        this.logicalRB.setMnemonic(StringUtils.getMnemonicKeyCode((String)logicalPathText));
        this.dirTypeGroup.add(this.physicalRB);
        this.dirTypeGroup.add(this.logicalRB);
        this.triggerPathLabel.setText(StringUtils.stripMnemonic((String)triggerDirText));
        this.triggerPathLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)triggerDirText));
        this.triggerPathLabel.setLabelFor(this.triggerPathTF);
        this.triggerPathTF.getDocument().addDocumentListener(this);
        this.triggerFilenameLabel.setText(StringUtils.stripMnemonic((String)triggerFilenameText));
        this.triggerFilenameLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)triggerFilenameText));
        this.triggerFilenameLabel.setLabelFor(this.triggerFilenameTF);
        this.triggerFilenameTF.getDocument().addDocumentListener(this);
        this.triggerPathTF.setVisible(false);
        this.triggerPathCB.setVisible(false);
        this.triggerPanel.setLayout(new GridBagLayout());
        this.triggerPanel.add((Component)this.useInputDirCB, new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.triggerPanel.add((Component)this.physicalRB, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.triggerPanel.add((Component)this.logicalRB, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.triggerPanel.add((Component)this.triggerPathLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.triggerPanel.add((Component)this.triggerPathTF, new GridBagConstraints(1, 2, 0, 1, 0.0, 0.0, 18, 2, new Insets(10, 5, 0, 5), 0, 0));
        this.triggerPanel.add((Component)this.triggerPathCB, new GridBagConstraints(1, 2, 0, 1, 0.0, 0.0, 18, 2, new Insets(10, 5, 0, 5), 0, 0));
        this.triggerPanel.add((Component)this.triggerFilenameLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.triggerPanel.add((Component)this.triggerFilenameTF, new GridBagConstraints(1, 3, 0, 1, 0.0, 0.0, 18, 2, new Insets(10, 5, 5, 5), 0, 0));
        this.add((Component)this.pollFreqUnits, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(25, 6, 0, 0), 0, 0));
        this.add((Component)this.pollFreqLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(25, 0, 0, 0), 0, 0));
        this.add((Component)this.pollsubCheckbox, new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this.pollFreq, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(25, 12, 0, 0), 20, 0));
        this.add((Component)this.minAgeLB, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(12, 0, 0, 0), 0, 0));
        this.add((Component)this.minimumAge, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(12, 12, 0, 0), 0, 0));
        this.add((Component)this.minimumAgeUnits, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(12, 6, 0, 0), 0, 0));
        this.add((Component)this.introPrompt, new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.useTriggerCB, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(12, 0, 0, 0), 0, 0));
        this.add((Component)this.triggerPanel, new GridBagConstraints(0, 4, 0, 1, 1.0, 0.0, 18, 2, new Insets(12, 0, 0, 0), 0, 0));
        this.add((Component)this.spacer, new GridBagConstraints(0, 5, 1, 1, 0.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.pollFreqUnits.setSelectedIndex(1);
        this.minimumAgeUnits.setSelectedIndex(1);
        if (this.m_wcontext._read_service != null) {
            FileAdapterContext fac = (FileAdapterContext)this.m_wcontext._ascontext;
            JcaOperation jop = this.m_wcontext._read_jca_operation;
            JcaAddress jcaa = this.m_wcontext._read_jca_address;
            String tempstr = null;
            tempstr = jop.getAttributeValue("PollingFrequency");
            if (tempstr != null && tempstr.length() > 0) {
                this.pollFreq.setIntValue(Integer.valueOf(tempstr).intValue());
            }
            this.pollFreqUnits.setSelectedItem(this.m_wcontext.TIME_SECONDS);
            Boolean pollsub = Boolean.valueOf(jop.getAttributeValue("PollSubDirectories"));
            this.pollsubCheckbox.setSelected(pollsub);
            tempstr = jop.getAttributeValue("MinimumAge");
            if (tempstr != null && tempstr.length() > 0) {
                this.minimumAge.setIntValue(Integer.valueOf(tempstr).intValue());
            }
            this.minimumAgeUnits.setSelectedItem(this.m_wcontext.TIME_SECONDS);
            String triggerFile = jop.getAttributeValue(WSDL_TRIGGER_FILE);
            String logicalPath = jop.getAttributeValue(WSDL_TRIGGER_LOGICAL_DIR);
            String physicalPath = jop.getAttributeValue(WSDL_TRIGGER_PHYSICAL_DIR);
            if (triggerFile != null) {
                this.triggerFilenameTF.setText(triggerFile);
                if (logicalPath != null) {
                    this.logicalRB.setSelected(true);
                    this.triggerPath = logicalPath;
                    this.m_wcontext._logicalNames_old.put(WSDL_TRIGGER_LOGICAL_DIR, this.triggerPath);
                } else if (physicalPath != null) {
                    this.physicalRB.setSelected(true);
                    this.triggerPath = physicalPath;
                }
                if (fac.isDirInList(this.triggerPath)) {
                    this.useInputDirCB.setSelected(true);
                }
                this.useTriggerCB.setSelected(true);
                this.triggerPanel.setVisible(true);
                this.updateTriggerPanel();
                this.checkDoc();
            }
            if (this.m_wizard.getCurrentPageIndex() == 0) {
                this.wizardValidatePage(null);
            }
        } else {
            this.updateTriggerPanel();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        ItemSelectable source = e.getItemSelectable();
        if (source == this.pollsubCheckbox) {
            this.pollSubDirs = e.getStateChange() == 1;
        }
    }

    @Override
    public void wizardValidatePage(WizardEvent event) {
        FileAdapterContext fac = (FileAdapterContext)this.m_wcontext._ascontext;
        if (this.triggerPathTF.isVisible()) {
            this.triggerPath = this.triggerPathTF.getText();
        } else if (this.triggerPathCB.isVisible()) {
            this.triggerPath = (String)this.triggerPathCB.getSelectedItem();
        }
        if (this.m_wcontext._service_type.equals("Ftp")) {
            ImageWizardPage tempwp;
            this.removePages();
            if (this.getLong(this.minimumAge.getValue()) > 0L || !fac._deleteFilesAfterProcessing) {
                tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("FTP_CT_TITLE"));
                if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
                    HelpSystem.getHelpSystem().registerTopic((JComponent)tempwp.getContent(), "bpmjdev_adp_wiz_ftp_filemod");
                }
                FtpAdapterCreationTimePage dsp2 = new FtpAdapterCreationTimePage(this.m_wcontext, tempwp);
            }
            if (!fac.ignoreFileContent & !fac.isAttachment) {
                tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("FA_SC_TITLE"));
                if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
                    HelpSystem.getHelpSystem().registerTopic((JComponent)tempwp.getContent(), "bpmjdev_adp_wiz_message");
                }
                FileAdapterSchemaPage dsp3 = new FileAdapterSchemaPage(this.m_wcontext, tempwp);
                this.addFinishPage();
            } else {
                this.addFinishPage();
                String finish_info = null;
                String finish_prompt = null;
                MessageFormat msgformat = null;
                Object[] obj = null;
                if (this.m_wcontext._read_service != null) {
                    msgformat = new MessageFormat(this.getTranslatedString("FTP_FN_UPDATE_PROMPT"));
                    obj = new Object[]{this.m_wcontext._write_service_name};
                    finish_prompt = msgformat.format(obj);
                    msgformat = new MessageFormat(this.getTranslatedString("FA_FN_UPDATE_SUMMARY"));
                    obj = new Object[]{this.m_wcontext._write_wsdl_name};
                    finish_info = msgformat.format(obj);
                } else {
                    msgformat = new MessageFormat(this.getTranslatedString("FTP_FN_PROMPT"));
                    obj = new Object[]{this.m_wcontext._write_service_name};
                    finish_prompt = msgformat.format(obj);
                    msgformat = new MessageFormat(this.getTranslatedString("FA_FN_SUMMARY"));
                    obj = new Object[]{this.m_wcontext._write_wsdl_name};
                    finish_info = msgformat.format(obj);
                }
                this.setFinishPageContents(finish_prompt, finish_info);
            }
        }
        if (this.useTriggerCB.isSelected() && fac.directoryList != null && fac.isDirInList(this.triggerPath)) {
            Matcher m;
            Pattern p;
            boolean includePatternMatches = false;
            boolean excludePatternMatches = true;
            if (fac.includeFilePattern != null && !fac.includeFilePattern.trim().equals("")) {
                if (!fac.includeFilePattern.trim().equals(FileAdapterReadFilteringPage.convertWildcardToRegex("*.*"))) {
                    p = Pattern.compile(fac.includeFilePattern);
                    m = p.matcher(this.triggerFilenameTF.getText());
                    if (m.matches()) {
                        includePatternMatches = true;
                    }
                } else if ((fac.excludeFilePattern == null || fac.excludeFilePattern.trim().equals("")) && (m = (p = Pattern.compile(fac.includeFilePattern)).matcher(this.triggerFilenameTF.getText())).matches()) {
                    includePatternMatches = true;
                }
            }
            if (!(fac.excludeFilePattern == null || fac.excludeFilePattern.trim().equals("") || fac.excludeFilePattern.trim().equals(FileAdapterReadFilteringPage.convertWildcardToRegex("*.*")) || (m = (p = Pattern.compile(fac.excludeFilePattern)).matcher(this.triggerFilenameTF.getText())).matches())) {
                excludePatternMatches = false;
            }
            if (includePatternMatches || includePatternMatches && !excludePatternMatches) {
                MultiLineOptionPane.showMessageDialog((Component)this.m_wcontext._parentFrame, (Object)this.m_wcontext._bundle.getString("FA_RP_INVALID_TRIGGER_FILE"), (String)this.m_wcontext._bundle.getString("FA_RP_TRIGGER_FILE_ERROR"), (int)0);
                ((Cancelable)event).cancel();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.useTriggerCB) {
            if (this.useTriggerCB.isSelected()) {
                this.triggerPanel.setVisible(true);
            } else {
                this.triggerPanel.setVisible(false);
            }
        } else if (e.getSource() == this.useInputDirCB) {
            this.triggerPath = null;
            this.updateTriggerPanel();
        }
        this.checkDoc();
    }

    private void updateTriggerPanel() {
        FileAdapterContext fac = (FileAdapterContext)this.m_wcontext._ascontext;
        if (this.useInputDirCB.isSelected()) {
            if (fac.directoryList.size() == 1) {
                String dir = (String)fac.directoryList.get(0);
                this.triggerPathTF.setVisible(true);
                this.triggerPathCB.setVisible(false);
                this.triggerPathTF.setEnabled(false);
                this.triggerPathTF.setText(dir);
            } else {
                this.triggerPathCB.setVisible(true);
                this.triggerPathTF.setVisible(false);
                this.initTriggerPathCB(fac.directoryList);
                if (this.triggerPath != null) {
                    this.triggerPathCB.setSelectedItem(this.triggerPath);
                }
            }
            if (fac.isPhysicalDirectory) {
                this.physicalRB.setSelected(true);
            } else {
                this.logicalRB.setSelected(true);
            }
            this.physicalRB.setEnabled(false);
            this.logicalRB.setEnabled(false);
        } else {
            this.triggerPathCB.setVisible(false);
            this.triggerPathTF.setVisible(true);
            this.triggerPathTF.setEnabled(true);
            this.physicalRB.setEnabled(true);
            this.logicalRB.setEnabled(true);
            if (this.triggerPath != null) {
                this.triggerPathTF.setText(this.triggerPath);
            }
            if (fac.isDirInList(this.triggerPathTF.getText())) {
                this.triggerPathTF.setText("");
            }
        }
    }

    private void initTriggerPathCB(List dirList) {
        this.triggerPathCB.removeAllItems();
        if (dirList != null) {
            for (int i = 0; i < dirList.size(); ++i) {
                String curDir = (String)dirList.get(i);
                this.triggerPathCB.addItem(curDir);
            }
        }
    }

    public void updatePage() {
        this.updateTriggerPanel();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.checkDoc(e);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.checkDoc(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.checkDoc(e);
    }

    private void checkDoc(DocumentEvent e) {
        this.checkDoc();
    }

    private void checkDoc() {
        boolean triggerPathOK = false;
        if (this.triggerPathTF.isVisible() && this.triggerPathTF.getText() != null && !this.triggerPathTF.getText().trim().equals("")) {
            triggerPathOK = true;
        } else if (this.triggerPathCB.isVisible() && this.triggerPathCB.getItemCount() > 0) {
            triggerPathOK = true;
        }
        if (!this.useTriggerCB.isSelected() || this.useTriggerCB.isSelected() && triggerPathOK && this.triggerFilenameTF.getText() != null && !this.triggerFilenameTF.getText().trim().equals("")) {
            this.m_page.setCanAdvance(true);
        } else {
            this.m_page.setCanAdvance(false);
        }
    }

    @Override
    public void buildWSDL() throws WSDLException {
        JcaOperation jop = this.m_wcontext._write_jca_operation;
        JcaAddress jcaa = this.m_wcontext._write_jca_address;
        String units = (String)this.pollFreqUnits.getSelectedItem();
        long pollint = this.getLong(this.pollFreq.getValue());
        pollint = this.getSeconds(pollint, units);
        jop.setAttributeValue("PollingFrequency", Long.toString(pollint));
        long minAgeint = this.getLong(this.minimumAge.getValue());
        minAgeint = this.getSeconds(minAgeint, (String)this.minimumAgeUnits.getSelectedItem());
        jop.setAttributeValue("MinimumAge", Long.toString(minAgeint));
        if (this.useTriggerCB.isSelected()) {
            if (this.physicalRB.isSelected()) {
                jop.setAttributeValue(WSDL_TRIGGER_PHYSICAL_DIR, this.triggerPath);
            } else {
                jop.setAttributeValue(WSDL_TRIGGER_LOGICAL_DIR, this.triggerPath);
                if (this.m_wcontext._logicalNames != null) {
                    this.m_wcontext._logicalNames.put(WSDL_TRIGGER_LOGICAL_DIR, this.triggerPath);
                }
            }
            jop.setAttributeValue(WSDL_TRIGGER_FILE, this.triggerFilenameTF.getText());
        }
    }

    public long getSeconds(long pollint, String units) {
        long seconds = pollint;
        if (!units.equals(this.m_wcontext.TIME_SECONDS)) {
            if (units.equals(this.m_wcontext.TIME_MINUTES)) {
                seconds = pollint * 60L;
            } else if (units.equals(this.m_wcontext.TIME_HOURS)) {
                seconds = pollint * 60L * 60L;
            } else if (units.equals(this.m_wcontext.TIME_DAYS)) {
                seconds = pollint * 60L * 60L * 24L;
            } else if (units.equals(this.m_wcontext.TIME_WEEKS)) {
                seconds = pollint * 60L * 60L * 24L * 7L;
            }
        }
        return seconds;
    }
}

