/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.file;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.wsdl.WSDLException;
import oracle.bali.ewt.event.Cancelable;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.bali.share.nls.StringUtils;
import oracle.tip.tools.ide.common.utils.MultiLineOptionPane;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.FocusRequester;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.file.FileAdapterContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.file.FileAdapterValidation;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.techAdapterWizardPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.JcaAddress;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.JcaOperation;

public class FileAdapterReadFilteringPage
extends techAdapterWizardPage
implements ItemListener {
    public static final String s_DeleteFile = "DeleteFile";
    public static final String s_DeleteFile_true = "true";
    public static final String s_DeleteFile_false = "false";
    private boolean pollSubDirs = false;
    private boolean addedTimePage = false;
    String m_includePattern = null;
    String m_excludePattern = null;
    private MultiLineLabel introPrompt;
    private JLabel includeFilesLabel = new JLabel();
    private JTextField includePattern = new JTextField();
    private JLabel excludeLabel = new JLabel();
    private JTextField excludePattern = new JTextField();
    private JCheckBox batchesCheckbox = new JCheckBox();
    private NumericSpinBox numberMessages = new NumericSpinBox(1, Integer.MAX_VALUE);
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private GridBagLayout gridBagLayout3 = new GridBagLayout();
    private JLabel messageNumberLabel = new JLabel();
    private JLabel namePatternLB = new JLabel();
    private JRadioButton wildcardRB = new JRadioButton();
    private JRadioButton regexRB = new JRadioButton();
    ButtonGroup namePatternGroup = new ButtonGroup();
    private FileAdapterContext fileAdapterCtx;

    public FileAdapterReadFilteringPage(AdapterWizardContext wcontext, ImageWizardPage iwp) {
        try {
            this.setContextAndPage(wcontext, iwp);
            this.fileAdapterCtx = (FileAdapterContext)wcontext._ascontext;
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        String intro = "";
        if (this.m_wcontext._isOutboundFileListing) {
            intro = this.getTranslatedString("FA_FL_INTRO_PROMPT");
        } else if (this.m_wcontext._service_type.equals("Ftp")) {
            intro = this.getTranslatedString("FTP_RF_INTRO_PROMPT");
        } else if (this.m_wcontext._service_type.equals("File")) {
            intro = this.getTranslatedString("FA_RF_INTRO_PROMPT");
        }
        String namePatternPrompt = this.getTranslatedString("FA_RC2_NAME_PATTERN_PROMPT");
        String wildcardPrompt = StringUtils.stripMnemonic((String)this.getTranslatedString("FA_RC2_WILDCARD_PROMPT"));
        String wildcardTip = this.getTranslatedString("FA_RC2_WILDCARD_TIP");
        int wildcardNM = StringUtils.getMnemonicKeyCode((String)this.getTranslatedString("FA_RC2_WILDCARD_PROMPT"));
        String regexPrompt = StringUtils.stripMnemonic((String)this.getTranslatedString("FA_RC2_REGEX_PROMPT"));
        String regexTip = this.getTranslatedString("FA_RC2_REGEX_TIP");
        int regexNM = StringUtils.getMnemonicKeyCode((String)this.getTranslatedString("FA_RC2_REGEX_PROMPT"));
        String includeLB = StringUtils.stripMnemonic((String)this.getTranslatedString("FA_RC2_INCLUDE_FILES"));
        String excludeLB = StringUtils.stripMnemonic((String)this.getTranslatedString("FA_RC2_EXCLUDE_FILES"));
        String batchCBTX = StringUtils.stripMnemonic((String)this.getTranslatedString("FA_RC2_BATCH_READ"));
        String batchesCBTip = this.getTranslatedString("FA_RC2_BATCH_TIP");
        int multipleMessagesMN = StringUtils.getMnemonicKeyCode((String)this.getTranslatedString("FA_RC2_BATCH_READ"));
        String messageNumberLBTX = StringUtils.stripMnemonic((String)this.getTranslatedString("FA_RC2_MESSAGE_NUMBER"));
        String numberMessagesTip = this.getTranslatedString("FA_RC2_MESSAGE_NUMBER_TIP");
        int batchNumberMN = StringUtils.getMnemonicKeyCode((String)this.getTranslatedString("FA_RC2_MESSAGE_NUMBER"));
        String excludeTip = this.getTranslatedString("FA_RC2_EXCLUDE_TIP");
        String includeTip = this.getTranslatedString("FA_RC2_INCLUDE_TIP");
        int excludeMN = StringUtils.getMnemonicKeyCode((String)this.getTranslatedString("FA_RC2_EXCLUDE_FILES"));
        int includeMN = StringUtils.getMnemonicKeyCode((String)this.getTranslatedString("FA_RC2_INCLUDE_FILES"));
        String[] time_intervals = new String[]{this.m_wcontext.TIME_SECONDS, this.m_wcontext.TIME_MINUTES, this.m_wcontext.TIME_HOURS, this.m_wcontext.TIME_DAYS, this.m_wcontext.TIME_WEEKS};
        this.setLayout(this.gridBagLayout1);
        this.introPrompt = new MultiLineLabel(WordWrapper.getTextWrapper(), intro);
        this.includeFilesLabel.setText(includeLB);
        this.includePattern.setText("");
        this.excludeLabel.setText(excludeLB);
        this.excludePattern.setText("");
        this.excludeLabel.setLabelFor(this.excludePattern);
        this.includeFilesLabel.setLabelFor(this.includePattern);
        this.excludePattern.setToolTipText(excludeTip);
        this.includePattern.setToolTipText(includeTip);
        this.excludeLabel.setDisplayedMnemonic(excludeMN);
        this.includeFilesLabel.setDisplayedMnemonic(includeMN);
        this.includePattern.getAccessibleContext().setAccessibleDescription(includeTip);
        this.includePattern.getAccessibleContext().setAccessibleName(includeLB);
        this.excludePattern.getAccessibleContext().setAccessibleDescription(excludeTip);
        this.excludePattern.getAccessibleContext().setAccessibleName(excludeLB);
        this.namePatternLB.setText(namePatternPrompt);
        this.namePatternLB.setLabelFor(this.wildcardRB);
        this.wildcardRB.setText(wildcardPrompt);
        this.wildcardRB.setMnemonic(wildcardNM);
        this.wildcardRB.setToolTipText(wildcardTip);
        this.wildcardRB.getAccessibleContext().setAccessibleDescription(wildcardTip);
        this.wildcardRB.getAccessibleContext().setAccessibleName(wildcardPrompt);
        this.namePatternGroup.add(this.wildcardRB);
        this.regexRB.setText(regexPrompt);
        this.regexRB.setMnemonic(regexNM);
        this.regexRB.setToolTipText(regexTip);
        this.regexRB.getAccessibleContext().setAccessibleDescription(regexTip);
        this.regexRB.getAccessibleContext().setAccessibleName(regexPrompt);
        this.namePatternGroup.add(this.regexRB);
        this.batchesCheckbox.setText(batchCBTX);
        this.batchesCheckbox.addItemListener(this);
        this.batchesCheckbox.setToolTipText(batchesCBTip);
        this.batchesCheckbox.setMnemonic(multipleMessagesMN);
        this.numberMessages.setIntValue(1);
        this.numberMessages.setSize(new Dimension(44, 22));
        this.messageNumberLabel.setLabelFor((Component)this.numberMessages);
        this.messageNumberLabel.setText(messageNumberLBTX);
        this.messageNumberLabel.setDisplayedMnemonic(batchNumberMN);
        this.numberMessages.setToolTipText(numberMessagesTip);
        this.numberMessages.getAccessibleContext().setAccessibleDescription(numberMessagesTip);
        this.numberMessages.getAccessibleContext().setAccessibleName(messageNumberLBTX);
        this.numberMessages.setPreferredSize(new Dimension(44, 22));
        this.add((Component)this.numberMessages, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 18, 0, new Insets(-5, 12, 0, 0), 17, 0));
        this.add((Component)this.batchesCheckbox, new GridBagConstraints(0, 6, 0, 1, 0.0, 0.0, 17, 0, new Insets(20, 0, 0, 0), 0, 0));
        this.add((Component)this.excludePattern, new GridBagConstraints(1, 5, 0, 1, 1.0, 0.0, 17, 2, new Insets(10, 12, 0, 0), 0, 0));
        this.add((Component)this.excludeLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.includePattern, new GridBagConstraints(1, 4, 0, 1, 1.0, 0.0, 17, 2, new Insets(10, 12, 0, 0), 0, 0));
        this.add((Component)this.includeFilesLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.messageNumberLabel, new GridBagConstraints(0, 7, 1, 1, 0.0, 1.0, 18, 0, new Insets(0, 24, 0, 0), 0, 0));
        this.add((Component)this.namePatternLB, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(25, 0, 0, 0), 0, 0));
        this.add((Component)this.wildcardRB, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(25, 12, 0, 0), 0, 0));
        this.add((Component)this.regexRB, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 12, 0, 0), 0, 0));
        this.add((Component)this.introPrompt, new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.m_page.setInitialFocus((Component)this.includePattern);
        this.wildcardRB.setSelected(true);
        this.numberMessages.setEnabled(false);
        if (this.m_wcontext._read_service != null) {
            JcaOperation jop = this.m_wcontext._read_jca_operation;
            JcaAddress jcaa = this.m_wcontext._read_jca_address;
            String tempstr = null;
            this.m_includePattern = jop.getAttributeValue("IncludeFiles");
            if (this.m_includePattern != null && this.m_includePattern.length() > 0) {
                tempstr = jcaa.getUiIncludeWildcardExpression();
                if (tempstr != null && tempstr.length() > 0) {
                    this.includePattern.setText(tempstr);
                } else {
                    this.includePattern.setText(this.m_includePattern);
                    this.regexRB.setSelected(true);
                }
            }
            this.m_excludePattern = jop.getAttributeValue("ExcludeFiles");
            if (this.m_excludePattern != null && this.m_excludePattern.length() > 0) {
                tempstr = jcaa.getUiExcludeWildcardExpression();
                if (tempstr != null && tempstr.length() > 0) {
                    this.excludePattern.setText(tempstr);
                } else {
                    this.excludePattern.setText(this.m_excludePattern);
                    this.regexRB.setSelected(true);
                }
            }
            if ((tempstr = jop.getAttributeValue("PublishSize")) != null && tempstr.length() > 0) {
                this.numberMessages.setIntValue(Integer.valueOf(tempstr).intValue());
                this.numberMessages.setEnabled(true);
                this.batchesCheckbox.setSelected(true);
            }
        }
        if (this.fileAdapterCtx.isAttachment || this.m_wcontext._isOutboundFileListing) {
            this.batchesCheckbox.setEnabled(false);
            this.batchesCheckbox.setSelected(false);
            this.messageNumberLabel.setEnabled(false);
            this.numberMessages.setEnabled(false);
        } else {
            this.batchesCheckbox.setEnabled(true);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        ItemSelectable source = e.getItemSelectable();
        if (source == this.batchesCheckbox) {
            if (e.getStateChange() == 1) {
                this.numberMessages.setEnabled(true);
                this.numberMessages.grabFocus();
            } else {
                this.numberMessages.setEnabled(false);
            }
        }
    }

    @Override
    public void wizardValidatePage(WizardEvent event) {
        boolean isInclude = true;
        String fname = this.includePattern.getText().trim();
        String beforeConvertExpression = null;
        try {
            boolean rc1;
            if (fname.length() == 0) {
                this.m_includePattern = null;
            } else {
                if (this.wildcardRB.isSelected()) {
                    beforeConvertExpression = fname;
                    fname = FileAdapterReadFilteringPage.convertWildcardToRegex(beforeConvertExpression);
                }
                this.m_includePattern = fname;
                rc1 = FileAdapterValidation.validateRegex(this.m_wcontext._bundle, fname, beforeConvertExpression);
            }
            isInclude = false;
            fname = this.excludePattern.getText().trim();
            beforeConvertExpression = null;
            if (fname.length() == 0) {
                this.m_excludePattern = null;
            } else {
                if (this.wildcardRB.isSelected()) {
                    beforeConvertExpression = fname;
                    fname = FileAdapterReadFilteringPage.convertWildcardToRegex(beforeConvertExpression);
                }
                this.m_excludePattern = fname;
                rc1 = FileAdapterValidation.validateRegex(this.m_wcontext._bundle, fname, beforeConvertExpression);
            }
            if (this.m_includePattern == null && this.m_excludePattern == null) {
                MultiLineOptionPane.showMessageDialog((Component)this.m_wcontext._parentFrame, (Object)this.m_wcontext._bundle.getString("FA_VL_MISSING_PATTERN_MSG"), (String)this.m_wcontext._bundle.getString("FA_ERROR"), (int)0);
                ((Cancelable)event).cancel();
            }
            FileAdapterContext fac = (FileAdapterContext)this.m_wcontext._ascontext;
            fac.includeFilePattern = this.m_includePattern;
            fac.excludeFilePattern = this.m_excludePattern;
        }
        catch (Exception ex1) {
            MultiLineOptionPane.showMessageDialog((Component)this.m_wcontext._parentFrame, (Object)ex1.getLocalizedMessage(), (String)this.m_wcontext._bundle.getString("FA_VL_FILE_NAME_ERROR_TITLE"), (int)0);
            if (isInclude) {
                new FocusRequester(this.includePattern);
            } else {
                new FocusRequester(this.excludePattern);
            }
            ((Cancelable)event).cancel();
        }
        if (this.m_wcontext._isOutboundFileListing) {
            this.setFinishPage();
        }
    }

    public static String convertWildcardToRegex(String express1) {
        String outstr = "";
        int strlen = express1.length();
        for (int ii = 0; ii < strlen; ++ii) {
            char testch = express1.charAt(ii);
            outstr = testch == '.' ? outstr + "\\." : (testch == '*' ? outstr + ".*" : (testch == '?' ? outstr + "." : outstr + testch));
        }
        return outstr;
    }

    @Override
    public void buildWSDL() throws WSDLException {
        JcaOperation jop = this.m_wcontext._write_jca_operation;
        JcaAddress jcaa = this.m_wcontext._write_jca_address;
        String tempstr = this.m_includePattern;
        if (tempstr != null && tempstr.length() > 0) {
            jop.setAttributeValue("IncludeFiles", tempstr);
            if (this.wildcardRB.isSelected()) {
                jcaa.setUiIncludeWildcardExpression(this.includePattern.getText().trim());
            }
        }
        if ((tempstr = this.m_excludePattern) != null && tempstr.length() > 0) {
            jop.setAttributeValue("ExcludeFiles", tempstr);
            if (this.wildcardRB.isSelected()) {
                jcaa.setUiExcludeWildcardExpression(this.excludePattern.getText().trim());
            }
        }
        if (this.numberMessages.isEnabled()) {
            jop.setAttributeValue("PublishSize", Long.toString(this.getLong(this.numberMessages.getValue())));
        }
    }

    public void setFinishPage() {
        String finish_info = null;
        String finish_prompt = null;
        MessageFormat msgformat = null;
        Object[] obj = null;
        if (this.m_wcontext._read_service != null) {
            msgformat = new MessageFormat(this.getTranslatedString("FA_FN_UPDATE_PROMPT"));
            if (this.m_wcontext._service_type.equals("Ftp")) {
                msgformat = new MessageFormat(this.getTranslatedString("FTP_FN_UPDATE_PROMPT"));
            }
            obj = new Object[]{this.m_wcontext._write_service_name};
            finish_prompt = msgformat.format(obj);
            msgformat = new MessageFormat(this.getTranslatedString("FA_FN_UPDATE_SUMMARY"));
            obj = new Object[]{this.m_wcontext._write_wsdl_name};
            finish_info = msgformat.format(obj);
        } else {
            msgformat = new MessageFormat(this.getTranslatedString("FA_FN_PROMPT"));
            if (this.m_wcontext._service_type.equals("Ftp")) {
                msgformat = new MessageFormat(this.getTranslatedString("FTP_FN_PROMPT"));
            }
            obj = new Object[]{this.m_wcontext._write_service_name};
            finish_prompt = msgformat.format(obj);
            msgformat = new MessageFormat(this.getTranslatedString("FA_FN_SUMMARY"));
            obj = new Object[]{this.m_wcontext._write_wsdl_name};
            finish_info = msgformat.format(obj);
        }
        this.setFinishPageContents(finish_prompt, finish_info);
    }
}

