/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.file;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;

public class FileAdapterContext {
    private static final String DIR_SEPARATOR = ";";
    public boolean _deleteFilesAfterProcessing = false;
    public boolean ignoreFileContent = false;
    public boolean isPhysicalDirectory = true;
    public String includeFilePattern = "";
    public String excludeFilePattern = "";
    public List directoryList;
    public boolean recursive = true;
    public boolean streamFiles = false;
    public boolean isAttachment = false;

    public void populateLogicalNames(AdapterWizardContext ctx, boolean old) {
        if (this.directoryList != null) {
            if (old && ctx._logicalNames_old == null) {
                ctx._logicalNames_old = new Hashtable();
            } else if (ctx._logicalNames == null) {
                ctx._logicalNames = new Hashtable();
            }
            for (int i = 0; i < this.directoryList.size(); ++i) {
                String curDir = (String)this.directoryList.get(i);
                if (old) {
                    ctx._logicalNames_old.put("LogicalDirectory", curDir);
                    continue;
                }
                ctx._logicalNames.put("LogicalDirectory", curDir);
            }
        }
    }

    public void setDirectoryList(String dirStr) {
        this.directoryList = FileAdapterContext.convertDirStrToList(dirStr);
    }

    public static List convertDirStrToList(String dirStr) {
        ArrayList<String> dirList = new ArrayList<String>();
        if (dirStr != null && !dirStr.trim().equals("")) {
            StringTokenizer tokenizer = new StringTokenizer(dirStr, DIR_SEPARATOR);
            while (tokenizer.hasMoreTokens()) {
                String curDir = tokenizer.nextToken();
                dirList.add(curDir);
            }
        }
        return dirList;
    }

    public String convertDirListToString() {
        String dirStr = null;
        boolean firstTime = true;
        if (this.directoryList != null && this.directoryList.size() > 0) {
            for (int i = 0; i < this.directoryList.size(); ++i) {
                String curDir = (String)this.directoryList.get(i);
                if (firstTime) {
                    dirStr = curDir;
                    firstTime = false;
                    continue;
                }
                dirStr = dirStr + DIR_SEPARATOR + curDir;
            }
        }
        return dirStr;
    }

    public boolean isDirInList(String dir) {
        if (dir != null && this.directoryList != null) {
            for (int i = 0; i < this.directoryList.size(); ++i) {
                String curDir = (String)this.directoryList.get(i);
                if (!(this.recursive ? dir.startsWith(curDir) : dir.equals(curDir))) continue;
                return true;
            }
        }
        return false;
    }
}

