/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.sqlserver;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.wsdl.Definition;
import oracle.tip.adapter.db.sp.xsd.IXSDProcedure;
import oracle.tip.adapter.db.sp.xsd.sqlserver.XSDProcedure;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.AbstractDataAccess;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.ArgumentObject;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.IDBAdapterSPUserInput;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.PackageObject;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.ProcedureObject;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.sqlserver.DBAdapterSPUserInput;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.JcaOperation;

public class DataAccess
extends AbstractDataAccess {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getPackages(Connection conn, String catalogName) throws Exception {
        List schemaList = null;
        ResultSet schemas = null;
        Statement stmt = null;
        try {
            String query = "select schema_name from " + catalogName.toUpperCase() + ".INFORMATION_SCHEMA.SCHEMATA order by schema_name";
            stmt = conn.createStatement();
            this.traceQuery(query);
            schemas = stmt.executeQuery(query);
            schemaList = this.generatePackages(conn, schemas, catalogName);
        }
        catch (Throwable throwable) {
            this.closeResultSet(schemas);
            throw throwable;
        }
        this.closeResultSet(schemas);
        return schemaList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PackageObject getPackage(Connection conn, String catalogName, String schemaName) throws Exception {
        PackageObject schemaObj = null;
        if (schemaName != null) {
            ResultSet rs;
            block3: {
                rs = null;
                Statement stmt = null;
                String query = "select schema_name from " + catalogName.toUpperCase() + ".INFORMATION_SCHEMA.SCHEMATA " + "where schema_name = '" + schemaName + "'";
                try {
                    stmt = conn.createStatement();
                    this.traceQuery(query);
                    rs = stmt.executeQuery(query);
                    if (!rs.next()) break block3;
                    schemaObj = new PackageObject(rs.getString("schema_name"), catalogName);
                }
                catch (Throwable throwable) {
                    this.closeResultSet(rs);
                    throw throwable;
                }
            }
            this.closeResultSet(rs);
        }
        return schemaObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getProcedures(Connection conn, String catalogName, PackageObject schemaObj) throws Exception {
        List procedureList = null;
        ResultSet routines = null;
        Statement stmt = null;
        String query = "select routine_schema, routine_name from " + catalogName.toUpperCase() + ".INFORMATION_SCHEMA.ROUTINES " + "where routine_schema = '" + schemaObj.getName() + "' " + "group by routine_schema, routine_name order by routine_name";
        try {
            stmt = conn.createStatement();
            this.traceQuery(query);
            routines = stmt.executeQuery(query);
            procedureList = this.generatePackagedProcedures(routines, catalogName, schemaObj);
        }
        catch (Throwable throwable) {
            this.closeResultSet(routines);
            throw throwable;
        }
        this.closeResultSet(routines);
        return procedureList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getSchemas(Connection conn) throws Exception {
        ArrayList<String> catalogList = new ArrayList<String>();
        CallableStatement cStmt = null;
        ResultSet catalogNames = null;
        String query = "execute sp_databases";
        this.traceQuery(query);
        try {
            String currentSchema;
            cStmt = conn.prepareCall(query);
            catalogNames = cStmt.executeQuery();
            while (catalogNames.next()) {
                catalogList.add(catalogNames.getString("database_name"));
            }
            if (catalogList.size() == 0 && (currentSchema = this.getConnectionSchema(conn)) != null) {
                catalogList.add(currentSchema);
            }
        }
        catch (Throwable throwable) {
            this.closeResultSet(catalogNames);
            throw throwable;
        }
        this.closeResultSet(catalogNames);
        return catalogList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getArguments(Connection conn, ProcedureObject procObj) throws Exception {
        List argumentList = null;
        ResultSet arguments = null;
        Statement stmt = null;
        if (procObj != null) {
            String query = "select parameter_name, ordinal_position, parameter_mode, data_type, character_maximum_length from " + procObj.getSchema().toUpperCase() + ".INFORMATION_SCHEMA.PARAMETERS " + "where specific_schema = '" + procObj.getPackage().getName() + "' " + "and specific_name = '" + procObj.getName() + "' " + "order by ordinal_position";
            try {
                stmt = conn.createStatement();
                this.traceQuery(query);
                arguments = stmt.executeQuery(query);
                argumentList = this.generateArgumentList(arguments, procObj);
            }
            catch (Throwable throwable) {
                this.closeResultSet(arguments);
                throw throwable;
            }
            this.closeResultSet(arguments);
        }
        return argumentList;
    }

    private List generateArgumentList(ResultSet args, ProcedureObject procObj) throws Exception {
        ArrayList<ArgumentObject> argumentList = new ArrayList<ArgumentObject>();
        while (args.next()) {
            ArgumentObject argumentObj = new ArgumentObject(null, args.getString("parameter_name"), null, args.getString("ordinal_position"), null, args.getString("data_type"), null, procObj.getSchema(), args.getString("parameter_mode"), args.getInt("character_maximum_length"), 0, procObj);
            argumentList.add(argumentObj);
        }
        return argumentList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List searchProcedures(Connection conn, String searchString, PackageObject schemaObj, String catalogName) throws Exception {
        List procedureList = null;
        if (searchString != null) {
            String routineName = null;
            String schemaName = null;
            int index = -1;
            index = searchString.indexOf(".");
            if (index != -1) {
                schemaName = searchString.substring(0, index);
                routineName = searchString.substring(index + 1, searchString.length());
            } else {
                schemaName = "%";
                routineName = searchString;
            }
            ResultSet routines = null;
            Statement stmt = null;
            String query = "select routine_schema, routine_name from " + catalogName.toUpperCase() + ".INFORMATION_SCHEMA.ROUTINES " + "where routine_schema like '" + schemaName + "' " + "and routine_name like '" + routineName + "' " + "group by routine_schema, routine_name order by routine_schema";
            try {
                stmt = conn.createStatement();
                this.traceQuery(query);
                routines = stmt.executeQuery(query);
                procedureList = this.generatePackagedProcedures(routines, catalogName, schemaObj);
            }
            catch (Throwable throwable) {
                this.closeResultSet(routines);
                throw throwable;
            }
            this.closeResultSet(routines);
        }
        return procedureList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getProcedureSourceCode(Connection conn, ProcedureObject procObj) throws Exception {
        ArrayList<String> sourceList = new ArrayList<String>();
        if (procObj != null) {
            ResultSet definition;
            block4: {
                definition = null;
                Statement stmt = null;
                String query = "select object_definition(object_id('" + procObj.getSchema() + "." + procObj.getPackage().getName() + "." + procObj.getName() + "'))";
                try {
                    String code;
                    stmt = conn.createStatement();
                    this.traceQuery(query);
                    definition = stmt.executeQuery(query);
                    if (!definition.next() || (code = definition.getString(1)) == null) break block4;
                    char[] chars = new char[]{'\n'};
                    StringTokenizer st = new StringTokenizer(code, new String(chars));
                    while (st.hasMoreTokens()) {
                        sourceList.add(st.nextToken() + '\n');
                    }
                }
                catch (Throwable throwable) {
                    this.closeResultSet(definition);
                    throw throwable;
                }
            }
            this.closeResultSet(definition);
        }
        return sourceList;
    }

    private List generatePackagedProcedures(ResultSet routines, String catalogName, PackageObject schemaObj) throws Exception {
        ArrayList<ProcedureObject> procedureList = new ArrayList<ProcedureObject>();
        PackageObject currentSchemaObj = schemaObj;
        routines.setFetchSize(500);
        while (routines.next()) {
            String schemaName = routines.getString("routine_schema");
            if (currentSchemaObj == null || !currentSchemaObj.getName().equals(schemaName)) {
                currentSchemaObj = new PackageObject(schemaName, catalogName);
            }
            String routineName = routines.getString("routine_name");
            ProcedureObject procedureObj = new ProcedureObject(null, routineName, catalogName, currentSchemaObj, 0, false);
            procedureList.add(procedureObj);
        }
        return procedureList;
    }

    private List generatePackages(Connection conn, ResultSet schemas, String catalogName) throws Exception {
        ArrayList<PackageObject> schemaList = new ArrayList<PackageObject>();
        schemas.setFetchSize(500);
        while (schemas.next()) {
            String schemaName = schemas.getString("schema_name");
            schemaList.add(new PackageObject(schemaName, catalogName));
        }
        return schemaList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getProcedure(Connection conn, String catalogName, String schemaName, String procedureName) throws Exception {
        List procedureList = null;
        if (procedureName != null) {
            ResultSet routines = null;
            Statement stmt = null;
            try {
                PackageObject schemaObj = new PackageObject(schemaName, catalogName);
                String query = "select routine_schema, routine_name from " + catalogName.toUpperCase() + ".INFORMATION_SCHEMA.ROUTINES " + "where routine_schema = '" + schemaName + "' " + "and routine_name = '" + procedureName + "' " + "group by routine_schema, routine_name order by routine_name";
                stmt = conn.createStatement();
                this.traceQuery(query);
                routines = stmt.executeQuery(query);
                procedureList = this.generatePackagedProcedures(routines, catalogName, schemaObj);
            }
            catch (Throwable throwable) {
                this.closeResultSet(routines);
                throw throwable;
            }
            this.closeResultSet(routines);
        }
        return procedureList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getConnectionSchema(Connection conn) throws Exception {
        String catalogName = null;
        ResultSet db = null;
        Statement stmt = null;
        try {
            String query = "select db_name()";
            stmt = conn.createStatement();
            this.traceQuery(query);
            db = stmt.executeQuery(query);
            if (db.next()) {
                catalogName = db.getString(1);
            }
        }
        catch (Throwable throwable) {
            this.closeResultSet(db);
            throw throwable;
        }
        this.closeResultSet(db);
        return catalogName;
    }

    public XSDProcedure convertToXSDStoredProcedure(AdapterWizardContext wcontext, ProcedureObject procObj) throws Exception {
        XSDProcedure xsdStoredProc = null;
        if (procObj != null) {
            List argList;
            String defaultCatalog = wcontext._bundle.getString("CM_WZ_DBSCHEMA_CONNECTION_USER_DEFAULT");
            String catalogName = procObj.getSchema();
            if (catalogName.equals(defaultCatalog)) {
                catalogName = this.getConnectionSchema(wcontext._connection);
            }
            String schemaName = null;
            if (procObj.getPackage() != null) {
                schemaName = procObj.getPackage().getName();
            }
            xsdStoredProc = new XSDProcedure(catalogName, schemaName, procObj.getName());
            if (procObj.hasReturnStatus()) {
                xsdStoredProc.addParameter(null, "INT", null, "0", 0);
            }
            if ((argList = procObj.getArgumentList()) != null && argList.size() > 0) {
                for (int i = 0; i < argList.size(); ++i) {
                    ArgumentObject currentArg = (ArgumentObject)argList.get(i);
                    if (currentArg.getName().equals("RowSet")) continue;
                    xsdStoredProc.addParameter(currentArg.getName(), currentArg.getTypeName(), currentArg.getInOut(), currentArg.getPosition(), currentArg.getCharLength());
                }
            }
        }
        return xsdStoredProc;
    }

    @Override
    protected void setJcaOperationInteractionSpec(AdapterWizardContext wcontext, JcaOperation jcaOp) {
        jcaOp.setAttributeValue("InteractionSpec", "oracle.tip.adapter.db.DBStoredProcedureInteractionSpec");
    }

    @Override
    protected IXSDProcedure getTheXsdStoredProcedure(AdapterWizardContext wcontext, ProcedureObject procObj) throws Exception {
        return this.convertToXSDStoredProcedure(wcontext, procObj);
    }

    @Override
    protected void setUiOverloadedProcedure(AdapterWizardContext wcontext, ProcedureObject procObj) {
    }

    @Override
    protected void setUiProcedureReturnStatus(AdapterWizardContext wcontext, ProcedureObject procObj) {
        if (procObj.hasReturnStatus()) {
            wcontext._write_jca_address.setUiProcedureReturnStatus(Boolean.toString(procObj.hasReturnStatus()));
        }
    }

    @Override
    protected void setUiStrongXSD(AdapterWizardContext wcontext) {
        IDBAdapterSPUserInput userInput = (IDBAdapterSPUserInput)wcontext._ascontext;
        wcontext._write_jca_address.setUiStrongXSD(userInput.isStrongXSD().toString());
    }

    private void importHeaderWSDL(AdapterWizardContext wcontext, Definition def) throws Exception {
    }

    public void printUserInput(DBAdapterSPUserInput userInput) {
        System.out.println("************ USER INPUT ***************");
        if (userInput != null) {
            List argList = null;
            PackageObject schemaObj = userInput.getPackage();
            ProcedureObject procObj = userInput.getProcedure();
            if (procObj != null) {
                argList = procObj.getArgumentList();
            }
            System.out.println("Catalog: " + userInput.getSchema());
            if (schemaObj != null) {
                System.out.println("Schema: " + schemaObj.getName());
            }
            if (procObj != null) {
                System.out.println("Procedure: " + procObj.getName());
            }
            if (argList != null && argList.size() > 0) {
                System.out.println("\nARGUMENTS - " + argList.size());
                System.out.println("--------------------");
                for (int i = 0; i < argList.size(); ++i) {
                    ArgumentObject argObj = (ArgumentObject)argList.get(i);
                    System.out.println(" >> " + i + " << ");
                    System.out.println("Name: " + argObj.getName());
                    System.out.println("Type: " + argObj.getTypeName());
                    System.out.println("Direction: " + argObj.getInOut());
                    System.out.println("Position: " + argObj.getPosition());
                    System.out.println("CharLength: " + argObj.getCharLength());
                }
            }
        }
        System.out.println("***************************************");
    }
}

