/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.sqlserver;

import java.awt.Component;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.List;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.javatools.dialogs.MessageDialog;
import oracle.tip.adapter.db.sp.RowSetMetaData;
import oracle.tip.adapter.db.sp.SPUtil;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.AbstractRowSetPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.ArgumentObject;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.ProcedureObject;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.TestArgumentTableModel;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.sqlserver.SQLServerDatabase;

public class DBAdapterRowSetPage
extends AbstractRowSetPage {
    public DBAdapterRowSetPage(AdapterWizardContext wcontext, ImageWizardPage iwp) throws Exception {
        super(wcontext, iwp, new SQLServerDatabase());
    }

    @Override
    public String getRowSetPageIntroText() {
        return "DB_SP_CURSOR_PAGE_TEXT_THIRD_PARTY";
    }

    private String getFunctionCallSql(ProcedureObject procedure, Connection connection) throws Exception {
        StringBuffer SQL = new StringBuffer();
        SQL.append("{ ? = call ");
        SQL.append(this.getQualifiedProcedureName(procedure, connection)).append("(");
        List argList = procedure.getArgumentList();
        for (int i = 1; i < argList.size(); ++i) {
            SQL.append("?");
            if (i >= argList.size() - 1) continue;
            SQL.append(", ");
        }
        SQL.append(") }");
        return SQL.toString();
    }

    private String getProcedureCallSql(ProcedureObject procedure, Connection connection) throws Exception {
        StringBuffer SQL = new StringBuffer();
        SQL.append("execute ");
        SQL.append(this.getQualifiedProcedureName(procedure, connection));
        SQL.append(" ");
        List argList = procedure.getArgumentList();
        for (int i = 0; i < argList.size(); ++i) {
            ArgumentObject arg = (ArgumentObject)argList.get(i);
            SQL.append(arg.getName()).append("=?");
            if (i >= argList.size() - 1) continue;
            SQL.append(", ");
        }
        return SQL.toString();
    }

    @Override
    public String getCallSql(ProcedureObject procedure, Connection connection) throws Exception {
        if (procedure.isFunction()) {
            return this.getFunctionCallSql(procedure, connection);
        }
        return this.getProcedureCallSql(procedure, connection);
    }

    @Override
    public void bindAllParameters(ProcedureObject procedure, CallableStatement cStmt, Connection connection, TestArgumentTableModel argTableModel) throws Exception {
        List argList = procedure.getArgumentList();
        for (int i = 0; i < argList.size(); ++i) {
            ArgumentObject arg = (ArgumentObject)argList.get(i);
            int index = Integer.valueOf(arg.getPosition());
            if (procedure.isFunction()) {
                ++index;
            }
            int jdbcType = SPUtil.getJDBCType((String)arg.getTypeName().toUpperCase(), (HashMap)this.platform.getSqlTypeMappings());
            if (arg.getInOut().contains("IN")) {
                Object object = this.getArgumentValue(arg, jdbcType, argTableModel, connection);
                if (object == null) {
                    cStmt.setNull(index, jdbcType);
                } else {
                    cStmt.setObject(index, object);
                }
            }
            if (!arg.getInOut().contains("OUT")) continue;
            cStmt.registerOutParameter(index, jdbcType);
        }
    }

    @Override
    public boolean retrieveAllRowSets(ProcedureObject procedure, CallableStatement cStmt, boolean hasResults, String SQL) throws Exception {
        boolean success = true;
        if (hasResults) {
            int i = 0;
            while (hasResults) {
                String rowSetName = "RowSet" + Integer.toString(i);
                ResultSet rs = cStmt.getResultSet();
                if (!rs.next()) {
                    success = false;
                    String message = this.getTranslatedString("DB_SP_EMPTY_ROWSET") + rowSetName + " SQL: " + SQL;
                    String title = this.getTranslatedString("DB_SP_INTROSPECTION_FAILED");
                    MessageDialog.information((Component)this.m_wcontext._parentFrame, (Object)message, (String)title, null);
                } else {
                    RowSetMetaData metaData = new RowSetMetaData(rs.getMetaData());
                    procedure.getRowSets().put(rowSetName, metaData);
                }
                rs.close();
                hasResults = cStmt.getMoreResults();
                ++i;
            }
            if (!success) {
                procedure.getRowSets().clear();
            }
        } else {
            String message = this.getTranslatedString("DB_SP_NO_ROWSETS_MESSAGE") + SQL;
            String title = this.getTranslatedString("DB_SP_NO_ROWSETS_TITLE");
            MessageDialog.information((Component)this.m_wcontext._parentFrame, (Object)message, (String)title, null);
        }
        return success;
    }

    @Override
    public Boolean introspectStrong(ProcedureObject procObj) {
        return Boolean.TRUE;
    }
}

