/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.oracle;

import java.io.File;
import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFactory;
import oracle.tip.adapter.db.sp.xsd.IXSDProcedure;
import oracle.tip.adapter.db.sp.xsd.oracle.JPublisher;
import oracle.tip.adapter.db.sp.xsd.oracle.XSDProcedure;
import oracle.tip.tools.ide.pm.addin.model.XMLNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.AbstractDataAccess;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.ArgumentObject;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.PackageObject;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.ProcedureObject;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.oracle.DBAdapterSPUserInput;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.JcaOperation;

public class DataAccess
extends AbstractDataAccess {
    @Override
    public List getPackages(Connection conn, String owner) throws Exception {
        List packageList = null;
        Statement stmt = null;
        ResultSet rs = null;
        String query = "select object_id, object_name, object_type, owner from all_objects where (object_type='PACKAGE' or object_type='PROCEDURE' or object_type='FUNCTION') and owner='" + owner + "'" + " " + "order by object_type, object_name";
        stmt = conn.createStatement();
        this.traceQuery(query);
        rs = stmt.executeQuery(query);
        packageList = this.generatePackages(rs);
        this.closeResultSet(rs);
        return packageList;
    }

    @Override
    public PackageObject getPackage(Connection conn, String owner, String packageName) throws Exception {
        PackageObject pkgObj = null;
        Statement stmt = null;
        ResultSet rs = null;
        if (packageName != null) {
            String query = "select object_name, owner from all_objects where object_type='PACKAGE' and owner='" + owner + "'" + " and " + "object_name='" + packageName.toUpperCase() + "' ";
            stmt = conn.createStatement();
            this.traceQuery(query);
            rs = stmt.executeQuery(query);
            if (rs.next()) {
                String schema = rs.getString("OWNER");
                String pkgName = rs.getString("OBJECT_NAME");
                pkgObj = new PackageObject(pkgName, schema);
                this.closeResultSet(rs);
            }
        }
        return pkgObj;
    }

    @Override
    public List getProcedures(Connection conn, String owner, PackageObject pkgObj) throws Exception {
        List procList = null;
        Statement stmt = null;
        ResultSet rs = null;
        String query = "select object_name, owner, package_name, overload from all_arguments where object_id in (select object_id from all_objects where object_name = '" + pkgObj.getName() + "' " + "and object_type = 'PACKAGE') " + "and owner = '" + owner + "' " + "group by owner, package_name, object_name, overload " + "order by object_name";
        stmt = conn.createStatement();
        this.traceQuery(query);
        rs = stmt.executeQuery(query);
        procList = this.generatePackagedProcedures(rs, pkgObj);
        this.closeResultSet(rs);
        return procList;
    }

    @Override
    public List getSchemas(Connection conn) throws Exception {
        ArrayList<String> schemaList = null;
        Statement stmt = null;
        ResultSet rs = null;
        String query = "select username from all_users order by username";
        stmt = conn.createStatement();
        this.traceQuery(query);
        rs = stmt.executeQuery(query);
        if (rs != null) {
            schemaList = new ArrayList<String>();
            while (rs.next()) {
                schemaList.add(rs.getString("USERNAME"));
            }
            this.closeResultSet(rs);
        }
        return schemaList;
    }

    @Override
    public List getArguments(Connection conn, ProcedureObject procObj) throws Exception {
        List argList = null;
        Statement stmt = null;
        ResultSet rs = null;
        String query = null;
        String overloadVal = null;
        String packageName = null;
        String owner = null;
        String objectID = null;
        int overload = 0;
        PackageObject pkgObj = null;
        if (procObj != null) {
            objectID = procObj.getObjectID();
            overload = procObj.getOverload();
            pkgObj = procObj.getPackage();
            owner = procObj.getSchema();
            if (pkgObj != null) {
                packageName = pkgObj.getName();
            }
            query = "select owner, object_name, package_name, object_id, overload, argument_name, position, data_level, decode(pls_type, NULL, data_type, pls_type) data_type_mod, type_owner, in_out, sequence, type_subname, data_type, decode(type_subname, NULL, decode(type_name, NULL, decode(pls_type, NULL, data_type, pls_type), type_name), type_subname) type_name_mod from all_arguments where object_id=";
            query = objectID != null ? query + "'" + objectID + "' " : query + "(select object_id from all_objects " + "where object_name='" + packageName + "' " + "and object_type='PACKAGE' " + "and owner='" + owner + "') ";
            query = query + "and owner ='" + owner + "' " + "and data_level=0 " + "and object_name='" + procObj.getName() + "'";
            if (packageName != null) {
                query = query + " and package_name='" + packageName + "'";
            }
            if (overload > 0) {
                overloadVal = String.valueOf(overload);
                query = query + " and overload='" + overloadVal + "'";
            }
            if ((query = query + " order by position") != null) {
                stmt = conn.createStatement();
                this.traceQuery(query);
                rs = stmt.executeQuery(query);
                argList = this.generateArgumentList(rs, procObj);
                this.closeResultSet(rs);
            }
        }
        return argList;
    }

    private List generateArgumentList(ResultSet rs, ProcedureObject procObj) throws Exception {
        ArgumentObject argObj;
        ArrayList<ArgumentObject> argList = null;
        int count = 0;
        if (rs != null) {
            argList = new ArrayList<ArgumentObject>();
            while (rs.next()) {
                argObj = new ArgumentObject(rs.getString("OBJECT_ID"), rs.getString("ARGUMENT_NAME"), rs.getString("OVERLOAD"), rs.getString("POSITION"), rs.getString("SEQUENCE"), rs.getString("type_name_mod"), rs.getString("data_type_mod"), rs.getString("TYPE_OWNER"), rs.getString("IN_OUT"), 0, 0, procObj);
                argObj.setTypeSubname(rs.getString("TYPE_SUBNAME"));
                argObj.setOriginalDatatype(rs.getString("DATA_TYPE"));
                argList.add(argObj);
                ++count;
            }
        }
        if (argList != null && argList.size() == 1 && !"OUT".equalsIgnoreCase((argObj = (ArgumentObject)argList.get(0)).getInOut()) && (argObj.getDatatype() == null || argObj.getDatatype().trim().equals(""))) {
            argList = new ArrayList();
        }
        return argList;
    }

    public int getOverloadCount(Connection conn, String objectID, String owner, String packageName, String procName) throws Exception {
        int count = -1;
        Statement stmt = null;
        ResultSet rs = null;
        String query = null;
        query = "select overload from all_arguments where object_id=";
        query = objectID != null ? query + "'" + objectID + "' " : query + "(select object_id from all_objects " + "where object_name='" + packageName + "' " + "and object_type='PACKAGE' " + "and owner='" + owner + "') ";
        query = query + "and owner ='" + owner + "' " + "and object_name='" + procName + "'";
        if (packageName != null) {
            query = query + " and package_name='" + packageName + "'";
        }
        if ((query = query + " order by overload") != null) {
            stmt = conn.createStatement();
            this.traceQuery(query);
            rs = stmt.executeQuery(query);
        }
        if (rs != null) {
            String currentOverloadVal = null;
            while (rs.next()) {
                currentOverloadVal = rs.getString("OVERLOAD");
            }
            if (currentOverloadVal != null && !currentOverloadVal.trim().equals("")) {
                count = Integer.valueOf(currentOverloadVal);
            }
        }
        if (count == -1) {
            count = 0;
        }
        return count;
    }

    @Override
    public List searchProcedures(Connection conn, String searchString, PackageObject pkgObj, String owner) throws Exception {
        List pkgProcList;
        block9: {
            boolean wildCardSearch;
            String query;
            ResultSet rs;
            Statement stmt;
            List procList;
            block10: {
                procList = null;
                pkgProcList = null;
                stmt = null;
                rs = null;
                query = null;
                wildCardSearch = false;
                if ((searchString = searchString.toUpperCase()) == null) break block9;
                if (searchString.indexOf("%") > -1) {
                    wildCardSearch = true;
                }
                if (pkgObj == null) break block10;
                query = wildCardSearch ? "select object_name, owner, package_name, overload from all_arguments where object_id in (select object_id from all_objects where object_name = '" + pkgObj.getName() + "' " + "and object_type = 'PACKAGE') " + "and object_name like '" + searchString + "' " + "and owner = '" + owner + "' " + "group by owner, package_name, object_name, overload " + "order by object_name" : "select object_name, owner, package_name, overload from all_arguments where object_id in (select object_id from all_objects where object_name = '" + pkgObj.getName() + "' " + "and object_type = 'PACKAGE') " + "and object_name = '" + searchString + "' " + "and owner = '" + owner + "' " + "group by owner, package_name, object_name, overload " + "order by object_name";
                if (query == null) break block9;
                stmt = conn.createStatement();
                this.traceQuery(query);
                rs = stmt.executeQuery(query);
                if (rs == null) break block9;
                pkgProcList = this.generatePackagedProcedures(rs, pkgObj);
                break block9;
            }
            query = wildCardSearch ? "select object_id, object_name, object_type, owner from all_objects where object_name like '" + searchString + "' " + "and (object_type='PROCEDURE' or object_type='FUNCTION')" + "and owner='" + owner + "' " + "order by object_name" : "select object_id, object_name, object_type, owner from all_objects where object_name='" + searchString + "' " + "and (object_type='PROCEDURE' or object_type='FUNCTION')" + "and owner='" + owner + "' " + "order by object_name";
            if (query != null) {
                stmt = conn.createStatement();
                this.traceQuery(query);
                rs = stmt.executeQuery(query);
                if (rs != null) {
                    procList = this.generatePackages(rs);
                }
            }
            if ((query = wildCardSearch ? "select object_name, owner, package_name, overload from all_arguments where object_id in (select object_id from all_objects where object_type = 'PACKAGE') and object_name like '" + searchString + "' " + "and owner = '" + owner + "' " + "group by owner, package_name, object_name, overload " + "order by object_name" : "select object_name, owner, package_name, overload from all_arguments where object_id in (select object_id from all_objects where object_type = 'PACKAGE') and object_name = '" + searchString + "' " + "and owner = '" + owner + "' " + "group by owner, package_name, object_name, overload " + "order by object_name") != null) {
                stmt = conn.createStatement();
                this.traceQuery(query);
                rs = stmt.executeQuery(query);
                if (rs != null) {
                    pkgProcList = this.generatePackagedProcedures(rs, pkgObj);
                }
            }
            if (procList != null && pkgProcList == null) {
                pkgProcList = procList;
            } else if (procList != null && pkgProcList != null) {
                for (int i = 0; i < procList.size(); ++i) {
                    pkgProcList.add(procList.get(i));
                }
            }
        }
        return pkgProcList;
    }

    @Override
    public List getProcedureSourceCode(Connection conn, ProcedureObject procObj) throws Exception {
        ArrayList<String> sourceList = null;
        Statement stmt = null;
        ResultSet rs = null;
        String query = null;
        String query2 = null;
        if (conn != null && procObj != null) {
            String sourceLine;
            if (procObj.getPackage() == null) {
                query = !procObj.isFunction() ? "select text from all_source where owner='" + procObj.getSchema() + "' and " + "type='PROCEDURE' and " + "name='" + procObj.getName() + "' " + "order by line" : "select text from all_source where owner='" + procObj.getSchema() + "' and " + "type='FUNCTION' and " + "name='" + procObj.getName() + "' " + "order by line";
            } else {
                query = "select text from all_source where owner='" + procObj.getSchema() + "' and " + "type='PACKAGE' and " + "name='" + procObj.getPackage().getName() + "' " + "order by line";
                query2 = "select text from all_source where owner='" + procObj.getSchema() + "' and " + "type='PACKAGE BODY' and " + "name='" + procObj.getPackage().getName() + "' " + "order by line";
            }
            if (query != null) {
                stmt = conn.createStatement();
                this.traceQuery(query);
                rs = stmt.executeQuery(query);
                if (rs != null) {
                    sourceList = new ArrayList<String>();
                    rs.setFetchSize(500);
                    while (rs.next()) {
                        sourceLine = rs.getString("TEXT");
                        sourceList.add(sourceLine);
                    }
                }
            }
            if (query2 != null) {
                stmt = conn.createStatement();
                this.traceQuery(query2);
                rs = stmt.executeQuery(query2);
                if (rs != null) {
                    if (sourceList == null) {
                        sourceList = new ArrayList();
                    }
                    rs.setFetchSize(500);
                    if (rs.next()) {
                        if (sourceList != null && sourceList.size() > 0) {
                            sourceList.add("\n\n");
                            sourceList.add("********************************************");
                            sourceList.add("\n\n");
                        }
                        do {
                            sourceLine = rs.getString("TEXT");
                            sourceList.add(sourceLine);
                        } while (rs.next());
                    }
                }
            }
            this.closeResultSet(rs);
        }
        return sourceList;
    }

    private List generatePackagedProcedures(ResultSet rs, PackageObject pkgObj) throws Exception {
        PackageObject currentPkgObj = pkgObj;
        ArrayList<ProcedureObject> procList = null;
        if (rs != null) {
            procList = new ArrayList<ProcedureObject>();
            boolean i = false;
            rs.setFetchSize(500);
            while (rs.next()) {
                String owner = rs.getString("OWNER");
                String packageName = rs.getString("PACKAGE_NAME");
                String procName = rs.getString("OBJECT_NAME");
                String overloadStr = rs.getString("OVERLOAD");
                if (currentPkgObj == null || !currentPkgObj.getName().equals(packageName)) {
                    currentPkgObj = new PackageObject(packageName, owner);
                }
                int overload = 0;
                if (overloadStr != null) {
                    overload = Integer.valueOf(overloadStr);
                }
                ProcedureObject procObj = new ProcedureObject(null, procName, owner, currentPkgObj, overload, false);
                procList.add(procObj);
            }
        }
        return procList;
    }

    private List generatePackages(ResultSet rs) throws Exception {
        ArrayList<PackageObject> pkgList = null;
        ArrayList<ProcedureObject> procList = null;
        ArrayList<ProcedureObject> objList = null;
        int currentOverload = 0;
        ProcedureObject prevProcObj = null;
        if (rs != null) {
            pkgList = new ArrayList<PackageObject>();
            procList = new ArrayList<ProcedureObject>();
            rs.setFetchSize(1000);
            while (rs.next()) {
                ProcedureObject procObj;
                String objectID = rs.getString("OBJECT_ID");
                String objectName = rs.getString("OBJECT_NAME");
                String objectType = rs.getString("OBJECT_TYPE");
                String schema = rs.getString("OWNER");
                if (objectType != null && objectType.equalsIgnoreCase("PACKAGE")) {
                    PackageObject pkgObj = new PackageObject(objectName, schema);
                    pkgList.add(pkgObj);
                    continue;
                }
                if (objectType == null || !objectType.equalsIgnoreCase("PROCEDURE") && !objectType.equalsIgnoreCase("FUNCTION")) continue;
                if (prevProcObj != null) {
                    if (prevProcObj.getName().trim().equals(objectName.trim())) {
                        if (prevProcObj.getOverload() == 0) {
                            prevProcObj.setOverload(1);
                        }
                        currentOverload = prevProcObj.getOverload() + 1;
                    } else {
                        currentOverload = 0;
                    }
                }
                prevProcObj = procObj = new ProcedureObject(objectID, objectName, schema, null, currentOverload, false);
                procList.add(procObj);
            }
        }
        if (pkgList != null && pkgList.size() > 0) {
            if (objList == null) {
                objList = new ArrayList<ProcedureObject>();
            }
            objList.addAll(pkgList);
        }
        if (procList != null && procList.size() > 0) {
            if (objList == null) {
                objList = new ArrayList();
            }
            Collections.sort(procList);
            objList.addAll(procList);
        }
        return objList;
    }

    @Override
    public List getProcedure(Connection conn, String owner, String packageName, String procedureName) throws Exception {
        List procList = null;
        Statement stmt = null;
        ResultSet rs = null;
        String query = null;
        if (conn != null && owner != null && procedureName != null) {
            if (packageName == null) {
                query = "select object_id, object_name, object_type, owner from all_objects where object_name='" + procedureName + "' and " + "(object_type='PROCEDURE' or object_type='FUNCTION') and " + "owner='" + owner + "' " + "order by object_name";
                stmt = conn.createStatement();
                this.traceQuery(query);
                rs = stmt.executeQuery(query);
                procList = this.generatePackages(rs);
                this.closeResultSet(rs);
            } else {
                query = "select object_name, package_name, owner, overload from all_arguments where object_id in (select object_id from all_objects where object_name = '" + packageName + "' and object_type = 'PACKAGE') and " + "object_name = '" + procedureName + "' and owner = '" + owner + "' " + "group by owner, package_name, object_name, overload " + "order by object_name";
                stmt = conn.createStatement();
                this.traceQuery(query);
                rs = stmt.executeQuery(query);
                procList = this.generatePackagedProcedures(rs, null);
                this.closeResultSet(rs);
            }
        }
        return procList;
    }

    @Override
    public String getConnectionSchema(Connection conn) throws Exception {
        DatabaseMetaData metaData = conn.getMetaData();
        String connSchema = metaData.getUserName();
        return connSchema;
    }

    public XSDProcedure convertToXSDStoredProcedure(AdapterWizardContext wcontext, ProcedureObject procObj) throws Exception {
        XSDProcedure xsdStoredProc = null;
        if (procObj != null) {
            String defaultSchema = wcontext._bundle.getString("CM_WZ_DBSCHEMA_CONNECTION_USER_DEFAULT");
            String schema = procObj.getSchema();
            if (schema.equals(defaultSchema)) {
                schema = this.getConnectionSchema(wcontext._connection);
            }
            String pkgName = null;
            if (procObj.getPackage() != null) {
                pkgName = procObj.getPackage().getName();
            }
            xsdStoredProc = new XSDProcedure(schema, pkgName, procObj.getName());
            xsdStoredProc.setOverload(Integer.toString(procObj.getOverload()));
            List argList = procObj.getArgumentList();
            if (argList != null && argList.size() > 0) {
                for (int i = 0; i < argList.size(); ++i) {
                    ArgumentObject currentArg = (ArgumentObject)argList.get(i);
                    xsdStoredProc.addParameter(currentArg.getName(), currentArg.getTypeName(), currentArg.getDatatype(), currentArg.getTypeSchema(), currentArg.getInOut(), currentArg.getPosition(), currentArg.getSequence(), 0);
                }
            }
        }
        return xsdStoredProc;
    }

    @Override
    protected void setJcaOperationInteractionSpec(AdapterWizardContext wcontext, JcaOperation jop) {
        if (wcontext._service_type.equals("Apps")) {
            jop.setAttributeValue("InteractionSpec", "oracle.tip.adapter.apps.AppsStoredProcedureInteractionSpec");
        } else {
            jop.setAttributeValue("InteractionSpec", "oracle.tip.adapter.db.DBStoredProcedureInteractionSpec");
        }
    }

    @Override
    protected IXSDProcedure getTheXsdStoredProcedure(AdapterWizardContext wcontext, ProcedureObject procObj) throws Exception {
        XSDProcedure xsdStoredProc = this.convertToXSDStoredProcedure(wcontext, procObj);
        if (procObj.hasPLSQLBooleanOrRecordTypes()) {
            ProcedureObject wrapperProc = procObj.convertToWrapperProcedure(this.getConnectionSchema(wcontext._connection));
            XSDProcedure wrapperXSDStoredProc = this.convertToXSDStoredProcedure(wcontext, wrapperProc);
            String wrapperOverload = wrapperXSDStoredProc.getOverload();
            if (wrapperOverload != null && !wrapperOverload.trim().equals("")) {
                wrapperProc.setOverload(Integer.valueOf(wrapperOverload));
            } else {
                wrapperProc.setOverload(0);
            }
            String userParam = "-user=" + wcontext._connection.getMetaData().getUserName() + "/" + wcontext.dbConnectionInfo.getPassword();
            String urlParam = "-url=" + wcontext._connection.getMetaData().getURL();
            String dirParam = "-dir=" + wcontext.getFilePath();
            ArrayList<String> miscInfoList = new ArrayList<String>();
            miscInfoList.add(userParam);
            miscInfoList.add(urlParam);
            miscInfoList.add(dirParam);
            String[] jpubOut = JPublisher.generateWrapper((IXSDProcedure)xsdStoredProc, (String)wrapperProc.getPackage().getName(), miscInfoList, (String)wrapperProc.getName());
            String wrapperSchema = this.getConnectionSchema(wcontext._connection);
            List wrapperProcList = this.getProcedure(wcontext._connection, wrapperSchema, procObj.getWrapperPackageName(), procObj.getWrapperProcedureName());
            wrapperProc = null;
            if (wrapperProcList != null && wrapperProcList.size() > 0) {
                wrapperProc = (ProcedureObject)wrapperProcList.get(0);
                List argList = this.getArguments(wcontext._connection, wrapperProc);
                wrapperProc.setArgumentList(argList);
                wrapperXSDStoredProc = this.convertToXSDStoredProcedure(wcontext, wrapperProc);
            }
            if (wrapperProc == null) {
                MessageFormat msgFormat = new MessageFormat(wcontext._bundle.getString("DB_SP_WRAPPER_PROCEDURE_NOT_FOUND"));
                Object[] obj = new Object[]{procObj.getWrapperProcedureName(), procObj.getWrapperPackageName(), wrapperSchema};
                String msg = msgFormat.format(obj);
                WSDLException notFoundEx = new WSDLException("OTHER_ERROR", msg);
                notFoundEx.printStackTrace();
                throw notFoundEx;
            }
            DBAdapterSPUserInput userInput = new DBAdapterSPUserInput();
            String wrapperSQLFile = wcontext.getFilePath() + File.separator + userInput.getWrapperSQLFilename(procObj);
            String wrapperDropSQLFile = wcontext.getFilePath() + File.separator + userInput.getWrapperDropSQLFilename(procObj);
            if (wcontext._project != null) {
                Node sqlNode;
                if (wrapperSQLFile != null) {
                    URL wrapperSQLURL = URLFactory.newURL((String)wrapperSQLFile);
                    sqlNode = NodeFactory.findOrCreate(XMLNode.class, (URL)wrapperSQLURL);
                    wcontext._project.add((Element)sqlNode, true);
                    wcontext.addURL(wrapperSQLURL);
                }
                if (wrapperDropSQLFile != null) {
                    URL wrapperDropSQLURL = URLFactory.newURL((String)wrapperDropSQLFile);
                    sqlNode = NodeFactory.findOrCreate(XMLNode.class, (URL)wrapperDropSQLURL);
                    wcontext._project.add((Element)sqlNode, true);
                    wcontext.addURL(wrapperDropSQLURL);
                }
            }
            this.m_ProcObj = wrapperProc;
            xsdStoredProc = wrapperXSDStoredProc;
            wcontext._db_sp_xsd_filename = null;
        }
        return xsdStoredProc;
    }

    @Override
    protected void setUiOverloadedProcedure(AdapterWizardContext wcontext, ProcedureObject procObj) {
        if (procObj.getOverload() > 0) {
            wcontext._write_jca_address.setUiOverloadedProcedure(String.valueOf(procObj.getOverload()));
        }
    }

    @Override
    protected void setUiProcedureReturnStatus(AdapterWizardContext wcontext, ProcedureObject procObj) {
    }

    @Override
    public void setUiStrongXSD(AdapterWizardContext wcontext) {
    }

    private void importHeaderWSDL(AdapterWizardContext wcontext, Definition def) throws Exception {
    }

    public void printUserInput(DBAdapterSPUserInput userInput) {
        System.out.println("************ USER INPUT ***************");
        if (userInput != null) {
            List argList = null;
            PackageObject pkgObj = userInput.getPackage();
            ProcedureObject procObj = userInput.getProcedure();
            if (procObj != null) {
                argList = procObj.getArgumentList();
            }
            System.out.println("Schema: " + userInput.getSchema());
            if (pkgObj != null) {
                System.out.println("Package: " + pkgObj.getName());
            }
            if (procObj != null) {
                System.out.println("Procedure: " + procObj.getName());
            }
            if (procObj.isFunction()) {
                System.out.println("Type = FUNCTION");
            } else {
                System.out.println("Type = PROCEDURE");
            }
            if (argList != null && argList.size() > 0) {
                System.out.println("\nARGUMENTS - " + argList.size());
                System.out.println("--------------------");
                for (int i = 0; i < argList.size(); ++i) {
                    ArgumentObject argObj = (ArgumentObject)argList.get(i);
                    System.out.println(" >> " + i + " << ");
                    System.out.println("Name: " + argObj.getName());
                    System.out.println("Type: " + argObj.getTypeName());
                    System.out.println("Direction: " + argObj.getInOut());
                    System.out.println("Position: " + argObj.getPosition());
                    System.out.println("Sequence: " + argObj.getSequence());
                    System.out.println("Object Id: " + argObj.getObjectID());
                    System.out.println("Overload: " + argObj.getOverload());
                }
            }
        }
        System.out.println("***************************************");
    }
}

