/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.oracle;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import oracle.bali.ewt.event.Cancelable;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.tip.tools.ide.common.utils.MultiLineOptionPane;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.AbstractStoredProcPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.PackageObject;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.ProcedureObject;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.oracle.OracleDatabase;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.oracle.SelectProcDialog;

public class DBAdapterStoredProcPage
extends AbstractStoredProcPage {
    private static final String WRAPPER_PKG_DEFAULT_PREFIX = "bpel_";
    private static final String WRAPPER_PKG_TEXT_FIELD = "WRAPPER_PKG_TEXT_FIELD";

    public DBAdapterStoredProcPage(AdapterWizardContext wcontext, ImageWizardPage iwp) throws Exception {
        super(wcontext, iwp, new OracleDatabase());
    }

    @Override
    protected void jbInitHelper(ProcedureObject procObj) {
        String wrapperOverwriteText = this.getTranslatedString("DB_SP_OVERWRITE_WRAPPER");
        this.overwriteWrapperPkgCheckBox.setText(wrapperOverwriteText);
        String wrapperPkgText = this.getTranslatedString("DB_SP_WRAPPER_PKG_PROMPT");
        this.wrapperPackageLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), wrapperPkgText);
        this.wrapperPackageTextField = new JTextField(WRAPPER_PKG_DEFAULT_PREFIX + this.m_wcontext._write_service_name);
        this.add((Component)this.wrapperPackageLabel, new GridBagConstraints(0, 5, 0, 1, 1.0, 0.0, 16, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.wrapperPackageLabel.setVisible(false);
        this.add((Component)this.wrapperPackageTextField, new GridBagConstraints(0, 6, 3, 1, 1.0, 0.0, 16, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.wrapperPackageTextField.setVisible(false);
        this.add((Component)this.overwriteWrapperPkgCheckBox, new GridBagConstraints(0, 7, 3, 1, 1.0, 0.0, 16, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.overwriteWrapperPkgCheckBox.setVisible(false);
        this.wrapperPackageTextField.getDocument().addDocumentListener(this);
        this.wrapperPackageTextField.getDocument().putProperty("DOCUMENT_NAME_KEY", WRAPPER_PKG_TEXT_FIELD);
        if (this.isUpdating) {
            this.m_page.setCanAdvance(true);
            this.userInput.setHasResolvedOverloadedProcedure(true);
            this.isUpdating = false;
        } else {
            this.m_page.setCanAdvance(false);
        }
    }

    @Override
    protected void redrawPage() {
        if (this.userInput.getProcedure().hasPLSQLBooleanOrRecordTypes()) {
            Object[] obj = new Object[]{this.userInput.getProcedure().getWrapperPackageName()};
            this.wrapperPackageLabel.setVisible(true);
            this.wrapperPackageTextField.setVisible(true);
            this.overwriteWrapperPkgCheckBox.setVisible(true);
            this.revalidate();
        } else {
            this.wrapperPackageLabel.setVisible(false);
            this.wrapperPackageTextField.setVisible(false);
            this.overwriteWrapperPkgCheckBox.setVisible(false);
            this.revalidate();
        }
    }

    @Override
    protected void loadProcedureBrowseDialog(boolean overloadedProcSpecified) {
        boolean copyOverloadedResolved = this.userInput.hasResolvedOverloadedProcedure();
        String selectedSchema = (String)this.schemaComboBox.getSelectedItem();
        this.userInput.setProcUserTextInput(this.procTextField.getText().trim());
        try {
            SelectProcDialog selectProcDialog = new SelectProcDialog(this.m_wcontext, selectedSchema, overloadedProcSpecified, this.userInput);
            if (selectProcDialog.runDialog()) {
                this.userInput = selectProcDialog.getUserInput();
                if (this.userInput.getProcedure() != null) {
                    this.userInput.getProcedure().setWrapperInfo(this.m_wcontext);
                }
                this.reflectUserInput();
                this.userInput.setHasResolvedOverloadedProcedure(true);
            } else {
                this.userInput.setHasResolvedOverloadedProcedure(copyOverloadedResolved);
            }
            this.userInput.setIsInSearchMode(false);
        }
        catch (Exception e) {
            MultiLineOptionPane.showMessageDialog((Component)this.m_wcontext._parentFrame, (Object)this.getTranslatedString("DB_SP_CONN_ERROR_STORED_PROCS"), (String)this.getTranslatedString("DB_SP_ERROR"), (int)0);
            e.printStackTrace();
        }
    }

    @Override
    protected void validatePage(WizardEvent event, String schema, String packageName, String procedureName) throws Exception {
        ProcedureObject procObj;
        List procList = null;
        if (packageName == null && procedureName != null) {
            procList = this.dataAccess.getProcedure(this.m_wcontext._connection, schema, null, procedureName);
        } else if (packageName != null && procedureName != null) {
            procList = this.dataAccess.getProcedure(this.m_wcontext._connection, schema, packageName, procedureName);
        } else {
            this.m_page.setCanAdvance(false);
            MultiLineOptionPane.showMessageDialog((Component)this.m_wcontext._parentFrame, (Object)this.getTranslatedString("DB_SP_PROCEDURE_NOT_FOUND_MSG"), (String)this.getTranslatedString("DB_SP_PROCEDURE_NOT_FOUND_TITLE"), (int)0);
            ((Cancelable)event).cancel();
        }
        if (procList != null && procList.size() == 1) {
            procObj = (ProcedureObject)procList.get(0);
            List argList = this.dataAccess.getArguments(this.m_wcontext._connection, procObj);
            procObj.setArgumentList(argList);
            this.userInput.setProcedure(procObj);
            this.userInput.setPackage(procObj.getPackage());
        } else if (procList != null && procList.size() > 1 && !this.userInput.hasResolvedOverloadedProcedure()) {
            this.loadProcedureBrowseDialog(true);
            ((Cancelable)event).cancel();
        } else if (procList == null || procList.size() < 1) {
            MultiLineOptionPane.showMessageDialog((Component)this.m_wcontext._parentFrame, (Object)this.getTranslatedString("DB_SP_PROCEDURE_NOT_FOUND_MSG"), (String)this.getTranslatedString("DB_SP_PROCEDURE_NOT_FOUND_TITLE"), (int)0);
            ((Cancelable)event).cancel();
        }
        if ((procList != null && procList.size() == 1 || procList != null && procList.size() > 1 && this.userInput.hasResolvedOverloadedProcedure()) && (procObj = this.userInput.getProcedure()).hasPLSQLBooleanOrRecordTypes()) {
            procObj.setWrapperInfo(this.m_wcontext);
            if (!this.wrapperPackageTextField.isVisible() && procObj.hasPLSQLBooleanOrRecordTypes()) {
                ((Cancelable)event).cancel();
                this.reflectUserInput();
            } else {
                String wrapperPkgName = this.wrapperPackageTextField.getText();
                procObj.setWrapperPackageName(wrapperPkgName);
                PackageObject wrapperPkgObj = this.dataAccess.getPackage(this.m_wcontext._connection, procObj.getSchema(), wrapperPkgName);
                if (!this.overwriteWrapperPkgCheckBox.isSelected() && wrapperPkgObj != null) {
                    MultiLineOptionPane.showMessageDialog((Component)this.m_wcontext._parentFrame, (Object)this.getTranslatedString("DB_SP_WRAPPER_PKG_EXISTS"), (String)this.getTranslatedString("DB_SP_ERROR"), (int)0);
                    ((Cancelable)event).cancel();
                }
            }
        }
    }

    @Override
    protected void schemaComboBox_actionPerformed(ActionEvent e) {
        if (!this.procTextField.getText().trim().equals("")) {
            this.m_page.setCanAdvance(true);
        } else {
            this.m_page.setCanAdvance(false);
        }
        this.clearAndHideArgsTable();
        this.userInput.setHasResolvedOverloadedProcedure(false);
    }

    @Override
    protected void respondToUserInput(DocumentEvent e) {
        boolean procTextIsValid = false;
        boolean wrapperPkgTextIsValid = false;
        String docName = (String)e.getDocument().getProperty("DOCUMENT_NAME_KEY");
        if (docName != null && docName.equals("PROC_TEXT_FIELD")) {
            this.userInput.setHasResolvedOverloadedProcedure(false);
            this.argsLabel.setVisible(false);
            this.tableScrollPane.setVisible(false);
            this.wrapperPackageLabel.setVisible(false);
            this.wrapperPackageTextField.setVisible(false);
            this.overwriteWrapperPkgCheckBox.setVisible(false);
            this.revalidate();
        }
        if (this.procTextField.getText() != null && !this.procTextField.getText().trim().equals("")) {
            procTextIsValid = true;
        }
        if (this.wrapperPackageTextField.isVisible() && this.wrapperPackageTextField.getText() != null && !this.wrapperPackageTextField.getText().trim().equals("")) {
            wrapperPkgTextIsValid = true;
        } else if (!this.wrapperPackageTextField.isVisible()) {
            wrapperPkgTextIsValid = true;
        }
        this.m_page.setCanAdvance(procTextIsValid && wrapperPkgTextIsValid);
    }
}

