/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.oracle;

import java.awt.Component;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.List;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.javatools.dialogs.MessageDialog;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.tip.adapter.db.sp.ITypeConverter;
import oracle.tip.adapter.db.sp.RowSetMetaData;
import oracle.tip.adapter.db.sp.SPUtil;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.AbstractRowSetPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.ArgumentObject;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.ProcedureObject;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.TestArgumentTableModel;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.oracle.OracleDatabase;

public class DBAdapterRowSetPage
extends AbstractRowSetPage {
    public DBAdapterRowSetPage(AdapterWizardContext wcontext, ImageWizardPage iwp) throws Exception {
        super(wcontext, iwp, new OracleDatabase());
    }

    @Override
    public String getCallSql(ProcedureObject procedure, Connection connection) throws Exception {
        StringBuffer SQL = new StringBuffer("BEGIN ");
        int start = 0;
        if (procedure.isFunction()) {
            SQL.append("? := ");
            start = 1;
        }
        SQL.append(this.getQualifiedProcedureName(procedure, connection));
        SQL.append("(");
        List argList = procedure.getArgumentList();
        for (int i = start; i < argList.size(); ++i) {
            ArgumentObject arg = (ArgumentObject)argList.get(i);
            SQL.append(arg.getName()).append("=>?");
            if (i >= argList.size() - 1) continue;
            SQL.append(", ");
        }
        SQL.append("); END;");
        return SQL.toString();
    }

    @Override
    public Object getArgumentValue(ArgumentObject arg, int jdbcType, TestArgumentTableModel argTableModel, Connection connection) throws Exception {
        Object object = null;
        if (argTableModel != null) {
            String value = (String)argTableModel.getNamedValue(arg.getName());
            switch (jdbcType) {
                case -10: 
                case 2006: {
                    object = null;
                    break;
                }
                case 2002: {
                    value = value.substring(value.indexOf(40) + 1, value.lastIndexOf(41));
                    Object[] params = value.split(",");
                    Object[] objParams = new Object[params.length];
                    for (int j = 0; j < params.length; ++j) {
                        params[j] = params[j].trim();
                    }
                    StructDescriptor desc = StructDescriptor.createDescriptor((String)arg.getTypeName(), (Connection)connection);
                    object = new STRUCT(desc, connection, params);
                    break;
                }
                default: {
                    ITypeConverter typeConverter = this.platform.getTypeConverter();
                    object = typeConverter.toObject(connection, null, jdbcType, value, value == null);
                }
            }
        }
        return object;
    }

    @Override
    public void bindAllParameters(ProcedureObject procedure, CallableStatement cStmt, Connection connection, TestArgumentTableModel argTableModel) throws Exception {
        List argList = procedure.getArgumentList();
        for (int i = 0; i < argList.size(); ++i) {
            int jdbcType;
            ArgumentObject arg = (ArgumentObject)argList.get(i);
            int index = Integer.valueOf(arg.getPosition());
            if (procedure.isFunction()) {
                ++index;
            }
            if ((jdbcType = SPUtil.getJDBCType((String)arg.getDatatype(), (HashMap)this.platform.getSqlTypeMappings())) == 1111) {
                if (arg.getDatatype().equals("REF CURSOR")) {
                    jdbcType = -10;
                } else if (arg.getDatatype().startsWith("REF")) {
                    jdbcType = 2006;
                } else if (arg.getDatatype().equals("OBJECT")) {
                    jdbcType = 2002;
                } else if (arg.getDatatype().equals("VARRAY")) {
                    jdbcType = 2003;
                } else if (arg.getDatatype().equals("TABLE")) {
                    jdbcType = 2003;
                }
            }
            if (arg.getInOut().contains("IN") && jdbcType != -10) {
                Object object = this.getArgumentValue(arg, jdbcType, argTableModel, connection);
                if (object == null) {
                    if (jdbcType == 2003 || jdbcType == 2002) {
                        cStmt.setNull(index, jdbcType, arg.getTypeName());
                    } else {
                        cStmt.setNull(index, jdbcType);
                    }
                } else {
                    cStmt.setObject(index, object);
                }
            }
            if (!arg.getInOut().contains("OUT")) continue;
            if (jdbcType == 2003 || jdbcType == 2002) {
                cStmt.registerOutParameter(index, jdbcType, arg.getTypeName());
                continue;
            }
            cStmt.registerOutParameter(index, jdbcType);
        }
    }

    @Override
    public boolean retrieveAllRowSets(ProcedureObject procedure, CallableStatement cStmt, boolean hasResults, String SQL) throws Exception {
        boolean success = true;
        List argList = procedure.getArgumentList();
        for (int i = 0; i < argList.size(); ++i) {
            ResultSet rs;
            ArgumentObject arg = (ArgumentObject)argList.get(i);
            if (!arg.getDatatype().equals("REF CURSOR")) continue;
            int index = Integer.valueOf(arg.getPosition());
            String name = arg.getName();
            if (procedure.isFunction()) {
                ++index;
                name = procedure.getName();
            }
            if (!(rs = (ResultSet)cStmt.getObject(index)).next()) {
                success = success && procedure.getRowSets().containsKey(name);
                String message = this.getTranslatedString("DB_SP_EMPTY_ROWSET") + arg.getName() + " SQL: " + SQL;
                String title = this.getTranslatedString("DB_SP_INTROSPECTION_FAILED");
                MessageDialog.information((Component)this.m_wcontext._parentFrame, (Object)message, (String)title, null);
            } else {
                RowSetMetaData metaData = new RowSetMetaData(rs.getMetaData());
                procedure.getRowSets().put(name, metaData);
            }
            rs.close();
        }
        return success;
    }
}

